/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.AbstractPolygon;

public class EMFPolygon
extends AbstractPolygon {
    public EMFPolygon() {
        super(3, 1, null, 0, null);
    }

    public EMFPolygon(Rectangle rectangle, int n2, Point[] pointArray) {
        super(3, 1, rectangle, n2, pointArray);
    }

    protected EMFPolygon(int n2, int n3, Rectangle rectangle, int n4, Point[] pointArray) {
        super(n2, n3, rectangle, n4, pointArray);
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        Rectangle rectangle = eMFInputStream.readRECTL();
        int n4 = eMFInputStream.readDWORD();
        return new EMFPolygon(rectangle, n4, eMFInputStream.readPOINTL(n4));
    }

    public void render(EMFRenderer eMFRenderer) {
        Point[] pointArray = this.getPoints();
        if (pointArray.length > 1) {
            GeneralPath generalPath = new GeneralPath(eMFRenderer.getWindingRule());
            generalPath.moveTo((float)pointArray[0].getX(), (float)pointArray[0].getY());
            for (int i2 = 1; i2 < pointArray.length; ++i2) {
                generalPath.lineTo((float)pointArray[i2].getX(), (float)pointArray[i2].getY());
            }
            generalPath.closePath();
            eMFRenderer.fillAndDrawOrAppend(generalPath);
        }
    }
}

