/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFImageLoader;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.BitmapInfo;
import org.freehep.graphicsio.emf.gdi.BitmapInfoHeader;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.util.UserProperties;
import org.freehep.util.io.NoCloseOutputStream;

public class BitBlt
extends EMFTag
implements EMFConstants {
    private static final int size = 100;
    private Rectangle bounds;
    private int x;
    private int y;
    private int width;
    private int height;
    private int dwROP;
    private int xSrc;
    private int ySrc;
    private AffineTransform transform;
    private Color bkg;
    private int usage;
    private BitmapInfo bmi;
    private BufferedImage image;

    public BitBlt() {
        super(76, 1);
    }

    public BitBlt(Rectangle rectangle, int n2, int n3, int n4, int n5, AffineTransform affineTransform, BufferedImage bufferedImage, Color color) {
        this();
        this.bounds = rectangle;
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
        this.dwROP = 0xCC0020;
        this.xSrc = 0;
        this.ySrc = 0;
        this.transform = affineTransform;
        this.bkg = color;
        this.usage = 0;
        this.image = bufferedImage;
        this.bmi = null;
    }

    public EMFTag read(int n2, EMFInputStream eMFInputStream, int n3) throws IOException {
        BitBlt bitBlt = new BitBlt();
        bitBlt.bounds = eMFInputStream.readRECTL();
        bitBlt.x = eMFInputStream.readLONG();
        bitBlt.y = eMFInputStream.readLONG();
        bitBlt.width = eMFInputStream.readLONG();
        bitBlt.height = eMFInputStream.readLONG();
        bitBlt.dwROP = eMFInputStream.readDWORD();
        bitBlt.xSrc = eMFInputStream.readLONG();
        bitBlt.ySrc = eMFInputStream.readLONG();
        bitBlt.transform = eMFInputStream.readXFORM();
        bitBlt.bkg = eMFInputStream.readCOLORREF();
        bitBlt.usage = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        int n4 = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        int n5 = eMFInputStream.readDWORD();
        bitBlt.bmi = n4 > 0 ? new BitmapInfo(eMFInputStream) : null;
        bitBlt.image = n5 > 0 && bitBlt.bmi != null ? EMFImageLoader.readImage(bitBlt.bmi.getHeader(), bitBlt.width, bitBlt.height, eMFInputStream, n5, null) : null;
        return bitBlt;
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writeLONG(this.x);
        eMFOutputStream.writeLONG(this.y);
        eMFOutputStream.writeLONG(this.width);
        eMFOutputStream.writeLONG(this.height);
        eMFOutputStream.writeDWORD(this.dwROP);
        eMFOutputStream.writeLONG(this.xSrc);
        eMFOutputStream.writeLONG(this.ySrc);
        eMFOutputStream.writeXFORM(this.transform);
        eMFOutputStream.writeCOLORREF(this.bkg);
        eMFOutputStream.writeDWORD(this.usage);
        eMFOutputStream.writeDWORD(100);
        eMFOutputStream.writeDWORD(40);
        eMFOutputStream.writeDWORD(140);
        eMFOutputStream.pushBuffer();
        UserProperties userProperties = new UserProperties();
        userProperties.setProperty(RawImageWriteParam.BACKGROUND, this.bkg);
        userProperties.setProperty(RawImageWriteParam.CODE, "BGR");
        userProperties.setProperty(RawImageWriteParam.PAD, 4);
        ImageGraphics2D.writeImage(this.image, "raw", (Properties)userProperties, (OutputStream)new NoCloseOutputStream(eMFOutputStream));
        int n3 = eMFOutputStream.popBuffer();
        BitmapInfoHeader bitmapInfoHeader = new BitmapInfoHeader(this.image.getWidth(), this.image.getHeight(), 24, 0, n3, 0, 0, 0, 0);
        this.bmi = new BitmapInfo(bitmapInfoHeader);
        this.bmi.write(eMFOutputStream);
        eMFOutputStream.writeDWORD(n3);
        eMFOutputStream.append();
    }

    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  x, y, w, h: " + this.x + " " + this.y + " " + this.width + " " + this.height + "\n  dwROP: 0x" + Integer.toHexString(this.dwROP) + "\n  xSrc, ySrc: " + this.xSrc + " " + this.ySrc + "\n  transform: " + this.transform + "\n  bkg: " + this.bkg + "\n  usage: " + this.usage + "\n" + (this.bmi != null ? this.bmi.toString() : "  bitmap: null");
    }

    public void render(EMFRenderer eMFRenderer) {
        if (this.image != null) {
            eMFRenderer.drawImage(this.image, this.transform);
        }
    }
}

