/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public abstract class AbstractPolygon
extends EMFTag {
    private Rectangle bounds;
    private int numberOfPoints;
    private Point[] points;

    protected AbstractPolygon(int n2, int n3) {
        super(n2, n3);
    }

    protected AbstractPolygon(int n2, int n3, Rectangle rectangle, int n4, Point[] pointArray) {
        super(n2, n3);
        this.bounds = rectangle;
        this.numberOfPoints = n4;
        this.points = pointArray;
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writeDWORD(this.numberOfPoints);
        eMFOutputStream.writePOINTL(this.numberOfPoints, this.points);
    }

    public String toString() {
        String string = super.toString() + "\n  bounds: " + this.bounds + "\n  #points: " + this.numberOfPoints;
        if (this.points != null) {
            string = string + "\n  points: ";
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                string = string + "[" + this.points[i2].x + "," + this.points[i2].y + "]";
                if (i2 >= this.points.length - 1) continue;
                string = string + ", ";
            }
        }
        return string;
    }

    protected Rectangle getBounds() {
        return this.bounds;
    }

    protected int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    protected Point[] getPoints() {
        return this.points;
    }
}

