/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public abstract class AbstractPolyPolygon
extends EMFTag {
    private Rectangle bounds;
    private int[] numberOfPoints;
    private Point[][] points;

    protected AbstractPolyPolygon(int n2, int n3, Rectangle rectangle, int[] nArray, Point[][] pointArray) {
        super(n2, n3);
        this.bounds = rectangle;
        this.numberOfPoints = nArray;
        this.points = pointArray;
    }

    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  #polys: " + this.numberOfPoints.length;
    }

    protected Rectangle getBounds() {
        return this.bounds;
    }

    protected int[] getNumberOfPoints() {
        return this.numberOfPoints;
    }

    protected Point[][] getPoints() {
        return this.points;
    }

    public void render(EMFRenderer eMFRenderer) {
        this.render(eMFRenderer, true);
    }

    protected void render(EMFRenderer eMFRenderer, boolean bl) {
        GeneralPath generalPath = new GeneralPath(eMFRenderer.getWindingRule());
        for (int i2 = 0; i2 < this.numberOfPoints.length; ++i2) {
            GeneralPath generalPath2 = new GeneralPath(eMFRenderer.getWindingRule());
            for (int i3 = 0; i3 < this.numberOfPoints[i2]; ++i3) {
                Point point = this.points[i2][i3];
                if (i3 > 0) {
                    generalPath2.lineTo((float)point.getX(), (float)point.getY());
                    continue;
                }
                generalPath2.moveTo((float)point.getX(), (float)point.getY());
            }
            if (bl) {
                generalPath2.closePath();
            }
            generalPath.append(generalPath2, false);
        }
        if (bl) {
            eMFRenderer.fillAndDrawOrAppend(generalPath);
        } else {
            eMFRenderer.drawOrAppend(generalPath);
        }
    }
}

