/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.gdi.GDIObject;

public abstract class AbstractPen
implements EMFConstants,
GDIObject {
    private static final Logger logger = Logger.getLogger("org.freehep.graphicsio.emf");

    protected int getJoin(int n2) {
        switch (n2 & 0xF000) {
            case 0: {
                return 1;
            }
            case 4096: {
                return 2;
            }
            case 8192: {
                return 0;
            }
        }
        logger.warning("got unsupported pen style " + n2);
        return 1;
    }

    protected int getCap(int n2) {
        switch (n2 & 0xF00) {
            case 0: {
                return 1;
            }
            case 256: {
                return 2;
            }
            case 512: {
                return 0;
            }
        }
        logger.warning("got unsupported pen style " + n2);
        return 1;
    }

    protected float[] getDash(int n2, int[] nArray) {
        switch (n2 & 0xFF) {
            case 0: {
                return null;
            }
            case 1: {
                return new float[]{5.0f, 5.0f};
            }
            case 2: {
                return new float[]{1.0f, 2.0f};
            }
            case 3: {
                return new float[]{5.0f, 2.0f, 1.0f, 2.0f};
            }
            case 4: {
                return new float[]{5.0f, 2.0f, 1.0f, 2.0f, 1.0f, 2.0f};
            }
            case 6: {
                return null;
            }
            case 5: {
                return null;
            }
            case 7: {
                if (nArray != null && nArray.length > 0) {
                    float[] fArray = new float[nArray.length];
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        fArray[i2] = nArray[i2];
                    }
                    return fArray;
                }
                return null;
            }
        }
        logger.warning("got unsupported pen style " + n2);
        return null;
    }

    private boolean isInsideFrameStroke(int n2) {
        return (n2 & 0xFF) == 6;
    }

    protected Stroke createStroke(EMFRenderer eMFRenderer, int n2, int[] nArray, float f2) {
        if (this.isInsideFrameStroke(n2)) {
            return new InsideFrameStroke(f2, this.getCap(n2), this.getJoin(n2), eMFRenderer.getMeterLimit(), this.getDash(n2, nArray), 0.0f);
        }
        return new BasicStroke(f2, this.getCap(n2), this.getJoin(n2), eMFRenderer.getMeterLimit(), this.getDash(n2, nArray), 0.0f);
    }

    private class InsideFrameStroke
    implements Stroke {
        private BasicStroke stroke;

        public InsideFrameStroke(float f2, int n2, int n3, float f3, float[] fArray, float f4) {
            this.stroke = new BasicStroke(f2, n2, n3, f3, fArray, f4);
        }

        public Shape createStrokedShape(Shape shape) {
            if (shape == null) {
                return null;
            }
            Rectangle2D rectangle2D = shape.getBounds2D();
            float f2 = this.stroke.getLineWidth();
            AffineTransform affineTransform = new AffineTransform();
            if (rectangle2D.getWidth() > 0.0) {
                affineTransform.scale((rectangle2D.getWidth() - (double)f2) / rectangle2D.getWidth(), 1.0);
            }
            if (rectangle2D.getHeight() > 0.0) {
                affineTransform.scale(1.0, (rectangle2D.getHeight() - (double)f2) / rectangle2D.getHeight());
            }
            shape = affineTransform.createTransformedShape(shape);
            Rectangle2D rectangle2D2 = shape.getBounds2D();
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(rectangle2D.getX() - rectangle2D2.getX() + (double)(f2 / 2.0f), rectangle2D.getY() - rectangle2D2.getY() + (double)(f2 / 2.0f));
            shape = affineTransform2.createTransformedShape(shape);
            return this.stroke.createStrokedShape(shape);
        }
    }
}

