/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.Text;

public abstract class AbstractExtTextOut
extends EMFTag
implements EMFConstants {
    private Rectangle bounds;
    private int mode;
    private float xScale;
    private float yScale;

    protected AbstractExtTextOut(int n2, int n3, Rectangle rectangle, int n4, float f2, float f3) {
        super(n2, n3);
        this.bounds = rectangle;
        this.mode = n4;
        this.xScale = f2;
        this.yScale = f3;
    }

    public abstract Text getText();

    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  mode: " + this.mode + "\n  xScale: " + this.xScale + "\n  yScale: " + this.yScale + "\n" + this.getText().toString();
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writeDWORD(this.mode);
        eMFOutputStream.writeFLOAT(this.xScale);
        eMFOutputStream.writeFLOAT(this.yScale);
        this.getText().write(eMFOutputStream);
    }

    public void render(EMFRenderer eMFRenderer) {
        Text text = this.getText();
        eMFRenderer.drawOrAppendText(text.getString(), text.getPos().getX(), text.getPos().getY());
    }
}

