/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public abstract class AbstractClipPath
extends EMFTag {
    private int mode;

    protected AbstractClipPath(int n2, int n3, int n4) {
        super(n2, n3);
        this.mode = n4;
    }

    public String toString() {
        return super.toString() + "\n  mode: " + this.mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void render(EMFRenderer eMFRenderer, Shape shape) {
        if (shape != null) {
            if (this.mode == 1) {
                eMFRenderer.clip(shape);
            } else if (this.mode == 5) {
                AffineTransform affineTransform = eMFRenderer.getTransform();
                eMFRenderer.resetTransformation();
                eMFRenderer.setClip(eMFRenderer.getInitialClip());
                eMFRenderer.setTransform(affineTransform);
                eMFRenderer.clip(shape);
            } else if (this.mode == 4) {
                Shape shape2 = eMFRenderer.getClip();
                if (shape2 != null) {
                    Area area = new Area(shape);
                    area.subtract(new Area(shape2));
                    eMFRenderer.setClip(area);
                } else {
                    eMFRenderer.setClip(shape);
                }
            } else if (this.mode == 2) {
                GeneralPath generalPath = new GeneralPath(shape);
                Shape shape3 = eMFRenderer.getClip();
                if (shape3 != null) {
                    generalPath.append(shape3, false);
                }
                eMFRenderer.setClip(generalPath);
            } else if (this.mode == 3) {
                Shape shape4 = eMFRenderer.getClip();
                if (shape4 != null) {
                    Area area = new Area(shape);
                    area.exclusiveOr(new Area(shape4));
                    eMFRenderer.setClip(area);
                } else {
                    eMFRenderer.setClip(shape);
                }
            }
        }
        eMFRenderer.setPath(null);
    }
}

