/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public abstract class AbstractArc
extends EMFTag {
    private Rectangle bounds;
    private Point start;
    private Point end;

    protected AbstractArc(int n2, int n3, Rectangle rectangle, Point point, Point point2) {
        super(n2, n3);
        this.bounds = rectangle;
        this.start = point;
        this.end = point2;
    }

    public void write(int n2, EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writePOINTL(this.start);
        eMFOutputStream.writePOINTL(this.end);
    }

    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  start: " + this.start + "\n  end: " + this.end;
    }

    protected Shape getShape(EMFRenderer eMFRenderer, int n2) {
        double d2;
        double d3;
        double d4 = this.start.getX() / this.bounds.getWidth();
        double d5 = this.end.getX() / this.bounds.getWidth();
        if (eMFRenderer.getArcDirection() == 2) {
            d3 = Math.acos(d4);
            d2 = Math.acos(d5);
        } else {
            d3 = Math.acos(d5);
            d2 = Math.acos(d4);
        }
        return new Arc2D.Double(this.start.getX(), this.start.getY(), this.bounds.getWidth(), this.bounds.getHeight(), d3, d2 - d3, n2);
    }
}

