/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFPanel;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.swing.ExtensionFileFilter;

public class EMFViewer
extends JFrame {
    private static String TITLE = "Freehep EMF Viewer";
    private static String LOAD_BUTTON_TITLE = "Open EMF";
    private static String ZOOMIN__BUTTON_TITLE = "Zoom in";
    private static String ZOOMOUT_BUTTON_TITLE = "Zoom out";
    private EMFPanel emfPanel = new EMFPanel();
    private JFileChooser fileChooser = new JFileChooser();

    public EMFViewer() {
        this.initGUI();
        this.setDefaultCloseOperation(3);
        this.setSize(500, 300);
    }

    private void initGUI() {
        this.setTitle(TITLE);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        this.getContentPane().add(jPanel);
        jPanel.setLayout(new BorderLayout(3, 3));
        jPanel.add("Center", new JScrollPane(this.emfPanel));
        this.fileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter("emf", "Encapsulated Metafile"));
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 3, 3));
        jPanel.add("South", jPanel2);
        JButton jButton = new JButton(ZOOMIN__BUTTON_TITLE);
        jButton.addActionListener(new ZoomInAction());
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(ZOOMOUT_BUTTON_TITLE);
        jButton2.addActionListener(new ZoomOutAction());
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton(LOAD_BUTTON_TITLE);
        jButton3.addActionListener(new OpenFileAction());
        jPanel2.add(jButton3);
    }

    public void show(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            EMFInputStream eMFInputStream = new EMFInputStream(new BufferedInputStream(fileInputStream));
            EMFRenderer eMFRenderer = new EMFRenderer(eMFInputStream);
            this.emfPanel.setRenderer(eMFRenderer);
            this.setTitle(TITLE + " - " + file.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    private class OpenFileAction
    implements ActionListener {
        private OpenFileAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n2 = EMFViewer.this.fileChooser.showOpenDialog(EMFViewer.this);
            if (n2 == 0) {
                EMFViewer.this.show(EMFViewer.this.fileChooser.getSelectedFile());
            }
        }
    }

    private class ZoomInAction
    implements ActionListener {
        private ZoomInAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EMFViewer.this.emfPanel.zoomIn();
        }
    }

    private class ZoomOutAction
    implements ActionListener {
        private ZoomOutAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EMFViewer.this.emfPanel.zoomOut();
        }
    }
}

