/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Logger;
import org.freehep.graphicsio.emf.EMFHeader;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.GDIObject;
import org.freehep.util.io.Tag;

public class EMFRenderer {
    private static final Logger logger = Logger.getLogger("org.freehep.graphicsio.emf");
    private EMFHeader header;
    public static double TWIP_SCALE = 0.1763888888888889;
    private GeneralPath figure = null;
    private AffineTransform initialTransform;
    private Point windowOrigin = null;
    private Point viewportOrigin = null;
    private Dimension windowSize = null;
    private Dimension viewportSize = null;
    private boolean mapModeIsotropic = false;
    private AffineTransform mapModeTransform = AffineTransform.getScaleInstance(TWIP_SCALE, TWIP_SCALE);
    private Shape initialClip;
    private Graphics2D g2;
    private GDIObject[] gdiObjects = new GDIObject[256];
    private Paint brushPaint = new Color(0, 0, 0, 0);
    private Paint penPaint = Color.BLACK;
    private Stroke penStroke = new BasicStroke();
    private int textAlignMode = 0;
    private Color textColor = Color.BLACK;
    private int windingRule = 0;
    private int bkMode = 2;
    private boolean useCreatePen = true;
    private int meterLimit = 10;
    private int rop2 = 13;
    private int scaleMode = 4;
    private Point brushOrigin = new Point(0, 0);
    private Vector tags = new Vector(0);
    private GeneralPath path = null;
    private AffineTransform pathTransform = new AffineTransform();
    private Stack dcStack = new Stack();
    private int arcDirection = 1;

    public EMFRenderer(EMFInputStream eMFInputStream) throws IOException {
        Tag tag;
        this.header = eMFInputStream.readHeader();
        while ((tag = eMFInputStream.readTag()) != null) {
            this.tags.add(tag);
        }
        eMFInputStream.close();
    }

    public Dimension getSize() {
        return this.header.getBounds().getSize();
    }

    public void paint(Graphics2D graphics2D) {
        this.g2 = graphics2D;
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.initialTransform = graphics2D.getTransform();
        this.path = null;
        this.figure = null;
        this.meterLimit = 10;
        this.windingRule = 0;
        this.bkMode = 2;
        this.useCreatePen = true;
        this.scaleMode = 4;
        this.windowOrigin = null;
        this.viewportOrigin = null;
        this.windowSize = null;
        this.viewportSize = null;
        this.mapModeIsotropic = false;
        this.mapModeTransform = AffineTransform.getScaleInstance(TWIP_SCALE, TWIP_SCALE);
        this.resetTransformation(graphics2D);
        this.initialClip = graphics2D.getClip();
        for (int i2 = 0; i2 < this.tags.size(); ++i2) {
            Tag tag = (Tag)this.tags.get(i2);
            if (tag instanceof EMFTag) {
                ((EMFTag)this.tags.get(i2)).render(this);
                continue;
            }
            logger.warning("unknown tag: " + tag);
        }
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    private void resetTransformation(Graphics2D graphics2D) {
        if (this.initialTransform != null) {
            graphics2D.setTransform(this.initialTransform);
        } else {
            graphics2D.setTransform(new AffineTransform());
        }
        if (this.windowOrigin != null) {
            graphics2D.translate(-this.windowOrigin.getX(), -this.windowOrigin.getY());
        }
        if (this.viewportOrigin != null) {
            graphics2D.translate(-this.viewportOrigin.getX(), -this.viewportOrigin.getY());
        }
        if (this.viewportSize != null && this.windowSize != null) {
            double d2 = this.viewportSize.getWidth() / this.windowSize.getWidth();
            double d3 = this.viewportSize.getHeight() / this.windowSize.getHeight();
            graphics2D.scale(d2, d3);
        }
    }

    public void saveDC() {
        DC dC = new DC();
        dC.paint = this.g2.getPaint();
        dC.stroke = this.g2.getStroke();
        dC.transform = this.g2.getTransform();
        dC.pathTransform = this.pathTransform;
        dC.clip = this.g2.getClip();
        dC.path = this.path;
        dC.meterLimit = this.meterLimit;
        dC.windingRule = this.windingRule;
        dC.bkMode = this.bkMode;
        dC.useCreatePen = this.useCreatePen;
        dC.scaleMode = this.scaleMode;
        this.dcStack.push(dC);
    }

    public void retoreDC() {
        if (!this.dcStack.empty()) {
            DC dC = (DC)this.dcStack.pop();
            this.meterLimit = dC.meterLimit;
            this.windingRule = dC.windingRule;
            this.path = dC.path;
            this.bkMode = dC.bkMode;
            this.useCreatePen = dC.useCreatePen;
            this.scaleMode = dC.scaleMode;
            this.pathTransform = dC.pathTransform;
            this.g2.setPaint(dC.paint);
            this.g2.setStroke(dC.stroke);
            this.g2.setTransform(dC.transform);
            this.g2.setClip(dC.clip);
        }
    }

    public void closeFigure() {
        if (this.figure == null) {
            return;
        }
        try {
            this.figure.closePath();
            this.appendToPath(this.figure);
            this.figure = null;
        }
        catch (IllegalPathStateException illegalPathStateException) {
            logger.warning("no figure to close");
        }
    }

    public void fixViewportSize() {
        if (this.mapModeIsotropic && this.windowSize != null && this.viewportSize != null) {
            this.viewportSize.setSize(this.viewportSize.getWidth(), this.viewportSize.getWidth() * (this.windowSize.getHeight() / this.windowSize.getWidth()));
        }
    }

    private void fillAndDrawOrAppend(Graphics2D graphics2D, Shape shape) {
        if (!this.appendToPath(shape)) {
            if (this.useCreatePen) {
                if (this.bkMode == 2) {
                    this.fillShape(graphics2D, shape);
                } else {
                    this.fillShape(graphics2D, shape);
                }
            } else {
                this.fillShape(graphics2D, shape);
            }
            this.drawShape(graphics2D, shape);
        }
    }

    private void drawOrAppend(Graphics2D graphics2D, Shape shape) {
        if (!this.appendToPath(shape)) {
            this.drawShape(graphics2D, shape);
        }
    }

    public void drawOrAppendText(String string, double d2, double d3) {
        if (this.path != null) {
            TextLayout textLayout = new TextLayout(string, this.g2.getFont(), this.g2.getFontRenderContext());
            this.path.append(textLayout.getOutline(null), false);
        } else {
            this.g2.setPaint(this.textColor);
            this.g2.drawString(string, (int)d2, (int)d3);
        }
    }

    private boolean appendToPath(Shape shape) {
        if (this.path != null) {
            if (this.pathTransform != null) {
                shape = this.pathTransform.createTransformedShape(shape);
            }
            this.path.append(shape, false);
            return true;
        }
        return false;
    }

    public void closePath() {
        if (this.path != null) {
            try {
                this.path.closePath();
            }
            catch (IllegalPathStateException illegalPathStateException) {
                logger.warning("no figure to close");
            }
        }
    }

    private void fillShape(Graphics2D graphics2D, Shape shape) {
        graphics2D.setPaint(this.brushPaint);
        graphics2D.fill(shape);
    }

    private void drawShape(Graphics2D graphics2D, Shape shape) {
        graphics2D.setStroke(this.penStroke);
        if (this.rop2 == 1) {
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.setPaint(Color.black);
        } else if (this.rop2 == 13) {
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.setPaint(this.penPaint);
        } else if (this.rop2 == 11) {
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.setPaint(this.penPaint);
        } else if (this.rop2 == 16) {
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.setPaint(Color.white);
        } else if (this.rop2 == 4) {
            graphics2D.setComposite(AlphaComposite.SrcOver);
        } else if (this.rop2 == 7) {
            graphics2D.setComposite(AlphaComposite.Xor);
        } else {
            logger.warning("got unsupported ROP" + this.rop2);
        }
        graphics2D.draw(shape);
    }

    public void setFont(Font font) {
        this.g2.setFont(font);
    }

    public AffineTransform getTransform() {
        return this.g2.getTransform();
    }

    public void transform(AffineTransform affineTransform) {
        this.g2.transform(affineTransform);
    }

    public void resetTransformation() {
        this.resetTransformation(this.g2);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.g2.setTransform(affineTransform);
    }

    public void setClip(Shape shape) {
        this.g2.setClip(shape);
    }

    public void clip(Shape shape) {
        this.g2.clip(shape);
    }

    public Shape getClip() {
        return this.g2.getClip();
    }

    public void drawImage(BufferedImage bufferedImage, AffineTransform affineTransform) {
        this.g2.drawImage(bufferedImage, affineTransform, null);
    }

    public void drawImage(BufferedImage bufferedImage, int n2, int n3, int n4, int n5) {
        this.g2.drawImage(bufferedImage, n2, n3, n4, n5, null);
    }

    public void drawShape(Shape shape) {
        this.drawShape(this.g2, shape);
    }

    public void fillShape(Shape shape) {
        this.fillShape(this.g2, shape);
    }

    public void fillAndDrawOrAppend(Shape shape) {
        this.fillAndDrawOrAppend(this.g2, shape);
    }

    public void drawOrAppend(Shape shape) {
        this.drawOrAppend(this.g2, shape);
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public GeneralPath getFigure() {
        return this.figure;
    }

    public void setFigure(GeneralPath generalPath) {
        this.figure = generalPath;
    }

    public GeneralPath getPath() {
        return this.path;
    }

    public void setPath(GeneralPath generalPath) {
        this.path = generalPath;
    }

    public Shape getInitialClip() {
        return this.initialClip;
    }

    public AffineTransform getPathTransform() {
        return this.pathTransform;
    }

    public void setPathTransform(AffineTransform affineTransform) {
        this.pathTransform = affineTransform;
    }

    public void setWindingRule(int n2) {
        this.windingRule = n2;
    }

    public void setMapModeIsotropic(boolean bl) {
        this.mapModeIsotropic = bl;
    }

    public AffineTransform getMapModeTransform() {
        return this.mapModeTransform;
    }

    public void setMapModeTransform(AffineTransform affineTransform) {
        this.mapModeTransform = affineTransform;
    }

    public void setWindowOrigin(Point point) {
        this.windowOrigin = point;
    }

    public void setViewportOrigin(Point point) {
        this.viewportOrigin = point;
    }

    public void setViewportSize(Dimension dimension) {
        this.viewportSize = dimension;
        this.fixViewportSize();
        this.resetTransformation();
    }

    public void setWindowSize(Dimension dimension) {
        this.windowSize = dimension;
        this.fixViewportSize();
        this.resetTransformation();
    }

    public GDIObject getGDIObject(int n2) {
        return this.gdiObjects[n2];
    }

    public void storeGDIObject(int n2, GDIObject gDIObject) {
        this.gdiObjects[n2] = gDIObject;
    }

    public void setUseCreatePen(boolean bl) {
        this.useCreatePen = bl;
    }

    public void setPenPaint(Paint paint) {
        this.penPaint = paint;
    }

    public Stroke getPenStroke() {
        return this.penStroke;
    }

    public void setPenStroke(Stroke stroke) {
        this.penStroke = stroke;
    }

    public void setBrushPaint(Paint paint) {
        this.brushPaint = paint;
    }

    public float getMeterLimit() {
        return this.meterLimit;
    }

    public void setMeterLimit(int n2) {
        this.meterLimit = n2;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public void setRop2(int n2) {
        this.rop2 = n2;
    }

    public void setBkMode(int n2) {
        this.bkMode = n2;
    }

    public int getTextAlignMode() {
        return this.textAlignMode;
    }

    public void setTextAlignMode(int n2) {
        this.textAlignMode = n2;
    }

    public void setScaleMode(int n2) {
        this.scaleMode = n2;
    }

    public Point getBrushOrigin() {
        return this.brushOrigin;
    }

    public void setBrushOrigin(Point point) {
        this.brushOrigin = point;
    }

    public void setArcDirection(int n2) {
        this.arcDirection = n2;
    }

    public int getArcDirection() {
        return this.arcDirection;
    }

    private class DC {
        private Paint paint;
        private Stroke stroke;
        private AffineTransform transform;
        private Shape clip;
        public GeneralPath path;
        public int bkMode;
        public int windingRule;
        public int meterLimit;
        public boolean useCreatePen;
        public int scaleMode;
        public AffineTransform pathTransform;

        private DC() {
        }
    }
}

