/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import org.freehep.graphicsio.emf.EMFRenderer;

public class EMFPanel
extends JComponent {
    private static double SCALE_FACTOR = 2.0;
    private EMFRenderer renderer;
    private double scale = 1.0;

    public EMFPanel() {
        this.setBackground(Color.white);
    }

    public void setRenderer(EMFRenderer eMFRenderer) {
        this.renderer = eMFRenderer;
        this.scale = 1.0;
        this.setSize(this.getPreferredSize());
    }

    public Dimension getPreferredSize() {
        if (this.renderer == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = this.renderer.getSize();
        return new Dimension((int)Math.ceil((double)dimension.width * this.scale), (int)Math.ceil((double)dimension.height * this.scale));
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        if (this.renderer == null) {
            return;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.scale(this.scale, this.scale);
        this.renderer.paint(graphics2D);
        graphics2D.setTransform(affineTransform);
    }

    public void zoomIn() {
        this.scale *= SCALE_FACTOR;
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    public void zoomOut() {
        this.scale /= SCALE_FACTOR;
        this.setSize(this.getPreferredSize());
        this.repaint();
    }
}

