/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.emf.EMFHandleManager;
import org.freehep.graphicsio.emf.EMFHeader;
import org.freehep.graphicsio.emf.EMFTagSet;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TaggedOutputStream;

public class EMFOutputStream
extends TaggedOutputStream {
    private String application;
    private String name;
    private int recordCount = 0;
    private Rectangle imageBounds;
    private int version;
    private EMFHandleManager handles;
    private Dimension device;

    public EMFOutputStream(OutputStream outputStream, Rectangle rectangle, EMFHandleManager eMFHandleManager, String string, String string2, Dimension dimension, int n2) throws IOException {
        super(outputStream, new EMFTagSet(n2), null, true);
        this.version = n2;
        this.imageBounds = rectangle;
        this.handles = eMFHandleManager;
        this.application = string;
        this.name = string2;
        this.device = dimension;
        this.pushBuffer();
    }

    public EMFOutputStream(OutputStream outputStream, Rectangle rectangle, EMFHandleManager eMFHandleManager, String string, String string2, Dimension dimension) throws IOException {
        this(outputStream, rectangle, eMFHandleManager, string, string2, dimension, 1);
    }

    public void close() throws IOException {
        int n2 = this.popBuffer();
        ++this.recordCount;
        EMFHeader eMFHeader = new EMFHeader(this.imageBounds, this.getVersion(), 0, n2, this.recordCount, this.handles.maxHandlesUsed(), this.application, this.name, this.device);
        this.writeHeader(eMFHeader);
        this.append();
        super.close();
    }

    public void writeDWORD(int n2) throws IOException {
        this.writeUnsignedInt(n2);
    }

    public void writeDWORD(int[] nArray) throws IOException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.writeDWORD(nArray[i2]);
        }
    }

    public void writeWORD(int n2) throws IOException {
        this.writeUnsignedShort(n2);
    }

    public void writeFLOAT(float f2) throws IOException {
        this.writeFloat(f2);
    }

    public void writeCOLORREF(Color color) throws IOException {
        this.writeByte(color.getRed());
        this.writeByte(color.getGreen());
        this.writeByte(color.getBlue());
        this.writeByte(0);
    }

    public void writeCOLOR16(Color color) throws IOException {
        this.writeShort(color.getRed() << 8);
        this.writeShort(color.getGreen() << 8);
        this.writeShort(color.getBlue() << 8);
        this.writeShort(color.getAlpha() << 8);
    }

    public void writeXFORM(AffineTransform affineTransform) throws IOException {
        this.writeFLOAT((float)affineTransform.getScaleX());
        this.writeFLOAT((float)affineTransform.getShearY());
        this.writeFLOAT((float)affineTransform.getShearX());
        this.writeFLOAT((float)affineTransform.getScaleY());
        this.writeFLOAT((float)affineTransform.getTranslateX());
        this.writeFLOAT((float)affineTransform.getTranslateY());
    }

    public void writePOINTS(Point[] pointArray) throws IOException {
        this.writePOINTS(pointArray.length, pointArray);
    }

    public void writePOINTS(int n2, Point[] pointArray) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writePOINTS(pointArray[i2]);
        }
    }

    public void writePOINTS(Point point) throws IOException {
        this.writeSHORT((short)point.x);
        this.writeSHORT((short)point.y);
    }

    public void writePOINTL(Point[] pointArray) throws IOException {
        this.writePOINTL(pointArray.length, pointArray);
    }

    public void writePOINTL(int n2, Point[] pointArray) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writePOINTL(pointArray[i2]);
        }
    }

    public void writePOINTL(Point point) throws IOException {
        this.writeLONG(point.x);
        this.writeLONG(point.y);
    }

    public void writeRECTL(Rectangle rectangle) throws IOException {
        this.writeLONG(rectangle.x);
        this.writeLONG(rectangle.y);
        this.writeLONG(rectangle.x + rectangle.width);
        this.writeLONG(rectangle.y + rectangle.height);
    }

    public void writeSIZEL(Dimension dimension) throws IOException {
        this.writeLONG(dimension.width);
        this.writeLONG(dimension.height);
    }

    public void writeUINT(int n2) throws IOException {
        this.writeUnsignedInt(n2);
    }

    public void writeULONG(int n2) throws IOException {
        this.writeUnsignedInt(n2);
    }

    public void writeLONG(int n2) throws IOException {
        this.writeInt(n2);
    }

    public void writeSHORT(short s2) throws IOException {
        this.writeShort(s2);
    }

    public void writeBYTE(byte[] byArray) throws IOException {
        this.writeByte(byArray);
    }

    public void writeBYTE(byte by) throws IOException {
        this.writeByte(by);
    }

    public void writeBYTE(int n2) throws IOException {
        this.writeByte(n2);
    }

    public void writeBYTE(boolean bl) throws IOException {
        this.writeBYTE(bl ? 1 : 0);
    }

    public void writeWORD(boolean bl) throws IOException {
        this.writeWORD(bl ? 1 : 0);
    }

    public void writeDWORD(boolean bl) throws IOException {
        this.writeDWORD(bl ? 1 : 0);
    }

    public void writeWCHAR(String string) throws IOException {
        this.writeByte(string.getBytes("UTF-16LE"));
    }

    public void writeWCHAR(String string, int n2) throws IOException {
        this.writeWCHAR(string);
        for (int i2 = n2 - string.length(); i2 > 0; --i2) {
            this.writeWORD(0);
        }
    }

    protected int getTagAlignment() {
        return 4;
    }

    protected void writeTagHeader(TagHeader tagHeader) throws IOException {
        int n2 = tagHeader.getTag();
        long l2 = tagHeader.getLength();
        this.writeUnsignedInt(n2);
        this.writeUnsignedInt(l2 + 8L);
    }

    public void writeTag(Tag tag) throws IOException {
        ++this.recordCount;
        super.writeTag(tag);
    }

    protected void writeActionHeader(ActionHeader actionHeader) throws IOException {
    }

    public void writeHeader(EMFHeader eMFHeader) throws IOException {
        eMFHeader.write(this);
    }

    public int getVersion() {
        return this.version;
    }
}

