/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.gdi.BitmapInfoHeader;
import org.freehep.graphicsio.emf.gdi.BlendFunction;

public class EMFImageLoader {
    public static BufferedImage readImage(BitmapInfoHeader bitmapInfoHeader, int n2, int n3, EMFInputStream eMFInputStream, int n4, BlendFunction blendFunction) throws IOException {
        if (bitmapInfoHeader.getBitCount() == 1) {
            int n5 = eMFInputStream.readUnsignedByte();
            int n6 = eMFInputStream.readUnsignedByte();
            int n7 = eMFInputStream.readUnsignedByte();
            eMFInputStream.readUnsignedByte();
            int n8 = new Color(n7, n6, n5).getRGB();
            n5 = eMFInputStream.readUnsignedByte();
            n6 = eMFInputStream.readUnsignedByte();
            n7 = eMFInputStream.readUnsignedByte();
            eMFInputStream.readUnsignedByte();
            int n9 = new Color(n7, n6, n5).getRGB();
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            int[] nArray = eMFInputStream.readUnsignedByte(n4 - 8);
            int n10 = n2 % 8;
            if (n10 != 0) {
                n10 = 8 - n10;
            }
            int n11 = 0;
            int[] nArray2 = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
            for (int i2 = n3 - 1; i2 > -1; --i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n12 = nArray[n11 / 8];
                    int n13 = n12 & nArray2[n11 % 8];
                    ++n11;
                    if (n13 > 0) {
                        bufferedImage.setRGB(i3, i2, n9);
                        continue;
                    }
                    bufferedImage.setRGB(i3, i2, n8);
                }
                n11 += n10;
            }
            return bufferedImage;
        }
        if (bitmapInfoHeader.getBitCount() == 8 && bitmapInfoHeader.getCompression() == 0) {
            int n14 = bitmapInfoHeader.getClrUsed();
            int[] nArray = eMFInputStream.readUnsignedByte(n14 * 4);
            int[] nArray3 = eMFInputStream.readUnsignedByte(n4 - n14 * 4);
            int[] nArray4 = new int[256];
            int n15 = 0;
            int n16 = 0;
            while (n16 < n14) {
                nArray4[n16] = new Color(nArray[n15 + 2], nArray[n15 + 1], nArray[n15]).getRGB();
                n15 = ++n16 * 4;
            }
            if (n14 < 256) {
                Arrays.fill(nArray4, n14, 256, 0);
            }
            if ((n16 = n2 % 4) != 0) {
                n16 = 4 - n16;
            }
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            int n17 = 0;
            for (int i4 = n3 - 1; i4 > -1; --i4) {
                for (int i5 = 0; i5 < n2; ++i5) {
                    bufferedImage.setRGB(i5, i4, nArray4[nArray3[n17++]]);
                }
                n17 += n16;
            }
            return bufferedImage;
        }
        if (bitmapInfoHeader.getBitCount() == 16 && bitmapInfoHeader.getCompression() == 0) {
            int[] nArray = eMFInputStream.readDWORD(n4 / 4);
            n2 = (n2 + n2 % 2) / 2;
            n3 = nArray.length / n2 / 2;
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            int n18 = 0;
            int n19 = n3 - 1;
            while (n19 > -1) {
                for (int i6 = 0; i6 < n2; ++i6) {
                    int n20 = nArray[n18 + n2];
                    int n21 = nArray[n18++];
                    bufferedImage.setRGB(i6, n19, new Color((float)((n21 & 0x7C00) + (n20 & 0x7C00)) / 63488.0f, (float)((n21 & 0x3E0) + (n20 & 0x3E0)) / 1984.0f, (float)((n21 & 0x1F) + (n20 & 0x1F)) / 62.0f).getRGB());
                }
                --n19;
                n18 += n2;
            }
            return bufferedImage;
        }
        if (bitmapInfoHeader.getBitCount() == 32 && bitmapInfoHeader.getCompression() == 0) {
            n2 = (n2 + n2 % 20) / 20;
            n3 = (n3 + n3 % 20) / 20;
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
            int[] nArray = eMFInputStream.readDWORD(n4 / 4);
            int n22 = 0;
            int n23 = blendFunction.getSourceConstantAlpha();
            if (blendFunction.getAlphaFormat() != 1) {
                for (int i7 = n3 - 1; i7 > -1 && n22 < nArray.length; --i7) {
                    for (int i8 = 0; i8 < n2 && n22 < nArray.length; ++i8) {
                        int n24 = nArray[n22++];
                        bufferedImage.setRGB(i8, i7, new Color((n24 & 0xFF0000) >> 16, (n24 & 0xFF00) >> 8, n24 & 0xFF, n23).getRGB());
                    }
                }
            } else if (n23 == 255) {
                for (int i9 = n3 - 1; i9 > -1 && n22 < nArray.length; --i9) {
                    for (int i10 = 0; i10 < n2 && n22 < nArray.length; ++i10) {
                        int n25;
                        int n26;
                        if ((n26 = ((n25 = nArray[n22++]) & 0xFF000000) >> 24) == -1) {
                            n26 = 255;
                        }
                        bufferedImage.setRGB(i10, i9, new Color((n25 & 0xFF0000) >> 16, (n25 & 0xFF00) >> 8, n25 & 0xFF, n26).getRGB());
                    }
                }
            } else {
                for (int i11 = n3 - 1; i11 > -1 && n22 < nArray.length; --i11) {
                    for (int i12 = 0; i12 < n2 && n22 < nArray.length; ++i12) {
                        int n27;
                        int n28;
                        if ((n28 = ((n27 = nArray[n22++]) & 0xFF000000) >> 24) == -1) {
                            n28 = 255;
                        }
                        n28 = n28 * n23 / 255;
                        bufferedImage.setRGB(i12, i11, new Color((n27 & 0xFF0000) >> 16, (n27 & 0xFF00) >> 8, n27 & 0xFF, n28).getRGB());
                    }
                }
            }
            return bufferedImage;
        }
        if (bitmapInfoHeader.getBitCount() == 32 && bitmapInfoHeader.getCompression() == 3) {
            eMFInputStream.readByte(n4);
            return null;
        }
        eMFInputStream.readByte(n4);
        return null;
    }
}

