/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class EMFHeader
implements EMFConstants {
    private static final Dimension screenMM = new Dimension(320, 240);
    private Rectangle bounds;
    private Rectangle frame;
    private String signature;
    private int versionMajor;
    private int versionMinor;
    private int bytes;
    private int records;
    private int handles;
    private String description;
    private int palEntries;
    private Dimension device;
    private Dimension millimeters;
    private Dimension micrometers;
    private boolean openGL;

    public EMFHeader(Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, String string, String string2, Dimension dimension) {
        this.bounds = rectangle;
        double d2 = (double)EMFHeader.screenMM.width / (double)dimension.width;
        double d3 = (double)EMFHeader.screenMM.height / (double)dimension.height;
        this.frame = new Rectangle((int)((double)(rectangle.x * 100) * d2), (int)((double)(rectangle.y * 100) * d3), (int)((double)(rectangle.width * 100) * d2), (int)((double)(rectangle.height * 100) * d3));
        this.signature = " EMF";
        this.versionMajor = n2;
        this.versionMinor = n3;
        this.bytes = n4;
        this.records = n5;
        this.handles = n6;
        this.description = string.trim() + "\u0000" + string2.trim() + "\u0000\u0000";
        this.palEntries = 0;
        this.device = dimension;
        this.millimeters = screenMM;
        this.openGL = false;
        this.micrometers = new Dimension(EMFHeader.screenMM.width * 1000, EMFHeader.screenMM.height * 1000);
    }

    EMFHeader(EMFInputStream eMFInputStream) throws IOException {
        eMFInputStream.readUnsignedInt();
        int n2 = eMFInputStream.readDWORD();
        this.bounds = eMFInputStream.readRECTL();
        this.frame = eMFInputStream.readRECTL();
        this.signature = new String(eMFInputStream.readBYTE(4));
        int n3 = eMFInputStream.readDWORD();
        this.versionMajor = n3 >> 16;
        this.versionMinor = n3 & 0xFFFF;
        this.bytes = eMFInputStream.readDWORD();
        this.records = eMFInputStream.readDWORD();
        this.handles = eMFInputStream.readWORD();
        eMFInputStream.readWORD();
        int n4 = eMFInputStream.readDWORD();
        int n5 = eMFInputStream.readDWORD();
        this.palEntries = eMFInputStream.readDWORD();
        this.device = eMFInputStream.readSIZEL();
        this.millimeters = eMFInputStream.readSIZEL();
        int n6 = 88;
        if (n5 > 88) {
            eMFInputStream.readDWORD();
            eMFInputStream.readDWORD();
            this.openGL = eMFInputStream.readDWORD() != 0;
            n6 += 12;
            if (n5 > 100) {
                this.micrometers = eMFInputStream.readSIZEL();
                n6 += 8;
            }
        }
        if (n6 < n5) {
            eMFInputStream.skipBytes(n5 - n6);
            n6 = n5;
        }
        this.description = eMFInputStream.readWCHAR(n4);
        if ((n6 += n4 * 2) < n2) {
            eMFInputStream.skipBytes(n2 - n6);
        }
    }

    public void write(EMFOutputStream eMFOutputStream) throws IOException {
        int n2 = eMFOutputStream.getTagAlignment();
        int n3 = (n2 - this.size() % n2) % n2;
        int n4 = this.size() + n3;
        eMFOutputStream.writeDWORD(1);
        eMFOutputStream.writeDWORD(n4);
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writeRECTL(this.frame);
        eMFOutputStream.writeBYTE(this.signature.getBytes());
        eMFOutputStream.writeDWORD(this.versionMajor << 16 | this.versionMinor);
        eMFOutputStream.writeDWORD(n4 + this.bytes);
        eMFOutputStream.writeDWORD(this.records);
        eMFOutputStream.writeWORD(this.handles);
        eMFOutputStream.writeWORD(0);
        eMFOutputStream.writeDWORD(this.description.length());
        eMFOutputStream.writeDWORD(108);
        eMFOutputStream.writeDWORD(this.palEntries);
        eMFOutputStream.writeSIZEL(this.device);
        eMFOutputStream.writeSIZEL(this.millimeters);
        eMFOutputStream.writeDWORD(0);
        eMFOutputStream.writeDWORD(0);
        eMFOutputStream.writeDWORD(this.openGL);
        eMFOutputStream.writeSIZEL(this.micrometers);
        eMFOutputStream.writeWCHAR(this.description);
        for (int i2 = 0; i2 < n3; ++i2) {
            eMFOutputStream.write(0);
        }
    }

    public int size() {
        return 108 + 2 * this.description.length();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("EMF Header\n");
        stringBuffer.append("  bounds: ").append(this.bounds).append("\n");
        stringBuffer.append("  frame: ").append(this.frame).append("\n");
        stringBuffer.append("  signature: ").append(this.signature).append("\n");
        stringBuffer.append("  versionMajor: ").append(this.versionMajor).append("\n");
        stringBuffer.append("  versionMinor: ").append(this.versionMinor).append("\n");
        stringBuffer.append("  #bytes: ").append(this.bytes).append("\n");
        stringBuffer.append("  #records: ").append(this.records).append("\n");
        stringBuffer.append("  #handles: ").append(this.handles).append("\n");
        stringBuffer.append("  description: ").append(this.description).append("\n");
        stringBuffer.append("  #palEntries: ").append(this.palEntries).append("\n");
        stringBuffer.append("  device: ").append(this.device).append("\n");
        stringBuffer.append("  millimeters: ").append(this.millimeters).append("\n");
        stringBuffer.append("  openGL: ").append(this.openGL).append("\n");
        stringBuffer.append("  micrometers: ").append(this.micrometers);
        return stringBuffer.toString();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Rectangle getFrame() {
        return this.frame;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getDescription() {
        return this.description;
    }

    public Dimension getDevice() {
        return this.device;
    }

    public Dimension getMillimeters() {
        return this.millimeters;
    }

    public Dimension getMicrometers() {
        return this.micrometers;
    }

    public boolean isOpenGL() {
        return this.openGL;
    }
}

