/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.freehep.graphics2d.PixelGraphics2D;
import org.freehep.graphicsio.ImageParamConverter;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.util.UserProperties;
import org.freehep.util.images.ImageUtilities;
import org.freehep.util.io.ASCII85OutputStream;
import org.freehep.util.io.FlateOutputStream;

public class ImageGraphics2D
extends PixelGraphics2D {
    private static final String[] alwaysCompressedFormats = new String[]{"JPG".toLowerCase(), "JPEG".toLowerCase(), "GIF".toLowerCase()};
    private static final String[] nonTransparentFormats = new String[]{"JPG".toLowerCase(), "JPEG".toLowerCase(), "PPM".toLowerCase()};
    public static final String rootKey = "org.freehep.graphicsio";
    public static final String TRANSPARENT = ".Transparent";
    public static final String BACKGROUND = ".Background";
    public static final String BACKGROUND_COLOR = ".BackgroundColor";
    public static final String ANTIALIAS = ".Antialias";
    public static final String ANTIALIAS_TEXT = ".AntialiasText";
    public static final String PROGRESSIVE = ".Progressive";
    public static final String COMPRESS = ".Compress";
    public static final String COMPRESS_MODE = ".CompressMode";
    public static final String COMPRESS_DESCRIPTION = ".CompressDescription";
    public static final String COMPRESS_QUALITY = ".CompressQuality";
    private static final Map defaultProperties = new HashMap();
    protected OutputStream os;
    protected BufferedImage image;
    protected String format;
    protected Component component;

    public static Properties getDefaultProperties(String string) {
        UserProperties userProperties = (UserProperties)defaultProperties.get(string);
        if (userProperties == null) {
            userProperties = new UserProperties();
            defaultProperties.put(string, userProperties);
            String string2 = "org.freehep.graphicsio." + string;
            if (ImageGraphics2D.canWriteTransparent(string)) {
                userProperties.setProperty(string2 + TRANSPARENT, true);
                userProperties.setProperty(string2 + BACKGROUND, false);
                userProperties.setProperty(string2 + BACKGROUND_COLOR, Color.GRAY);
            } else {
                userProperties.setProperty(string2 + BACKGROUND, false);
                userProperties.setProperty(string2 + BACKGROUND_COLOR, Color.GRAY);
            }
            userProperties.setProperty(string2 + ANTIALIAS, true);
            userProperties.setProperty(string2 + ANTIALIAS_TEXT, true);
            ImageWriter imageWriter = ImageGraphics2D.getPreferredImageWriter(string);
            if (imageWriter != null) {
                ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                if (imageWriteParam.canWriteCompressed()) {
                    imageWriteParam.setCompressionMode(2);
                    userProperties.setProperty(string2 + COMPRESS, true);
                    String[] stringArray = imageWriteParam.getCompressionTypes();
                    String string3 = imageWriteParam.getCompressionType();
                    userProperties.setProperty(string2 + COMPRESS_MODE, string3 != null ? string3 : stringArray[0]);
                    userProperties.setProperty(string2 + COMPRESS_DESCRIPTION, "Custom");
                    float f2 = 0.0f;
                    try {
                        f2 = imageWriteParam.getCompressionQuality();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    userProperties.setProperty(string2 + COMPRESS_QUALITY, f2);
                } else {
                    userProperties.setProperty(string2 + COMPRESS, false);
                    userProperties.setProperty(string2 + COMPRESS_MODE, "");
                    userProperties.setProperty(string2 + COMPRESS_DESCRIPTION, "Custom");
                    userProperties.setProperty(string2 + COMPRESS_QUALITY, 0.0f);
                }
                if (imageWriteParam.canWriteProgressive()) {
                    userProperties.setProperty(string2 + PROGRESSIVE, imageWriteParam.getProgressiveMode() != 0);
                } else {
                    userProperties.setProperty(string2 + PROGRESSIVE, false);
                }
            } else {
                System.err.println(ImageGraphics2D.class + ": No writer for format '" + string + "'.");
            }
        }
        return userProperties;
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        String string = "org.freehep.graphicsio." + this.format;
        Properties properties2 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (string2.indexOf("." + this.format) < 0) {
                string2 = string + string2;
            }
            properties2.setProperty(string2, string3);
        }
        super.setProperties(properties2);
        this.setPropertiesOnGraphics();
    }

    private void setPropertiesOnGraphics() {
        String string = "org.freehep.graphicsio." + this.format;
        if (this.isProperty(string + ANTIALIAS)) {
            this.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isProperty(string + ANTIALIAS_TEXT)) {
            this.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            this.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.isProperty(string + TRANSPARENT)) {
            this.setBackground(null);
        } else if (this.isProperty(string + BACKGROUND)) {
            this.setBackground(this.getPropertyColor(string + BACKGROUND_COLOR));
        } else {
            this.setBackground(this.component != null ? this.component.getBackground() : Color.WHITE);
        }
    }

    private void setHintsOnGraphics() {
        if (this.format.equalsIgnoreCase("JPG")) {
            this.setRenderingHint(KEY_SYMBOL_BLIT, VALUE_SYMBOL_BLIT_OFF);
        } else {
            this.setRenderingHint(KEY_SYMBOL_BLIT, VALUE_SYMBOL_BLIT_ON);
        }
    }

    public ImageGraphics2D(File file, Dimension dimension, String string) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), dimension, string);
    }

    public ImageGraphics2D(File file, Component component, String string) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component, string);
    }

    public ImageGraphics2D(OutputStream outputStream, Dimension dimension, String string) {
        this.init(outputStream, dimension, string);
        this.component = null;
    }

    public ImageGraphics2D(OutputStream outputStream, Component component, String string) {
        this.component = component;
        this.init(outputStream, component.getSize(), string);
        this.setColor(component.getForeground());
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            this.setTransform(graphicsConfiguration.getDefaultTransform());
        }
    }

    private void init(OutputStream outputStream, Dimension dimension, String string) {
        this.os = outputStream;
        this.format = string;
        this.initProperties(ImageGraphics2D.getDefaultProperties(string));
        this.image = ImageGraphics2D.createBufferedImage(string, dimension.width, dimension.height);
        this.setHostGraphics(this.image.getGraphics());
        this.setPropertiesOnGraphics();
        this.setHintsOnGraphics();
        this.hostGraphics.clipRect(0, 0, dimension.width, dimension.height);
    }

    protected ImageGraphics2D(ImageGraphics2D imageGraphics2D) {
        super(imageGraphics2D);
        this.image = imageGraphics2D.image;
        this.os = imageGraphics2D.os;
        this.format = imageGraphics2D.format;
        this.setHintsOnGraphics();
    }

    public Graphics create() {
        return new ImageGraphics2D(this);
    }

    public Graphics create(double d2, double d3, double d4, double d5) {
        ImageGraphics2D imageGraphics2D = new ImageGraphics2D(this);
        imageGraphics2D.translate(d2, d3);
        imageGraphics2D.clipRect(0.0, 0.0, d4, d5);
        return imageGraphics2D;
    }

    public void startExport() {
        if (this.getBackground() != null) {
            this.clearRect(0.0, 0.0, (double)this.image.getWidth(), (double)this.image.getHeight());
        }
    }

    public void endExport() {
        try {
            this.write();
            this.closeStream();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    protected void write() throws IOException {
        ImageGraphics2D.writeImage(this.image, this.format, this.getProperties(), this.os);
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    protected void handleException(Exception exception) {
        System.err.println(exception);
    }

    public static BufferedImage createBufferedImage(String string, int n2, int n3) {
        if ("WBMP".equalsIgnoreCase(string)) {
            return new BufferedImage(n2, n3, 12);
        }
        if ("JPG".equalsIgnoreCase(string)) {
            return new BufferedImage(n2, n3, 1);
        }
        if ("BMP".equalsIgnoreCase(string)) {
            return new BufferedImage(n2, n3, 1);
        }
        return new BufferedImage(n2, n3, 2);
    }

    public static BufferedImage generateThumbnail(Component component, Dimension dimension) {
        int n2 = Math.max(dimension.width, dimension.height);
        if (n2 < 0) {
            return null;
        }
        int n3 = component.getBounds().width;
        int n4 = component.getBounds().height;
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        Graphics graphics = bufferedImage.getGraphics();
        component.print(graphics);
        int n5 = n2;
        int n6 = n2;
        if (n3 < n4) {
            n5 = n3 * dimension.height / n4;
        } else {
            n6 = n4 * dimension.width / n3;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n5, n6, 2);
        Graphics graphics2 = bufferedImage2.getGraphics();
        graphics2.drawImage(bufferedImage, 0, 0, n5, n6, null);
        return bufferedImage2;
    }

    public static void writeImage(Image image, String string, Properties properties, OutputStream outputStream) throws IOException {
        ImageGraphics2D.writeImage(ImageUtilities.createRenderedImage(image, null, Color.black), string, properties, outputStream);
    }

    public static void writeImage(RenderedImage renderedImage, String string, Properties properties, OutputStream outputStream) throws IOException {
        ImageWriter imageWriter = ImageGraphics2D.getPreferredImageWriter(string);
        if (imageWriter == null) {
            throw new IOException(ImageGraphics2D.class + ": No writer for format '" + string + "'.");
        }
        UserProperties userProperties = new UserProperties(properties);
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (imageWriteParam instanceof ImageParamConverter) {
            imageWriteParam = ((ImageParamConverter)((Object)imageWriteParam)).getWriteParam(userProperties);
        }
        String string2 = "org.freehep.graphicsio." + string;
        if (imageWriteParam.canWriteCompressed()) {
            if (userProperties.isProperty(string2 + COMPRESS)) {
                if (userProperties.getProperty(string2 + COMPRESS_MODE).equals("")) {
                    imageWriteParam.setCompressionMode(1);
                } else {
                    imageWriteParam.setCompressionMode(2);
                    imageWriteParam.setCompressionType(userProperties.getProperty(string2 + COMPRESS_MODE));
                    imageWriteParam.setCompressionQuality(userProperties.getPropertyFloat(string2 + COMPRESS_QUALITY));
                }
            } else if (ImageGraphics2D.canWriteUncompressed(string)) {
                imageWriteParam.setCompressionMode(0);
            }
        }
        if (imageWriteParam.canWriteProgressive()) {
            if (userProperties.isProperty(string2 + PROGRESSIVE)) {
                imageWriteParam.setProgressiveMode(1);
            } else {
                imageWriteParam.setProgressiveMode(0);
            }
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(null, new IIOImage(renderedImage, null, null), imageWriteParam);
        imageWriter.dispose();
        imageOutputStream.close();
    }

    public static ImageWriter getPreferredImageWriter(String string) {
        return (ImageWriter)ImageGraphics2D.getImageWriters(ImageIO.getImageWritersByFormatName(string)).first();
    }

    public static ImageWriter getPreferredImageWriterForMIMEType(String string) {
        return (ImageWriter)ImageGraphics2D.getImageWriters(ImageIO.getImageWritersByMIMEType(string)).first();
    }

    public static SortedSet getImageWriters(Iterator iterator) {
        TreeSet<ImageWriter> treeSet = new TreeSet<ImageWriter>(new Comparator(){

            private int order(Object object) {
                String string = object.getClass().getName();
                if (string.startsWith("org.freehep.")) {
                    return 0;
                }
                if (string.startsWith("com.sun.imageio.")) {
                    return 1;
                }
                if (string.startsWith("com.sun.media.")) {
                    return 2;
                }
                return 3;
            }

            public int compare(Object object, Object object2) {
                int n2;
                int n3 = this.order(object);
                return n3 < (n2 = this.order(object2)) ? -1 : (n3 > n2 ? 1 : 0);
            }
        });
        while (iterator.hasNext()) {
            treeSet.add((ImageWriter)iterator.next());
        }
        return treeSet;
    }

    public static BufferedImage readImage(String string, InputStream inputStream) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string.toLowerCase());
        if (!iterator.hasNext()) {
            throw new IOException(ImageGraphics2D.class + ": No reader for format '" + string + "'.");
        }
        ImageReader imageReader = iterator.next();
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        imageReader.setInput(imageInputStream, true);
        BufferedImage bufferedImage = imageReader.read(0);
        imageReader.dispose();
        imageInputStream.close();
        return bufferedImage;
    }

    public static boolean canWriteUncompressed(String string) {
        return !Arrays.asList(alwaysCompressedFormats).contains(string.toLowerCase());
    }

    public static boolean canWriteTransparent(String string) {
        return !Arrays.asList(nonTransparentFormats).contains(string.toLowerCase());
    }

    public static UserProperties getRAWProperties(Color color, String string) {
        UserProperties userProperties = new UserProperties();
        userProperties.setProperty(RawImageWriteParam.BACKGROUND, color);
        userProperties.setProperty(RawImageWriteParam.CODE, string);
        userProperties.setProperty(RawImageWriteParam.PAD, 1);
        return userProperties;
    }

    public static byte[] toByteArray(RenderedImage renderedImage, String string, String string2, Properties properties) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = byteArrayOutputStream;
        if ("ASCII85".equals(string2) || "Flate-ASCII85".equals(string2)) {
            outputStream = new ASCII85OutputStream(outputStream);
        }
        if ("Flate".equals(string2) || "Flate-ASCII85".equals(string2)) {
            outputStream = new FlateOutputStream(outputStream);
        }
        if (properties == null) {
            properties = new Properties();
        }
        ImageGraphics2D.writeImage(renderedImage, string.toLowerCase(), properties, outputStream);
        outputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

