/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.Color;
import java.awt.color.ColorSpace;

public class PrintColor
extends Color {
    public static final int COLOR = 0;
    public static final int GRAYSCALE = 1;
    public static final int BLACK_AND_WHITE = 2;
    protected static Color[] defaultColors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.CYAN, Color.MAGENTA, Color.YELLOW, Color.ORANGE, Color.PINK, Color.WHITE, Color.LIGHT_GRAY, Color.GRAY, Color.DARK_GRAY, Color.BLACK};
    protected float asGray;
    protected boolean asBlack;

    private static void testColorValueRange(float f2) {
        boolean bl = false;
        String string = "";
        if (f2 < 0.0f || f2 > 1.0f) {
            bl = true;
            string = string + " asGray";
        }
        if (bl) {
            throw new IllegalArgumentException("PrintColor parameter outside of expected range:" + string);
        }
    }

    public PrintColor(float f2, float f3, float f4, float f5, boolean bl) {
        this(f2, f3, f4, 1.0f, f5, bl);
    }

    public PrintColor(float f2, float f3, float f4, float f5, float f6, boolean bl) {
        super(f2, f3, f4, f5);
        this.asGray = f6;
        this.asBlack = bl;
        PrintColor.testColorValueRange(f6);
    }

    public PrintColor(Color color, float f2, boolean bl) {
        super(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        this.asGray = f2;
        this.asBlack = bl;
        PrintColor.testColorValueRange(f2);
    }

    public float getAsGray() {
        return this.asGray;
    }

    public boolean getAsBlack() {
        return this.asBlack;
    }

    public PrintColor getColor(int n2) {
        switch (n2) {
            case 0: {
                return this;
            }
            case 1: {
                return new PrintColor(this.getAsGray(), this.getAsGray(), this.getAsGray(), (float)this.getAlpha() / 255.0f, this.getAsGray(), this.getAsBlack());
            }
            case 2: {
                if (this.getAsBlack()) {
                    return new PrintColor(Color.black, this.getAsGray(), this.getAsBlack());
                }
                return new PrintColor(Color.white, this.getAsGray(), this.getAsBlack());
            }
        }
        throw new IllegalArgumentException("ColorMode on PrintColor out of range: " + n2);
    }

    public static PrintColor createPrintColor(Color color) {
        if (color == null) {
            return null;
        }
        if (color instanceof PrintColor) {
            return (PrintColor)color;
        }
        float[] fArray = ColorSpace.getInstance(1003).fromRGB(color.getRGBComponents(null));
        if (fArray[0] == 0.0f) {
            fArray[0] = 1.0f;
        } else if (fArray[0] == 1.0f) {
            fArray[0] = 0.0f;
        }
        return new PrintColor(color, fArray[0], !color.equals(Color.black));
    }

    public static Color getDefaultColor(int n2) {
        if (n2 < 0 || n2 >= defaultColors.length) {
            throw new IllegalArgumentException("PrintColor.getDefaultColor index outside of expected range: " + n2);
        }
        return PrintColor.createPrintColor(defaultColors[n2]);
    }

    public static Color mixColor(Color color, Color color2) {
        int n2 = (color.getRed() + color2.getRed()) / 2;
        int n3 = (color.getGreen() + color2.getGreen()) / 2;
        int n4 = (color.getBlue() + color2.getBlue()) / 2;
        return new Color(n2, n3, n4);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof PrintColor && ((PrintColor)object).asGray == this.asGray && ((PrintColor)object).asBlack == this.asBlack;
    }

    public String toString() {
        return super.toString() + ", asGray: " + this.asGray + ", asBlack: " + this.asBlack;
    }

    public static PrintColor invert(Color color) {
        PrintColor printColor = PrintColor.createPrintColor(color);
        return new PrintColor(new Color(printColor.getRGB() ^ 0x808080), (printColor.getAsGray() + 0.5f) % 1.0f, !printColor.getAsBlack());
    }
}

