/*
 * Decompiled with CFR 0.152.
 */
package geogebra.export.pstricks;

import geogebra.euclidian.b;
import geogebra.euclidian.e;
import geogebra.euclidian.w;
import geogebra.euclidian.z;
import geogebra.export.pstricks.k;
import geogebra.i;
import geogebra.kernel.A;
import geogebra.kernel.K;
import geogebra.kernel.Z;
import geogebra.kernel.aB;
import geogebra.kernel.aQ;
import geogebra.kernel.ar;
import geogebra.kernel.arithmetic.a;
import geogebra.kernel.bE;
import geogebra.kernel.bM;
import geogebra.kernel.bQ;
import geogebra.kernel.bS;
import geogebra.kernel.bV;
import geogebra.kernel.bd;
import geogebra.kernel.bk;
import geogebra.kernel.bm;
import geogebra.kernel.bn;
import geogebra.kernel.bz;
import geogebra.kernel.cC;
import geogebra.kernel.cY;
import geogebra.kernel.cZ;
import geogebra.kernel.cg;
import geogebra.kernel.cn;
import geogebra.kernel.cr;
import geogebra.kernel.ct;
import geogebra.kernel.j;
import geogebra.kernel.y;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GeoGebraToPstricks
implements ActionListener {
    private final double a = 1.0E-5;
    private StringBuffer a;
    private StringBuffer b;
    private StringBuffer c;
    private StringBuffer d;
    private StringBuffer e;
    private StringBuffer f;
    private i a;
    private bM a;
    private y a;
    private w a;
    private k a;
    private HashMap a = 1.0E-5;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;
    private double g;

    public GeoGebraToPstricks(i i2) {
        this.a = i2;
        this.a = i2.a();
        this.a = this.a.a();
        this.a = i2.a();
        this.initGui();
    }

    public i getApp() {
        return this.a;
    }

    private void initGui() {
        this.b = 1.0;
        this.c = 1.0;
        Rectangle rectangle = this.a.a();
        if (rectangle != null) {
            this.d = this.a.c(rectangle.getMinX());
            this.e = this.a.c(rectangle.getMaxX());
            this.f = this.a.d(rectangle.getMaxY());
            this.g = this.a.d(rectangle.getMinY());
        } else {
            this.d = this.a.h();
            this.e = this.a.g();
            this.f = this.a.j();
            this.g = this.a.i();
        }
        this.a = new k(this);
    }

    private void refreshEuclidianView() {
        int n2 = this.a.a(this.d);
        int n3 = this.a.b(this.f);
        int n4 = this.a.a(this.e) - n2;
        int n5 = this.a.b(this.g) - n3;
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        this.a.a(rectangle);
    }

    public void setxmin(double d2) {
        this.d = d2;
        this.refreshEuclidianView();
    }

    public void setxmax(double d2) {
        this.e = d2;
        this.refreshEuclidianView();
    }

    public void setymin(double d2) {
        this.f = d2;
        this.refreshEuclidianView();
    }

    public void setymax(double d2) {
        this.g = d2;
        this.refreshEuclidianView();
    }

    public double getxmin() {
        return this.d;
    }

    public double getxmax() {
        return this.e;
    }

    public double getymin() {
        return this.f;
    }

    public double getymax() {
        return this.g;
    }

    public void setxunit(double d2) {
        this.b = d2;
    }

    public void setyunit(double d2) {
        this.c = d2;
    }

    public double getxunit() {
        return this.b;
    }

    public double getyunit() {
        return this.c;
    }

    public void createPstricks() {
        try {
            this.b = this.a.a();
            this.c = this.a.b();
        }
        catch (NullPointerException nullPointerException) {
            this.b = 1.0;
            this.c = 1.0;
        }
        this.a = new StringBuffer();
        this.b = new StringBuffer();
        this.c = new StringBuffer();
        this.d = new StringBuffer();
        this.e = new StringBuffer();
        this.f = new StringBuffer();
        this.a = new HashMap();
        this.c.append("\\documentclass[" + this.a.a() + "pt]{article}\n" + "\\usepackage{pstricks,pstricks-add,pst-math,pst-xkey}\n");
        this.e.append("\\begin{document}\n");
        if (this.a.e()) {
            this.drawGrid();
        } else {
            this.initUnitAndVariable();
            this.f.append("\\begin{pspicture*}(");
            this.f.append(this.a.a(this.d));
            this.f.append(",");
            this.f.append(this.a.a(this.f));
            this.f.append(")(");
            this.f.append(this.a.a(this.e));
            this.f.append(",");
            this.f.append(this.a.a(this.g));
            this.f.append(")\n");
        }
        if (this.a.c() || this.a.d()) {
            this.drawAxis();
        }
        Iterator iterator = this.a.a().iterator();
        while (iterator.hasNext()) {
            bE bE2 = (bE)iterator.next();
            this.drawGeoElement(bE2);
        }
        this.a.append(this.b);
        this.a.append("\\end{pspicture*}\n");
        this.a.insert(0, (Object)this.d);
        this.a.insert(0, (Object)this.f);
        this.a.insert(0, (Object)this.e);
        this.a.insert(0, (Object)this.c);
        this.a.append("\\end{document}");
        this.a.a(this.a);
    }

    private void drawGeoElement(bE bE2) {
        if (bE2.L()) {
            if (bE2.ag()) {
                this.drawGeoPoint((bQ)bE2);
                this.drawLabel(bE2, null);
            } else if (bE2.ai()) {
                this.drawGeoSegment((cr)bE2);
                this.drawLabel(bE2, null);
            } else if (bE2.ah()) {
                this.drawGeoRay((ct)bE2);
                this.drawLabel(bE2, null);
            } else if (bE2.c_()) {
                this.drawGeoLine((j)bE2);
                this.drawLabel(bE2, null);
            } else if (bE2.u_()) {
                this.drawPolygon((ar)bE2);
                this.drawLabel(bE2, null);
            } else if (bE2.r_()) {
                if (bE2.j()) {
                    this.drawSlider((bV)bE2);
                } else {
                    this.drawAngle((A)bE2);
                    this.drawLabel(bE2, this.a.c((bE)((A)bE2)));
                }
            } else if (bE2.af()) {
                aQ aQ2 = bE2.a();
                if (aQ2 == null) {
                    this.drawSlider((bV)bE2);
                } else if (aQ2 instanceof bn) {
                    this.drawSlope((bV)bE2);
                    this.drawLabel(bE2, null);
                } else if (aQ2 instanceof bm) {
                    this.drawIntegral((bV)bE2);
                    this.drawLabel(bE2, null);
                } else if (aQ2 instanceof bz) {
                    this.drawSumUpperLower((bV)bE2);
                    this.drawLabel(bE2, null);
                }
            } else if (bE2.r()) {
                this.drawGeoVector((K)bE2);
                this.drawLabel(bE2, null);
            } else if (bE2.ae()) {
                cY cY2 = (cY)bE2;
                this.drawGeoConicPart(cY2);
                if (cY2.g() == 1 || cY2.g() == 2) {
                    this.drawLabel(bE2, null);
                }
            } else if (bE2.H()) {
                if (this.isSinglePointConic(bE2)) {
                    bd bd2 = (bd)bE2;
                    bQ bQ2 = bd2.a();
                    bQ2.e((bE)bd2);
                    bQ2.a = bd2.a;
                    bQ2.c = bd2.c;
                    bQ2.a = bd2.e;
                    bQ2.b(bd2.c, bd2.d);
                    e e2 = new e(this.a, bQ2);
                    e2.a((bE)bd2);
                    this.drawGeoPoint(bQ2);
                    this.drawLabel((bE)bQ2, (geogebra.euclidian.K)e2);
                } else if (this.isDoubleLineConic(bE2)) {
                    bd bd3 = (bd)bE2;
                    j[] jArray = bd3.a();
                    z[] zArray = new z[2];
                    int n2 = 0;
                    while (n2 < 2) {
                        jArray[n2].e((bE)bd3);
                        jArray[n2].a = bd3.a;
                        jArray[n2].c = bd3.c;
                        jArray[n2].e = bd3.e;
                        jArray[n2].f = bd3.f;
                        ++n2;
                    }
                    zArray[0] = new z(this.a, jArray[0]);
                    zArray[1] = new z(this.a, jArray[1]);
                    zArray[0].a((bE)bd3);
                    zArray[1].a((bE)bd3);
                    this.drawGeoLine(jArray[0]);
                    this.drawGeoLine(jArray[1]);
                    this.drawLabel((bE)jArray[0], (geogebra.euclidian.K)zArray[0]);
                    this.drawLabel((bE)jArray[1], (geogebra.euclidian.K)zArray[1]);
                } else if (!this.isEmpty(bE2)) {
                    this.drawGeoConic((bd)bE2);
                    this.drawLabel(bE2, null);
                }
            } else if (bE2.z()) {
                this.drawFunction((Z)bE2);
                this.drawLabel(bE2, null);
            } else if (bE2.aj()) {
                this.drawText((cC)bE2);
            } else if (!bE2.w() && bE2.t_()) {
                this.drawLocus((bk)bE2);
            }
        }
    }

    private void drawLocus(bk bk2) {
        ArrayList arrayList = bk2.a();
        Iterator iterator = arrayList.iterator();
        this.a.append("\\pscustom{");
        while (iterator.hasNext()) {
            aB aB2 = (aB)iterator.next();
            String string = this.a.a(aB2.a);
            String string2 = this.a.a(aB2.b);
            boolean bl = aB2.a;
            if (bl) {
                this.a.append("\\lineto(");
            } else {
                this.a.append("\\moveto(");
            }
            this.a.append(string);
            this.a.append(",");
            this.a.append(string2);
            this.a.append(")\n");
        }
        this.a.append("}\n");
    }

    private void drawSumUpperLower(bV bV2) {
        bz bz2 = (bz)bV2.a();
        int n2 = bz2.b();
        double d2 = bz2.a();
        double[] dArray = bz2.a();
        double[] dArray2 = bz2.b();
        int n3 = 0;
        while (n3 < n2) {
            this.d.append("\\psframe");
            this.d.append(this.LineOptionCode((bE)bV2, true));
            this.d.append("(");
            this.d.append(this.a.a(dArray2[n3]));
            this.d.append(",0)(");
            this.d.append(this.a.a(dArray2[n3] + d2));
            this.d.append(",");
            this.d.append(this.a.a(dArray[n3]));
            this.d.append(")\n");
            ++n3;
        }
    }

    private void drawIntegral(bV bV2) {
        bm bm2 = (bm)bV2.a();
        Z z2 = bm2.a();
        String string = this.a.a(bm2.a().e());
        String string2 = this.a.a(bm2.b().e());
        String string3 = z2.c();
        string3 = this.killSpace(geogebra.util.k.a((String)string3, (boolean)true));
        this.d.append("\\pscustom");
        this.d.append(this.LineOptionCode((bE)bV2, true));
        this.d.append("{\\psplot{");
        this.d.append(string);
        this.d.append("}{");
        this.d.append(string2);
        this.d.append("}{");
        this.d.append(string3);
        this.d.append("}\\lineto(");
        this.d.append(string2);
        this.d.append(",0)\\lineto(");
        this.d.append(string);
        this.d.append(",0)\\closepath}\n");
    }

    private void drawSlope(bV bV2) {
        int n2 = bV2.k();
        double d2 = bV2.c() * (double)n2;
        double d3 = this.a.b() * d2;
        double[] dArray = new double[2];
        if (Math.abs(d3) > 3.4028234663852886E38) {
            return;
        }
        j j2 = ((bn)bV2.a()).a();
        j2.b(dArray);
        float f2 = (float)dArray[0];
        float f3 = (float)dArray[1];
        float f4 = f2 + (float)n2;
        this.d.append("\\pspolygon");
        this.d.append(this.LineOptionCode((bE)bV2, true));
        this.d.append("(");
        this.d.append(this.a.a((double)f2));
        this.d.append(",");
        this.d.append(this.a.a((double)f3));
        this.d.append(")");
        this.d.append("(");
        this.d.append(this.a.a((double)f4));
        this.d.append(",");
        this.d.append(this.a.a((double)f3));
        this.d.append(")");
        this.d.append("(");
        this.d.append(this.a.a((double)f4));
        this.d.append(",");
        this.d.append(this.a.a((double)f3 + d2));
        this.d.append(")");
        this.d.append("\n");
        float f5 = (f2 + f4) / 2.0f;
        float f6 = f3 - (float)((double)(this.a.getFont().getSize() + 2) / this.a.b());
        Color color = bV2.a();
        this.b.append("\\rput[bl](");
        this.b.append(this.a.a((double)f5));
        this.b.append(",");
        this.b.append(this.a.a((double)f6));
        this.b.append("){");
        if (!color.equals(Color.BLACK)) {
            this.b.append("\\");
            this.ColorCode(color, this.b);
            this.b.append("{");
        }
        this.b.append(n2);
        if (!color.equals(Color.BLACK)) {
            this.b.append("}");
        }
        this.b.append("}\n");
    }

    private void drawAngle(A a2) {
        K k2;
        bQ bQ2;
        bQ bQ3;
        geogebra.kernel.i i2;
        int n2 = a2.g();
        aQ aQ2 = a2.a();
        bQ bQ4 = new bQ(this.a);
        bQ4.a(0.0, 0.0, 1.0);
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        if (aQ2 instanceof geogebra.kernel.i) {
            i2 = (geogebra.kernel.i)aQ2;
            bQ3 = i2.b();
            bQ2 = i2.a();
            bQ3.a_(dArray2);
            dArray[0] = bQ2.a - dArray2[0];
            dArray[1] = bQ2.b - dArray2[1];
        } else if (aQ2 instanceof cn) {
            i2 = (cn)aQ2;
            k2 = i2.a();
            bQ3 = k2.a();
            if (bQ3 == null) {
                bQ3 = bQ4;
            }
            bQ3.a_(dArray2);
            k2.a_(dArray);
        } else if (aQ2 instanceof cg) {
            i2 = (cg)aQ2;
            j j2 = i2.a();
            j j3 = i2.b();
            bQ3 = bQ4;
            bS.a((bS)j2, (bS)j3, (bS)bQ3);
            bQ3.a_(dArray2);
            j2.a(dArray);
        } else if (aQ2 instanceof geogebra.kernel.k) {
            i2 = (geogebra.kernel.k)aQ2;
            bS bS2 = i2.a();
            if (bS2 instanceof K) {
                k2 = (K)bS2;
                bQ3 = k2.a();
                if (bQ3 == null) {
                    bQ3 = bQ4;
                }
                bQ3.a_(dArray2);
            } else if (bS2 instanceof bQ) {
                bQ2 = (bQ)bS2;
                bQ3 = bQ4;
                bQ3.a_(dArray2);
            }
            dArray[0] = 1.0;
            dArray[1] = 0.0;
        }
        double d2 = Math.atan2(dArray[1], dArray[0]);
        double d3 = a2.a();
        if (d3 > Math.PI * 2) {
            d3 -= Math.PI * 2;
        }
        if (a2.f() == 1) {
            d2 += d3;
            d3 = Math.PI * 2 - d3;
        }
        if (a2.f() == 2 && d3 > Math.PI) {
            d2 += d3;
            d3 = Math.PI * 2 - d3;
        }
        if (a2.f() == 3 && d3 < Math.PI) {
            d2 += d3;
            d3 = Math.PI * 2 - d3;
        }
        d3 += d2;
        double d4 = (double)n2 / this.a.a();
        if (this.a.a(a2.c(), 1.5707963267948966) && a2.n() && this.a.c() == 1) {
            double[] dArray3 = new double[]{dArray2[0] + (d4 /= Math.sqrt(2.0)) * Math.cos(d2), dArray2[1] + d4 * Math.sin(d2), dArray2[0] + d4 * Math.sqrt(2.0) * Math.cos(d2 + 0.7853981633974483), dArray2[1] + d4 * Math.sqrt(2.0) * Math.sin(d2 + 0.7853981633974483), dArray2[0] + d4 * Math.cos(d2 + 1.5707963267948966), dArray2[1] + d4 * Math.sin(d2 + 1.5707963267948966), dArray2[0], dArray2[1]};
            this.d.append("\\pspolygon");
            this.d.append(this.LineOptionCode((bE)a2, true));
            int n3 = 0;
            while (n3 < 4) {
                this.d.append("(");
                this.d.append(this.a.a(dArray3[2 * n3]));
                this.d.append(",");
                this.d.append(this.a.a(dArray3[2 * n3 + 1]));
                this.d.append(")");
                ++n3;
            }
            this.d.append("\n");
        } else {
            this.a.append("\\pscustom");
            this.a.append(this.LineOptionCode((bE)a2, true));
            this.a.append("{\\parametricplot{");
            this.a.append(d2);
            this.a.append("}{");
            this.a.append(d3);
            this.a.append("}{");
            this.a.append(this.a.a(d4));
            this.a.append("*cos(t)+");
            this.a.append(this.a.a(dArray2[0]));
            this.a.append("|");
            this.a.append(this.a.a(d4));
            this.a.append("*sin(t)+");
            this.a.append(this.a.a(dArray2[1]));
            this.a.append("}");
            this.a.append("\\lineto(");
            this.a.append(this.a.a(dArray2[0]));
            this.a.append(",");
            this.a.append(this.a.a(dArray2[1]));
            this.a.append(")\\closepath}\n");
            if (this.a.a(a2.c(), 1.5707963267948966) && a2.n() && this.a.c() == 2) {
                double d5 = (double)a2.e / this.a.a();
                double d6 = (double)n2 / this.a.a() / 1.7;
                double d7 = (d2 + d3) / 2.0;
                double d8 = dArray2[0] + d6 * Math.cos(d7);
                double d9 = dArray2[1] + d6 * Math.sin(d7);
                this.a.append("\\psellipse*");
                this.a.append(this.LineOptionCode((bE)a2, true));
                this.a.append("(");
                this.a.append(this.a.a(d8));
                this.a.append(",");
                this.a.append(this.a.a(d9));
                this.a.append(")(");
                this.a.append(this.a.a(d5));
                this.a.append(",");
                this.a.append(this.a.a(d5));
                this.a.append(")\n");
            }
        }
        int n4 = a2.g;
        if (n4 != 0) {
            this.markAngle(a2, d4, dArray2, d2, d3);
        }
    }

    private void drawArc(A a2, double[] dArray, double d2, double d3, double d4) {
        this.a.append("\\parametricplot");
        this.a.append(this.LineOptionCode((bE)a2, false));
        this.a.append("{");
        this.a.append(d2);
        this.a.append("}{");
        this.a.append(d3);
        this.a.append("}{");
        this.a.append(this.a.a(d4));
        this.a.append("*cos(t)+");
        this.a.append(this.a.a(dArray[0]));
        this.a.append("|");
        this.a.append(this.a.a(d4));
        this.a.append("*sin(t)+");
        this.a.append(this.a.a(dArray[1]));
        this.a.append("}\n");
    }

    private void drawTick(A a2, double[] dArray, double d2) {
        d2 = -d2;
        double d3 = a2.g();
        double d4 = 2.5 + (double)a2.e / 4.0;
        double d5 = this.a.c(dArray[0] + (d3 - d4) * Math.cos(d2));
        double d6 = this.a.c(dArray[0] + (d3 + d4) * Math.cos(d2));
        double d7 = this.a.d(dArray[1] + (d3 - d4) * Math.sin(d2) * this.a.c());
        double d8 = this.a.d(dArray[1] + (d3 + d4) * Math.sin(d2) * this.a.c());
        this.a.append("\\psline");
        this.a.append(this.LineOptionCode((bE)a2, false));
        this.a.append("(");
        this.a.append(this.a.a(d5));
        this.a.append(",");
        this.a.append(this.a.a(d7));
        this.a.append(")(");
        this.a.append(this.a.a(d6));
        this.a.append(",");
        this.a.append(this.a.a(d8));
        this.a.append(")\n");
    }

    private void markAngle(A a2, double d2, double[] dArray, double d3, double d4) {
        switch (a2.g) {
            case 1: {
                double d5 = 4.0 + (double)a2.e / 2.0;
                this.drawArc(a2, dArray, d3, d4, d2);
                this.drawArc(a2, dArray, d3, d4, d2 -= d5 / this.a.a());
                break;
            }
            case 2: {
                double d6 = 4.0 + (double)a2.e / 2.0;
                this.drawArc(a2, dArray, d3, d4, d2);
                this.drawArc(a2, dArray, d3, d4, d2 -= d6 / this.a.a());
                this.drawArc(a2, dArray, d3, d4, d2 -= d6 / this.a.a());
                break;
            }
            case 3: {
                this.drawArc(a2, dArray, d3, d4, d2);
                this.a.a(dArray);
                this.drawTick(a2, dArray, (d3 + d4) / 2.0);
                break;
            }
            case 4: {
                this.drawArc(a2, dArray, d3, d4, d2);
                this.a.a(dArray);
                double[] dArray2 = new double[]{(2.0 * d3 + 3.0 * d4) / 5.0, (3.0 * d3 + 2.0 * d4) / 5.0};
                if (Math.abs(dArray2[1] - dArray2[0]) > geogebra.euclidian.b.a) {
                    dArray2[0] = (d3 + d4) / 2.0 - geogebra.euclidian.b.a / 2.0;
                    dArray2[1] = (d3 + d4) / 2.0 + geogebra.euclidian.b.a / 2.0;
                }
                this.drawTick(a2, dArray, dArray2[0]);
                this.drawTick(a2, dArray, dArray2[1]);
                break;
            }
            case 5: {
                this.drawArc(a2, dArray, d3, d4, d2);
                this.a.a(dArray);
                double[] dArray3 = new double[]{(5.0 * d3 + 3.0 * d4) / 8.0, (3.0 * d3 + 5.0 * d4) / 8.0};
                if (Math.abs(dArray3[1] - dArray3[0]) > geogebra.euclidian.b.a) {
                    dArray3[0] = (d3 + d4) / 2.0 - geogebra.euclidian.b.a / 2.0;
                    dArray3[1] = (d3 + d4) / 2.0 + geogebra.euclidian.b.a / 2.0;
                }
                this.drawTick(a2, dArray, (d3 + d4) / 2.0);
                this.drawTick(a2, dArray, dArray3[0]);
                this.drawTick(a2, dArray, dArray3[1]);
            }
        }
    }

    private void drawSlider(bV bV2) {
        boolean bl = bV2.as();
        double d2 = bV2.d();
        double d3 = bV2.g();
        double d4 = bV2.c();
        double d5 = bV2.h();
        double d6 = bV2.i();
        double d7 = bV2.j();
        if (bV2.x()) {
            d6 = this.a.c(d6);
            d7 = this.a.d(d7);
            d5 = bl ? d5 / this.a.a() : d5 / this.a.b();
        }
        bQ bQ2 = new bQ(this.a);
        bQ2.a = bV2.a();
        String string = "$" + geogebra.util.k.a((String)bV2.s(), (boolean)true) + "$";
        bQ2.b(string);
        double d8 = (d4 - d3) / (d2 - d3);
        bQ2.a = 2 + (bV2.e + 1) / 3;
        bQ2.h(bV2.P());
        if (bl) {
            bQ2.a(d6 + d5 * d8, d7, 1.0);
        } else {
            bQ2.a(d6, d7 + d5 * d8, 1.0);
        }
        e e2 = new e(this.a, bQ2);
        e2.a((bE)bV2);
        if (bV2.P()) {
            if (bl) {
                e2.d -= 15;
                e2.e -= 5;
            } else {
                e2.d += 5;
                e2.e += 2 * bQ2.a + 4;
            }
        }
        this.drawGeoPoint(bQ2);
        this.drawLabel((bE)bQ2, (geogebra.euclidian.K)e2);
        this.a.append("\\psline");
        this.a.append(this.LineOptionCode((bE)bV2, true));
        this.a.append("(");
        this.a.append(this.a.a(d6));
        this.a.append(",");
        this.a.append(this.a.a(d7));
        this.a.append(")(");
        if (bl) {
            d6 += d5;
        } else {
            d7 += d5;
        }
        this.a.append(this.a.a(d6));
        this.a.append(",");
        this.a.append(this.a.a(d7));
        this.a.append(")\n");
    }

    private void drawPolygon(ar ar2) {
        float f2 = ar2.a();
        if (f2 == 0.0f) {
            return;
        }
        this.d.append("\\pspolygon");
        this.d.append(this.LineOptionCode((bE)ar2, true));
        bQ[] bQArray = ar2.a();
        int n2 = 0;
        while (n2 < bQArray.length) {
            double d2 = bQArray[n2].c();
            double d3 = bQArray[n2].d();
            double d4 = bQArray[n2].g();
            d3 /= d4;
            this.d.append("(");
            this.d.append(this.a.a(d2 /= d4));
            this.d.append(",");
            this.d.append(this.a.a(d3));
            this.d.append(")");
            ++n2;
        }
        this.d.append("\n");
    }

    private void drawText(cC cC2) {
        double d2;
        double d3;
        boolean bl = cC2.ao();
        String string = cC2.g();
        Color color = cC2.a();
        int n2 = cC2.k();
        int n3 = cC2.g() + this.a.f();
        if (cC2.x()) {
            d3 = cC2.e();
            d2 = cC2.b_();
        } else {
            bQ bQ2 = cC2.a();
            if (bQ2 == null) {
                d3 = (int)this.a.d();
                d2 = (int)this.a.e();
            } else {
                if (!bQ2.a()) {
                    return;
                }
                d3 = this.a.a(bQ2.a);
                d2 = this.a.b(bQ2.b);
            }
            d3 += (double)cC2.c;
            d2 += (double)cC2.d;
        }
        d3 = this.a.c(d3);
        d2 = this.a.d(d2 - (double)this.a.getFont().getSize());
        int n4 = string.indexOf("\n");
        if (n4 == -1) {
            this.a.append("\\rput[tl](");
            this.a.append(this.a.a(d3));
            this.a.append(",");
            this.a.append(this.a.a(d2));
            this.a.append("){");
            this.addText(string, bl, n2, n3, color);
            this.a.append("}\n");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            int n5 = 0;
            Font font = new Font(cC2.ap() ? "Serif" : "SansSerif", n2, n3);
            FontMetrics fontMetrics = this.a.getFontMetrics(font);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                n5 = Math.max(n5, fontMetrics.stringWidth(string2));
                stringBuffer.append(string2);
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append(" \\\\ ");
            }
            this.a.append("\\rput[lt](");
            this.a.append(this.a.a(d3));
            this.a.append(",");
            this.a.append(this.a.a(d2));
            this.a.append("){\\parbox{");
            this.a.append(this.a.a((double)n5 * (this.e - this.d) * this.b / (double)this.a.getWidth() + 1.0));
            this.a.append(" cm}{");
            this.addText(new String(stringBuffer), bl, n2, n3, color);
            this.a.append("}}\n");
        }
    }

    private void addText(String string, boolean bl, int n2, int n3, Color color) {
        if (bl) {
            this.a.append("$");
        }
        switch (n2) {
            case 1: {
                if (bl) {
                    this.a.append("\\mathbf{");
                    break;
                }
                this.a.append("\\textbf{");
                break;
            }
            case 2: {
                if (bl) {
                    this.a.append("\\mathit{");
                    break;
                }
                this.a.append("\\textit{");
                break;
            }
            case 3: {
                if (bl) {
                    this.a.append("\\mathit{\\mathbf{");
                    break;
                }
                this.a.append("\\textit{\\textbf{");
            }
        }
        if (!color.equals(Color.BLACK)) {
            this.a.append("\\");
            this.ColorCode(color, this.a);
            this.a.append("{");
        }
        this.a.append(string);
        if (!color.equals(Color.BLACK)) {
            this.a.append("}");
        }
        switch (n2) {
            case 1: 
            case 2: {
                this.a.append("}");
                break;
            }
            case 3: {
                this.a.append("}}");
            }
        }
        if (bl) {
            this.a.append("$");
        }
    }

    private void drawGeoConicPart(cY cY2) {
        double d2 = cY2.a().a();
        double d3 = cY2.a().b();
        double d4 = cY2.a()[0];
        double d5 = cY2.c();
        double d6 = cY2.d();
        if (this.b == this.c) {
            d5 = Math.toDegrees(d5);
            d6 = Math.toDegrees(d6);
            if (cY2.g() == 2) {
                this.a.append("\\pswedge");
            } else if (cY2.g() == 1) {
                this.a.append("\\psarc");
            }
            this.a.append(this.LineOptionCode((bE)cY2, true));
            this.a.append("(");
            this.a.append(this.a.a(d2));
            this.a.append(",");
            this.a.append(this.a.a(d3));
            this.a.append("){");
            this.a.append(this.a.a(d4 * this.b));
            this.a.append("}{");
            this.a.append(this.a.a(d5));
            this.a.append("}{");
            this.a.append(this.a.a(d6));
            this.a.append("}\n");
        } else {
            if (cY2.g() == 2) {
                this.a.append("\\pscustom");
                this.a.append(this.LineOptionCode((bE)cY2, true));
                this.a.append("{\\parametricplot{");
            } else if (cY2.g() == 1) {
                this.a.append("\\parametricplot");
                this.a.append(this.LineOptionCode((bE)cY2, true));
                this.a.append("{");
            }
            this.a.append(d5);
            this.a.append("}{");
            this.a.append(d6);
            this.a.append("}{");
            this.a.append(this.a.a(d4));
            this.a.append("*cos(t)+");
            this.a.append(this.a.a(d2));
            this.a.append("|");
            this.a.append(this.a.a(d4));
            this.a.append("*sin(t)+");
            this.a.append(this.a.a(d3));
            this.a.append("}");
            if (cY2.g() == 2) {
                this.a.append("\\lineto(");
                this.a.append(this.a.a(d2));
                this.a.append(",");
                this.a.append(this.a.a(d3));
                this.a.append(")\\closepath}");
            }
            this.a.append("\n");
        }
    }

    private void drawFunction(Z z2) {
        a a2 = z2.a();
        if (a2 == null) {
            return;
        }
        String string = a2.c();
        string = this.killSpace(geogebra.util.k.a((String)string, (boolean)true));
        double d2 = this.d;
        double d3 = this.e;
        if (a2.m()) {
            d2 = Math.max(d2, a2.a());
            d3 = Math.min(d3, a2.b());
        }
        double d4 = d2;
        double d5 = d2;
        while (d4 < d3) {
            d5 = this.firstDefinedValue(a2, d2, d3);
            if (d5 == d3) break;
            d4 = this.maxDefinedValue(a2, d5, d3);
            this.a.append("\\psplot");
            this.a.append(this.LineOptionCode((bE)z2, true));
            int n2 = this.a.lastIndexOf("]");
            if (n2 == this.a.length() - 1) {
                this.a.deleteCharAt(n2);
                this.a.append(",plotpoints=200]{");
            } else {
                this.a.append("[plotpoints=200]{");
            }
            this.a.append(d5);
            this.a.append("}{");
            this.a.append(d4);
            this.a.append("}{");
            this.a.append(string);
            this.a.append("}\n");
            d2 = d4 += 1.0E-5;
        }
    }

    private String killSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if ("*/+-".indexOf(c2) != -1) {
                stringBuffer.append(c2);
                bl = true;
                bl2 = false;
            } else if (c2 == ' ') {
                if (!bl) {
                    bl2 = true;
                } else {
                    bl2 = false;
                    bl = false;
                }
            } else {
                if (bl2) {
                    stringBuffer.append("*");
                }
                stringBuffer.append(c2);
                bl2 = false;
                bl = false;
            }
            ++n2;
        }
        this.renameFunc(stringBuffer, "log(", "ln(");
        this.renameFunc(stringBuffer, "ceil(", "ceiling(");
        this.renameFunc(stringBuffer, "exp(", "EXP(");
        this.renameFunc(stringBuffer, "atan(", "ATAN(");
        this.renameFunc(stringBuffer, "cosh(", "COSH(");
        this.renameFunc(stringBuffer, "acosh(", "ACOSH(");
        this.renameFunc(stringBuffer, "asinh(", "ASINH(");
        this.renameFunc(stringBuffer, "atanh(", "ATANH(");
        this.renameFunc(stringBuffer, "sinh(", "SINH(");
        this.renameFunc(stringBuffer, "tanh(", "TANH(");
        this.renameFunc(stringBuffer, "\u212f", "2.718281828");
        return new String(stringBuffer);
    }

    private void renameFunc(StringBuffer stringBuffer, String string, String string2) {
        int n2 = stringBuffer.indexOf(string);
        while (n2 > -1) {
            stringBuffer.replace(n2, n2 + string.length(), string2);
            n2 = stringBuffer.indexOf(string);
        }
    }

    private double maxDefinedValue(a a2, double d2, double d3) {
        double d4 = d2;
        double d5 = (d3 - d2) / 100.0;
        while (d4 <= d3) {
            double d6 = a2.a(d4);
            if (Double.isNaN(d6)) {
                if (d5 < 1.0E-5) {
                    return d4 - d5;
                }
                return this.maxDefinedValue(a2, d4 - d5, d4);
            }
            d4 += d5;
        }
        return d3;
    }

    private double firstDefinedValue(a a2, double d2, double d3) {
        double d4 = d2;
        double d5 = (d3 - d2) / 100.0;
        while (d4 <= d3) {
            double d6 = a2.a(d4);
            if (!Double.isNaN(d6)) {
                if (d4 == d2) {
                    return d2;
                }
                if (d5 < 1.0E-5) {
                    return d4;
                }
                return this.firstDefinedValue(a2, d4 - d5, d4);
            }
            d4 += d5;
        }
        return d3;
    }

    private void drawGeoVector(K k2) {
        String string;
        String string2;
        bQ bQ2 = k2.a();
        if (bQ2 == null) {
            string2 = "0";
            string = "0";
        } else {
            string2 = this.a.a(bQ2.c() / bQ2.g());
            string = this.a.a(bQ2.d() / bQ2.g());
        }
        double[] dArray = new double[3];
        k2.c(dArray);
        String string3 = this.a.a(dArray[0] + Double.parseDouble(string2));
        String string4 = this.a.a(dArray[1] + Double.parseDouble(string));
        this.a.append("\\psline");
        this.a.append(this.LineOptionCode((bE)k2, true));
        this.a.append("{->}(");
        this.a.append(string2);
        this.a.append(",");
        this.a.append(string);
        this.a.append(")(");
        this.a.append(string3);
        this.a.append(",");
        this.a.append(string4);
        this.a.append(")\n");
    }

    private void drawCircle(bd bd2) {
        if (this.b == this.c) {
            double d2 = bd2.a().a();
            double d3 = bd2.a().b();
            double d4 = bd2.a()[0];
            this.a.append("\\pscircle");
            this.a.append(this.LineOptionCode((bE)bd2, true));
            this.a.append("(");
            this.a.append(this.a.a(d2));
            this.a.append(",");
            this.a.append(this.a.a(d3));
            this.a.append("){");
            String string = this.a.a(d4 * this.b);
            if (Double.parseDouble(string) != 0.0) {
                this.a.append(string);
            } else {
                this.a.append(d4);
            }
            this.a.append("}\n");
        } else {
            double d5 = bd2.a().a();
            double d6 = bd2.a().b();
            double d7 = bd2.a()[0];
            double d8 = bd2.a()[1];
            this.a.append("\\psellipse");
            this.a.append(this.LineOptionCode((bE)bd2, true));
            this.a.append("(");
            this.a.append(this.a.a(d5));
            this.a.append(",");
            this.a.append(this.a.a(d6));
            this.a.append(")(");
            this.a.append(this.a.a(d7));
            this.a.append(",");
            this.a.append(this.a.a(d8));
            this.a.append(")\n");
        }
    }

    private void drawGeoConic(bd bd2) {
        switch (bd2.f()) {
            case 4: {
                this.drawCircle(bd2);
                break;
            }
            case 3: {
                AffineTransform affineTransform = bd2.a();
                double d2 = affineTransform.getScaleX();
                double d3 = affineTransform.getShearY();
                double d4 = bd2.a().a();
                double d5 = bd2.a().b();
                double d6 = bd2.a()[0];
                double d7 = bd2.a()[1];
                double d8 = Math.toDegrees(Math.atan2(d3, d2));
                this.a.append("\\rput{");
                this.a.append(this.a.a(d8));
                this.a.append("}(");
                this.a.append(this.a.a(d4));
                this.a.append(",");
                this.a.append(this.a.a(d5));
                this.a.append("){\\psellipse");
                this.a.append(this.LineOptionCode((bE)bd2, true));
                this.a.append("(0,0)(");
                this.a.append(this.a.a(d6));
                this.a.append(",");
                this.a.append(this.a.a(d7));
                this.a.append(")}\n");
                break;
            }
            case 9: {
                double d9 = bd2.d;
                AffineTransform affineTransform = bd2.a();
                double d10 = affineTransform.getScaleX();
                double d11 = affineTransform.getShearY();
                double d12 = bd2.a().a();
                double d13 = bd2.a().b();
                double d14 = Math.max(Math.abs(d12 - this.d), Math.abs(d12 - this.e));
                d14 = Math.max(d14, Math.abs(d13 - this.f));
                d14 = Math.max(d14, Math.abs(d13 - this.g));
                d14 = 4.0 * d14 / d9;
                int n2 = 4;
                int n3 = 16;
                while ((double)n3 < d14) {
                    n3 = (n2 += 2) * n2;
                }
                d14 = (double)n2 * d9;
                double d15 = Math.toDegrees(Math.atan2(d11, d10)) - 90.0;
                this.a.append("\\rput{");
                this.a.append(this.a.a(d15));
                this.a.append("}(");
                this.a.append(this.a.a(d12));
                this.a.append(",");
                this.a.append(this.a.a(d13));
                this.a.append("){\\psplot");
                this.a.append(this.LineOptionCode((bE)bd2, true));
                this.a.append("{");
                this.a.append(this.a.a(-d14));
                this.a.append("}{");
                this.a.append(this.a.a(d14));
                this.a.append("}");
                this.a.append("{x^2/2/");
                this.a.append(this.a.a(d9));
                this.a.append("}}\n");
                break;
            }
            case 5: {
                AffineTransform affineTransform = bd2.a();
                double d16 = affineTransform.getScaleX();
                double d17 = affineTransform.getShearY();
                double d18 = bd2.a().a();
                double d19 = bd2.a().b();
                double d20 = bd2.a()[0];
                double d21 = bd2.a()[1];
                double d22 = Math.toDegrees(Math.atan2(d17, d16));
                this.a.append("\\rput{");
                this.a.append(this.a.a(d22));
                this.a.append("}(");
                this.a.append(this.a.a(d18));
                this.a.append(",");
                this.a.append(this.a.a(d19));
                this.a.append("){\\parametricplot");
                this.a.append(this.LineOptionCode((bE)bd2, true));
                this.a.append("{-0.99}{0.99}{");
                this.a.append(this.a.a(d20));
                this.a.append("*(1+t^2)/(1-t^2)|");
                this.a.append(this.a.a(d21));
                this.a.append("*2*t/(1-t^2)");
                this.a.append("}}\n");
                this.a.append("\\rput{");
                this.a.append(this.a.a(d22));
                this.a.append("}(");
                this.a.append(this.a.a(d18));
                this.a.append(",");
                this.a.append(this.a.a(d19));
                this.a.append("){\\parametricplot");
                this.a.append(this.LineOptionCode((bE)bd2, true));
                this.a.append("{-0.99}{0.99}{");
                this.a.append(this.a.a(d20));
                this.a.append("*(-1-t^2)/(1-t^2)|");
                this.a.append(this.a.a(d21));
                this.a.append("*(-2)*t/(1-t^2)");
                this.a.append("}}\n");
            }
        }
    }

    private void drawGeoPoint(bQ bQ2) {
        if (this.a.a()) {
            double d2 = bQ2.c();
            double d3 = bQ2.d();
            double d4 = bQ2.g();
            d2 /= d4;
            d3 /= d4;
            this.b.append("\\psdots");
            this.PointOptionCode(bQ2);
            this.b.append("(");
            this.b.append(this.a.a(d2));
            this.b.append(",");
            this.b.append(this.a.a(d3));
            this.b.append(")\n");
        }
    }

    private void drawGeoLine(j j2) {
        double d2 = j2.c();
        double d3 = j2.d();
        double d4 = j2.g();
        if (d3 != 0.0) {
            this.a.append("\\psplot");
        } else {
            this.a.append("\\psline");
        }
        this.a.append(this.LineOptionCode((bE)j2, true));
        if (d3 != 0.0) {
            this.a.append("{");
            this.a.append(this.a.a(this.d));
            this.a.append("}{");
            this.a.append(this.a.a(this.e));
            this.a.append("}{(-");
            this.a.append(this.a.a(d4));
            this.a.append("-");
            this.a.append(this.a.a(d2));
            this.a.append("*x)/");
            String string = this.a.a(d3);
            if (Double.parseDouble(string) != 0.0) {
                this.a.append(string);
            } else {
                this.a.append(d3);
            }
            this.a.append("}\n");
        } else {
            String string = this.a.a(-d4 / d2);
            this.a.append("(");
            this.a.append(string);
            this.a.append(",");
            this.a.append(this.a.a(this.f));
            this.a.append(")(");
            this.a.append(string);
            this.a.append(",");
            this.a.append(this.a.a(this.g));
            this.a.append(")\n");
        }
    }

    private void drawGeoSegment(cr cr2) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        bQ bQ2 = cr2.a();
        bQ bQ3 = cr2.b();
        bQ2.a_(dArray);
        bQ3.a_(dArray2);
        String string = this.a.a(dArray[0]);
        String string2 = this.a.a(dArray[1]);
        String string3 = this.a.a(dArray2[0]);
        String string4 = this.a.a(dArray2[1]);
        this.a.append("\\psline");
        this.a.append(this.LineOptionCode((bE)cr2, true));
        this.a.append("(");
        this.a.append(string);
        this.a.append(",");
        this.a.append(string2);
        this.a.append(")(");
        this.a.append(string3);
        this.a.append(",");
        this.a.append(string4);
        this.a.append(")\n");
        int n2 = cr2.g;
        if (n2 != 0) {
            this.mark(dArray, dArray2, n2, (bE)cr2);
        }
    }

    private void drawLine(double d2, double d3, double d4, double d5, bE bE2) {
        String string = this.a.a(d2);
        String string2 = this.a.a(d3);
        String string3 = this.a.a(d4);
        String string4 = this.a.a(d5);
        this.a.append("\\psline");
        this.a.append(this.LineOptionCode(bE2, true));
        this.a.append("(");
        this.a.append(string);
        this.a.append(",");
        this.a.append(string2);
        this.a.append(")(");
        this.a.append(string3);
        this.a.append(",");
        this.a.append(string4);
        this.a.append(")\n");
    }

    private void mark(double[] dArray, double[] dArray2, int n2, bE bE2) {
        this.a.a(dArray);
        this.a.a(dArray2);
        double d2 = (dArray[0] + dArray2[0]) / 2.0;
        double d3 = (dArray[1] + dArray2[1]) / 2.0;
        double d4 = dArray[1] - dArray2[1];
        double d5 = dArray2[0] - dArray[0];
        double d6 = cZ.a((double)d4, (double)d5);
        double d7 = 2.5 + (double)bE2.e / 2.0;
        double d8 = d7 + 1.0;
        double d9 = 1.5;
        switch (n2) {
            case 1: {
                double d10 = d8 / d6;
                double d11 = this.a.c(d2 - (d4 *= d10 / this.b));
                double d12 = this.a.d(d3 - (d5 *= d10 / this.c));
                double d13 = this.a.c(d2 + d4);
                double d14 = this.a.d(d3 + d5);
                this.drawLine(d11, d12, d13, d14, bE2);
                break;
            }
            case 2: {
                double d15 = d7 / (2.0 * d6);
                double d16 = -d5 * d15;
                double d17 = d4 * d15;
                d15 = d8 / d6;
                double d18 = this.a.c(d2 + d16 - (d4 *= d15));
                double d19 = this.a.c(d2 + d16 + d4);
                double d20 = this.a.d(d3 + d17 - (d5 *= d15));
                double d21 = this.a.d(d3 + d17 + d5);
                this.drawLine(d18, d20, d19, d21, bE2);
                d18 = this.a.c(d2 - d16 - d4);
                d19 = this.a.c(d2 - d16 + d4);
                d20 = this.a.d(d3 - d17 - d5);
                d21 = this.a.d(d3 - d17 + d5);
                this.drawLine(d18, d20, d19, d21, bE2);
                break;
            }
            case 3: {
                double d22 = d7 / d6;
                double d23 = -d5 * d22;
                double d24 = d4 * d22;
                d22 = d8 / d6;
                double d25 = this.a.c(d2 + d23 - (d4 *= d22));
                double d26 = this.a.c(d2 + d23 + d4);
                double d27 = this.a.d(d3 + d24 - (d5 *= d22));
                double d28 = this.a.d(d3 + d24 + d5);
                this.drawLine(d25, d27, d26, d28, bE2);
                d25 = this.a.c(d2 - d4);
                d26 = this.a.c(d2 + d4);
                d27 = this.a.d(d3 - d5);
                d28 = this.a.d(d3 + d5);
                this.drawLine(d25, d27, d26, d28, bE2);
                d25 = this.a.c(d2 - d23 - d4);
                d26 = this.a.c(d2 - d23 + d4);
                d27 = this.a.d(d3 - d24 - d5);
                d28 = this.a.d(d3 - d24 + d5);
                this.drawLine(d25, d27, d26, d28, bE2);
                break;
            }
            case 4: {
                double d29 = d7 / (2.0 * d6);
                double d30 = -d5 * d29;
                double d31 = d4 * d29;
                d29 = d8 / d6;
                double d32 = this.a.c(d2 - d9 * d30);
                double d33 = this.a.c(d3 - d9 * d31);
                double d34 = this.a.c(d2 - d9 * d30 + d9 * ((d4 *= d29) + d30));
                double d35 = this.a.d(d3 - d9 * d31 + d9 * ((d5 *= d29) + d31));
                this.drawLine(d32, d33, d34, d35, bE2);
                d32 = this.a.c(d2 - d9 * d30);
                d33 = this.a.d(d3 - d9 * d31);
                d34 = this.a.c(d2 - d9 * d30 + d9 * (-d4 + d30));
                d35 = this.a.d(d3 - d9 * d31 + d9 * (-d5 + d31));
                this.drawLine(d32, d33, d34, d35, bE2);
                break;
            }
            case 5: {
                double d36 = d7 / (2.0 * d6);
                double d37 = -d5 * d36;
                double d38 = d4 * d36;
                d36 = d8 / d6;
                double d39 = this.a.c(d2 - 2.0 * d9 * d37);
                double d40 = this.a.c(d3 - 2.0 * d9 * d38);
                double d41 = this.a.c(d2 - 2.0 * d9 * d37 + d9 * ((d4 *= d36) + d37));
                double d42 = this.a.d(d3 - 2.0 * d9 * d38 + d9 * ((d5 *= d36) + d38));
                this.drawLine(d39, d40, d41, d42, bE2);
                d39 = this.a.c(d2 - 2.0 * d9 * d37);
                d40 = this.a.d(d3 - 2.0 * d9 * d38);
                d41 = this.a.c(d2 - 2.0 * d9 * d37 + d9 * (-d4 + d37));
                d42 = this.a.d(d3 - 2.0 * d9 * d38 + d9 * (-d5 + d38));
                this.drawLine(d39, d40, d41, d42, bE2);
                d39 = this.a.c(d2);
                d40 = this.a.d(d3);
                d41 = this.a.d(d2 + d9 * (d4 + d37));
                d42 = this.a.d(d3 + d9 * (d5 + d38));
                this.drawLine(d39, d40, d41, d42, bE2);
                d39 = this.a.c(d2);
                d40 = this.a.d(d3);
                d41 = this.a.c(d2 + d9 * (-d4 + d37));
                d42 = this.a.d(d3 + d9 * (-d5 + d38));
                this.drawLine(d39, d40, d41, d42, bE2);
                break;
            }
            case 6: {
                double d43 = d7 / d6;
                double d44 = -d5 * d43;
                double d45 = d4 * d43;
                d43 = d8 / d6;
                double d46 = this.a.c(d2 - d9 * d44);
                double d47 = this.a.c(d3 - d9 * d45);
                double d48 = this.a.c(d2 - d9 * d44 + d9 * ((d4 *= d43) + d44));
                double d49 = this.a.d(d3 - d9 * d45 + d9 * ((d5 *= d43) + d45));
                this.drawLine(d46, d47, d48, d49, bE2);
                d46 = this.a.c(d2 - d9 * d44);
                d47 = this.a.d(d3 - d9 * d45);
                d48 = this.a.c(d2 - d9 * d44 + d9 * (-d4 + d44));
                d49 = this.a.d(d3 - d9 * d45 + d9 * (-d5 + d45));
                this.drawLine(d46, d47, d48, d49, bE2);
                d46 = this.a.c(d2 + d9 * d44);
                d47 = this.a.d(d3 + d9 * d45);
                d48 = this.a.d(d2 + d9 * d44 + d9 * (d4 + d44));
                d49 = this.a.d(d3 + d9 * d45 + d9 * (d5 + d45));
                this.drawLine(d46, d47, d48, d49, bE2);
                d46 = this.a.c(d2 + d9 * d44);
                d47 = this.a.d(d3 + d9 * d45);
                d48 = this.a.c(d2 + d9 * d44 + d9 * (-d4 + d44));
                d49 = this.a.d(d3 + d9 * d45 + d9 * (-d5 + d45));
                this.drawLine(d46, d47, d48, d49, bE2);
                d46 = this.a.c(d2 - 3.0 * d9 * d44);
                d47 = this.a.d(d3 - 3.0 * d9 * d45);
                d48 = this.a.c(d2 - 3.0 * d9 * d44 + d9 * (d4 + d44));
                d49 = this.a.d(d3 - 3.0 * d9 * d45 + d9 * (d5 + d45));
                this.drawLine(d46, d47, d48, d49, bE2);
                d46 = this.a.c(d2 - 3.0 * d9 * d44);
                d47 = this.a.d(d3 - 3.0 * d9 * d45);
                d48 = this.a.c(d2 - 3.0 * d9 * d44 + d9 * (-d4 + d44));
                d49 = this.a.d(d3 - 3.0 * d9 * d45 + d9 * (-d5 + d45));
                this.drawLine(d46, d47, d48, d49, bE2);
            }
        }
    }

    private void drawGeoRay(ct ct2) {
        bQ bQ2 = ct2.a();
        double d2 = bQ2.c();
        double d3 = bQ2.g();
        d2 /= d3;
        String string = this.a.a(bQ2.d() / d3);
        double d4 = ct2.c();
        double d5 = ct2.d();
        double d6 = ct2.g();
        if (d5 != 0.0) {
            this.a.append("\\psplot");
        } else {
            this.a.append("\\psline");
        }
        this.a.append(this.LineOptionCode((bE)ct2, true));
        double d7 = this.d;
        double d8 = this.e;
        if (d5 > 0.0) {
            d7 = d2;
        } else {
            d8 = d2;
        }
        if (d5 != 0.0) {
            this.a.append("{");
            this.a.append(this.a.a(d7));
            this.a.append("}{");
            this.a.append(this.a.a(d8));
            this.a.append("}{(-");
            this.a.append(this.a.a(d6));
            this.a.append("-");
            this.a.append(this.a.a(d4));
            this.a.append("*x)/");
            String string2 = this.a.a(d5);
            if (Double.parseDouble(string2) != 0.0) {
                this.a.append(string2);
            } else {
                this.a.append(d5);
            }
            this.a.append("}\n");
        } else {
            d8 = -d4 > 0.0 ? this.g : this.f;
            this.a.append("(");
            this.a.append(this.a.a(d2));
            this.a.append(",");
            this.a.append(string);
            this.a.append(")(");
            this.a.append(this.a.a(d2));
            this.a.append(",");
            this.a.append(this.a.a(d8));
            this.a.append(")\n");
        }
    }

    private void initUnitAndVariable() {
        this.f.append("\\psset{xunit=");
        this.f.append(this.sci2dec(this.b));
        this.f.append("cm,yunit=");
        this.f.append(this.sci2dec(this.c));
        this.f.append("cm,algebraic=true,dotstyle=");
        switch (this.a.b()) {
            case 2: {
                this.f.append("o");
                break;
            }
            case 1: {
                this.f.append("+");
                break;
            }
            case 0: {
                this.f.append("*");
            }
        }
        this.f.append(",dotsize=");
        this.f.append(3);
        this.f.append("pt 0");
        this.f.append(",linewidth=");
        this.f.append(this.a.a(0.8));
        this.f.append("pt,arrowsize=3pt 2,arrowinset=0.25}\n");
    }

    private void drawLabel(bE bE2, geogebra.euclidian.K k2) {
        if (bE2.P()) {
            String string = "$" + geogebra.util.k.a((String)bE2.s(), (boolean)true) + "$";
            if (k2 == null) {
                k2 = this.a.c(bE2);
            }
            double d2 = k2.a();
            double d3 = k2.b();
            d2 = this.a.c((double)Math.round(d2));
            d3 = this.a.d((double)Math.round(d3));
            Color color = bE2.a();
            this.b.append("\\rput[bl](");
            this.b.append(this.a.a(d2));
            this.b.append(",");
            this.b.append(this.a.a(d3));
            this.b.append("){");
            if (!color.equals(Color.BLACK)) {
                this.b.append("\\");
                this.ColorCode(color, this.b);
                this.b.append("{");
            }
            this.b.append(string);
            if (!color.equals(Color.BLACK)) {
                this.b.append("}");
            }
            this.b.append("}\n");
        }
    }

    private boolean isSinglePointConic(bE bE2) {
        return bE2.H() && ((bd)bE2).f() == 1;
    }

    private boolean isDoubleLineConic(bE bE2) {
        return bE2.H() && (((bd)bE2).f() == 7 || ((bd)bE2).f() == 2 || ((bd)bE2).f() == 8);
    }

    private boolean isEmpty(bE bE2) {
        return bE2.H() && ((bd)bE2).f() == 6;
    }

    private void drawGrid() {
        Color color = this.a.b();
        double[] dArray = this.a.b();
        int n2 = this.a.e();
        this.f.append("\\psset{xunit=");
        this.f.append(this.sci2dec(dArray[0] * this.b));
        this.f.append("cm,yunit=");
        this.f.append(this.sci2dec(dArray[1] * this.c));
        this.f.append("cm}\n");
        this.f.append("\\begin{pspicture*}(");
        this.f.append(this.a.a(this.d / dArray[0]));
        this.f.append(",");
        this.f.append(this.a.a(this.f / dArray[1]));
        this.f.append(")(");
        this.f.append(this.a.a(this.e / dArray[0]));
        this.f.append(",");
        this.f.append(this.a.a(this.g / dArray[1]));
        this.f.append(")\n");
        this.f.append("\\psgrid[subgriddiv=0,gridlabels=0,gridcolor=");
        this.ColorCode(color, this.f);
        this.f.append("](0,0)(");
        this.f.append(this.a.a(this.d / dArray[0]));
        this.f.append(",");
        this.f.append(this.a.a(this.f / dArray[1]));
        this.f.append(")(");
        this.f.append(this.a.a(this.e / dArray[0]));
        this.f.append(",");
        this.f.append(this.a.a(this.g / dArray[1]));
        this.f.append(")\n");
        this.initUnitAndVariable();
    }

    private void drawAxis() {
        boolean bl = this.a.c();
        boolean bl2 = this.a.d();
        double d2 = this.a.a()[0];
        double d3 = this.a.a()[1];
        this.f.append("\\psaxes[xAxis=");
        this.f.append(bl);
        this.f.append(",yAxis=");
        this.f.append(bl2);
        this.f.append(',');
        boolean bl3 = this.a.b()[0];
        boolean bl4 = this.a.b()[1];
        if (!bl3 && !bl4) {
            this.f.append("labels=none,");
        } else if (bl3 && !bl4) {
            this.f.append("labels=x,");
        } else if (!bl3 && bl4) {
            this.f.append("labels=y,");
        }
        this.f.append("Dx=");
        this.f.append(this.a.a(d2));
        this.f.append(",Dy=");
        this.f.append(this.a.a(d3));
        this.f.append(",ticksize=-2pt 0,subticks=2");
        this.f.append("]{-");
        if (this.a.f() == 1) {
            this.f.append(">");
        }
        this.f.append("}(0,0)(");
        this.f.append(this.a.a(this.d));
        this.f.append(",");
        this.f.append(this.a.a(this.f));
        this.f.append(")(");
        this.f.append(this.a.a(this.e));
        this.f.append(",");
        this.f.append(this.a.a(this.g));
        this.f.append(")\n");
    }

    private void PointOptionCode(bQ bQ2) {
        Color color = bQ2.a();
        int n2 = bQ2.e();
        boolean bl = false;
        boolean bl2 = false;
        if (n2 != 3) {
            bl = true;
            bl2 = true;
            this.b.append("[dotsize=");
            this.b.append(n2);
            this.b.append("pt 0");
        }
        if (!color.equals(Color.BLACK)) {
            if (bl) {
                this.b.append(",");
            }
            if (!bl2) {
                this.b.append("[");
            }
            bl2 = true;
            this.b.append("linecolor=");
            this.ColorCode(color, this.b);
        }
        if (bl2) {
            this.b.append("]");
        }
    }

    private String LineOptionCode(bE bE2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Color color = bE2.a();
        int n2 = bE2.i();
        int n3 = bE2.j();
        boolean bl2 = false;
        boolean bl3 = false;
        if (n2 != 2) {
            bl2 = true;
            bl3 = true;
            stringBuffer.append("[linewidth=");
            stringBuffer.append(this.a.a((double)n2 / 2.0 * 0.8));
            stringBuffer.append("pt");
        }
        if (n3 != 0) {
            if (bl2) {
                stringBuffer.append(",");
            } else {
                bl2 = true;
            }
            if (!bl3) {
                stringBuffer.append("[");
            }
            bl3 = true;
            this.LinestyleCode(n3, stringBuffer);
        }
        if (!color.equals(Color.BLACK)) {
            if (bl2) {
                stringBuffer.append(",");
            } else {
                bl2 = true;
            }
            if (!bl3) {
                stringBuffer.append("[");
            }
            bl3 = true;
            stringBuffer.append("linecolor=");
            this.ColorCode(color, stringBuffer);
        }
        if (bl && bE2.v() && bE2.a() > 0.0f) {
            if (bl2) {
                stringBuffer.append(",");
            } else {
                bl2 = true;
            }
            if (!bl3) {
                stringBuffer.append("[");
            }
            bl3 = true;
            stringBuffer.append("fillcolor=");
            this.ColorCode(color, stringBuffer);
            stringBuffer.append(",fillstyle=solid,opacity=");
            stringBuffer.append(bE2.a());
        }
        if (bl3) {
            stringBuffer.append("]");
        }
        return new String(stringBuffer);
    }

    private void LinestyleCode(int n2, StringBuffer stringBuffer) {
        switch (n2) {
            case 20: {
                stringBuffer.append("linestyle=dotted");
                break;
            }
            case 10: {
                stringBuffer.append("linestyle=dashed,dash=");
                int n3 = this.resizePt(4);
                stringBuffer.append(n3);
                stringBuffer.append("pt ");
                stringBuffer.append(n3);
                stringBuffer.append("pt");
                break;
            }
            case 15: {
                stringBuffer.append("linestyle=dashed,dash=");
                int n4 = this.resizePt(8);
                stringBuffer.append(n4);
                stringBuffer.append("pt ");
                stringBuffer.append(n4);
                stringBuffer.append("pt");
                break;
            }
            case 30: {
                stringBuffer.append("linestyle=dashed,dash=");
                int n5 = this.resizePt(1);
                int n6 = this.resizePt(4);
                int n7 = this.resizePt(8);
                stringBuffer.append(n5);
                stringBuffer.append("pt ");
                stringBuffer.append(n6);
                stringBuffer.append("pt ");
                stringBuffer.append(n7);
                stringBuffer.append("pt ");
                stringBuffer.append(n6);
                stringBuffer.append("pt ");
            }
        }
    }

    private int resizePt(int n2) {
        double d2 = this.a.getHeight() / 30;
        double d3 = this.a.c();
        double d4 = d3 / d2;
        int n3 = (int)Math.round(d4 * (double)n2);
        if (n3 != 0) {
            return n3;
        }
        return 1;
    }

    public void ColorCode(Color color, StringBuffer stringBuffer) {
        if (color.equals(Color.BLACK)) {
            stringBuffer.append("black");
        } else if (color.equals(Color.DARK_GRAY)) {
            stringBuffer.append("darkgray");
        } else if (color.equals(Color.GRAY)) {
            stringBuffer.append("gray");
        } else if (color.equals(Color.LIGHT_GRAY)) {
            stringBuffer.append("lightgray");
        } else if (color.equals(Color.WHITE)) {
            stringBuffer.append("white");
        } else if (color.equals(Color.RED)) {
            stringBuffer.append("red");
        } else if (color.equals(Color.GREEN)) {
            stringBuffer.append("green");
        } else if (color.equals(Color.BLUE)) {
            stringBuffer.append("blue");
        } else if (color.equals(Color.CYAN)) {
            stringBuffer.append("cyan");
        } else if (color.equals(Color.MAGENTA)) {
            stringBuffer.append("magenta");
        } else if (color.equals(Color.YELLOW)) {
            stringBuffer.append("yellow");
        } else {
            String string = "";
            if (this.a.containsKey(color)) {
                string = this.a.get(color).toString();
            } else {
                int n2 = color.getRed();
                int n3 = color.getGreen();
                int n4 = color.getBlue();
                string = this.createSuffix(n2, n3, n4);
                this.e.append("\\newrgbcolor{" + string + "}{" + this.a.a((double)n2 / 255.0) + " " + this.a.a((double)n3 / 255.0) + " " + this.a.a((double)n4 / 255.0) + "}\n");
                this.a.put(color, string);
            }
            stringBuffer.append(string);
        }
    }

    String createSuffix(int n2, int n3, int n4) {
        String string = "qrstuvwxyzabcdef";
        int[] nArray = new int[]{n2, n3, n4};
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = 0;
        while (n5 < nArray.length) {
            int n6 = nArray[n5] / 16;
            int n7 = nArray[n5] % 16;
            stringBuffer.append("qrstuvwxyzabcdef".charAt(n6));
            stringBuffer.append("qrstuvwxyzabcdef".charAt(n7));
            ++n5;
        }
        return new String(stringBuffer);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.createPstricks();
    }

    public void refreshSelectionRectangle() {
        int n2 = this.a.a(this.d);
        int n3 = this.a.a(this.e);
        int n4 = this.a.b(this.f);
        int n5 = this.a.b(this.g);
        Rectangle rectangle = new Rectangle(n2, n5, n3 - n2, n4 - n5);
        this.a.a(rectangle);
        this.a.repaint();
    }

    private String sci2dec(double d2) {
        String string = String.valueOf(d2).toLowerCase(Locale.US);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "e");
        if (stringTokenizer.countTokens() == 1) {
            return string;
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n2 = Integer.parseInt(string3);
        if (n2 > 0) {
            int n3 = stringBuffer.indexOf(".");
            if (n3 == -1) {
                int n4 = 0;
                while (n4 < n2) {
                    stringBuffer.append("0");
                    ++n4;
                }
            } else {
                stringBuffer.deleteCharAt(n3);
                int n5 = n2 - (stringBuffer.length() - n3);
                int n6 = 0;
                while (n6 < n5) {
                    stringBuffer.append("0");
                    ++n6;
                }
            }
        } else {
            n2 = -n2;
            int n7 = stringBuffer.indexOf(".");
            stringBuffer.deleteCharAt(n7);
            int n8 = 0;
            while (n8 < n2 - 1) {
                stringBuffer.insert(0, "0");
                ++n8;
            }
            stringBuffer.insert(0, "0.");
        }
        return stringBuffer.toString();
    }
}

