/*
 * Decompiled with CFR 0.152.
 */
package geogebra.export;

import geogebra.euclidian.w;
import geogebra.export.I;
import geogebra.export.c;
import geogebra.export.epsgraphics.b;
import geogebra.export.f;
import geogebra.export.m;
import geogebra.export.q;
import geogebra.export.x;
import geogebra.gui.Q;
import geogebra.i;
import geogebra.io.a;
import geogebra.util.k;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GraphicExportDialog
extends JDialog
implements KeyListener {
    private i a;
    private JComboBox a;
    private JComboBox b;
    private JLabel a;
    private JButton a;
    private double a;
    private int a;
    private int b;
    private NumberFormat a;
    private final int c = 0;
    private final int d = 1;
    private final int e = 2;
    private final int f = 3;
    private final int g = 4;

    public GraphicExportDialog(i i2) {
        super((Frame)i2.a(), true);
        this.a = i2;
        this.a = NumberFormat.getInstance(Locale.ENGLISH);
        this.a.setGroupingUsed(false);
        this.a.setMaximumFractionDigits(2);
        this.initGUI();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.loadPreferences();
            super.setVisible(true);
        } else {
            this.savePreferences();
            super.setVisible(false);
        }
    }

    private void initGUI() {
        this.setResizable(false);
        this.setTitle(String.valueOf(this.a.b("Export")) + ": " + this.a.a("DrawingPad"));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel(new FlowLayout(5));
        String[] stringArray = new String[]{String.valueOf(this.a.a("png")) + " (" + "png" + ")", String.valueOf(this.a.a("pdf")) + " (" + "pdf" + ")", String.valueOf(this.a.a("eps")) + " (" + "eps" + ")", String.valueOf(this.a.a("svg")) + " (" + "svg" + ")", String.valueOf(this.a.a("emf")) + " (" + "emf" + ")"};
        this.a = new JComboBox<String>(stringArray);
        jPanel2.add(new JLabel(String.valueOf(this.a.a("Format")) + ":"));
        jPanel2.add(this.a);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        w w2 = this.a.a();
        m m2 = new m(this.a, w2);
        m2.a(new f(this));
        jPanel3.add(m2);
        JPanel jPanel4 = new JPanel(new FlowLayout(5));
        String[] stringArray2 = new String[]{"72", "96", "150", "300", "600"};
        this.b = new JComboBox<String>(stringArray2);
        this.b.setSelectedItem("300");
        jPanel4.add(new JLabel(String.valueOf(this.a.a("ResolutionInDPI")) + ":"));
        jPanel4.add(this.b);
        jPanel3.add(jPanel4);
        this.b.addActionListener(new q(this));
        this.a.addActionListener(new x(this));
        JPanel jPanel5 = new JPanel(new FlowLayout(5));
        jPanel5.add(new JLabel(String.valueOf(this.a.a("Size")) + ":"));
        this.a = new JLabel();
        jPanel5.add(this.a);
        jPanel3.add(jPanel5);
        jPanel.add((Component)jPanel3, "Center");
        this.a = new JButton(this.a.a("Cancel"));
        this.a.addActionListener(new I(this));
        JButton jButton = new JButton(this.a.b("Export"));
        jButton.addActionListener(new c(this));
        JPanel jPanel6 = new JPanel(new FlowLayout(1));
        jPanel6.add(jButton);
        jPanel6.add(this.a);
        jPanel.add((Component)jPanel6, "South");
        k.a((Container)this, (KeyListener)this);
        this.updateSizeLabel();
        this.centerOnScreen();
    }

    private int getDPI() {
        return Integer.parseInt((String)this.b.getSelectedItem());
    }

    private void loadPreferences() {
        try {
            int n2 = 0;
            String string = Q.a((String)"export_pic_format", (String)"png");
            if (string.equals("eps")) {
                n2 = 2;
            } else if (string.equals("svg")) {
                n2 = 3;
            }
            this.a.setSelectedIndex(n2);
            if (this.b.isEnabled()) {
                String string2 = Q.a((String)"export_pic_dpi", (String)"300");
                int n3 = 0;
                while (n3 < this.b.getItemCount()) {
                    String string3 = this.b.getItemAt(n3).toString();
                    if (string3.equals(string2)) {
                        this.b.setSelectedIndex(n3);
                    }
                    ++n3;
                }
            }
            this.updateSizeLabel();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void savePreferences() {
        String string;
        Q.a((String)"export_pic_dpi", (String)this.b.getSelectedItem().toString());
        switch (this.a.getSelectedIndex()) {
            case 2: {
                string = "eps";
                break;
            }
            case 3: {
                string = "svg";
                break;
            }
            default: {
                string = "png";
            }
        }
        Q.a((String)"export_pic_format", (String)string);
    }

    private void updateSizeLabel() {
        w w2 = this.a.a();
        double d2 = w2.f();
        this.a = d2 * (double)this.getDPI() / 2.54 / w2.a();
        StringBuffer stringBuffer = new StringBuffer();
        double d3 = d2 * ((double)w2.g() / w2.a());
        double d4 = d2 * ((double)w2.h() / w2.b());
        stringBuffer.append(this.a.format(d3));
        stringBuffer.append(" x ");
        stringBuffer.append(this.a.format(d4));
        stringBuffer.append(" cm");
        this.a = (int)Math.floor((double)w2.g() * this.a);
        this.b = (int)Math.floor((double)w2.h() * this.a);
        stringBuffer.append(", ");
        stringBuffer.append(this.a);
        stringBuffer.append(" x ");
        stringBuffer.append(this.b);
        stringBuffer.append(" pixel");
        this.a.setText(stringBuffer.toString());
    }

    private void centerOnScreen() {
        this.pack();
        this.setLocationRelativeTo((Component)this.a.a());
    }

    private final boolean exportEPS() {
        File file = this.a.a("eps", null, String.valueOf(this.a.a("eps")) + " " + this.a.b("Files"));
        if (file == null) {
            return false;
        }
        try {
            w w2 = this.a.a();
            b b2 = new b(String.valueOf(this.a.a("ApplicationName")) + ", " + this.a.a("ApplicationURL"), file, 0, 0, this.a, this.b);
            w2.a((Graphics2D)b2, this.a);
            b2.b();
            return true;
        }
        catch (Exception exception) {
            this.a.b("SaveFileFailed");
            System.err.println(exception.toString());
            return false;
        }
    }

    private final boolean exportEMF() {
        File file = this.a.a("emf", null, String.valueOf(this.a.a("emf")) + " " + this.a.b("Files"));
        if (file == null) {
            return false;
        }
        try {
            EMFGraphics2D eMFGraphics2D = new EMFGraphics2D(file, new Dimension(this.a, this.b));
            ((VectorGraphics)eMFGraphics2D).startExport();
            this.a.a().a((Graphics2D)eMFGraphics2D, this.a);
            ((VectorGraphics)eMFGraphics2D).endExport();
            return true;
        }
        catch (Exception exception) {
            this.a.b("SaveFileFailed");
            System.err.println(exception.toString());
            return false;
        }
        catch (Error error) {
            this.a.b("SaveFileFailed");
            System.err.println(error.toString());
            return false;
        }
    }

    private final boolean exportPDF() {
        File file = this.a.a("pdf", null, String.valueOf(this.a.a("pdf")) + " " + this.a.b("Files"));
        if (file == null) {
            return false;
        }
        try {
            PDFGraphics2D pDFGraphics2D = new PDFGraphics2D(file, new Dimension(this.a, this.b));
            ((VectorGraphics)pDFGraphics2D).startExport();
            this.a.a().a((Graphics2D)pDFGraphics2D, this.a);
            ((VectorGraphics)pDFGraphics2D).endExport();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.a.b("SaveFileFailed");
            return false;
        }
        catch (Error error) {
            error.printStackTrace();
            this.a.b("SaveFileFailed");
            return false;
        }
    }

    private final boolean exportSVG() {
        File file = this.a.a("svg", null, String.valueOf(this.a.a("svg")) + " " + this.a.b("Files"));
        if (file == null) {
            return false;
        }
        try {
            SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(file, new Dimension(this.a, this.b));
            ((VectorGraphics)sVGGraphics2D).startExport();
            this.a.a().a((Graphics2D)sVGGraphics2D, this.a);
            ((VectorGraphics)sVGGraphics2D).endExport();
            return true;
        }
        catch (Exception exception) {
            this.a.b("SaveFileFailed");
            System.err.println(exception.toString());
            return false;
        }
        catch (Error error) {
            this.a.b("SaveFileFailed");
            System.err.println(error.toString());
            return false;
        }
    }

    private final boolean exportPNG() {
        File file = this.a.a("png", null, String.valueOf(this.a.a("png")) + " " + this.a.b("Files"));
        if (file == null) {
            return false;
        }
        try {
            BufferedImage bufferedImage = this.a.a().a(this.a);
            geogebra.io.a.a((BufferedImage)bufferedImage, (String)"png", (float)this.getDPI(), (File)file);
            return true;
        }
        catch (Exception exception) {
            this.a.b("SaveFileFailed");
            System.err.println(exception.toString());
            return false;
        }
        catch (Error error) {
            this.a.b("SaveFileFailed");
            System.err.println(error.toString());
            return false;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        if (n2 == 27) {
            this.setVisible(false);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    static void access$0(GraphicExportDialog graphicExportDialog) {
        graphicExportDialog.updateSizeLabel();
    }

    static JComboBox access$1(GraphicExportDialog graphicExportDialog) {
        return graphicExportDialog.a;
    }

    static JComboBox access$2(GraphicExportDialog graphicExportDialog) {
        return graphicExportDialog.b;
    }

    static boolean access$3(GraphicExportDialog graphicExportDialog) {
        return graphicExportDialog.exportPNG();
    }

    static boolean access$4(GraphicExportDialog graphicExportDialog) {
        return graphicExportDialog.exportEPS();
    }

    static boolean access$5(GraphicExportDialog graphicExportDialog) {
        return graphicExportDialog.exportEMF();
    }

    static boolean access$6(GraphicExportDialog graphicExportDialog) {
        return graphicExportDialog.exportPDF();
    }

    static boolean access$7(GraphicExportDialog graphicExportDialog) {
        return graphicExportDialog.exportSVG();
    }
}

