(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12776,        437]*)
(*NotebookOutlinePosition[     13547,        463]*)
(*  CellTagsIndexPosition[     13503,        459]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Einf\[UDoubleDot]hrung in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Title"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell["", "Text"],

Cell["\<\
Dieser Mathematica-Kurs entstand als Begleitmaterial zu den \
Einf\[UDoubleDot]hrungsvorlesungen \"Einf\[UDoubleDot]hrung in das \
Mathematische Arbeiten\" und \"Analysis 1\" am Institut f\[UDoubleDot]r \
Mathematik der Universit\[ADoubleDot]t Wien im Wintersemester 2003. Das \
Material ist inhaltlich auf die Analysis Vorlesung abgestimmt und bietet nach \
einer Einf\[UDoubleDot]hrung in die Grundkonzepte von Mathematica \
(Grundlegende Bedienung, Terme, Variablen, Gleichungen,...) eine \
Zusammenstellung der grundlegenden Mathematica Kenntnisse zu den klassischen \
Themen einer Analysis 1 (Folgen, Reihen,...).\
\>", "Text"],

Cell["\<\
Das hier vorliegende Material wendet sich an Studienanf\[ADoubleDot]nger und \
ist in sich geschlossen, d.h. auch zum Selbststudium geeignet.\
\>", "Text"],

Cell[TextData[{
  "Die Arbeit an diesen Materialien wurde vom Projekt \"Neue Medien in der \
Mathematik-Ausbildung\" (",
  ButtonBox["http://www.mathe-online.at/nml",
    ButtonData:>{
      URL[ "http://www.mathe-online.at/nml"], None},
    ButtonStyle->"Hyperlink"],
  ") unterst\[UDoubleDot]tzt, das im Rahmen der \"Initiative Neue Medien in \
der Lehre\" vom Bundesministerium f\[UDoubleDot]r Bildung, Wissenschaft und \
Kultur gef\[ODoubleDot]rdert wird."
}], "Text"],

Cell["", "Text"],

Cell[TextData[{
  "Was ist ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " eigentlich?"
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ist ein sogenanntes Computer Algebra System (CAS). Prinzipiell ist ein \
CAS ein Programm, das neben numerischen Berechnungen auch symbolisch mit \
mathematischen Ausdr\[UDoubleDot]cken umgehen kann.\n",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " bietet viele verschiedene Anwendungsm\[ODoubleDot]glichkeiten: Auf \
einfachstem Level ist ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " als (sehr intelligenter und genauer) Taschenrechner benutzbar. Weiters \
ist ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ein umfassendes Programmpaket f\[UDoubleDot]r numerische und symbolische \
Berechnungen mit einer Menge von eingebauten Funktionen und Befehlen. So kann \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " unter anderem Grenzwerte berechnen, differenzieren, integrieren und \
Gleichungen, Gleichungssysteme und Differentialgleichungen l\[ODoubleDot]sen. \
Als Grafik-System bietet ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " vielf\[ADoubleDot]ltige M\[ODoubleDot]glichkeiten f\[UDoubleDot]r die \
Visualisierung von Daten und die grafische Darstellung von Funktionen, sowohl \
2D als auch 3D. Auf fortgeschrittenerem Level ist ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " auch eine Programmiersprache, der alle eingebauten Funktionen und Befehle \
zur Verf\[UDoubleDot]gung stehen.\nMehr Infos zu ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ": ",
  ButtonBox["http://www.wolfram.com/products/mathematica/index.html",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/mathematica/index.html"], None},
    ButtonStyle->"Hyperlink"]
}], "Text"],

Cell[TextData[{
  "Neben ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " gibt es noch einige andere Computer Algebra Systeme. Vielleicht ist \
einigen von Ihnen das Programm Derive (",
  ButtonBox["http://education.ti.com/us/product/software/derive/features/\
features.html",
    ButtonData:>{
      URL[ 
      "http://education.ti.com/us/product/software/derive/features/features.\
html"], None},
    ButtonStyle->"Hyperlink"],
  ") aus der Schule bekannt. Weitere CASe sind Maple (",
  ButtonBox["http://www.maplesoft.com",
    ButtonData:>{
      URL[ "http://www.maplesoft.com/"], None},
    ButtonStyle->"Hyperlink"],
  "), MATLAB (",
  ButtonBox["http://www.mathworks.com",
    ButtonData:>{
      URL[ "http://www.mathworks.com/"], None},
    ButtonStyle->"Hyperlink"],
  ") und MuPad (",
  ButtonBox["http://www.mupad.de",
    ButtonData:>{
      URL[ "http://www.mupad.de/"], None},
    ButtonStyle->"Hyperlink"],
  "). "
}], "Text"],

Cell["", "Text"],

Cell[CellGroupData[{

Cell["Inhaltsverzeichnis", "Subtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  ButtonBox["Grundlegende Funktionsweise und Bedienung von ",
    ButtonData:>{
      FrontEnd`FileName[ {"kapitel"}, "grundlagen.nb", CharacterEncoding -> 
        "WindowsANSI"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{
      FrontEnd`FileName[ {"kapitel"}, "grundlagen.nb", CharacterEncoding -> 
        "WindowsANSI"], None},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"]
}], "Section"],

Cell["Durchf\[UDoubleDot]hren von Berechnungen; Grundrechnungsarten", "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Befehle und der Help Browser"
}], "Text"],

Cell["Verwenden von fr\[UDoubleDot]heren Ergebnissen", "Text"],

Cell[TextData[{
  "Exakte und approximative Rechenergebnisse; der Befehl ",
  StyleBox["N",
    FontFamily->"Courier New"]
}], "Text"],

Cell["Eingabe \[UDoubleDot]ber Paletten", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Variablen",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "variablen.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell["Zuweisen und L\[ODoubleDot]schen", "Text"],

Cell["Verz\[ODoubleDot]gerte Zuweisung", "Text"],

Cell["Substitution", "Text"]
}, Open  ]],

Cell[TextData[ButtonBox["Manipulation von Termen",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "terme.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Funktionen",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "funktionen.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell["Eingebaute mathematische Funktionen", "Text"],

Cell["Definition von Funktionen", "Text"],

Cell["Grafische Darstellung von Funktionen", "Text"],

Cell["Wertetabellen", "Text"],

Cell["St\[UDoubleDot]ckweise Definition von Funktionen", "Text"],

Cell["Rekursive Definition von Funktionen", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["L\[ODoubleDot]sen von Gleichungen",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "gleichungen.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell[TextData[{
  "Der Vergleichsoperator ",
  StyleBox["==",
    FontFamily->"Courier New"]
}], "Text"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["Solve",
    FontFamily->"Courier New"]
}], "Text"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["FindRoot",
    FontFamily->"Courier New"]
}], "Text"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["Reduce",
    FontFamily->"Courier New"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Grenzwertberechnungen bei Folgen und Reihen",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "folgengrenzwerte.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell["Folgen", "Text"],

Cell["Reihen", "Text"],

Cell["Grafische Darstellung von Folgen und Reihen", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Plots",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "plots.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell[TextData[{
  "Plots im ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]]
}], "Text"],

Cell[TextData[{
  "Plots im ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]]
}], "Text"]
}, Open  ]],

Cell[TextData[ButtonBox["Grenzwertberechnungen bei Funktionen",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "funktionengrenzwerte.nb", 
      CharacterEncoding -> "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell[TextData[ButtonBox["Differentiation",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "differentiation.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell[TextData[ButtonBox["Potenzreihen",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "potenzreihen.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell[TextData[ButtonBox["Manipulation von trigonometrischen und \
hyperbolischen Funktionen",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "winkelfunktionen.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Integration",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "integration.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell["Unbestimmtes Integral", "Text"],

Cell["Bestimmtes Integral", "Text"],

Cell["Uneigentliche Integrale", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Vektoren und Matrizen",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "matrizen.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell["Vektoren", "Text"],

Cell["Matrizen", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Mehrdimensionale Funktionen und ihre \
Differentiation",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "differentiation2.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell["Mehrdimensionale Funktionen", "Text"],

Cell["Partielle Ableitungen", "Text"],

Cell["Die erste Ableitung", "Text"],

Cell["H\[ODoubleDot]here partielle Ableitungen", "Text"],

Cell["Die zweite Ableitung", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Gew\[ODoubleDot]hnliche Differentialgleichungen",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "diffgleichungen.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["DSolve",
    FontFamily->"Courier New"]
}], "Text"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["NDSolve",
    FontFamily->"Courier New"]
}], "Text"],

Cell["Plotten von L\[ODoubleDot]sungskurven und Vektorfeldern", "Text"]
}, Open  ]],

Cell[TextData[ButtonBox["Animationen",
  ButtonData:>{
    FrontEnd`FileName[ {"kapitel"}, "animationen.nb", CharacterEncoding -> 
      "WindowsANSI"], None},
  ButtonStyle->"Hyperlink"]], "Section"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
PrintingStyleEnvironment->"Printout",
WindowToolbars->"EditBar",
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 111, 4, 95, "Title"],
Cell[1890, 59, 246, 7, 52, "Text"],
Cell[2139, 68, 16, 0, 33, "Text"],
Cell[2158, 70, 642, 10, 90, "Text"],
Cell[2803, 82, 165, 3, 33, "Text"],
Cell[2971, 87, 472, 10, 52, "Text"],
Cell[3446, 99, 16, 0, 33, "Text"],
Cell[3465, 101, 110, 5, 33, "Text"],
Cell[3578, 108, 1721, 40, 166, "Text"],
Cell[5302, 150, 954, 29, 71, "Text"],
Cell[6259, 181, 16, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[6300, 185, 38, 0, 51, "Subtitle"],

Cell[CellGroupData[{
Cell[6363, 189, 467, 12, 73, "Section"],
Cell[6833, 203, 77, 0, 33, "Text"],
Cell[6913, 205, 113, 4, 33, "Text"],
Cell[7029, 211, 62, 0, 33, "Text"],
Cell[7094, 213, 134, 4, 33, "Text"],
Cell[7231, 219, 49, 0, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7317, 224, 196, 4, 73, "Section"],
Cell[7516, 230, 48, 0, 33, "Text"],
Cell[7567, 232, 48, 0, 33, "Text"],
Cell[7618, 234, 28, 0, 33, "Text"]
}, Open  ]],
Cell[7661, 237, 206, 4, 73, "Section"],

Cell[CellGroupData[{
Cell[7892, 245, 198, 4, 73, "Section"],
Cell[8093, 251, 51, 0, 33, "Text"],
Cell[8147, 253, 41, 0, 33, "Text"],
Cell[8191, 255, 52, 0, 33, "Text"],
Cell[8246, 257, 29, 0, 33, "Text"],
Cell[8278, 259, 64, 0, 33, "Text"],
Cell[8345, 261, 51, 0, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8433, 266, 222, 4, 73, "Section"],
Cell[8658, 272, 104, 4, 33, "Text"],
Cell[8765, 278, 95, 4, 33, "Text"],
Cell[8863, 284, 98, 4, 33, "Text"],
Cell[8964, 290, 96, 4, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9097, 299, 237, 4, 73, "Section"],
Cell[9337, 305, 22, 0, 33, "Text"],
Cell[9362, 307, 22, 0, 33, "Text"],
Cell[9387, 309, 59, 0, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9483, 314, 188, 4, 73, "Section"],
Cell[9674, 320, 114, 4, 33, "Text"],
Cell[9791, 326, 114, 4, 33, "Text"]
}, Open  ]],
Cell[9920, 333, 234, 4, 73, "Section"],
Cell[10157, 339, 208, 4, 73, "Section"],
Cell[10368, 345, 202, 4, 73, "Section"],
Cell[10573, 351, 260, 5, 73, "Section"],

Cell[CellGroupData[{
Cell[10858, 360, 200, 4, 73, "Section"],
Cell[11061, 366, 37, 0, 33, "Text"],
Cell[11101, 368, 35, 0, 33, "Text"],
Cell[11139, 370, 39, 0, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11215, 375, 207, 4, 73, "Section"],
Cell[11425, 381, 24, 0, 33, "Text"],
Cell[11452, 383, 24, 0, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11513, 388, 248, 5, 73, "Section"],
Cell[11764, 395, 43, 0, 33, "Text"],
Cell[11810, 397, 37, 0, 33, "Text"],
Cell[11850, 399, 35, 0, 33, "Text"],
Cell[11888, 401, 56, 0, 33, "Text"],
Cell[11947, 403, 36, 0, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12020, 408, 240, 4, 73, "Section"],
Cell[12263, 414, 96, 4, 33, "Text"],
Cell[12362, 420, 97, 4, 33, "Text"],
Cell[12462, 426, 71, 0, 33, "Text"]
}, Open  ]],
Cell[12548, 429, 200, 4, 73, "Section"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

