(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7668,        262]*)
(*NotebookOutlinePosition[      8332,        285]*)
(*  CellTagsIndexPosition[      8288,        281]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Manipulation von trigonometrischen und hyperbolischen Funktionen\
\>", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell["", "Text"],

Cell[TextData[{
  "Im Kapitel ",
  ButtonBox["Manipulation von Termen",
    ButtonData:>{"terme.nb", None},
    ButtonStyle->"Hyperlink"],
  " haben wir eine Reihe algebraischer Umformungsbefehle kennengelernt. In \
diesem Kapitel wollen wir Umformungsbefehle speziell f\[UDoubleDot]r die \
trigonometrischen und hyperbolischen Funktionen betrachten."
}], "Text"],

Cell[BoxData[GridBox[{
        {\(Sin[x], Cos[x], Tan[x], \[IndentingNewLine]Csc[x], Sec[x], 
          Cot[x]\), 
          
          StyleBox[\(trigonometrische\ Funktionen\ \((Argumente\ im\ Bogenma\
\[SZ])\)\),
            FontFamily->"Times New Roman"]},
        {\(ArcSin[x], ArcCos[x], ArcTan[x], \[IndentingNewLine]ArcCsc[x], 
          ArcSec[x], ArcCot[x]\), 
          
          StyleBox[\(inverse\ trigonometrische\ Funktionen\ \((Resultate\ im\ \
Bogenma\[SZ])\)\),
            FontFamily->"Times New Roman"]},
        {\(Sinh[x], Cosh[x], Tanh[x], \[IndentingNewLine]Csch[x], Sech[x], 
          Coth[x]\), 
          StyleBox[\(hyperbolische\ Funktionen\),
            FontFamily->"Times New Roman"]},
        {\(ArcSinh[x], ArcCosh[x], ArcTanh[x], \[IndentingNewLine]ArcCsch[x], 
          ArcSech[x], ArcCoth[x]\), 
          StyleBox[\(inverse\ hyperbolische\ Funktionen\),
            FontFamily->"Times New Roman"]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  StyleBox["TrigExpand",
    FontFamily->"Courier New"],
  " verwendet die Summens\[ADoubleDot]tze um Summen und ganzzahlige Vielfache \
in den Argumenten der trigonometrischen Funktionen (so weit als \
m\[ODoubleDot]glich) aufzuspalten und expandiert Produkte von \
trigonometrischen Funktionen zu Summen und Potenzen."
}], "Text"],

Cell["Hier drei Beispiele:", "Text"],

Cell[BoxData[
    \(TrigExpand[Sin[x + y]]\)], "Input"],

Cell[BoxData[
    \(TrigExpand[Tan[x]\ Cos[2  x]]\)], "Input"],

Cell[BoxData[
    \(polynom = TrigExpand[Cos[2  x] Sin[3  x]\^2]\)], "Input"],

Cell[TextData[{
  StyleBox["TrigFactor",
    FontFamily->"Courier New"],
  " verwendet die Summens\[ADoubleDot]tze um Summen und ganzzahlige Vielfache \
in den Argumenten der trigonometrischen Funktionen (so weit als \
m\[ODoubleDot]glich) aufzuspalten und zerlegt die resultierenden Polynome in \
den trigonometrischen Funktionen in Produkte."
}], "Text"],

Cell[BoxData[
    \(TrigFactor[polynom]\)], "Input"],

Cell[TextData[{
  StyleBox["TrigReduce",
    FontFamily->"Courier New"],
  " liefert typischerweise einen linearen Ausdruck in den trigonometrischen \
Funktionen mit komplizierteren Argumenten."
}], "Text"],

Cell[BoxData[
    \(TrigReduce[\((Sin[x] + Sin[y]^2)\)*Cos[x]]\)], "Input"],

Cell[TextData[{
  StyleBox["TrigReduce",
    FontFamily->"Courier New"],
  " ist der zu ",
  StyleBox["TrigFactor",
    FontFamily->"Courier New"],
  " ungef\[ADoubleDot]hr kontr\[ADoubleDot]re Befehl. ",
  StyleBox["TrigFactor",
    FontFamily->"Courier New"],
  " hat das Polynom ",
  StyleBox["polynom",
    FontFamily->"Courier New"],
  " als Produkt geschrieben. ",
  StyleBox["TrigReduce",
    FontFamily->"Courier New"],
  " schreibt das Polynom ",
  StyleBox["polynom",
    FontFamily->"Courier New"],
  " als Summe ohne explizit auftretende Produkte oder Potenzen."
}], "Text"],

Cell[BoxData[
    \(TrigReduce[polynom]\)], "Input"],

Cell[BoxData[
    \(Clear[polynom]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " verwendet automatisch Funktionen wie ",
  StyleBox["Tan",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["Cot",
    FontFamily->"Courier New"],
  " etc. wann immer es geht."
}], "Text"],

Cell[BoxData[
    \(Sin[x]^2/Cos[x]\)], "Input"],

Cell[BoxData[
    \(1/Cos[x]\)], "Input"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["TrigFactorList",
    FontFamily->"Courier New"],
  " gibt eine Liste der Faktoren und ihrer Potenzen. ",
  StyleBox["TrigFactorList",
    FontFamily->"Courier New"],
  " versucht dabei im Ergebnis m\[ODoubleDot]glichst nur ",
  StyleBox["Sin",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["Cos",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["Sinh",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["Cosh",
    FontFamily->"Courier New"],
  " zu verwenden, also Funktionen wie ",
  StyleBox["Tan",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["Cot",
    FontFamily->"Courier New"],
  " etc. zu zerlegen."
}], "Text"],

Cell[BoxData[
    \(TrigFactorList[Sin[x]*Tan[x]]\)], "Input"],

Cell[BoxData[
    \(TrigFactorList[Sec[3  x]^2*Tan[x]]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          StyleBox[\(Trigonometrische\ \(\(Umformungsbefehle\)\(:\)\)\),
            
            FontFamily->
              "Times New Roman"], \(\(\ \ \ \)\(TrigExpand\)\), \(\(\ \ \ \
\)\(TrigReduce\)\)},
        {" ", \(\(\ \ \ \)\(TrigFactor\)\), \(\(\ \ \ \)\(TrigFactorList\)\)}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell["\<\
Alle Umformungsbefehle funktionieren auch f\[UDoubleDot]r hyperbolische \
Funktionen.\
\>", "Text"],

Cell[BoxData[
    \(TrigExpand[Tanh[x + y]]\)], "Input"],

Cell[BoxData[
    \(polynom = Cosh[x]\ Sinh[3  x]\)], "Input"],

Cell[BoxData[
    \(TrigFactor[polynom]\)], "Input"],

Cell[BoxData[
    \(TrigReduce[polynom]\)], "Input"],

Cell[BoxData[
    \(TrigFactorList[polynom]\)], "Input"],

Cell[BoxData[
    \(Clear[polynom]\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 92, 2, 51, "Subtitle"],
Cell[1871, 57, 246, 7, 52, "Text"],
Cell[2120, 66, 16, 0, 33, "Text"],
Cell[2139, 68, 363, 8, 52, "Text"],
Cell[2505, 78, 1070, 24, 187, "Text"],
Cell[3578, 104, 348, 7, 52, "Text"],
Cell[3929, 113, 36, 0, 33, "Text"],
Cell[3968, 115, 55, 1, 30, "Input"],
Cell[4026, 118, 62, 1, 30, "Input"],
Cell[4091, 121, 77, 1, 31, "Input"],
Cell[4171, 124, 356, 7, 52, "Text"],
Cell[4530, 133, 52, 1, 30, "Input"],
Cell[4585, 136, 206, 5, 33, "Text"],
Cell[4794, 143, 75, 1, 30, "Input"],
Cell[4872, 146, 586, 19, 52, "Text"],
Cell[5461, 167, 52, 1, 30, "Input"],
Cell[5516, 170, 47, 1, 30, "Input"],
Cell[5566, 173, 261, 10, 33, "Text"],
Cell[5830, 185, 48, 1, 30, "Input"],
Cell[5881, 188, 41, 1, 30, "Input"],
Cell[5925, 191, 683, 26, 52, "Text"],
Cell[6611, 219, 62, 1, 30, "Input"],
Cell[6676, 222, 67, 1, 30, "Input"],
Cell[6746, 225, 451, 11, 61, "Text"],
Cell[7200, 238, 109, 3, 33, "Text"],
Cell[7312, 243, 56, 1, 30, "Input"],
Cell[7371, 246, 62, 1, 30, "Input"],
Cell[7436, 249, 52, 1, 30, "Input"],
Cell[7491, 252, 52, 1, 30, "Input"],
Cell[7546, 255, 56, 1, 30, "Input"],
Cell[7605, 258, 47, 1, 30, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

