(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     26952,        919]*)
(*NotebookOutlinePosition[     37240,       1190]*)
(*  CellTagsIndexPosition[     37108,       1182]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Variablen", "Subtitle",
  CellTags->"kap2"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell[CellGroupData[{

Cell["Zuweisen und L\[ODoubleDot]schen", "Section",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  "Oft ist es praktisch Werten, Ausdr\[UDoubleDot]cken oder \
Zwischenergebnissen Namen zu geben. In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " geschieht dies - so wie auch in der Mathematik - durch die Einf\
\[UDoubleDot]hrung von Variablen.\nDurch den Operator \"",
  StyleBox["=",
    FontFamily->"Courier New"],
  "\" wird der Wert rechts vom Gleichheitszeichen der Variablen links vom \
Gleichheitszeichen zugewiesen."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  "Hier wird der Variablen ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " der Wert ",
  StyleBox["3",
    FontFamily->"Courier New"],
  " zugewiesen."
}], "Text",
  Background->None,
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(x = 3\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  "Ab nun ersetzt ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " immer durch den Wert ",
  StyleBox["3",
    FontFamily->"Courier New"],
  " (bis der Kernel deaktiviert wird)."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(x^2\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  "Weist man ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " einen neuen Wert zu, so wird der alte einfach \[UDoubleDot]berschrieben."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(x = 5 + 2; x^2\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["Clear",
    FontFamily->"Courier New"],
  " l\[ODoubleDot]scht den einer Variablen zugewiesenen Wert."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(Clear[x]\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  StyleBox["x",
    FontFamily->"Courier New"],
  " ist jetzt kein Wert mehr zugewiesen."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(x\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  "Variablen k\[ODoubleDot]nnen nicht nur Zahlen sondern auch ganze Ausdr\
\[UDoubleDot]cke (Terme, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Befehle etc.) zugewiesen werden."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(b = a^2 + 1\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  "Wird der symbolischen Variablen ",
  StyleBox["a",
    FontFamily->"Courier New"],
  " ein Wert zugewiesen, so hat das auch Auswirkungen auf ",
  StyleBox["b",
    FontFamily->"Courier New"],
  ", denn ",
  StyleBox["b",
    FontFamily->"Courier New"],
  " hat den Wert ",
  Cell[BoxData[
      \(a\^2\)],
    FontFamily->"Courier New"],
  StyleBox["+1",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " setzt ab nun f\[UDoubleDot]r ",
  StyleBox["a", "Output"],
  " immer den Wert ",
  StyleBox["5",
    FontFamily->"Courier New"],
  " ein."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(a = 5; b\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell["\<\
Das ist eine zweite M\[ODoubleDot]glichkleit den einer Variablen zugewiesenen \
Wert zu l\[ODoubleDot]schen.\
\>", "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(a =. \)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  "Da ",
  StyleBox["a",
    FontFamily->"Courier New"],
  " nun kein Wert mehr zugewiesen ist, kann ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " im Ausdruck ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["a",
            FontSlant->"Plain"], "2"], TraditionalForm]],
    FontFamily->"Courier New"],
  StyleBox["+1",
    FontFamily->"Courier New"],
  " auch keinen Wert f\[UDoubleDot]r ",
  StyleBox["a",
    FontFamily->"Courier New"],
  " mehr einsetzen. "
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(b\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            StyleBox["var",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], 
            StyleBox["=",
              FontFamily->"Courier New"], 
            StyleBox["aus",
              FontSlant->"Italic"]}], 
          RowBox[{"   ", 
            RowBox[{"der", " ", "Variablen", " ", 
              StyleBox["var",
                FontSlant->"Italic"], " ", "wird", " ", "der", " ", 
              "Ausdruck", " ", 
              StyleBox["aus",
                FontSlant->"Italic"], " ", "zugewiesen"}]}]},
        {
          RowBox[{
            StyleBox["var1",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], 
            StyleBox["=",
              FontFamily->"Courier New"], 
            RowBox[{
              StyleBox["var2",
                FontSlant->"Italic"], 
              StyleBox["=",
                FontFamily->"Courier New"], 
              StyleBox["aus",
                FontSlant->"Italic"]}]}], 
          RowBox[{"   ", 
            RowBox[{"den", " ", "Variablen", " ", 
              StyleBox["var1",
                FontSlant->"Italic"], " ", "und", " ", 
              StyleBox["var2",
                FontSlant->"Italic"], " ", "wird", " ", "der", " ", 
              "Ausdruck", " ", 
              StyleBox["aus",
                FontSlant->"Italic"], " ", \((gleichzeitig)\), " ", 
              "zugewiesen"}]}]},
        {
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["Clear",
                  FontFamily->"Courier New"], 
                StyleBox["[",
                  FontFamily->"Courier New"], 
                StyleBox["var",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["]",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"]}], 
              StyleBox["  ",
                FontFamily->"Courier New"], 
              StyleBox["oder",
                FontFamily->"Courier New",
                FontSlant->"Italic"]}], "\[IndentingNewLine]", 
            RowBox[{
              StyleBox["var",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox["=.",
                FontFamily->"Courier New"]}]}], 
          RowBox[{"   ", 
            RowBox[{
            "l\[ODoubleDot]scht", " ", "den", " ", "der", " ", "Variablen", 
              " ", 
              StyleBox["var",
                FontSlant->"Italic"], " ", "zugewiesenen", " ", 
              "Ausdruck"}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  FontFamily->"Times New Roman",
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  "Als Variablenname ist jede beliebige Kombination aus Gro\[SZ]- und \
Kleinbuchstaben und Zahlen erlaubt, die mit einem Buchstaben beginnt. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ist case-sensitive, das hei\[SZ]t, dass zwischen Gro\[SZ]- und \
Kleinschreibung unterschieden wird. So sind ",
  StyleBox["a",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["A",
    FontFamily->"Courier New"],
  " f\[UDoubleDot]r ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " zwei verschiedene Variablen.\nAlle eingebauten ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Objekte (Funktionen, Befehle, Konstanten etc.) beginnen mit einem \
Gro\[SZ]buchstaben. Um Verwirrung zu vermeiden sollten selbst definierte \
Variablen immer mit einem Kleinbuchstaben beginnen.\nWenn Sie eine Variable \
nicht mehr brauchen, dann l\[ODoubleDot]schen Sie den ihr zugewiesenen Wert \
sofort. Oft werden solche Zuweisungen vom Benutzer vergessen - nicht aber von \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Die Folge ist, dass ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " die zugewiesenen Werte weiter verwendet, auch dort, wo dies vom Benutzer \
nicht mehr gew\[UDoubleDot]nscht ist."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell["Beachten Sie die folgenden Schreibweisen:", "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  "Wir weisen den Variablen ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["y",
    FontFamily->"Courier New"],
  " unterschiedliche Werte zu."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[{
    \(x = 2\), "\[IndentingNewLine]", 
    \(y = 3\)}], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  StyleBox["x y",
    FontFamily->"Courier New"],
  " mit Abstand zwischen den Variablen meint die Variable ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " multipliziert mit der Variablen ",
  StyleBox["y",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(x\ y\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  StyleBox["xy",
    FontFamily->"Courier New"],
  " ohne Abstand zwischen den Variablen meint die Variable mit dem Namen ",
  StyleBox["xy",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(xy\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  StyleBox["5x",
    FontFamily->"Courier New"],
  " mit oder ohne Abstand zwischen der Zahl und der Variablen meint ",
  StyleBox["5",
    FontFamily->"Courier New"],
  " mal die Variable ",
  StyleBox["x",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(5  x\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  StyleBox["x 5",
    FontFamily->"Courier New"],
  " mit Abstand zwischen der Variablen und der Zahl meint ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " mal ",
  StyleBox["5",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(x\ 5\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  StyleBox["x5",
    FontFamily->"Courier New"],
  " ohne Abstand zwischen der Variablen und der Zahl meint die Variable mit \
dem Namen ",
  StyleBox["x5",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(x5\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  StyleBox["x^2y",
    FontFamily->"Courier New"],
  " meint ",
  StyleBox["(x^2)*y",
    FontFamily->"Courier New"],
  " und nicht ",
  StyleBox["x^(2y)",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(x^2  y\)], "Input",
  CellTags->{"kap2", "zuweisen"}],

Cell[TextData[{
  "In einem ",
  StyleBox["Clear",
    FontFamily->"Courier New"],
  "-Befehl k\[ODoubleDot]nnen die Werte von mehreren Variablen gleichzeitig \
gel\[ODoubleDot]scht werden."
}], "Text",
  CellTags->{"kap2", "zuweisen"}],

Cell[BoxData[
    \(Clear[x, y]\)], "Input",
  CellTags->{"kap2", "zuweisen"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Verz\[ODoubleDot]gerte Zuweisung", "Section",
  CellTags->"kap2"],

Cell[TextData[{
  "Bei einer Zuweisung mit \"",
  StyleBox["=",
    FontFamily->"Courier New"],
  "\" wird die rechte Seite zuerst evaluiert und dann der Variablen links \
zugewiesen. Hier wird zuerst eine Zufallszahl zwischen 0 und 1 mittels des \
Befehls ",
  StyleBox["Random[]",
    FontFamily->"Courier New"],
  " erzeugt. Diese Zufallszahl wird dann der Variablen ",
  StyleBox["a1",
    FontFamily->"Courier New"],
  " zugewiesen."
}], "Text",
  CellTags->"kap2"],

Cell[BoxData[
    \(a1 = Random[]\)], "Input",
  CellTags->"kap2"],

Cell[TextData[{
  "Mit dem Befehl \"",
  StyleBox["?",
    FontFamily->"Courier New"],
  "\" kann die Definition einer Variablen abgefragt werden."
}], "Text",
  CellTags->"kap2"],

Cell[BoxData[
    \(\(?a1\)\)], "Input",
  CellTags->"kap2"],

Cell[TextData[{
  "Bei einer Zuweisung mit \"",
  StyleBox[":=",
    FontFamily->"Courier New"],
  "\" wird die rechte Seite unevaluiert gelassen und so, wie sie ist, der \
Variablen links zugewiesen. Erst wenn eine so definierte Variable aufgerufen \
wird, wird die rechte Seite evaluiert, und zwar bei jedem Aufruf von Neuem. \
Da bei der Definition der Variablen nichts evaluiert wird, gibt es auch keine \
Ausgabe."
}], "Text",
  CellTags->"kap2"],

Cell[BoxData[
    \(a2 := Random[]\)], "Input",
  CellTags->"kap2"],

Cell[TextData[{
  "In ",
  StyleBox["a2",
    FontFamily->"Courier New"],
  " steht also nicht eine Zufallszahl zwischen 0 und 1, sondern der ",
  "BEFEHL",
  ", eine solche zu erzeugen."
}], "Text",
  CellTags->"kap2"],

Cell[BoxData[
    \(\(?a2\)\)], "Input",
  CellTags->"kap2"],

Cell[TextData[{
  "Bei jedem Aufruf von ",
  StyleBox["a2",
    FontFamily->"Courier New"],
  " wird also der Befehl ",
  StyleBox["Random[]",
    FontFamily->"Courier New"],
  " von Neuem ausgef\[UDoubleDot]hrt."
}], "Text",
  CellTags->"kap2"],

Cell[BoxData[
    \(a2\)], "Input",
  CellTags->"kap2"],

Cell[BoxData[
    \(a2\)], "Input",
  CellTags->"kap2"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            StyleBox["ls",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], 
            StyleBox["=",
              FontFamily->"Courier New"], 
            StyleBox["rs",
              FontFamily->"Times New Roman"]}], 
          RowBox[{
            StyleBox["   ",
              FontFamily->"Times New Roman"], 
            RowBox[{
              StyleBox["rs",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["wird",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["evaluiert",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["und",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["ls",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["zugewiesen",
                FontFamily->"Times New Roman"]}]}]},
        {
          RowBox[{
            StyleBox["ls",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], 
            StyleBox[":=",
              FontFamily->"Courier New"], 
            StyleBox["rs",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{
            StyleBox["   ",
              FontFamily->"Times New Roman"], 
            RowBox[{
              RowBox[{
                StyleBox["rs",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["wird",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["ls",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["unevaluiert",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["zugewiesen",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[";",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["rs",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["wird",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["bei",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["jedem",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Aufruf",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["ls",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["neu",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["evaluiert",
                  FontFamily->"Times New Roman"]}]}]}]},
        {
          RowBox[{
            StyleBox["?",
              FontFamily->"Courier New"], 
            StyleBox["x",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{
            StyleBox["   ",
              FontFamily->"Times New Roman"], 
            RowBox[{
              StyleBox["zeigt",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["die",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Definiton",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["von",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"kap2"],

Cell["Und wieder das L\[ODoubleDot]schen nicht vergessen!", "Text",
  CellTags->"kap2"],

Cell[BoxData[
    \(Clear[a1, a2]\)], "Input",
  CellTags->"kap2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitution", "Section",
  CellTags->{"kap2", "Substitution"}],

Cell[TextData[{
  "Um einen Wert in eine Variable einzusetzen ohne dass dieser Wert der \
Variablen zugewiesen wird kann man den Operator \"",
  StyleBox["/.",
    FontFamily->"Courier New"],
  "\" verwenden."
}], "Text",
  CellTags->{"kap2", "Substitution"}],

Cell[TextData[{
  StyleBox["b",
    FontFamily->"Courier New"],
  " ist (noch immer) der Wert ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["a",
            FontSlant->"Plain"], "2"], TraditionalForm]],
    FontFamily->"Courier New"],
  StyleBox["+1",
    FontFamily->"Courier New"],
  " zugewiesen (Die Zuweisung erfolgte im Abschnitt \"Zuweisen und L\
\[ODoubleDot]schen\" und wurde bis jetzt nicht gel\[ODoubleDot]scht. Mal \
ehrlich - h\[ADoubleDot]tten Sie das noch gewusst?). In der folgenden \
Input-Zelle steht ",
  StyleBox["b",
    FontFamily->"Courier New"],
  " links vom Operator \"",
  StyleBox["/.",
    FontFamily->"Courier New"],
  "\", also ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["a",
            FontSlant->"Plain"], "2"], TraditionalForm]],
    FontFamily->"Courier New"],
  StyleBox["+1",
    FontFamily->"Courier New"],
  ". Rechts vom Operator \"",
  StyleBox["/.",
    FontFamily->"Courier New"],
  "\" steht eine sogenannte  Ersetzungsregel der Form \"",
  StyleBox["Variable",
    FontSlant->"Italic"],
  "\[Rule]",
  StyleBox["Wert",
    FontSlant->"Italic"],
  "\", hier also ",
  StyleBox["a\[Rule]5",
    FontFamily->"Courier New"],
  ", was bedeutet, dass f\[UDoubleDot]r jedes ",
  StyleBox["a",
    FontFamily->"Courier New"],
  " im Ausdruck links der Wert ",
  StyleBox["5",
    FontFamily->"Courier New"],
  " eingesetzt werden soll. Der Pfeil kann dabei als \"",
  StyleBox["-",
    FontFamily->"Courier New"],
  "\" und \"",
  StyleBox[">",
    FontFamily->"Courier New"],
  "\" eingegeben oder mit der Maus aus der Palette BasicInput ausgew\
\[ADoubleDot]hlt werden. (Die verschiedenen Paletten finden Sie im Men\
\[UDoubleDot]punkt File \[Rule] Palettes.)"
}], "Text",
  CellTags->{"kap2", "Substitution"}],

Cell[BoxData[
    \(b /. a \[Rule] 5\)], "Input",
  CellTags->{"kap2", "Substitution"}],

Cell[TextData[{
  "Der Variablen ",
  StyleBox["a",
    FontFamily->"Courier New"],
  " wird dabei kein Wert zugewiesen."
}], "Text",
  CellTags->{"kap2", "Substitution"}],

Cell[BoxData[
    \(a\)], "Input",
  CellTags->{"kap2", "Substitution"}],

Cell[TextData[{
  "Auch der Wert von ",
  StyleBox["b",
    FontFamily->"Courier New"],
  " hat sich durch die vorige Substitution nicht ver\[ADoubleDot]ndert."
}], "Text",
  CellTags->{"kap2", "Substitution"}],

Cell[BoxData[
    \(b\)], "Input",
  CellTags->{"kap2", "Substitution"}],

Cell["\<\
Es ist auch m\[ODoubleDot]glich in einen Ausdruck, der mehrere Variablen enth\
\[ADoubleDot]lt, Werte f\[UDoubleDot]r diese Variablen einzusetzen. Die \
einzelnen Ersetzungsregeln m\[UDoubleDot]ssen daf\[UDoubleDot]r, mit \
Beistrichen voneinander getrennt, in geschwungene Klammern gesetzt werden.\
\>", "Text",
  CellTags->{"kap2", "Substitution"}],

Cell[BoxData[
    \(x^2 + y^2 /. {x \[Rule] 2, y \[Rule] s + 1}\)], "Input",
  CellTags->{"kap2", "Substitution"}],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            StyleBox["aus",
              FontSlant->"Italic"], 
            StyleBox["/.",
              FontFamily->"Courier New"], 
            RowBox[{
              StyleBox["var",
                FontSlant->"Italic"], 
              StyleBox["\[Rule]",
                FontFamily->"Courier New"], 
              StyleBox["wert",
                FontSlant->"Italic"]}]}], 
          RowBox[{"   ", 
            RowBox[{"setzt", " ", "den", " ", "Wert", "  ", 
              StyleBox["wert",
                FontSlant->"Italic"], "  ", "f\[UDoubleDot]r", " ", "die", 
              " ", "Variable", "  ", 
              StyleBox["var",
                FontSlant->"Italic"], "  ", "im", " ", "Ausdruck", "  ", 
              StyleBox["aus",
                FontSlant->"Italic"], "  ", "ein"}]}]},
        {
          RowBox[{
            StyleBox["aus",
              FontSlant->"Italic"], 
            StyleBox["/.",
              FontFamily->"Courier New"], 
            RowBox[{
              StyleBox["{",
                FontFamily->"Courier New"], 
              RowBox[{
                RowBox[{
                  StyleBox["var1",
                    FontSlant->"Italic"], 
                  StyleBox["\[Rule]",
                    FontFamily->"Courier New"], 
                  StyleBox["wert1",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                RowBox[{
                  StyleBox["var2",
                    FontSlant->"Italic"], 
                  StyleBox["\[Rule]",
                    FontFamily->"Courier New"], 
                  StyleBox["wert2",
                    FontSlant->"Italic"]}]}], 
              StyleBox["}",
                FontFamily->"Courier New"]}]}], 
          RowBox[{"   ", 
            RowBox[{
            "setzt", " ", "Werte", " ", "f\[UDoubleDot]r", " ", 
              "verschiedene", " ", "Variablen", " ", "im", " ", "Ausdruck", "  ",
               
              StyleBox["aus",
                FontSlant->"Italic"], "  ", "ein"}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  FontFamily->"Times New Roman",
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->{"kap2", "Substitution"}],

Cell[TextData[{
  "Da wir ",
  StyleBox["b",
    FontFamily->"Courier New"],
  " nicht mehr ben\[ODoubleDot]tigen, wollen wir obigen Rat beherzigen und ",
  StyleBox["b",
    FontFamily->"Courier New"],
  " wieder frei machen."
}], "Text",
  CellTags->{"kap2", "Substitution"}],

Cell[BoxData[
    \(Clear[b]\)], "Input",
  CellTags->{"kap2", "Substitution"}]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "kap2"->{
    Cell[1776, 53, 49, 1, 51, "Subtitle",
      CellTags->"kap2"],
    Cell[2099, 67, 85, 1, 73, "Section",
      CellTags->{"kap2", "zuweisen"}],
    Cell[2187, 70, 501, 12, 52, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[2691, 84, 240, 10, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[2934, 96, 72, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3009, 100, 305, 12, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3317, 114, 70, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3390, 118, 203, 6, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3596, 126, 81, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3680, 130, 193, 6, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3876, 138, 75, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3954, 142, 151, 5, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[4108, 149, 68, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[4179, 153, 254, 7, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[4436, 162, 78, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[4517, 166, 657, 26, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[5177, 194, 75, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[5255, 198, 166, 4, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[5424, 204, 72, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[5499, 208, 564, 21, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[6066, 231, 68, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[6137, 235, 2838, 78, 103, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[8978, 315, 1298, 32, 128, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[10279, 349, 91, 1, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[10373, 352, 231, 9, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[10607, 363, 113, 3, 50, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[10723, 368, 313, 11, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[11039, 381, 71, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[11113, 385, 241, 8, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[11357, 395, 69, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[11429, 399, 307, 11, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[11739, 412, 71, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[11813, 416, 285, 11, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[12101, 429, 71, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[12175, 433, 256, 9, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[12434, 444, 69, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[12506, 448, 255, 11, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[12764, 461, 73, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[12840, 465, 236, 7, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[13079, 474, 78, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[13194, 481, 71, 1, 43, "Section",
      CellTags->"kap2"],
    Cell[13268, 484, 470, 14, 52, "Text",
      CellTags->"kap2"],
    Cell[13741, 500, 66, 2, 30, "Input",
      CellTags->"kap2"],
    Cell[13810, 504, 179, 6, 33, "Text",
      CellTags->"kap2"],
    Cell[13992, 512, 60, 2, 30, "Input",
      CellTags->"kap2"],
    Cell[14055, 516, 451, 10, 52, "Text",
      CellTags->"kap2"],
    Cell[14509, 528, 67, 2, 30, "Input",
      CellTags->"kap2"],
    Cell[14579, 532, 219, 8, 33, "Text",
      CellTags->"kap2"],
    Cell[14801, 542, 60, 2, 30, "Input",
      CellTags->"kap2"],
    Cell[14864, 546, 245, 9, 33, "Text",
      CellTags->"kap2"],
    Cell[15112, 557, 55, 2, 30, "Input",
      CellTags->"kap2"],
    Cell[15170, 561, 55, 2, 30, "Input",
      CellTags->"kap2"],
    Cell[15228, 565, 5550, 148, 81, "Text",
      CellTags->"kap2"],
    Cell[20781, 715, 87, 1, 33, "Text",
      CellTags->"kap2"],
    Cell[20871, 718, 66, 2, 30, "Input",
      CellTags->"kap2"],
    Cell[20974, 725, 69, 1, 43, "Section",
      CellTags->{"kap2", "Substitution"}],
    Cell[21046, 728, 259, 7, 33, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[21308, 737, 1815, 58, 90, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[23126, 797, 87, 2, 30, "Input",
      CellTags->{"kap2", "Substitution"}],
    Cell[23216, 801, 171, 6, 33, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[23390, 809, 72, 2, 30, "Input",
      CellTags->{"kap2", "Substitution"}],
    Cell[23465, 813, 210, 6, 33, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[23678, 821, 72, 2, 30, "Input",
      CellTags->{"kap2", "Substitution"}],
    Cell[23753, 825, 360, 6, 52, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[24116, 833, 114, 2, 30, "Input",
      CellTags->{"kap2", "Substitution"}],
    Cell[24233, 837, 2329, 63, 63, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[26565, 902, 277, 9, 33, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[26845, 913, 79, 2, 30, "Input",
      CellTags->{"kap2", "Substitution"}]},
  "zuweisen"->{
    Cell[2099, 67, 85, 1, 73, "Section",
      CellTags->{"kap2", "zuweisen"}],
    Cell[2187, 70, 501, 12, 52, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[2691, 84, 240, 10, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[2934, 96, 72, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3009, 100, 305, 12, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3317, 114, 70, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3390, 118, 203, 6, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3596, 126, 81, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3680, 130, 193, 6, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3876, 138, 75, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[3954, 142, 151, 5, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[4108, 149, 68, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[4179, 153, 254, 7, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[4436, 162, 78, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[4517, 166, 657, 26, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[5177, 194, 75, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[5255, 198, 166, 4, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[5424, 204, 72, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[5499, 208, 564, 21, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[6066, 231, 68, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[6137, 235, 2838, 78, 103, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[8978, 315, 1298, 32, 128, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[10279, 349, 91, 1, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[10373, 352, 231, 9, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[10607, 363, 113, 3, 50, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[10723, 368, 313, 11, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[11039, 381, 71, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[11113, 385, 241, 8, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[11357, 395, 69, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[11429, 399, 307, 11, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[11739, 412, 71, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[11813, 416, 285, 11, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[12101, 429, 71, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[12175, 433, 256, 9, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[12434, 444, 69, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[12506, 448, 255, 11, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[12764, 461, 73, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}],
    Cell[12840, 465, 236, 7, 33, "Text",
      CellTags->{"kap2", "zuweisen"}],
    Cell[13079, 474, 78, 2, 30, "Input",
      CellTags->{"kap2", "zuweisen"}]},
  "Substitution"->{
    Cell[20974, 725, 69, 1, 43, "Section",
      CellTags->{"kap2", "Substitution"}],
    Cell[21046, 728, 259, 7, 33, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[21308, 737, 1815, 58, 90, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[23126, 797, 87, 2, 30, "Input",
      CellTags->{"kap2", "Substitution"}],
    Cell[23216, 801, 171, 6, 33, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[23390, 809, 72, 2, 30, "Input",
      CellTags->{"kap2", "Substitution"}],
    Cell[23465, 813, 210, 6, 33, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[23678, 821, 72, 2, 30, "Input",
      CellTags->{"kap2", "Substitution"}],
    Cell[23753, 825, 360, 6, 52, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[24116, 833, 114, 2, 30, "Input",
      CellTags->{"kap2", "Substitution"}],
    Cell[24233, 837, 2329, 63, 63, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[26565, 902, 277, 9, 33, "Text",
      CellTags->{"kap2", "Substitution"}],
    Cell[26845, 913, 79, 2, 30, "Input",
      CellTags->{"kap2", "Substitution"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"kap2", 27561, 935},
  {"zuweisen", 32851, 1072},
  {"Substitution", 35983, 1151}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 49, 1, 51, "Subtitle",
  CellTags->"kap2"],
Cell[1828, 56, 246, 7, 52, "Text"],

Cell[CellGroupData[{
Cell[2099, 67, 85, 1, 73, "Section",
  CellTags->{"kap2", "zuweisen"}],
Cell[2187, 70, 501, 12, 52, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[2691, 84, 240, 10, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[2934, 96, 72, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[3009, 100, 305, 12, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[3317, 114, 70, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[3390, 118, 203, 6, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[3596, 126, 81, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[3680, 130, 193, 6, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[3876, 138, 75, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[3954, 142, 151, 5, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[4108, 149, 68, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[4179, 153, 254, 7, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[4436, 162, 78, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[4517, 166, 657, 26, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[5177, 194, 75, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[5255, 198, 166, 4, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[5424, 204, 72, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[5499, 208, 564, 21, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[6066, 231, 68, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[6137, 235, 2838, 78, 103, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[8978, 315, 1298, 32, 128, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[10279, 349, 91, 1, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[10373, 352, 231, 9, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[10607, 363, 113, 3, 50, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[10723, 368, 313, 11, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[11039, 381, 71, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[11113, 385, 241, 8, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[11357, 395, 69, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[11429, 399, 307, 11, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[11739, 412, 71, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[11813, 416, 285, 11, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[12101, 429, 71, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[12175, 433, 256, 9, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[12434, 444, 69, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[12506, 448, 255, 11, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[12764, 461, 73, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}],
Cell[12840, 465, 236, 7, 33, "Text",
  CellTags->{"kap2", "zuweisen"}],
Cell[13079, 474, 78, 2, 30, "Input",
  CellTags->{"kap2", "zuweisen"}]
}, Closed]],

Cell[CellGroupData[{
Cell[13194, 481, 71, 1, 43, "Section",
  CellTags->"kap2"],
Cell[13268, 484, 470, 14, 52, "Text",
  CellTags->"kap2"],
Cell[13741, 500, 66, 2, 30, "Input",
  CellTags->"kap2"],
Cell[13810, 504, 179, 6, 33, "Text",
  CellTags->"kap2"],
Cell[13992, 512, 60, 2, 30, "Input",
  CellTags->"kap2"],
Cell[14055, 516, 451, 10, 52, "Text",
  CellTags->"kap2"],
Cell[14509, 528, 67, 2, 30, "Input",
  CellTags->"kap2"],
Cell[14579, 532, 219, 8, 33, "Text",
  CellTags->"kap2"],
Cell[14801, 542, 60, 2, 30, "Input",
  CellTags->"kap2"],
Cell[14864, 546, 245, 9, 33, "Text",
  CellTags->"kap2"],
Cell[15112, 557, 55, 2, 30, "Input",
  CellTags->"kap2"],
Cell[15170, 561, 55, 2, 30, "Input",
  CellTags->"kap2"],
Cell[15228, 565, 5550, 148, 81, "Text",
  CellTags->"kap2"],
Cell[20781, 715, 87, 1, 33, "Text",
  CellTags->"kap2"],
Cell[20871, 718, 66, 2, 30, "Input",
  CellTags->"kap2"]
}, Closed]],

Cell[CellGroupData[{
Cell[20974, 725, 69, 1, 43, "Section",
  CellTags->{"kap2", "Substitution"}],
Cell[21046, 728, 259, 7, 33, "Text",
  CellTags->{"kap2", "Substitution"}],
Cell[21308, 737, 1815, 58, 90, "Text",
  CellTags->{"kap2", "Substitution"}],
Cell[23126, 797, 87, 2, 30, "Input",
  CellTags->{"kap2", "Substitution"}],
Cell[23216, 801, 171, 6, 33, "Text",
  CellTags->{"kap2", "Substitution"}],
Cell[23390, 809, 72, 2, 30, "Input",
  CellTags->{"kap2", "Substitution"}],
Cell[23465, 813, 210, 6, 33, "Text",
  CellTags->{"kap2", "Substitution"}],
Cell[23678, 821, 72, 2, 30, "Input",
  CellTags->{"kap2", "Substitution"}],
Cell[23753, 825, 360, 6, 52, "Text",
  CellTags->{"kap2", "Substitution"}],
Cell[24116, 833, 114, 2, 30, "Input",
  CellTags->{"kap2", "Substitution"}],
Cell[24233, 837, 2329, 63, 63, "Text",
  CellTags->{"kap2", "Substitution"}],
Cell[26565, 902, 277, 9, 33, "Text",
  CellTags->{"kap2", "Substitution"}],
Cell[26845, 913, 79, 2, 30, "Input",
  CellTags->{"kap2", "Substitution"}]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

