(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7058,        248]*)
(*NotebookOutlinePosition[      7722,        271]*)
(*  CellTagsIndexPosition[      7678,        267]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Manipulation von Termen", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell["", "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kann nicht nur numerisch sondern auch symbolisch rechnen. Das heisst, es \
kann mit algebraischen Ausdr\[UDoubleDot]cken ebenso umgehen wie mit Zahlen."
}], "Text"],

Cell["Das ist eine typische numerische Berechnung.", "Text"],

Cell[BoxData[
    \(35 - 2*13 - 10\)], "Input"],

Cell[TextData[{
  "Das ist eine symbolische Berechnung (der Variablen ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " ist kein Wert zugewiesen). Dabei f\[UDoubleDot]hrt ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " einfache algebraische Vereinfachungen sofort durch."
}], "Text"],

Cell[BoxData[
    \(3  x - 2  x^2 + 7  x\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " stellt eine Vielzahl von algebraischen Umformungsbefehlen zur \
Manipulation von algebraischen Ausdr\[UDoubleDot]cken zur \
Verf\[UDoubleDot]gung (einige davon sind auch \[UDoubleDot]ber die Palette \
AlgebraicManipulation aufrufbar)."
}], "Text"],

Cell[TextData[{
  "Hier ist ein algebraischer Ausdruck, der der Variablen ",
  StyleBox["t",
    FontFamily->"Courier New"],
  " zugewiesen wird:"
}], "Text"],

Cell[BoxData[
    \(t = \(\((x^2 - 9)\) \((2 + x)\)\)\/\(x^2 \((4 - x^2)\)\)\)], "Input"],

Cell[TextData[{
  StyleBox["Expand",
    FontFamily->"Courier New"],
  " (oh welche \[CapitalUDoubleDot]beraschung!) expandiert Produkte und \
positive ganzzahlige Potenzen eines Ausdrucks. "
}], "Text"],

Cell[BoxData[
    \(Expand[t]\)], "Input"],

Cell[TextData[{
  StyleBox["ExpandAll",
    FontFamily->"Courier New"],
  " expandiert alle Produkte und ganzzahligen Potenzen eines Ausdrucks."
}], "Text"],

Cell[BoxData[
    \(ExpandAll[t]\)], "Input"],

Cell[TextData[{
  StyleBox["Together",
    FontFamily->"Courier New"],
  " bringt auf gemeinsamen Nenner und k\[UDoubleDot]rzt.\nWir wenden den \
Befehl auf den letzten Output an."
}], "Text"],

Cell[BoxData[
    \(Together[%]\)], "Input"],

Cell[TextData[{
  StyleBox["Apart",
    FontFamily->"Courier New"],
  " schreibt einen rationalen Ausdruck als Summe von Termen mit minimalen \
Nennern.\nWir wenden den Befehl wieder auf den letzten Output an."
}], "Text"],

Cell[BoxData[
    \(Apart[%]\)], "Input"],

Cell[TextData[{
  StyleBox["Factor",
    FontFamily->"Courier New"],
  " faktorisiert Polynome \[UDoubleDot]ber den ganzen Zahlen.\nUnd noch \
einmal wenden wir den Befehl auf den letzten Output an."
}], "Text"],

Cell[BoxData[
    \(Factor[%]\)], "Input"],

Cell[TextData[{
  StyleBox["Cancel",
    FontFamily->"Courier New"],
  " k\[UDoubleDot]rzt."
}], "Text"],

Cell[BoxData[
    \(Cancel[t]\)], "Input"],

Cell[TextData[{
  StyleBox["Simplify",
    FontFamily->"Courier New"],
  " f\[UDoubleDot]hrt eine Reihe von algebraischen Umformungen durch und gibt \
die (nach ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Geschmack) einfachste Form zur\[UDoubleDot]ck (als Anwender \
k\[ODoubleDot]nnte man da allerdings manchmal anderer Ansicht sein)."
}], "Text"],

Cell[BoxData[
    \(Simplify[t]\)], "Input"],

Cell[TextData[{
  "Wir l\[ODoubleDot]schen ",
  StyleBox["t",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear[t]\)], "Input"],

Cell[TextData[{
  "Manchmal ist der Befehl ",
  StyleBox["Simplify",
    FontFamily->"Courier New"],
  " zu schwach, d.h. kennt zu wenige Umformungsregeln, um einen bestimmten \
Ausdruck zu vereinfachen."
}], "Text"],

Cell[BoxData[
    \(Simplify[\@\(\(2 - x\)\/\(3 + x\)\)\/\@\(2 - x\)]\)], "Input"],

Cell[TextData[{
  "In einem solchen Fall kann man ",
  StyleBox["FullSimplify",
    FontFamily->"Courier New"],
  " probieren. ",
  StyleBox["FullSimplify",
    FontFamily->"Courier New"],
  " kennt mehr Umformungsregeln als ",
  StyleBox["Simplify",
    FontFamily->"Courier New"],
  ". ",
  StyleBox["FullSimplify",
    FontFamily->"Courier New"],
  " liefert daher ein Ergebnis, das mindestens so \"einfach\" ist wie das von \
",
  StyleBox["Simplify",
    FontFamily->"Courier New"],
  ", die Berechnung kann aber l\[ADoubleDot]nger dauern."
}], "Text"],

Cell[BoxData[
    \(FullSimplify[\@\(\(2 - x\)\/\(3 + x\)\)\/\@\(2 - x\)]\)], "Input"],

Cell["\<\
Viele weitere algebraische Umformungsbefehle finden sich im Help Browser \
\[Rule] Built-in Functions \[Rule] Algebraic Computation \[Rule] Formula \
Manipulation.\
\>", "Text"],

Cell[BoxData[GridBox[{
        {
          StyleBox[\(Algebraische\ \(\(Umformungsbefehle\)\(:\)\)\),
            
            FontFamily->
              "Times New Roman"], \(\(\ \ \ \)\(Expand\)\), \(\(\ \ \ \
\)\(Together\)\)},
        {" ", \(\(\ \ \ \)\(ExpandAll\)\), \(\(\ \ \ \)\(Apart\)\)},
        {" ", \(\(\ \ \ \)\(Simplify\)\), \(\(\ \ \ \)\(Factor\)\)},
        {" ", \(\(\ \ \ \)\(Cancel\)\), \(\(\ \ \ \)\(FullSimplify\)\)}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 43, 0, 51, "Subtitle"],
Cell[1822, 55, 246, 7, 52, "Text"],
Cell[2071, 64, 16, 0, 33, "Text"],
Cell[2090, 66, 236, 5, 33, "Text"],
Cell[2329, 73, 60, 0, 33, "Text"],
Cell[2392, 75, 47, 1, 30, "Input"],
Cell[2442, 78, 299, 8, 33, "Text"],
Cell[2744, 88, 53, 1, 30, "Input"],
Cell[2800, 91, 319, 7, 52, "Text"],
Cell[3122, 100, 158, 5, 33, "Text"],
Cell[3283, 107, 89, 1, 44, "Input"],
Cell[3375, 110, 203, 5, 33, "Text"],
Cell[3581, 117, 42, 1, 30, "Input"],
Cell[3626, 120, 156, 4, 33, "Text"],
Cell[3785, 126, 45, 1, 30, "Input"],
Cell[3833, 129, 192, 5, 52, "Text"],
Cell[4028, 136, 44, 1, 30, "Input"],
Cell[4075, 139, 222, 5, 52, "Text"],
Cell[4300, 146, 41, 1, 30, "Input"],
Cell[4344, 149, 211, 5, 52, "Text"],
Cell[4558, 156, 42, 1, 30, "Input"],
Cell[4603, 159, 104, 4, 33, "Text"],
Cell[4710, 165, 42, 1, 30, "Input"],
Cell[4755, 168, 363, 9, 52, "Text"],
Cell[5121, 179, 44, 1, 30, "Input"],
Cell[5168, 182, 111, 5, 33, "Text"],
Cell[5282, 189, 41, 1, 30, "Input"],
Cell[5326, 192, 216, 6, 33, "Text"],
Cell[5545, 200, 82, 1, 73, "Input"],
Cell[5630, 203, 557, 18, 52, "Text"],
Cell[6190, 223, 86, 1, 73, "Input"],
Cell[6279, 226, 187, 4, 33, "Text"],
Cell[6469, 232, 573, 13, 93, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

