(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23758,        690]*)
(*NotebookOutlinePosition[     24484,        715]*)
(*  CellTagsIndexPosition[     24440,        711]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Potenzreihen", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell["", "Text"],

Cell[TextData[{
  "Die Formel f\[UDoubleDot]r die Taylor-Entwicklung einer Funktion  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  an der Stelle ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  " lautet ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x)\), "=", 
          RowBox[{
            UnderoverscriptBox["\[Sum]", \(k = 0\), "\[Infinity]",
              
              LimitsPositioning->True], \(\(\(f\^\((k)\)\)(
                x\_0)\) \((x - x\_0)\)\^k\/\(k!\)\)}]}], TraditionalForm]]],
  ", wobei ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\^\((k)\)\)(x\_0)\)]],
  " die ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-te Ableitung von  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  an der Stelle ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(x\_0\)\(\ \)\)\)]],
  "bezeichnet."
}], "Text"],

Cell[TextData[{
  "Wir k\[ODoubleDot]nnen diese Formel verwenden, um z.B. die \
Taylor-Entwicklung der Cosinus-Funktion um 0 bis zum zehnten Glied zu \
berechnen. ",
  StyleBox["D[Cos[x],{x,k}]/.x\[Rule]0",
    FontFamily->"Courier New"],
  " berechnet im Folgenden die ",
  StyleBox["k",
    FontSlant->"Italic"],
  "-te Ableitung der Cosinus-Funktion an der Stelle 0 und ",
  StyleBox["k",
    FontFamily->"Courier New"],
  " ist der Laufindex des ",
  StyleBox["Sum",
    FontFamily->"Courier New"],
  "-Befehls. Der Output ist das zehnte Taylorpolynom der Cosinus-Funktion an \
der Stelle 0."
}], "Text"],

Cell[BoxData[
    \(Sum[\((D[Cos[x], {x, k}] /. x \[Rule] 0)\)*x\^k\/\(k!\), {k, 0, 
        10}]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " stellt einen Befehl zur Verf\[UDoubleDot]gung, der, wenn die \
Taylor-Formel anwendbar ist, dasselbe Ergebnis mit weniger Aufwand liefert. \
Dieser Befehl hei\[SZ]t ",
  StyleBox["Series",
    FontFamily->"Courier New"],
  " und verlangt zwei Argumente: Als erstes den Funktionsterm der Funktion, \
die in eine Potenzreihe entwickelt werden soll, und als zweites eine Liste, \
die den Namen der Variablen, die Stelle, an der entwickelt werden soll, und \
den Grad, bis zu dem entwickelt werden soll, enth\[ADoubleDot]lt. Der Output \
des Befehls ",
  StyleBox["Series",
    FontFamily->"Courier New"],
  " ist eine Potenzreihe, die in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " durch ein sogenanntes ",
  StyleBox["SeriesData",
    FontFamily->"Courier New"],
  "-Objekt repr\[ADoubleDot]sentiert wird. Ein solches Objekt ist an dem zus\
\[ADoubleDot]tzlichen Term ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          SuperscriptBox[
            RowBox[{
              StyleBox["O",
                FontSlant->"Plain"], "[", 
              StyleBox["x",
                FontSlant->"Plain"], "]"}], 
            RowBox[{
              StyleBox["n",
                FontSlant->"Plain"], "+", "1"}]],
          FontFamily->"Courier New"], TraditionalForm]]],
  " , der die restlichen Terme der Taylor-Entwicklung \
gr\[ODoubleDot]\[SZ]enordnungsm\[ADoubleDot]\[SZ]ig absch\[ADoubleDot]tzt, \
erkennbar."
}], "Text"],

Cell[TextData[{
  "Hier wird noch einmal die Taylor-Entwicklung der Cosinus-Funktion um 0 bis \
zum zehnten Glied exakt berechnet, diesmal mit dem Befehl ",
  StyleBox["Series",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(t = Series[Cos[x], {x, 0, 10}]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Series", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox[
                    SubscriptBox[
                      StyleBox["x",
                        FontSlant->"Italic"], "0"],
                    FontFamily->"Times New Roman"], ",", 
                  StyleBox["n",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{
            StyleBox["   ",
              FontFamily->"Times New Roman"], 
            RowBox[{
              RowBox[{
                StyleBox["erzeugt",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["eine",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Potenzreihenentwicklung",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["der",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Funktion",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["an",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["der",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Stelle",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  SubscriptBox[
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "0"],
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["mit",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["bis",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["zum",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Grad",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["n",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["explizit",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["angegebenen",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Termen",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell["\<\
Mit Potenzreihen kann auch gerechnet werden. Das Ergebnis ist (wenn m\
\[ODoubleDot]glich) bis zum selben Grad exakt.\
\>", "Text"],

Cell[BoxData[
    \(t^2\)], "Input"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["Normal",
    FontFamily->"Courier New"],
  " wandelt eine Potenzreihe in einen normalen Ausdruck um (erkennbar am \
Fehlen des Terms ",
  Cell[BoxData[
      \(O[x]\^\(n + 1\)\)]],
  ")."
}], "Text"],

Cell[BoxData[
    \(Normal[t]\)], "Input"],

Cell["\<\
Wird DIESER Ausdruck quadriert, so erhalten wir ein exaktes Ergebnis.\
\>", "Text"],

Cell[BoxData[
    \(%^2\)], "Input"],

Cell[BoxData[
    \(Clear[t]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Normal", "[", 
            StyleBox["potenzreihe",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["wandelt",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Potenzreihe",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["potenzreihe",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["ein",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["SeriesData",
                        FontFamily->"Courier New"]}], 
                    StyleBox["-",
                      FontFamily->"Times New Roman"], 
                    StyleBox["Objekt",
                      FontFamily->"Times New Roman"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}], 
                StyleBox["in",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["einen",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["normalen",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              StyleBox[\(Ausdruck\ um\),
                FontFamily->"Times New Roman"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell["Hier sind zwei Potenzreihen.", "Text"],

Cell[BoxData[{
    \(s = Series[Exp[x], {x, 0, 7}]\), "\[IndentingNewLine]", 
    \(t = Series[Tan[x], {x, 0, 7}]\)}], "Input"],

Cell["\<\
Um zwei Potenzreihen zusammenzusetzen, kann man entweder die eine direkt in \
die andere einsetzen...\
\>", "Text"],

Cell[BoxData[
    \(s /. x \[Rule] t\)], "Input"],

Cell[TextData[{
  "...oder den eingebauten Befehl ",
  StyleBox["ComposeSeries",
    FontFamily->"Courier New"],
  " verwenden."
}], "Text"],

Cell[BoxData[
    \(ComposeSeries[s, t]\)], "Input"],

Cell[BoxData[
    \(Clear[s, t]\)], "Input"],

Cell["Hier ist die Potenzreihenentwicklung der Sinus-Funktion.", "Text"],

Cell[BoxData[
    \(r = Series[Sin[x], {x, 0, 10}]\)], "Input"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["InverseSeries",
    FontFamily->"Courier New"],
  " gibt die Potenzreihenentwicklung der inversen Funktion, hier also ",
  Cell[BoxData[
      \(TraditionalForm\`sin\^\(-1\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(InverseSeries[r, y]\)], "Input"],

Cell["\<\
Die Zusammensetzung der Potenzreihe einer Funktion und die der inversen \
Funktion gibt die Identit\[ADoubleDot]t (bzw. die Potenzreihenentwicklung der \
Identit\[ADoubleDot]t).\
\>", "Text"],

Cell[BoxData[
    \(% /. y \[Rule] r\)], "Input"],

Cell[TextData[{
  "Mit dem Befehl ",
  StyleBox["SeriesCoefficient",
    FontFamily->"Courier New"],
  " l\[ADoubleDot]sst sich der Koeffizient des Terms vom Grad ",
  StyleBox["n",
    FontSlant->"Italic"],
  " aus der Taylor-Entwicklung herausgreifen."
}], "Text"],

Cell[BoxData[
    \(SeriesCoefficient[r, 7]\)], "Input"],

Cell[BoxData[
    \(Clear[r]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"ComposeSeries", "[", 
            RowBox[{
              StyleBox[
                SubscriptBox["reihe", 
                  StyleBox["1",
                    FontSlant->"Plain"]],
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              StyleBox[
                SubscriptBox["reihe", 
                  StyleBox["2",
                    FontSlant->"Plain"]],
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], "]"}], 
          RowBox[{"   ", 
            StyleBox[
              RowBox[{
              "ersetzt", " ", "die", " ", "Variable", " ", "in", " ", "der", 
                " ", "Potenzreihe", " ", 
                SubscriptBox[
                  StyleBox["reihe",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], "1"], " ", "durch", " ", "die", " ",
                 "Potenzreihe", " ", 
                SubscriptBox[
                  StyleBox["reihe",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], "2"]}],
              FontFamily->"Times New Roman"]}]},
        {
          RowBox[{"InverseSeries", "[", 
            RowBox[{
              StyleBox["reihe",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["liefert",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["die",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Potenzreihenentwicklung",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["(",
                      FontFamily->"Times New Roman"], 
                    RowBox[{
                      StyleBox["in",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["der",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["Variablen",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox[")",
                      FontFamily->"Times New Roman"]}], 
                  StyleBox["der",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Funktion",
                    FontFamily->"Times New Roman"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["invers",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["zu",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["der",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["durch",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Potenzreihe",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["reihe",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["dargestellten",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Funktion",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["ist",
                  FontFamily->"Times New Roman"]}]}]}]},
        {
          RowBox[{"SeriesCoefficient", "[", 
            RowBox[{
              StyleBox["reihe",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              StyleBox["n",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["liefert",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["den",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Koeffizienten",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["des",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Terms",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["vom",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Grad",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["n",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["der",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Taylor",
                  FontFamily->"Times New Roman"]}], 
              StyleBox["-",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["Reihe",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["reihe",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell["\<\
Je h\[ODoubleDot]her der Grad des Taylorpolynoms ist, desto besser \
approximiert es die Funktion.\
\>", "Text"],

Cell[TextData[{
  "Hier ist die Liste der Taylorpolynome vom Grad 2, 6, 10, 14, 18 und 22 der \
Funktion sin(",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  ") an der Stelle 0."
}], "Text"],

Cell[BoxData[
    \(Table[Normal[Series[Sin[x^2], {x, 0, k}]], {k, 2, 22, 4}]\)], "Input"],

Cell["Wir f\[UDoubleDot]gen der Liste auch noch die Funktion selbst hinzu.", \
"Text"],

Cell[BoxData[
    \(Join[%, {Sin[x^2]}]\)], "Input"],

Cell[TextData[{
  "Nun plotten wir die Taylorpolynome und die Funktion sin(",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  "). Je h\[ODoubleDot]her der Grad des Taylorpolynoms, desto dunkler ist der \
Graph. Der ",
  "Graph",
  " von sin(",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  ") ist schwarz."
}], "Text"],

Cell[BoxData[
    \(Plot[Evaluate[%], {x, 0, 3}, 
      PlotStyle \[Rule] 
        Table[{GrayLevel[i]}, {i, 7/8, 0, \(-1\)/8}]]\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 32, 0, 51, "Subtitle"],
Cell[1811, 55, 246, 7, 52, "Text"],
Cell[2060, 64, 16, 0, 33, "Text"],
Cell[2079, 66, 833, 29, 44, "Text"],
Cell[2915, 97, 608, 17, 52, "Text"],
Cell[3526, 116, 110, 2, 45, "Input"],
Cell[3639, 120, 1509, 39, 109, "Text"],
Cell[5151, 161, 227, 6, 33, "Text"],
Cell[5381, 169, 63, 1, 30, "Input"],
Cell[5447, 172, 4579, 114, 67, "Text"],
Cell[10029, 288, 141, 3, 33, "Text"],
Cell[10173, 293, 36, 1, 30, "Input"],
Cell[10212, 296, 244, 9, 33, "Text"],
Cell[10459, 307, 42, 1, 30, "Input"],
Cell[10504, 310, 93, 2, 33, "Text"],
Cell[10600, 314, 36, 1, 30, "Input"],
Cell[10639, 317, 41, 1, 30, "Input"],
Cell[10683, 320, 2447, 60, 67, "Text"],
Cell[13133, 382, 44, 0, 33, "Text"],
Cell[13180, 384, 127, 2, 50, "Input"],
Cell[13310, 388, 125, 3, 33, "Text"],
Cell[13438, 393, 49, 1, 30, "Input"],
Cell[13490, 396, 140, 5, 33, "Text"],
Cell[13633, 403, 52, 1, 30, "Input"],
Cell[13688, 406, 44, 1, 30, "Input"],
Cell[13735, 409, 72, 0, 33, "Text"],
Cell[13810, 411, 63, 1, 30, "Input"],
Cell[13876, 414, 241, 8, 33, "Text"],
Cell[14120, 424, 52, 1, 30, "Input"],
Cell[14175, 427, 201, 4, 33, "Text"],
Cell[14379, 433, 49, 1, 30, "Input"],
Cell[14431, 436, 266, 8, 33, "Text"],
Cell[14700, 446, 56, 1, 30, "Input"],
Cell[14759, 449, 41, 1, 30, "Input"],
Cell[14803, 452, 7900, 195, 103, "Text"],
Cell[22706, 649, 122, 3, 33, "Text"],
Cell[22831, 654, 197, 6, 33, "Text"],
Cell[23031, 662, 90, 1, 30, "Input"],
Cell[23124, 665, 86, 1, 33, "Text"],
Cell[23213, 668, 52, 1, 30, "Input"],
Cell[23268, 671, 330, 11, 33, "Text"],
Cell[23601, 684, 141, 3, 30, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

