(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     75479,       1991]*)
(*NotebookOutlinePosition[     78997,       2100]*)
(*  CellTagsIndexPosition[     78899,       2093]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Plots", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Plots im ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]]
}], "Section",
  CellTags->"plotR2"],

Cell[TextData[{
  "Mit dem Befehl ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  " lassen sich Funktionen von \[DoubleStruckCapitalR] nach \
\[DoubleStruckCapitalR] grafisch darstellen. Dazu m\[UDoubleDot]ssen der \
Funktionsterm, der Name der Variablen und das Intervall, in dem die Kurve \
gezeichnet werden soll, eingegeben werden."
}], "Text",
  CellTags->"plotR2"],

Cell[BoxData[
    \(Plot[Cos[x], {x, \(-3\) Pi, 2  Pi}]\)], "Input",
  CellTags->"plotR2"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Plot", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["xmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["xmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["zeichnet",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["die",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Funktion",
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[
                RowBox[{" ", 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"]}]], 
              StyleBox["im",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["Intervall",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["[",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["xmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Times New Roman"], 
                  StyleBox["xmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"plotR2"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " berechnet Funktionswerte an gleichm\[ADoubleDot]\[SZ]ig \[UDoubleDot]ber \
das Intervall verteilten St\[UDoubleDot]tzstellen und w\[ADoubleDot]hlt \
anschlie\[SZ]end mit einem adaptiven Algorithmus weitere \
St\[UDoubleDot]tzstellen aus, an denen die Funktion evaluiert wird, um die \
Kurve m\[ODoubleDot]glichst \"glatt\" zeichnen zu k\[ODoubleDot]nnen. Da die \
Anzahl aller St\[UDoubleDot]tzstellen trotz allem endlich ist, kann es \
passieren, dass ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  " wichtige Eigenschaften der Funktion \[UDoubleDot]bersieht."
}], "Text",
  CellTags->"plotR2"],

Cell[TextData[{
  "Die an den St\[UDoubleDot]tzstellen evaluierten Funktionswerte werden \
einfach miteinander verbunden. ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  " verbindet die beiden \[CapitalADoubleDot]ste der Hyperbel trotz der \
senkrechten Asymptote an der Stelle 1."
}], "Text",
  CellTags->"plotR2"],

Cell[BoxData[
    \(Plot[1\/\(x - 1\), {x, \(-2\), 4}]\)], "Input",
  CellTags->"plotR2"],

Cell[TextData[{
  "Mit einem ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  "-Befehl k\[ODoubleDot]nnen auch mehrere Funktionen gleichzeitig im \
angegebenen Intervall gezeichnet werden. Die einzelnen Funktionsterme werden \
einfach in Form einer Liste eingegeben."
}], "Text",
  CellTags->"plotR2"],

Cell[BoxData[
    \(Plot[{Cos[t], Cos[2  t], Cos[3  t]}, {t, 0, 2  Pi}]\)], "Input",
  CellTags->"plotR2"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{"Plot", "[", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox[
                        SubscriptBox[
                          StyleBox["f",
                            FontSlant->"Italic"], "1"],
                        FontFamily->"Times New Roman"], 
                      RowBox[{
                        StyleBox["(",
                          FontFamily->"Times New Roman"], 
                        StyleBox["x",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[")",
                          FontFamily->"Times New Roman"]}]}], ",", "...", ",",
                     
                    RowBox[{
                      StyleBox[\(f\_n\),
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      RowBox[{
                        StyleBox["(",
                          FontFamily->"Times New Roman"], 
                        StyleBox["x",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[")",
                          FontFamily->"Times New Roman"]}]}]}], "}"}], ",", 
                RowBox[{"{", 
                  RowBox[{
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], ",", 
                    StyleBox["xmin",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], ",", 
                    StyleBox["xmax",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], "}"}]}], "]"}], " "}], 
          RowBox[{"  ", 
            RowBox[{
              RowBox[{
                StyleBox["zeichnet",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Funktionen",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  SubscriptBox[
                    StyleBox["f",
                      FontSlant->"Italic"], "1"],
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["bis",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(f\_n\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["im",
                  FontFamily->"Times New Roman"]}], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["Intervall",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["[",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["xmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Times New Roman"], 
                  StyleBox["xmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"plotR2"],

Cell[TextData[{
  "Das Verh\[ADoubleDot]ltnis der Skalierungen der Achsen wird von ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " automatisch bestimmt (Goldener Schnitt). Das ist - wie im folgenden \
Beispiel ersichtlich - nicht immer w\[UDoubleDot]nschenswert."
}], "Text",
  CellTags->"plotR2"],

Cell["Der Kreis sieht aus wie eine Ellipse.", "Text",
  CellTags->"plotR2"],

Cell[BoxData[
    \(Plot[{\@\(1 - x\^2\), \(-\@\(1 - x\^2\)\)}, {x, \(-1\), 1}]\)], "Input",\

  CellTags->"plotR2"],

Cell[TextData[{
  "Mit Hilfe von sogenannten Optionen l\[ADoubleDot]sst sich das Aussehen von \
Plots ver\[ADoubleDot]ndern. Die Eingabe von Optionen erfolgt immer nach dem \
Muster \"",
  StyleBox["Option",
    FontSlant->"Italic"],
  "\[Rule]",
  StyleBox["Wert",
    FontSlant->"Italic"],
  "\". Die einzelnen Optionen werden einfach als weitere Argumente in den ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  "-Befehl hineingeschrieben."
}], "Text",
  CellTags->"plotR2"],

Cell[TextData[{
  "Die Option ",
  StyleBox["AspectRatio",
    FontFamily->"Courier New"],
  " setzt das Verh\[ADoubleDot]ltnis der Skalierungen der Achsen fest. Wird  \
",
  StyleBox["AspectRatio",
    FontFamily->"Courier New"],
  " auf den Wert ",
  StyleBox["1",
    FontFamily->"Courier New"],
  " (oder ",
  StyleBox["Automatic",
    FontFamily->"Courier New"],
  ") gesetzt, dann sieht unser Kreis auch wie ein Kreis aus."
}], "Text",
  CellTags->"plotR2"],

Cell[BoxData[
    \(Plot[{\@\(1 - x\^2\), \(-\@\(1 - x\^2\)\)}, {x, \(-1\), 1}, 
      AspectRatio \[Rule] 1]\)], "Input",
  CellTags->"plotR2"],

Cell[TextData[{
  "Beispiele f\[UDoubleDot]r weitere Optionen sind ",
  StyleBox["Frame",
    FontFamily->"Courier New"],
  " (rahmt - auf ",
  StyleBox["True",
    FontFamily->"Courier New"],
  " gesetzt - den Plot ein) und ",
  StyleBox["AxesOrigin",
    FontFamily->"Courier New"],
  " (legt fest, an welcher Stelle die Achsen einander schneiden, und bestimmt \
dadurch, wo die Achsen eingezeichnet werden). Es k\[ODoubleDot]nnen in einem \
",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  "-Befehl auch mehrere Optionen angegeben werden."
}], "Text",
  CellTags->"plotR2"],

Cell[BoxData[
    \(Plot[{\@\(1 - x\^2\), \(-\@\(1 - x\^2\)\)}, {x, \(-1\), 1}, 
      AspectRatio \[Rule] Automatic, Frame \[Rule] True, 
      AxesOrigin \[Rule] {1\/2, 1\/2}]\)], "Input",
  CellTags->"plotR2"],

Cell[TextData[{
  "Mit der Option ",
  StyleBox["PlotStyle",
    FontFamily->"Courier New"],
  " l\[ADoubleDot]sst sich das Aussehen des Graphen ver\[ADoubleDot]ndern. \
Mit ",
  StyleBox["Thickness[",
    FontFamily->"Courier New"],
  StyleBox["wert",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier New"],
  " bestimmt man die Dicke der Linie und ",
  StyleBox["Hue[",
    FontFamily->"Courier New"],
  StyleBox["wert",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier New"],
  " (",
  StyleBox["wert",
    FontSlant->"Italic"],
  " eine Zahl zwischen 0 und 1) setzt die Farbe des ",
  "Graph",
  "en fest."
}], "Text",
  CellTags->"plotR2"],

Cell[BoxData[
    \(Plot[Sin[x], {x, \(-3\) Pi, 3  Pi}, 
      PlotStyle \[Rule] {Thickness[ .03], Hue[ .9]}]\)], "Input",
  CellTags->"plotR2"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Plot", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["f",
                          FontSlant->"Italic"], "1"],
                      FontFamily->"Times New Roman"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], ",", "...", ",", 
                  RowBox[{
                    StyleBox[\(f\_n\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}]}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["xmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["xmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}], ",", "\[IndentingNewLine]",
               
              RowBox[{
                StyleBox[
                  SubscriptBox[
                    StyleBox["Option",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "1"],
                  FontFamily->"Times New Roman"], "\[Rule]", 
                StyleBox[
                  SubscriptBox[
                    StyleBox["Wert",
                      FontSlant->"Italic"], "1"],
                  FontFamily->"Times New Roman"]}], ",", "...", ",", 
              RowBox[{
                StyleBox[\(Option\_m\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "\[Rule]", 
                StyleBox[\(Wert\_m\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["zeichnet",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Funktionen",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  SubscriptBox[
                    StyleBox["f",
                      FontSlant->"Italic"], "1"],
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["bis",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(f\_n\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["im",
                  FontFamily->"Times New Roman"]}], "\[IndentingNewLine]", 
              RowBox[{
                RowBox[{
                  StyleBox["Intervall",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["[",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["xmin",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Times New Roman"], 
                    StyleBox["xmax",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["]",
                    FontFamily->"Times New Roman"]}], " ", 
                StyleBox["mit",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["den",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["mit",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["den",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Optionen",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              StyleBox[\(gesetzten\ Werten\),
                FontFamily->"Times New Roman"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"plotR2"],

Cell[TextData[{
  "Eine Liste aller m\[ODoubleDot]glichen Optionen f\[UDoubleDot]r ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  " findet sich im Help Browser unter dem Stichwort ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  " (mit einem Verweis auf ",
  StyleBox["Graphics",
    FontFamily->"Courier New"],
  ")."
}], "Text",
  CellTags->"plotR2"],

Cell[TextData[{
  "Der Kreis in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " mit Radius ",
  StyleBox["r",
    FontSlant->"Italic"],
  " in Mittelpunktslage wird durch ",
  StyleBox["t",
    FontSlant->"Italic"],
  "\[Rule](",
  StyleBox["r",
    FontSlant->"Italic"],
  " cos(",
  StyleBox["t",
    FontSlant->"Italic"],
  "), ",
  StyleBox["r",
    FontSlant->"Italic"],
  " sin(",
  StyleBox["t",
    FontSlant->"Italic"],
  ")) mit 0 \[LessEqual] ",
  StyleBox["t",
    FontSlant->"Italic"],
  " \[LessEqual] 2\[Pi] parametrisiert. Mit dem Befehl ",
  StyleBox["ParametricPlot",
    FontFamily->"Courier New"],
  " kann er auch in dieser Form gezeichnet werden."
}], "Text",
  CellTags->"plotR2"],

Cell[BoxData[
    \(ParametricPlot[{Cos[t], Sin[t]}, {t, 0, 2  Pi}, 
      AspectRatio \[Rule] 1]\)], "Input",
  CellTags->"plotR2"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"ParametricPlot", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  RowBox[{
                    StyleBox[\(f\_x\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      StyleBox["t",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], ",", 
                  RowBox[{
                    StyleBox[\(f\_y\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      StyleBox["t",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}]}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["tmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["tmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["ist",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["der",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Parameter",
                    FontFamily->"Times New Roman"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  RowBox[{
                    StyleBox["l\[ADoubleDot]uft",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["von",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["tmin",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["bis",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["tmax",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[";",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["die",
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["x",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["-",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["und",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["y",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["-",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(Koordinaten\ der\ Punkte\ der\ Kurve\),
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["werden",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["durch",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Funktionen",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(f\_x\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["und",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(f\_y\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["in",
                      FontFamily->"Times New Roman"], 
                    StyleBox["  ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["t",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              StyleBox["bestimmt",
                FontFamily->"Times New Roman"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"plotR2"],

Cell[TextData[{
  "Alle Optionen von ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  " k\[ODoubleDot]nnen auch in ",
  StyleBox["ParametricPlot",
    FontFamily->"Courier New"],
  " verwendet werden."
}], "Text",
  CellTags->"plotR2"],

Cell[TextData[{
  "Es sind auch mehrere Kurven in einem ",
  StyleBox["ParametricPlot",
    FontFamily->"Courier New"],
  "-Befehl m\[ODoubleDot]glich."
}], "Text",
  CellTags->"plotR2"],

Cell[BoxData[
    \(ParametricPlot[{{Sin[2  t], Cos[5  t]}, {Cos[t], Sin[t]}}, {t, 0, 
        2  Pi}]\)], "Input",
  CellTags->"plotR2"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"ParametricPlot", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{
                      RowBox[{
                        StyleBox[
                          SubscriptBox[
                            StyleBox["f",
                              FontFamily->"Times New Roman",
                              FontSlant->"Italic"], 
                            SubscriptBox["1", 
                              StyleBox["x",
                                FontSlant->"Italic"]]],
                          FontFamily->"Times New Roman"], 
                        RowBox[{
                          StyleBox["(",
                            FontFamily->"Times New Roman"], 
                          StyleBox["t",
                            FontFamily->"Times New Roman",
                            FontSlant->"Italic"], 
                          StyleBox[")",
                            FontFamily->"Times New Roman"]}]}], ",", 
                      RowBox[{
                        StyleBox[
                          SubscriptBox[
                            StyleBox["f",
                              FontSlant->"Italic"], 
                            SubscriptBox["1", 
                              StyleBox["y",
                                FontSlant->"Italic"]]],
                          FontFamily->"Times New Roman"], 
                        RowBox[{
                          StyleBox["(",
                            FontFamily->"Times New Roman"], 
                          StyleBox["t",
                            FontFamily->"Times New Roman",
                            FontSlant->"Italic"], 
                          StyleBox[")",
                            FontFamily->"Times New Roman"]}]}]}], "}"}], ",", 
                  "...", ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                    RowBox[{
                      RowBox[{
                        StyleBox[\(f\_\(n\_x\)\),
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        RowBox[{
                          StyleBox["(",
                            FontFamily->"Times New Roman"], 
                          StyleBox["t",
                            FontFamily->"Times New Roman",
                            FontSlant->"Italic"], 
                          StyleBox[")",
                            FontFamily->"Times New Roman"]}]}], ",", 
                      RowBox[{
                        StyleBox[\(f\_\(n\_y\)\),
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        RowBox[{
                          StyleBox["(",
                            FontFamily->"Times New Roman"], 
                          StyleBox["t",
                            FontFamily->"Times New Roman",
                            FontSlant->"Italic"], 
                          StyleBox[")",
                            FontFamily->"Times New Roman"]}]}]}], "}"}]}], 
                "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["tmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["tmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["ist",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["der",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Parameter",
                    FontFamily->"Times New Roman"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  RowBox[{
                    StyleBox["l\[ADoubleDot]uft",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["von",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["tmin",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["bis",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["tmax",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[";",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["die",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox["-",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["und",
                      FontFamily->"Times New Roman"]}]}]}], 
              "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["y",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["-",
                  FontFamily->"Times New Roman"], 
                
                StyleBox[\(Koordinaten\ der\ Punkte\ der\ einzelnen\ Kurven\ \
werden\ durch\),
                  FontFamily->"Times New Roman"]}], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Funktionen",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  RowBox[{" ", 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"]}]], 
                StyleBox[\(f\_\(i\_x\)\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["und",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(f\_\(i\_y\)\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["in",
                      FontFamily->"Times New Roman"], 
                    StyleBox["  ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["t",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["bestimmt",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"plotR2"],

Cell[TextData[{
  "Der ",
  StyleBox["ListPlot",
    FontFamily->"Courier New"],
  "-Befehl wurde bereits im Abschnitt ",
  ButtonBox["Grafische Darstellung von Folgen und Reihen",
    ButtonData:>{"folgengrenzwerte.nb", "graf"},
    ButtonStyle->"Hyperlink"],
  " des Kapitels ",
  ButtonBox["Grenzwertberechnungen bei Folgen und Reihen",
    ButtonData:>{"folgengrenzwerte.nb", None},
    ButtonStyle->"Hyperlink"],
  " erkl\[ADoubleDot]rt."
}], "Text",
  CellTags->"plotR2"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"ListPlot", "[", 
            RowBox[{"{", 
              RowBox[{
                StyleBox[
                  SubscriptBox[
                    StyleBox["y",
                      FontSlant->"Italic"], "1"],
                  FontFamily->"Times New Roman"], ",", 
                StyleBox[
                  SubscriptBox[
                    StyleBox["y",
                      FontSlant->"Italic"], "2"],
                  FontFamily->"Times New Roman"], ",", "...", ",", 
                StyleBox[\(y\_n\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], "}"}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox[
                RowBox[{"zeichnet", " ", "die", " ", "Punkte", " ", 
                  RowBox[{"(", 
                    RowBox[{"1", ",", " ", 
                      SubscriptBox[
                        StyleBox["y",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], "1"]}], ")"}]}],
                FontFamily->"Times New Roman"], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox[
                RowBox[{"(", 
                  RowBox[{"2", ",", " ", 
                    SubscriptBox[
                      StyleBox["y",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "2"]}], ")"}],
                FontFamily->"Times New Roman"], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox["...",
                FontFamily->"Courier New"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["n",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[\(y\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}]}]}]},
        {
          RowBox[{"ListPlot", "[", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["x",
                          FontSlant->"Italic"], "1"],
                      FontFamily->"Times New Roman"], ",", 
                    StyleBox[
                      SubscriptBox[
                        StyleBox["y",
                          FontSlant->"Italic"], "1"],
                      FontFamily->"Times New Roman"]}], 
                  StyleBox["}",
                    FontFamily->"Times New Roman"]}], ",", "...", ",", 
                RowBox[{"{", 
                  RowBox[{
                    StyleBox[\(x\_n\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], ",", 
                    StyleBox[\(y\_n\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], "}"}]}], "}"}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox[
                RowBox[{"zeichnet", " ", "die", " ", "Punkte", " ", 
                  RowBox[{"(", 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["x",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], "1"], ",", " ", 
                      SubscriptBox[
                        StyleBox["y",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], "1"]}], ")"}]}],
                FontFamily->"Times New Roman"], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox["...",
                FontFamily->"Courier New"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox[\(x\_n\),
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[\(y\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->{"graf", "plotR2"}],

Cell[BoxData[
    \(liste = {1, 0, 3, 4, 2}\)], "Input",
  CellTags->"plotR2"],

Cell[TextData[{
  "Mit der Option ",
  StyleBox["PlotStyle",
    FontFamily->"Courier New"],
  " lassen sich die Gr\[ODoubleDot]\[SZ]e und die Farbe der gezeichneten \
Punkt ver\[ADoubleDot]ndern."
}], "Text",
  CellTags->"plotR2"],

Cell[BoxData[
    \(ListPlot[liste, 
      PlotStyle \[Rule] {PointSize[ .05], Hue[ .7]}]\)], "Input",
  CellTags->"plotR2"],

Cell[TextData[{
  "Mit Hilfe der Option ",
  StyleBox["PlotJoined",
    FontFamily->"Courier New"],
  " lassen sich die Punkte miteinander verbinden."
}], "Text",
  CellTags->"plotR2"],

Cell[BoxData[
    \(ListPlot[liste, PlotJoined \[Rule] True]\)], "Input",
  CellTags->"plotR2"],

Cell[BoxData[
    \(Clear[liste]\)], "Input",
  CellTags->"plotR2"],

Cell[TextData[{
  "Eine Liste aller m\[ODoubleDot]glichen Optionen f\[UDoubleDot]r ",
  StyleBox["ListPlot",
    FontFamily->"Courier New"],
  " findet sich im Help Browser unter dem Stichwort ",
  StyleBox["ListPlot",
    FontFamily->"Courier New"],
  " (mit einem Verweis auf ",
  StyleBox["Graphics",
    FontFamily->"Courier New"],
  ")."
}], "Text",
  CellTags->"plotR2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Plots im ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]]
}], "Section"],

Cell[TextData[{
  "Funktionen von ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " nach \[DoubleStruckCapitalR] zeichnet man mit dem Befehl ",
  StyleBox["Plot3D",
    FontFamily->"Courier New"],
  ". Es m\[UDoubleDot]ssen der Funktionsterm, die Namen der zwei Variablen \
und die Intervalle, in denen gezeichnet werden soll, angegeben werden."
}], "Text"],

Cell[BoxData[
    \(Plot3D[Sin[x]*Sin[y], {x, 0, 4  Pi}, {y, 0, 4  Pi}]\)], "Input"],

Cell[TextData[{
  "Auch f\[UDoubleDot]r ",
  StyleBox["Plot3D",
    FontFamily->"Courier New"],
  " stehen eine Reihe von Optionen zur Verf\[UDoubleDot]gung. ",
  StyleBox["PlotPoints",
    FontFamily->"Courier New"],
  " gibt die Anzahl der St\[UDoubleDot]tzstellen an, an denen die Funktion \
ausgewertet wird, ",
  StyleBox["Mesh",
    FontFamily->"Courier New"],
  " gibt an, ob Gitternetzlinien gezeichnet werden sollen oder nicht."
}], "Text"],

Cell[BoxData[
    \(Plot3D[Sin[x]*Sin[y], {x, 0, 4  Pi}, {y, 0, 4  Pi}, 
      PlotPoints \[Rule] 40, Mesh \[Rule] False]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Plot3D", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Times New Roman"], 
                    StyleBox["y",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["xmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["xmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["y",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["ymin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["ymax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}], ",", "\[IndentingNewLine]",
               
              RowBox[{
                StyleBox[
                  SubscriptBox[
                    StyleBox["Option",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "1"],
                  FontFamily->"Times New Roman"], "\[Rule]", 
                StyleBox[
                  SubscriptBox[
                    StyleBox["Wert",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "1"],
                  FontFamily->"Times New Roman"]}], ",", "...", ",", 
              RowBox[{
                StyleBox[\(Option\_m\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "\[Rule]", 
                StyleBox[\(Wert\_m\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["zeichnet",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Funktion",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["xmin",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["bis",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["xmax",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["und",
                  FontFamily->"Times New Roman"]}], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["ymin",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["bis",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["ymax",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["mit",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["den",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["mit",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["den",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Optionen",
                  FontFamily->"Times New Roman"]}], "\[IndentingNewLine]", 
              StyleBox[\(gesetzten\ Werten\),
                FontFamily->"Times New Roman"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  "F\[UDoubleDot]r eine Liste aller m\[ODoubleDot]glichen Optionen f\
\[UDoubleDot]r ",
  StyleBox["Plot3D",
    FontFamily->"Courier New"],
  " siehe im Help Browser unter dem Stichwort ",
  StyleBox["Plot3D",
    FontFamily->"Courier New"],
  " (mit Verweisen auf ",
  StyleBox["SurfaceGraphics",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["Graphics3D",
    FontFamily->"Courier New"],
  ")."
}], "Text"],

Cell[TextData[{
  "Kurven im Raum k\[ODoubleDot]nnen mit ",
  StyleBox["ParametricPlot3D",
    FontFamily->"Courier New"],
  " gezeichnet werden."
}], "Text"],

Cell[BoxData[
    \(ParametricPlot3D[{2  Sin[t], 3  Cos[t], t/15}, {t, 0, 20}]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"ParametricPlot3D", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  RowBox[{
                    StyleBox[\(f\_x\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      StyleBox["t",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], ",", 
                  RowBox[{
                    StyleBox[\(f\_y\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      StyleBox["t",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], ",", 
                  RowBox[{
                    StyleBox[\(f\_z\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      StyleBox["t",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["tmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["tmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["ist",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["der",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Parameter",
                    FontFamily->"Times New Roman"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  RowBox[{
                    StyleBox["l\[ADoubleDot]uft",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["von",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["tmin",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["bis",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["tmax",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[";",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["die",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox["-",
                      FontFamily->"Times New Roman"]}]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
                RowBox[{
                  StyleBox["y",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["-",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["und",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["z",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["-",
                    FontFamily->"Times New Roman"], 
                  
                  StyleBox[\(Koordinaten\ der\ Punkte\ \ werden\ durch\ die\),
                    
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                RowBox[{
                  StyleBox["Funktionen",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[\(f\_x\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[" ",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox[\(f\_y\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["und",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[\(f\_z\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["(",
                      FontFamily->"Times New Roman"], 
                    RowBox[{
                      StyleBox["in",
                        FontFamily->"Times New Roman"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["t",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox[")",
                      FontFamily->"Times New Roman"]}], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["bestimmt",
                    FontFamily->"Times New Roman"]}]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  "Auch Fl\[ADoubleDot]chen in Parameterdarstellung k\[ODoubleDot]nnen mit ",
  StyleBox["ParametricPlot3D",
    FontFamily->"Courier New"],
  " gezeichnet werden. Hier ein zweidimensionaler Torus:"
}], "Text"],

Cell[BoxData[
    \(ParametricPlot3D[{Cos[s] \((3 + Cos[t])\), Sin[s] \((3 + Cos[t])\), 
        Sin[t]}, {s, 0, 2  Pi}, {t, 0, 2  Pi}]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"ParametricPlot3D", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  RowBox[{
                    StyleBox[\(f\_x\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      RowBox[{
                        StyleBox["s",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Times New Roman"], 
                        StyleBox["t",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], ",", 
                  RowBox[{
                    StyleBox[\(f\_y\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      RowBox[{
                        StyleBox["s",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Times New Roman"], 
                        StyleBox["t",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], ",", 
                  RowBox[{
                    StyleBox[\(f\_z\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      RowBox[{
                        StyleBox["s",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Times New Roman"], 
                        StyleBox["t",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["s",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["smin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["smax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["tmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["tmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"  ", 
            RowBox[{
              RowBox[{
                StyleBox["s",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["ist",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["der",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["erste",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Parameter",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["und",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["l\[ADoubleDot]uft",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["smin",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["bis",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["smax",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["ist",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["der",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["zweite",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Parameter",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["und",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["l\[ADoubleDot]uft",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["von",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["tmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["bis",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["tmax",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[";",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["die",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox["-",
                      FontFamily->"Times New Roman"]}]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["y",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["-",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["und",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["z",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["-",
                    FontFamily->"Times New Roman"], 
                  StyleBox[\(Koordinaten\ der\ Punkte\),
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["\[IndentingNewLine]",
                FontFamily->"Times New Roman"], 
              RowBox[{
                RowBox[{
                  StyleBox["der",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Fl\[ADoubleDot]che",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["werden",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["durch",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["die",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Funktionen",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[\(f\_x\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[" ",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(f\_y\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["und",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(f\_z\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["in",
                      FontFamily->"Times New Roman"], 
                    StyleBox["  ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["s",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox["  ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["und",
                      FontFamily->"Times New Roman"], 
                    StyleBox["  ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["t",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["bestimmt",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  "Wie schon bei",
  StyleBox[" ", "Input"],
  StyleBox["ParametricPlot",
    FontFamily->"Courier New"],
  " k\[ODoubleDot]nnen auch mit ",
  StyleBox["ParametricPlot3D",
    FontFamily->"Courier New"],
  " mehrere Objekte gleichzeitig gezeichnet werden. Hier ein Plot mit zwei Fl\
\[ADoubleDot]chen:"
}], "Text"],

Cell[BoxData[
    \(ParametricPlot3D[{{Cos[s] \((5 + Cos[t])\), Sin[s] \((5 + Cos[t])\), 
          Sin[t]}, {s*Cos[t], s*Sin[t], \(-s\) + Pi}}, {s, 0, 2  Pi}, {t, 0, 
        2  Pi}]\)], "Input"],

Cell[TextData[{
  "Eine Liste der m\[ODoubleDot]glichen Optionen f\[UDoubleDot]r ",
  StyleBox["ParametricPlot3D",
    FontFamily->"Courier New"],
  " findet sich im Help Browser unter dem Stichwort ",
  StyleBox["ParametricPlot3D",
    FontFamily->"Courier New"],
  " (mit einem Verweis auf ",
  StyleBox["Graphics3D",
    FontFamily->"Courier New"],
  ")."
}], "Text"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "plotR2"->{
    Cell[2075, 66, 139, 5, 73, "Section",
      CellTags->"plotR2"],
    Cell[2217, 73, 378, 9, 52, "Text",
      CellTags->"plotR2"],
    Cell[2598, 84, 90, 2, 30, "Input",
      CellTags->"plotR2"],
    Cell[2691, 88, 2846, 74, 48, "Text",
      CellTags->"plotR2"],
    Cell[5540, 164, 676, 14, 71, "Text",
      CellTags->"plotR2"],
    Cell[6219, 180, 323, 8, 33, "Text",
      CellTags->"plotR2"],
    Cell[6545, 190, 89, 2, 42, "Input",
      CellTags->"plotR2"],
    Cell[6637, 194, 308, 8, 33, "Text",
      CellTags->"plotR2"],
    Cell[6948, 204, 106, 2, 30, "Input",
      CellTags->"plotR2"],
    Cell[7057, 208, 4095, 100, 67, "Text",
      CellTags->"plotR2"],
    Cell[11155, 310, 308, 7, 33, "Text",
      CellTags->"plotR2"],
    Cell[11466, 319, 75, 1, 33, "Text",
      CellTags->"plotR2"],
    Cell[11544, 322, 116, 3, 34, "Input",
      CellTags->"plotR2"],
    Cell[11663, 327, 484, 14, 52, "Text",
      CellTags->"plotR2"],
    Cell[12150, 343, 463, 16, 33, "Text",
      CellTags->"plotR2"],
    Cell[12616, 361, 144, 3, 34, "Input",
      CellTags->"plotR2"],
    Cell[12763, 366, 583, 17, 52, "Text",
      CellTags->"plotR2"],
    Cell[13349, 385, 212, 4, 42, "Input",
      CellTags->"plotR2"],
    Cell[13564, 391, 750, 28, 52, "Text",
      CellTags->"plotR2"],
    Cell[14317, 421, 144, 3, 30, "Input",
      CellTags->"plotR2"],
    Cell[14464, 426, 5809, 141, 85, "Text",
      CellTags->"plotR2"],
    Cell[20276, 569, 368, 12, 33, "Text",
      CellTags->"plotR2"],
    Cell[20647, 583, 735, 30, 33, "Text",
      CellTags->"plotR2"],
    Cell[21385, 615, 132, 3, 30, "Input",
      CellTags->"plotR2"],
    Cell[21520, 620, 7081, 170, 105, "Text",
      CellTags->"plotR2"],
    Cell[28604, 792, 242, 9, 33, "Text",
      CellTags->"plotR2"],
    Cell[28849, 803, 186, 6, 33, "Text",
      CellTags->"plotR2"],
    Cell[29038, 811, 137, 3, 30, "Input",
      CellTags->"plotR2"],
    Cell[29178, 816, 8783, 205, 89, "Text",
      CellTags->"plotR2"],
    Cell[37964, 1023, 477, 14, 33, "Text",
      CellTags->"plotR2"],
    Cell[38444, 1039, 5478, 137, 65, "Text",
      CellTags->{"graf", "plotR2"}],
    Cell[43925, 1178, 78, 2, 30, "Input",
      CellTags->"plotR2"],
    Cell[44006, 1182, 231, 7, 33, "Text",
      CellTags->"plotR2"],
    Cell[44240, 1191, 124, 3, 30, "Input",
      CellTags->"plotR2"],
    Cell[44367, 1196, 184, 6, 33, "Text",
      CellTags->"plotR2"],
    Cell[44554, 1204, 95, 2, 30, "Input",
      CellTags->"plotR2"],
    Cell[44652, 1208, 67, 2, 30, "Input",
      CellTags->"plotR2"],
    Cell[44722, 1212, 376, 12, 33, "Text",
      CellTags->"plotR2"]},
  "graf"->{
    Cell[38444, 1039, 5478, 137, 65, "Text",
      CellTags->{"graf", "plotR2"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"plotR2", 76152, 2009},
  {"graf", 78791, 2086}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 25, 0, 51, "Subtitle"],
Cell[1804, 55, 246, 7, 52, "Text"],

Cell[CellGroupData[{
Cell[2075, 66, 139, 5, 73, "Section",
  CellTags->"plotR2"],
Cell[2217, 73, 378, 9, 52, "Text",
  CellTags->"plotR2"],
Cell[2598, 84, 90, 2, 30, "Input",
  CellTags->"plotR2"],
Cell[2691, 88, 2846, 74, 48, "Text",
  CellTags->"plotR2"],
Cell[5540, 164, 676, 14, 71, "Text",
  CellTags->"plotR2"],
Cell[6219, 180, 323, 8, 33, "Text",
  CellTags->"plotR2"],
Cell[6545, 190, 89, 2, 42, "Input",
  CellTags->"plotR2"],
Cell[6637, 194, 308, 8, 33, "Text",
  CellTags->"plotR2"],
Cell[6948, 204, 106, 2, 30, "Input",
  CellTags->"plotR2"],
Cell[7057, 208, 4095, 100, 67, "Text",
  CellTags->"plotR2"],
Cell[11155, 310, 308, 7, 33, "Text",
  CellTags->"plotR2"],
Cell[11466, 319, 75, 1, 33, "Text",
  CellTags->"plotR2"],
Cell[11544, 322, 116, 3, 34, "Input",
  CellTags->"plotR2"],
Cell[11663, 327, 484, 14, 52, "Text",
  CellTags->"plotR2"],
Cell[12150, 343, 463, 16, 33, "Text",
  CellTags->"plotR2"],
Cell[12616, 361, 144, 3, 34, "Input",
  CellTags->"plotR2"],
Cell[12763, 366, 583, 17, 52, "Text",
  CellTags->"plotR2"],
Cell[13349, 385, 212, 4, 42, "Input",
  CellTags->"plotR2"],
Cell[13564, 391, 750, 28, 52, "Text",
  CellTags->"plotR2"],
Cell[14317, 421, 144, 3, 30, "Input",
  CellTags->"plotR2"],
Cell[14464, 426, 5809, 141, 85, "Text",
  CellTags->"plotR2"],
Cell[20276, 569, 368, 12, 33, "Text",
  CellTags->"plotR2"],
Cell[20647, 583, 735, 30, 33, "Text",
  CellTags->"plotR2"],
Cell[21385, 615, 132, 3, 30, "Input",
  CellTags->"plotR2"],
Cell[21520, 620, 7081, 170, 105, "Text",
  CellTags->"plotR2"],
Cell[28604, 792, 242, 9, 33, "Text",
  CellTags->"plotR2"],
Cell[28849, 803, 186, 6, 33, "Text",
  CellTags->"plotR2"],
Cell[29038, 811, 137, 3, 30, "Input",
  CellTags->"plotR2"],
Cell[29178, 816, 8783, 205, 89, "Text",
  CellTags->"plotR2"],
Cell[37964, 1023, 477, 14, 33, "Text",
  CellTags->"plotR2"],
Cell[38444, 1039, 5478, 137, 65, "Text",
  CellTags->{"graf", "plotR2"}],
Cell[43925, 1178, 78, 2, 30, "Input",
  CellTags->"plotR2"],
Cell[44006, 1182, 231, 7, 33, "Text",
  CellTags->"plotR2"],
Cell[44240, 1191, 124, 3, 30, "Input",
  CellTags->"plotR2"],
Cell[44367, 1196, 184, 6, 33, "Text",
  CellTags->"plotR2"],
Cell[44554, 1204, 95, 2, 30, "Input",
  CellTags->"plotR2"],
Cell[44652, 1208, 67, 2, 30, "Input",
  CellTags->"plotR2"],
Cell[44722, 1212, 376, 12, 33, "Text",
  CellTags->"plotR2"]
}, Closed]],

Cell[CellGroupData[{
Cell[45135, 1229, 117, 4, 43, "Section"],
Cell[45255, 1235, 387, 9, 33, "Text"],
Cell[45645, 1246, 84, 1, 30, "Input"],
Cell[45732, 1249, 449, 12, 52, "Text"],
Cell[46184, 1263, 134, 2, 30, "Input"],
Cell[46321, 1267, 6009, 147, 85, "Text"],
Cell[52333, 1416, 433, 15, 33, "Text"],
Cell[52769, 1433, 158, 5, 33, "Text"],
Cell[52930, 1440, 91, 1, 30, "Input"],
Cell[53024, 1443, 8129, 193, 87, "Text"],
Cell[61156, 1638, 226, 5, 33, "Text"],
Cell[61385, 1645, 148, 2, 30, "Input"],
Cell[61536, 1649, 13010, 308, 125, "Text"],
Cell[74549, 1959, 330, 10, 34, "Text"],
Cell[74882, 1971, 196, 3, 50, "Input"],
Cell[75081, 1976, 370, 11, 33, "Text"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

