(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     58818,       1646]*)
(*NotebookOutlinePosition[     63208,       1777]*)
(*  CellTagsIndexPosition[     63133,       1771]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Vektoren und Matrizen", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell[CellGroupData[{

Cell["Vektoren", "Section"],

Cell[TextData[{
  "Ein Vektor wird in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ganz einfach als Liste dargestellt."
}], "Text"],

Cell["Hier sind zwei dreidimensionale Vektoren.", "Text"],

Cell[BoxData[{
    \(a = {a1, a2, a3}\), "\[IndentingNewLine]", 
    \(b = {b1, b2, b3}\)}], "Input"],

Cell[TextData[{
  "Die Addition ",
  StyleBox["+",
    FontFamily->"Courier New"],
  " zweier (gleich langer) Listen erfolgt komponentenweise, entspricht also \
der Vektoraddition."
}], "Text"],

Cell[BoxData[
    \(a + b\)], "Input"],

Cell[TextData[{
  "Die Multiplikation ",
  StyleBox["*",
    FontFamily->"Courier New"],
  " einer Zahl mit einer Liste wird ausgef\[UDoubleDot]hrt, indem die Zahl \
mit jedem Element der Liste multipliziert wird. Dies entspricht der \
Multiplikation eines Skalars mit einem Vektor."
}], "Text"],

Cell[TextData[{
  "Wir multiplizieren den Vektor ",
  StyleBox["a={a1,a2,a3}",
    FontFamily->"Courier New"],
  " mit einem Skalar ",
  StyleBox["t",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(t*a\)], "Input"],

Cell[TextData[{
  "Das Standardskalarprodukt zweier Vektoren berechnet man mit dem Operator \
\"",
  StyleBox[".",
    FontFamily->"Courier New"],
  "\"."
}], "Text"],

Cell[BoxData[
    \(a . b\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{
              StyleBox["{",
                FontFamily->"Courier New"], 
              RowBox[{
                StyleBox[
                  SubscriptBox["a", 
                    StyleBox["1",
                      FontSlant->"Plain"]],
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                StyleBox[\(a\_n\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["}",
                FontFamily->"Courier New"]}], ".", 
            RowBox[{
              StyleBox["{",
                FontFamily->"Courier New",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox[
                  SubscriptBox["b", 
                    StyleBox["1",
                      FontSlant->"Plain"]],
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                StyleBox["...",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                StyleBox[\(b\_n\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["}",
                FontFamily->"Courier New",
                FontSlant->"Italic"]}]}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox[\(Standardskalarproduk  t\),
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["der",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(Ve  ktoren\),
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["a", 
                        StyleBox["1",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox[\(a\_n\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["und",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["{",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox[
                    SubscriptBox["b", 
                      StyleBox["1",
                        FontSlant->"Plain"]],
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox["...",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox[\(b\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[BoxData[
    \(Clear[a, b]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Matrizen", "Section",
  CellTags->"matrizen"],

Cell[TextData[{
  "Eine Matrix ist in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nichts anderes als eine geschachtelte Liste."
}], "Text",
  CellTags->"matrizen"],

Cell["Hier ist eine 3\[Times]2-Matrix.", "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(a = {{1, 2}, {3, 4}, {5, 6}}\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  "Um die Matrix in der uns gewohnten Form anzuzeigen verwendet man den \
Befehl ",
  StyleBox["MatrixForm",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(MatrixForm[a]\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  StyleBox["ACHTUNG",
    FontWeight->"Bold"],
  ": Wie auch schon beim Befehl ",
  StyleBox["TableForm",
    FontFamily->"Courier New"],
  " (siehe im Abschnitt ",
  ButtonBox["Wertetabellen",
    ButtonData:>{"funktionen.nb", "wertetabellen"},
    ButtonStyle->"Hyperlink"],
  " im Kapitel ",
  ButtonBox["Funktionen",
    ButtonData:>{"funktionen.nb", None},
    ButtonStyle->"Hyperlink"],
  ") kann ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " mit der Ausgabe von ",
  StyleBox["MatrixForm",
    FontFamily->"Courier New"],
  " nicht mehr weiterrechnen. ",
  StyleBox["MatrixForm",
    FontFamily->"Courier New"],
  " liefert nur eine grafische Darstellung der geschachtelten Liste als \
Matrix, keinen f\[UDoubleDot]r ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " weiter verwendbaren Output."
}], "Text",
  CellTags->"matrizen"],

Cell[TextData[{
  "Mit der bereits bekannten Listenoperation ",
  StyleBox["Part",
    FontFamily->"Courier New"],
  " bzw. ihrer Kurzform ",
  StyleBox["[[",
    FontFamily->"Courier New"],
  StyleBox["...",
    FontFamily->"Times New Roman"],
  StyleBox["]]",
    FontFamily->"Courier New"],
  " lassen sich einzelne Eintr\[ADoubleDot]ge, Zeilen oder Spalten aus einer \
Matrix herausgreifen (siehe den Abschnitt ",
  ButtonBox["Wertetabellen",
    ButtonData:>{"funktionen.nb", "wertetabellen"},
    ButtonStyle->"Hyperlink"],
  " im Kapitel ",
  ButtonBox["Funktionen",
    ButtonData:>{"funktionen.nb", None},
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text",
  CellTags->"matrizen"],

Cell[TextData[{
  "Mit ",
  StyleBox["a[[2,1]]",
    FontFamily->"Courier New"],
  " erh\[ADoubleDot]lt man den Eintrag ",
  Cell[BoxData[
      \(TraditionalForm\`a\_21\)]],
  " der oben definierten Matrix ",
  StyleBox["a",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(a[\([2, 1]\)]\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  StyleBox["a[[3]]",
    FontFamily->"Courier New"],
  " liefert die dritte Zeile der Matrix ",
  StyleBox["a",
    FontFamily->"Courier New"],
  " in Form einer Liste."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(a[\([3]\)]\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  "Mit ",
  StyleBox["a[[All,2]]",
    FontFamily->"Courier New"],
  " erh\[ADoubleDot]lt man die zweite Spalte von ",
  StyleBox["a",
    FontFamily->"Courier New"],
  ", wieder in Form einer Liste."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(a[\([All, 2]\)]\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["Transpose",
    FontFamily->"Courier New"],
  " vertauscht die Zeilen und Spalten einer Matrix."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(Transpose[a]\ \ \  // MatrixForm\)], "Input",
  CellTags->"matrizen"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Transpose", "[", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["a", 
                        StyleBox["11",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox[
                      SubscriptBox["a", 
                        RowBox[{
                          StyleBox["1",
                            FontSlant->"Plain"], "n"}]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}], 
                StyleBox[",",
                  FontFamily->"Courier New"], "\[IndentingNewLine]", 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["a", 
                        StyleBox[
                          RowBox[{
                            StyleBox["m",
                              FontSlant->"Italic"], 
                            StyleBox["1",
                              FontSlant->"Plain"]}]]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox[\(a\_mn\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}]}], 
              StyleBox["}",
                FontFamily->"Courier New"]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox[\(liefert\ die\ Transponierte\ von\ der\ Matrix\),
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["{",
                        FontFamily->"Courier New"], 
                      RowBox[{
                        StyleBox[
                          SubscriptBox["a", 
                            StyleBox["11",
                              FontSlant->"Plain"]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox["...",
                          FontFamily->"Courier New"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox[
                          SubscriptBox["a", 
                            RowBox[{
                              StyleBox["1",
                                FontSlant->"Plain"], "n"}]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}], 
                      StyleBox["}",
                        FontFamily->"Courier New"]}], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    RowBox[{
                      StyleBox["{",
                        FontFamily->"Courier New"], 
                      RowBox[{
                        StyleBox[
                          SubscriptBox["a", 
                            StyleBox[
                              RowBox[{
                                StyleBox["m",
                                  FontSlant->"Italic"], 
                                StyleBox["1",
                                  FontSlant->"Plain"]}]]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox["...",
                          FontFamily->"Courier New"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox[\(a\_mn\),
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}], 
                      StyleBox["}",
                        FontFamily->"Courier New"]}]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["\[IndentingNewLine]",
                  FontFamily->"Times New Roman"], 
                
                StyleBox[\(d . h . \ 
                      Zeilen\ und\ Spalten\ werden\ vertauscht\),
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"matrizen"],

Cell[TextData[{
  "Wie schon bei den Vektoren erfolgt die komponentenweise Addition zweier \
Matrizen (von selber Dimension) bzw. die komponenetnweise Multiplikation \
einer Matrix mit einem Skalar mit den Operatoren ",
  StyleBox["+",
    FontFamily->"Courier New"],
  " bzw. ",
  StyleBox["*",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(a + {{5, 2}, {8, 7}, {0, 1}}\ \ \  // MatrixForm\)], "Input",
  CellTags->"matrizen"],

Cell[BoxData[
    \(t*a\ \ \  // MatrixForm\)], "Input",
  CellTags->"matrizen"],

Cell[BoxData[
    \(Clear[a]\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  "Hier ist eine neue Matrix. (Die runden Klammern bewirken, dass ",
  StyleBox["m",
    FontFamily->"Courier New"],
  " zuerst die geschachtelte Liste zugewiesen und erst dann der Befehl ",
  StyleBox["MatrixForm",
    FontFamily->"Courier New"],
  " ausgef\[UDoubleDot]hrt wird.)"
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(\((m = {{1, 2}, {3, 4}})\)\ \ \  // MatrixForm\)], "Input",
  CellTags->"matrizen"],

Cell["Und hier ist ein Vektor.", "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(v = {1, 2}\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  "Die Multiplikation einer Matrix mit einem Vektor erfolgt wieder mit \"",
  StyleBox[".",
    FontFamily->"Courier New"],
  "\". Dabei wird der Vektor von ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " je nach Bedarf als Spalten- oder als Zeilenvektor aufgefasst."
}], "Text",
  CellTags->"matrizen"],

Cell[TextData[{
  "Hier wird ",
  StyleBox["v",
    FontFamily->"Courier New"],
  " als Spaltenvektor aufgefasst."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(m . v\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  "Und hier wird mit demselben Vektor ",
  StyleBox["v",
    FontFamily->"Courier New"],
  " als Zeilenvektor gerechnet."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(v . m\)], "Input",
  CellTags->"matrizen"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["a", 
                        StyleBox["11",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox[
                      SubscriptBox["a", 
                        RowBox[{
                          StyleBox["1",
                            FontSlant->"Plain"], "n"}]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["a", 
                        StyleBox[
                          RowBox[{
                            StyleBox["m",
                              FontSlant->"Italic"], 
                            StyleBox["1",
                              FontSlant->"Plain"]}]]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox[\(a\_mn\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}]}], 
              StyleBox["}",
                FontFamily->"Courier New"]}], ".", "\[IndentingNewLine]", 
            RowBox[{
              StyleBox["{",
                FontFamily->"Courier New",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox[
                  SubscriptBox["v", 
                    StyleBox["1",
                      FontSlant->"Plain"]],
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                StyleBox["...",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                StyleBox[\(v\_n\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["}",
                FontFamily->"Courier New",
                FontSlant->"Italic"]}]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox[\(Produkt\ der\ Matrix\),
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["{",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  RowBox[{
                    StyleBox["{",
                      FontFamily->"Courier New"], 
                    StyleBox[
                      RowBox[{
                        StyleBox[
                          SubscriptBox["a", 
                            StyleBox["11",
                              FontSlant->"Plain"]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox["...",
                          FontFamily->"Courier New"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox[
                          SubscriptBox["a", 
                            RowBox[{
                              StyleBox["1",
                                FontSlant->"Plain"], "n"}]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}],
                      FontFamily->"Times New Roman"], 
                    StyleBox["}",
                      FontFamily->"Courier New"]}], 
                  StyleBox[",",
                    FontFamily->"Courier New"], 
                  StyleBox["...",
                    FontFamily->"Courier New"], 
                  StyleBox[",",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox["{",
                      FontFamily->"Courier New"], 
                    StyleBox[
                      RowBox[{
                        StyleBox[
                          SubscriptBox["a", 
                            StyleBox[
                              RowBox[{
                                StyleBox["m",
                                  FontSlant->"Italic"], 
                                StyleBox["1",
                                  FontSlant->"Plain"]}]]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox["...",
                          FontFamily->"Courier New"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox[\(a\_mn\),
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}],
                      FontFamily->"Times New Roman"], 
                    StyleBox["}",
                      FontFamily->"Courier New"]}]}], 
                StyleBox["}",
                  FontFamily->"Courier New"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["und",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["dem",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Vektor",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["v", 
                        StyleBox["1",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[\(v\_n\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"]}]}]}]}]},
        {
          RowBox[{
            RowBox[{
              StyleBox["{",
                FontFamily->"Courier New",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox[
                  SubscriptBox["v", 
                    StyleBox["1",
                      FontSlant->"Plain"]],
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                StyleBox["...",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                StyleBox[\(v\_n\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["}",
                FontFamily->"Courier New",
                FontSlant->"Italic"]}], ".", "\[IndentingNewLine]", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["a", 
                        StyleBox["11",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox[
                      SubscriptBox["a", 
                        RowBox[{
                          StyleBox["1",
                            FontSlant->"Plain"], "m"}]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["a", 
                        StyleBox[
                          RowBox[{
                            StyleBox["n",
                              FontSlant->"Italic"], 
                            StyleBox["1",
                              FontSlant->"Plain"]}]]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox[\(a\_nm\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}]}], 
              StyleBox["}",
                FontFamily->"Courier New"]}]}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["Produkt",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["des",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Vektors",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["v", 
                        StyleBox["1",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[\(v\_n\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"]}], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["und",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["der",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Matrix",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["{",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  RowBox[{
                    StyleBox["{",
                      FontFamily->"Courier New"], 
                    StyleBox[
                      RowBox[{
                        StyleBox[
                          SubscriptBox["a", 
                            StyleBox["11",
                              FontSlant->"Plain"]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox["...",
                          FontFamily->"Courier New"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox[
                          SubscriptBox["a", 
                            RowBox[{
                              StyleBox["1",
                                FontSlant->"Plain"], "m"}]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}],
                      FontFamily->"Times New Roman"], 
                    StyleBox["}",
                      FontFamily->"Courier New"]}], 
                  StyleBox[",",
                    FontFamily->"Courier New"], 
                  StyleBox["...",
                    FontFamily->"Courier New"], 
                  StyleBox[",",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox["{",
                      FontFamily->"Courier New"], 
                    RowBox[{
                      StyleBox[
                        SubscriptBox["a", 
                          StyleBox[
                            RowBox[{
                              StyleBox["n",
                                FontSlant->"Italic"], 
                              StyleBox["1",
                                FontSlant->"Plain"]}]]],
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[",",
                        FontFamily->"Courier New"], 
                      StyleBox["...",
                        FontFamily->"Courier New"], 
                      StyleBox[",",
                        FontFamily->"Courier New"], 
                      StyleBox[\(a\_nm\),
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox["}",
                      FontFamily->"Courier New"]}]}], 
                StyleBox["}",
                  FontFamily->"Courier New"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"matrizen"],

Cell[TextData[{
  "Mit \"",
  StyleBox[".",
    FontFamily->"Courier New"],
  "\" multipliziert man auch zwei Matrizen miteinander. Dabei muss darauf \
geachtet werden, dass die Dimensionen der Matrizen auch zusammenpassen."
}], "Text",
  CellTags->"matrizen"],

Cell["Hier ist eine zweite Matrix.", "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(\((n = {{1, 2}, {3, 4}, {5, 6}})\)\ \ \  // MatrixForm\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  "Das Matrixprodukt ",
  StyleBox["n.m",
    FontFamily->"Courier New"],
  " existiert."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(n . m\ \  // MatrixForm\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  "Versucht man ",
  StyleBox["m.n",
    FontFamily->"Courier New"],
  " auszurechnen erh\[ADoubleDot]lt man eine Fehlermeldung: Die Dimensionen \
der beiden Matrizen (in dieser Reihenfolge) passen nicht."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(m . n\)], "Input",
  CellTags->"matrizen"],

Cell[BoxData[
    \(Clear[v, m, n]\)], "Input",
  CellTags->"matrizen"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["a", 
                        StyleBox["11",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox[
                      SubscriptBox["a", 
                        RowBox[{
                          StyleBox["1",
                            FontSlant->"Plain"], "n"}]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["a", 
                        StyleBox[
                          RowBox[{
                            StyleBox["m",
                              FontSlant->"Italic"], 
                            StyleBox["1",
                              FontSlant->"Plain"]}]]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox[\(a\_mn\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}]}], 
              StyleBox["}",
                FontFamily->"Courier New"]}], 
            StyleBox[".",
              FontFamily->"Courier New"], "\[IndentingNewLine]", "  ", 
            RowBox[{
              StyleBox["{",
                FontFamily->"Times New Roman"], 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["b",
                          FontFamily->"Times New Roman"], 
                        StyleBox["11",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox[
                      SubscriptBox["b", 
                        RowBox[{
                          StyleBox["1",
                            FontSlant->"Plain"], "k"}]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["b", 
                        StyleBox[
                          RowBox[{
                            StyleBox["n",
                              FontSlant->"Italic"], 
                            StyleBox["1",
                              FontSlant->"Plain"]}]]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox[\(b\_nk\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}]}], 
              StyleBox["}",
                FontFamily->"Courier New"]}]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox[\(Produkt\ der\ Matrix\),
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["{",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  RowBox[{
                    StyleBox["{",
                      FontFamily->"Courier New"], 
                    StyleBox[
                      RowBox[{
                        StyleBox[
                          SubscriptBox["a", 
                            StyleBox["11",
                              FontSlant->"Plain"]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox["...",
                          FontFamily->"Courier New"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox[
                          SubscriptBox["a", 
                            RowBox[{
                              StyleBox["1",
                                FontSlant->"Plain"], "n"}]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}],
                      FontFamily->"Times New Roman"], 
                    StyleBox["}",
                      FontFamily->"Courier New"]}], 
                  StyleBox[",",
                    FontFamily->"Courier New"], 
                  StyleBox["...",
                    FontFamily->"Courier New"], 
                  StyleBox[",",
                    FontFamily->"Courier New"], 
                  StyleBox[
                    RowBox[{
                      StyleBox["{",
                        FontFamily->"Courier New"], 
                      RowBox[{
                        StyleBox[
                          SubscriptBox["a", 
                            StyleBox[
                              RowBox[{
                                StyleBox["m",
                                  FontSlant->"Italic"], 
                                StyleBox["1",
                                  FontSlant->"Plain"]}]]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox["...",
                          FontFamily->"Courier New"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox[\(a\_mn\),
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}], 
                      StyleBox["}",
                        FontFamily->"Courier New"]}],
                    FontFamily->"Times New Roman"]}], 
                StyleBox["}",
                  FontFamily->"Courier New"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              StyleBox[
                RowBox[{"und", "  ", "der", 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], " "}]], "Matrix"}],
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                RowBox[{
                  StyleBox["{",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["{",
                        FontFamily->"Courier New"], 
                      RowBox[{
                        StyleBox[
                          SubscriptBox[
                            StyleBox["b",
                              FontFamily->"Times New Roman"], 
                            StyleBox["11",
                              FontSlant->"Plain"]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox["...",
                          FontFamily->"Courier New"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox[
                          SubscriptBox["b", 
                            RowBox[{
                              StyleBox["1",
                                FontSlant->"Plain"], "k"}]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}], 
                      StyleBox["}",
                        FontFamily->"Courier New"]}], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[",",
                      FontFamily->"Courier New"], 
                    RowBox[{
                      StyleBox["{",
                        FontFamily->"Courier New"], 
                      RowBox[{
                        StyleBox[
                          SubscriptBox["b", 
                            StyleBox[
                              RowBox[{
                                StyleBox["n",
                                  FontSlant->"Italic"], 
                                StyleBox["1",
                                  FontSlant->"Plain"]}]]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox["...",
                          FontFamily->"Courier New"], 
                        StyleBox[",",
                          FontFamily->"Courier New"], 
                        StyleBox[\(b\_nk\),
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}], 
                      StyleBox["}",
                        FontFamily->"Courier New"]}]}], 
                  StyleBox["}",
                    FontFamily->"Courier New"]}], 
                StyleBox[";",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                RowBox[{
                  StyleBox["das",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Ergebnis",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["ist",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["eine",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["m",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["\[Times]",
                    FontFamily->"Times New Roman"], 
                  StyleBox["k",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["-",
                  FontFamily->"Times New Roman"], 
                StyleBox["Matrix",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"matrizen"],

Cell[TextData[{
  StyleBox["BEMERKUNG",
    FontWeight->"Bold"],
  ": Will man verhindern, dass Vektoren einmal als Spalten- und einmal als \
Zeilenvektoren aufgefasst werden, so muss der Vektor als Matrix, also als \
geschachtelte Liste, geschrieben werden. Dies entspricht auch der \
\[CapitalUDoubleDot]berlegung, dass ein Zeilenvektor mit ",
  StyleBox["n",
    FontSlant->"Italic"],
  " Eintr\[ADoubleDot]gen als 1\[Times]",
  StyleBox["n",
    FontSlant->"Italic"],
  "-Matrix und ein Spaltenvektor mit ",
  StyleBox["n",
    FontSlant->"Italic"],
  " Eintr\[ADoubleDot]gen als ",
  StyleBox["n",
    FontSlant->"Italic"],
  "\[Times]1-Matrix aufgefasst werden kann."
}], "Text",
  CellTags->"matrizen"],

Cell[TextData[{
  "F\[UDoubleDot]r quadratische Matrizen stellt ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ein paar weitere Befehle zur Verf\[UDoubleDot]gung."
}], "Text",
  CellTags->"matrizen"],

Cell["Hier ist eine 2\[Times]2-Matrix.", "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(\((A = {{1, 2}, {7, 1}})\)\ \ \  // MatrixForm\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  StyleBox["Det",
    FontFamily->"Courier New"],
  " berechnet die Determinante von ",
  StyleBox["A",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(Det[A]\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  "Ist die Determinante einer quadratischen Matrix ungleich Null, so kann mit \
",
  StyleBox["Inverse",
    FontFamily->"Courier New"],
  " die inverse Matrix berechnet werden."
}], "Text"],

Cell[BoxData[
    \(Inverse[A]\ \ \  // MatrixForm\)], "Input"],

Cell[TextData[{
  StyleBox["Eigenvalues",
    FontFamily->"Courier New"],
  " gibt eine Liste der Eigenwerte von ",
  StyleBox["A",
    FontFamily->"Courier New"],
  " aus."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(Eigenvalues[A]\)], "Input",
  CellTags->"matrizen"],

Cell[TextData[{
  "Und ",
  StyleBox["Eigenvectors",
    FontFamily->"Courier New"],
  " liefert eine Liste der Eigenvektorenvon  ",
  StyleBox["A",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"matrizen"],

Cell[BoxData[
    \(Eigenvectors[A]\)], "Input",
  CellTags->"matrizen"],

Cell[BoxData[
    \(Clear[A]\)], "Input",
  CellTags->"matrizen"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Det", "[", 
            StyleBox["A",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["Determinante",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["der",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["quadratischen",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Matrix",
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["A",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]},
        {
          RowBox[{"Inverse", "[", 
            StyleBox["A",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "]"}], 
          RowBox[{
            StyleBox["    ",
              FontFamily->"Times New Roman"], 
            RowBox[{
              StyleBox["Inverse",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["der",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["quadratischen",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Matrix",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["A",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]},
        {
          RowBox[{"Eigenvalues", "[", 
            StyleBox["A",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["liefert",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["eine",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Liste",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["der",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Eigenwerte",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["der",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["quadratischen",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Matrix",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["A",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]},
        {
          RowBox[{"Eigenvectors", "[", 
            StyleBox["A",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["liefert",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["eine",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Liste",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["der",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Eigenvektoren",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["der",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["quadratischen",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Matrix",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["A",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"matrizen"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "matrizen"->{
    Cell[8208, 254, 51, 1, 43, "Section",
      CellTags->"matrizen"],
    Cell[8262, 257, 178, 6, 33, "Text",
      CellTags->"matrizen"],
    Cell[8443, 265, 72, 1, 33, "Text",
      CellTags->"matrizen"],
    Cell[8518, 268, 85, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[8606, 272, 198, 7, 33, "Text",
      CellTags->"matrizen"],
    Cell[8807, 281, 70, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[8880, 285, 876, 29, 52, "Text",
      CellTags->"matrizen"],
    Cell[9759, 316, 688, 22, 52, "Text",
      CellTags->"matrizen"],
    Cell[10450, 340, 299, 12, 33, "Text",
      CellTags->"matrizen"],
    Cell[10752, 354, 70, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[10825, 358, 221, 8, 33, "Text",
      CellTags->"matrizen"],
    Cell[11049, 368, 67, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[11119, 372, 252, 9, 33, "Text",
      CellTags->"matrizen"],
    Cell[11374, 383, 72, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[11449, 387, 177, 6, 33, "Text",
      CellTags->"matrizen"],
    Cell[11629, 395, 89, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[11721, 399, 6091, 144, 85, "Text",
      CellTags->"matrizen"],
    Cell[17815, 545, 369, 11, 52, "Text",
      CellTags->"matrizen"],
    Cell[18187, 558, 105, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[18295, 562, 80, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[18378, 566, 65, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[18446, 570, 334, 9, 33, "Text",
      CellTags->"matrizen"],
    Cell[18783, 581, 103, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[18889, 585, 64, 1, 33, "Text",
      CellTags->"matrizen"],
    Cell[18956, 588, 67, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[19026, 592, 330, 9, 33, "Text",
      CellTags->"matrizen"],
    Cell[19359, 603, 150, 6, 33, "Text",
      CellTags->"matrizen"],
    Cell[19512, 611, 62, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[19577, 615, 173, 6, 33, "Text",
      CellTags->"matrizen"],
    Cell[19753, 623, 62, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[19818, 627, 16933, 413, 127, "Text",
      CellTags->"matrizen"],
    Cell[36754, 1042, 260, 7, 33, "Text",
      CellTags->"matrizen"],
    Cell[37017, 1051, 68, 1, 33, "Text",
      CellTags->"matrizen"],
    Cell[37088, 1054, 111, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[37202, 1058, 141, 6, 33, "Text",
      CellTags->"matrizen"],
    Cell[37346, 1066, 80, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[37429, 1070, 257, 7, 33, "Text",
      CellTags->"matrizen"],
    Cell[37689, 1079, 62, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[37754, 1083, 71, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[37828, 1087, 13268, 315, 123, "Text",
      CellTags->"matrizen"],
    Cell[51099, 1404, 709, 20, 71, "Text",
      CellTags->"matrizen"],
    Cell[51811, 1426, 211, 6, 33, "Text",
      CellTags->"matrizen"],
    Cell[52025, 1434, 72, 1, 33, "Text",
      CellTags->"matrizen"],
    Cell[52100, 1437, 103, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[52206, 1441, 193, 8, 33, "Text",
      CellTags->"matrizen"],
    Cell[52402, 1451, 63, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[52743, 1466, 209, 8, 33, "Text",
      CellTags->"matrizen"],
    Cell[52955, 1476, 71, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[53029, 1480, 222, 9, 33, "Text",
      CellTags->"matrizen"],
    Cell[53254, 1491, 72, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[53329, 1495, 65, 2, 30, "Input",
      CellTags->"matrizen"],
    Cell[53397, 1499, 5393, 143, 99, "Text",
      CellTags->"matrizen"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"matrizen", 59431, 1662}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 41, 0, 51, "Subtitle"],
Cell[1820, 55, 246, 7, 52, "Text"],

Cell[CellGroupData[{
Cell[2091, 66, 27, 0, 73, "Section"],
Cell[2121, 68, 145, 5, 33, "Text"],
Cell[2269, 75, 57, 0, 33, "Text"],
Cell[2329, 77, 101, 2, 50, "Input"],
Cell[2433, 81, 193, 6, 33, "Text"],
Cell[2629, 89, 38, 1, 30, "Input"],
Cell[2670, 92, 295, 7, 33, "Text"],
Cell[2968, 101, 200, 8, 33, "Text"],
Cell[3171, 111, 36, 1, 30, "Input"],
Cell[3210, 114, 166, 6, 33, "Text"],
Cell[3379, 122, 38, 1, 30, "Input"],
Cell[3420, 125, 4704, 121, 67, "Text"],
Cell[8127, 248, 44, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[8208, 254, 51, 1, 43, "Section",
  CellTags->"matrizen"],
Cell[8262, 257, 178, 6, 33, "Text",
  CellTags->"matrizen"],
Cell[8443, 265, 72, 1, 33, "Text",
  CellTags->"matrizen"],
Cell[8518, 268, 85, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[8606, 272, 198, 7, 33, "Text",
  CellTags->"matrizen"],
Cell[8807, 281, 70, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[8880, 285, 876, 29, 52, "Text",
  CellTags->"matrizen"],
Cell[9759, 316, 688, 22, 52, "Text",
  CellTags->"matrizen"],
Cell[10450, 340, 299, 12, 33, "Text",
  CellTags->"matrizen"],
Cell[10752, 354, 70, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[10825, 358, 221, 8, 33, "Text",
  CellTags->"matrizen"],
Cell[11049, 368, 67, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[11119, 372, 252, 9, 33, "Text",
  CellTags->"matrizen"],
Cell[11374, 383, 72, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[11449, 387, 177, 6, 33, "Text",
  CellTags->"matrizen"],
Cell[11629, 395, 89, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[11721, 399, 6091, 144, 85, "Text",
  CellTags->"matrizen"],
Cell[17815, 545, 369, 11, 52, "Text",
  CellTags->"matrizen"],
Cell[18187, 558, 105, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[18295, 562, 80, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[18378, 566, 65, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[18446, 570, 334, 9, 33, "Text",
  CellTags->"matrizen"],
Cell[18783, 581, 103, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[18889, 585, 64, 1, 33, "Text",
  CellTags->"matrizen"],
Cell[18956, 588, 67, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[19026, 592, 330, 9, 33, "Text",
  CellTags->"matrizen"],
Cell[19359, 603, 150, 6, 33, "Text",
  CellTags->"matrizen"],
Cell[19512, 611, 62, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[19577, 615, 173, 6, 33, "Text",
  CellTags->"matrizen"],
Cell[19753, 623, 62, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[19818, 627, 16933, 413, 127, "Text",
  CellTags->"matrizen"],
Cell[36754, 1042, 260, 7, 33, "Text",
  CellTags->"matrizen"],
Cell[37017, 1051, 68, 1, 33, "Text",
  CellTags->"matrizen"],
Cell[37088, 1054, 111, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[37202, 1058, 141, 6, 33, "Text",
  CellTags->"matrizen"],
Cell[37346, 1066, 80, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[37429, 1070, 257, 7, 33, "Text",
  CellTags->"matrizen"],
Cell[37689, 1079, 62, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[37754, 1083, 71, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[37828, 1087, 13268, 315, 123, "Text",
  CellTags->"matrizen"],
Cell[51099, 1404, 709, 20, 71, "Text",
  CellTags->"matrizen"],
Cell[51811, 1426, 211, 6, 33, "Text",
  CellTags->"matrizen"],
Cell[52025, 1434, 72, 1, 33, "Text",
  CellTags->"matrizen"],
Cell[52100, 1437, 103, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[52206, 1441, 193, 8, 33, "Text",
  CellTags->"matrizen"],
Cell[52402, 1451, 63, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[52468, 1455, 206, 6, 33, "Text"],
Cell[52677, 1463, 63, 1, 30, "Input"],
Cell[52743, 1466, 209, 8, 33, "Text",
  CellTags->"matrizen"],
Cell[52955, 1476, 71, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[53029, 1480, 222, 9, 33, "Text",
  CellTags->"matrizen"],
Cell[53254, 1491, 72, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[53329, 1495, 65, 2, 30, "Input",
  CellTags->"matrizen"],
Cell[53397, 1499, 5393, 143, 99, "Text",
  CellTags->"matrizen"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

