(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23443,        685]*)
(*NotebookOutlinePosition[     24107,        708]*)
(*  CellTagsIndexPosition[     24063,        704]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Integration", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell[CellGroupData[{

Cell["Unbestimmtes Integral", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kann Funktionen symbolisch integrieren. Der zugeh\[ODoubleDot]rige Befehl \
hei\[SZ]t ",
  StyleBox["Integrate",
    FontFamily->"Courier New"],
  ". Wir m\[UDoubleDot]ssen den Funktionsterm und die Integrationsvariable \
eingeben."
}], "Text"],

Cell[BoxData[
    \(Integrate[a^3, a]\)], "Input"],

Cell[TextData[{
  "Integrieren funktioniert auch \[UDoubleDot]ber den entsprechenden Button \
\"",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\[Placeholder] \[DifferentialD]\
\[Placeholder]\)]],
  "\" in der Palette BasicInput. Wieder m\[UDoubleDot]ssen wir den \
Funktionsterm und die Integrationsvariable eingeben."
}], "Text"],

Cell[BoxData[
    \(\[Integral]\(a\^3\) \[DifferentialD]a\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{
              RowBox[{"Integrate", "[", 
                RowBox[{
                  RowBox[{
                    StyleBox["f",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], ",", 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "]"}], "  ", 
              StyleBox["oder",
                FontFamily->"Courier New",
                FontSlant->"Italic"]}], "\[IndentingNewLine]", 
            RowBox[{"\[Integral]", 
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}], 
                RowBox[{"\[DifferentialD]", 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}]}]}]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["liefert",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["das",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["unbestimmte",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Integral",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["von",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["in",
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nimmt an, dass alle Ausdr\[UDoubleDot]cke, die die Integrationsvariable \
nicht explizit enthalten, von dieser auch unabh\[ADoubleDot]ngig sind. Solche \
Ausdr\[UDoubleDot]cke werden daher als Konstanten behandelt."
}], "Text"],

Cell[BoxData[
    \(Integrate[k*x^2, x]\)], "Input"],

Cell[TextData[{
  StyleBox["Integrate",
    FontFamily->"Courier New"],
  " liefert ein unbestimmtes Integral, das Spezialf\[ADoubleDot]lle der \
Parameter des Integranden nicht ber\[UDoubleDot]cksichtigt. F\[UDoubleDot]r \
",
  StyleBox["n ",
    FontSlant->"Italic"],
  "= ",
  StyleBox["-", "Input"],
  "1 ist das folgende Ergebnis nat\[UDoubleDot]rlich falsch."
}], "Text"],

Cell[BoxData[
    \(Integrate[x^n, x]\)], "Input"],

Cell[TextData[{
  "Wird ",
  StyleBox["x^(-1)",
    FontFamily->"Courier New"],
  " direkt integriert, so erh\[ADoubleDot]lt man auch ein richtiges \
Ergebnis."
}], "Text"],

Cell[BoxData[
    \(Integrate[x^\((\(-1\))\), x]\)], "Input"],

Cell[TextData[{
  "F\[UDoubleDot]r manche Integrale existieren keine geschlossenen Ausdr\
\[UDoubleDot]cke in mathematischen \"Standard-Funktionen\". ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " f\[UDoubleDot]hrt solche Integrationen nicht durch."
}], "Text"],

Cell[BoxData[
    \(Integrate[x^x, x]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Bestimmtes Integral", "Section"],

Cell[TextData[{
  "Mit dem Befehl ",
  StyleBox["Integrate",
    FontFamily->"Courier New"],
  " k\[ODoubleDot]nnen auch bestimmte Integrale berechnet werden. Dazu m\
\[UDoubleDot]ssen zus\[ADoubleDot]tzlich zu Funktionsterm und \
Integrationsvariablen auch die Integrationsgrenzen angegeben werden."
}], "Text"],

Cell[BoxData[
    \(Integrate[x^2, {x, 1, 2}]\)], "Input"],

Cell["\<\
Die Grenzen m\[UDoubleDot]ssen keine Zahlen, sondern k\[ODoubleDot]nnen auch \
symbolische Variablen sein.\
\>", "Text"],

Cell[BoxData[
    \(Integrate[x^2, {x, a, b}]\)], "Input"],

Cell[TextData[{
  "Wir k\[ODoubleDot]nnen die Eingabe auch wieder \[UDoubleDot]ber einen \
Button \"",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_\[Placeholder]\%\[Placeholder] \
\[Placeholder] \[DifferentialD]\[Placeholder]\)]],
  "\" in der Palette BasicInput t\[ADoubleDot]tigen."
}], "Text"],

Cell[BoxData[
    \(\[Integral]\_a\%b\( x\^2\) \[DifferentialD]x\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{
              RowBox[{"Integrate", "[", 
                RowBox[{
                  RowBox[{
                    StyleBox["f",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], ",", 
                      StyleBox["a",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], ",", 
                      StyleBox["b",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], "}"}]}], "]"}], 
              StyleBox[
                RowBox[{" ", 
                  StyleBox[" ",
                    FontFamily->"Courier New"]}]], 
              StyleBox["oder",
                FontFamily->"Courier New",
                FontSlant->"Italic"]}], 
            StyleBox["\[IndentingNewLine]",
              FontFamily->"Courier New"], 
            RowBox[{
              SubsuperscriptBox["\[Integral]", 
                StyleBox["a",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["b",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]], 
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}], 
                RowBox[{"\[DifferentialD]", 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}]}]}]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["liefert",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["das",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["bestimmte",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Integral",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["der",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Funktion",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["von",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["a",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["bis",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["b",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  StyleBox["Integrate",
    FontFamily->"Courier New"],
  " versucht symbolisch zu integrieren. Ist das nicht m\[ODoubleDot]glich, so \
kann mit dem Befehl ",
  StyleBox["Integrate",
    FontFamily->"Courier New"],
  " allein auch kein bestimmtes Integral berechnet werden."
}], "Text"],

Cell[BoxData[
    \(Integrate[x^x, {x, 0, 1}]\)], "Input"],

Cell[TextData[{
  "Verwenden wir zus\[ADoubleDot]tzlich den Befehl ",
  StyleBox["N",
    FontFamily->"Courier New"],
  ", so erhalten wir dennoch eine numerische Approximation des bestimmten \
Integrals."
}], "Text"],

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[TextData[{
  StyleBox["NIntegrate",
    FontFamily->"Courier New"],
  " (selbe Syntax wie ",
  StyleBox["Integrate",
    FontFamily->"Courier New"],
  ") sucht gleich nach einer numerischen Approximation des bestimmten \
Integrals."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"NIntegrate", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["a",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["b",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              
              StyleBox[\(liefert\ eine\ numerische\ Approximation\ des\ \
bestimmten\ Integrals\ der\),
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["Funktion",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["a",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["bis",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["b",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}]}]}]},
        {
          RowBox[{"N", "[", 
            RowBox[{"Integrate", "[", 
              RowBox[{
                RowBox[{
                  StyleBox["f",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox["(",
                      FontFamily->"Times New Roman"], 
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[")",
                      FontFamily->"Times New Roman"]}]}], ",", 
                RowBox[{"{", 
                  RowBox[{
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], ",", 
                    StyleBox["a",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], ",", 
                    StyleBox["b",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], "}"}]}], "]"}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["ruft",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["NIntegrate",
                      FontFamily->"Courier New"], 
                    StyleBox["[",
                      FontFamily->"Courier New"], 
                    RowBox[{
                      RowBox[{
                        StyleBox["f",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        RowBox[{
                          StyleBox["(",
                            FontFamily->"Times New Roman"], 
                          StyleBox["x",
                            FontFamily->"Times New Roman",
                            FontSlant->"Italic"], 
                          StyleBox[")",
                            FontFamily->"Times New Roman"]}]}], 
                      StyleBox[",",
                        FontFamily->"Courier New"], 
                      RowBox[{
                        StyleBox["{",
                          FontFamily->"Courier New"], 
                        RowBox[{
                          StyleBox["x",
                            FontFamily->"Times New Roman",
                            FontSlant->"Italic"], 
                          StyleBox[",",
                            FontFamily->"Courier New"], 
                          StyleBox["a",
                            FontFamily->"Times New Roman",
                            FontSlant->"Italic"], 
                          StyleBox[",",
                            FontFamily->"Courier New"], 
                          StyleBox["b",
                            FontFamily->"Times New Roman",
                            FontSlant->"Italic"]}], 
                        StyleBox["}",
                          FontFamily->"Courier New"]}]}], 
                    StyleBox["]",
                      FontFamily->"Courier New"]}], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["bei",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Integranden",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["auf",
                    FontFamily->"Times New Roman"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(die\ nicht\),
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["\[IndentingNewLine]",
                FontFamily->"Times New Roman"], 
              
              StyleBox[\(symbolisch\ durchgef\[UDoubleDot]hrt\ werden\ k\
\[ODoubleDot]nnen\),
                FontFamily->"Times New Roman"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  StyleBox["N[Integrate[...]]",
    FontFamily->"Courier New"],
  " versucht exakt zu integrieren und dann numerische Approximationen f\
\[UDoubleDot]r die Teile zu finden, die nicht symbolisch integrierbar sind. \
Der Befehl ",
  StyleBox["NIntegrate",
    FontFamily->"Courier New"],
  " versucht erst gar nicht ein exaktes, symbolisches Resultat zu erzielen, \
sondern verwendet sofort numerische Algorithmen."
}], "Text"],

Cell[TextData[{
  "Die unterschiedliche Funktionsweise von ",
  StyleBox["N[Integrate[...]]",
    FontFamily->"Courier New"],
  " und",
  StyleBox[" NIntegrate[...]",
    FontFamily->"Courier New"],
  " wird an folgendem Beispiel deutlich."
}], "Text"],

Cell[TextData[{
  "Das ist die Funktion ",
  Cell[BoxData[
      \(TraditionalForm\`e\^\(-x\^2\)\)]],
  " im Intervall [-10, 10]. Bei 0 hat sie ein sehr spitzes Maximum."
}], "Text"],

Cell[BoxData[
    \(Plot[Exp[\(-x\^2\)], {x, \(-10\), 10}, 
      PlotRange \[Rule] All]\)], "Input"],

Cell[TextData[{
  StyleBox["Integrate",
    FontFamily->"Courier New"],
  " kann das unbestimmte Integral von ",
  Cell[BoxData[
      \(TraditionalForm\`e\^\(-x\^2\)\)]],
  "in einer geschlossenen Form angeben (",
  StyleBox["Erf",
    FontFamily->"Courier New"],
  " ist die sogenannte \"error function\", eine in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " eingebaute Funktion)."
}], "Text"],

Cell[BoxData[
    \(Integrate[Exp[\(-x\^2\)], x]\)], "Input"],

Cell[TextData[{
  StyleBox["N[Integrate[...]]",
    FontFamily->"Courier New"],
  " integriert daher zuerst symbolisch und setzt dann die Grenzen ein."
}], "Text"],

Cell[BoxData[
    \(N[Integrate[Exp[\(-x\^2\)], {x, \(-1000\), 1000}]]\)], "Input"],

Cell[TextData[{
  StyleBox["NIntegrate",
    FontFamily->"Courier New"],
  " verwendet sofort numerische Algorithmen. Auf Grund des gro\[SZ]en \
Integrationsbereiches \"\[UDoubleDot]bersieht\" das numerische Verfahren das \
Maximum bei 0. Das Ergebnis ist falsch."
}], "Text"],

Cell[BoxData[
    \(NIntegrate[Exp[\(-x\^2\)], {x, \(-1000\), 1000}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Uneigentliche Integrale", "Section"],

Cell["\<\
Uneigentliche Integrale k\[ODoubleDot]nnen per definitionem ausgerechnet \
werden...\
\>", "Text"],

Cell[BoxData[
    \(Limit[\[Integral]\_1\%t\( 1\/x\^2\) \[DifferentialD]x, 
      t \[Rule] Infinity]\)], "Input"],

Cell[BoxData[
    \(Limit[\[Integral]\_t\%1 Log[x] \[DifferentialD]x, 
      t \[Rule] 0]\)], "Input"],

Cell[TextData[{
  "...oder (einfacher) indem die gew\[UDoubleDot]nschten Grenzen direkt in \
den Befehl ",
  StyleBox["Integrate",
    FontFamily->"Courier New"],
  " (oder ",
  StyleBox["NIntegrate",
    FontFamily->"Courier New"],
  ") eingegeben werden."
}], "Text"],

Cell[BoxData[
    \(Integrate[1\/x\^2, {x, 1, Infinity}]\)], "Input"],

Cell[BoxData[
    \(Integrate[Log[x], {x, 0, 1}]\)], "Input"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 31, 0, 51, "Subtitle"],
Cell[1810, 55, 246, 7, 52, "Text"],

Cell[CellGroupData[{
Cell[2081, 66, 40, 0, 73, "Section"],
Cell[2124, 68, 316, 9, 33, "Text"],
Cell[2443, 79, 50, 1, 30, "Input"],
Cell[2496, 82, 338, 8, 33, "Text"],
Cell[2837, 92, 70, 1, 41, "Input"],
Cell[2910, 95, 3061, 78, 69, "Text"],
Cell[5974, 175, 299, 6, 33, "Text"],
Cell[6276, 183, 52, 1, 30, "Input"],
Cell[6331, 186, 377, 11, 34, "Text"],
Cell[6711, 199, 50, 1, 30, "Input"],
Cell[6764, 202, 172, 6, 33, "Text"],
Cell[6939, 210, 61, 1, 30, "Input"],
Cell[7003, 213, 273, 6, 33, "Text"],
Cell[7279, 221, 50, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[7366, 227, 38, 0, 43, "Section"],
Cell[7407, 229, 312, 7, 33, "Text"],
Cell[7722, 238, 58, 1, 30, "Input"],
Cell[7783, 241, 130, 3, 33, "Text"],
Cell[7916, 246, 58, 1, 30, "Input"],
Cell[7977, 249, 306, 7, 33, "Text"],
Cell[8286, 258, 77, 1, 42, "Input"],
Cell[8366, 261, 4404, 112, 69, "Text"],
Cell[12773, 375, 302, 8, 33, "Text"],
Cell[13078, 385, 58, 1, 30, "Input"],
Cell[13139, 388, 217, 6, 33, "Text"],
Cell[13359, 396, 37, 1, 30, "Input"],
Cell[13399, 399, 249, 8, 33, "Text"],
Cell[13651, 409, 6865, 166, 107, "Text"],
Cell[20519, 577, 441, 10, 52, "Text"],
Cell[20963, 589, 252, 8, 33, "Text"],
Cell[21218, 599, 182, 5, 35, "Text"],
Cell[21403, 606, 101, 2, 31, "Input"],
Cell[21507, 610, 409, 13, 35, "Text"],
Cell[21919, 625, 61, 1, 31, "Input"],
Cell[21983, 628, 163, 4, 33, "Text"],
Cell[22149, 634, 83, 1, 31, "Input"],
Cell[22235, 637, 276, 6, 33, "Text"],
Cell[22514, 645, 81, 1, 31, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[22632, 651, 42, 0, 43, "Section"],
Cell[22677, 653, 108, 3, 33, "Text"],
Cell[22788, 658, 114, 2, 42, "Input"],
Cell[22905, 662, 102, 2, 42, "Input"],
Cell[23010, 666, 269, 9, 33, "Text"],
Cell[23282, 677, 69, 1, 42, "Input"],
Cell[23354, 680, 61, 1, 30, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

