(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     39695,       1174]*)
(*NotebookOutlinePosition[     46376,       1371]*)
(*  CellTagsIndexPosition[     46279,       1364]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Grundlegende Funktionsweise und Bedienung von ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell["", "Text"],

Cell[TextData[{
  "In diesem Kurs wechseln sich Erkl\[ADoubleDot]rungstexte, Beispiele und \
blaue Definitionsboxen ab.\nDie Beispiele sind so gestaltet, dass zwar die \
Eingabe sichtbar ist, die zugeh\[ODoubleDot]rige Ausgabe fehlt jedoch. Sie \
sollen beim Durcharbeiten der einzelnen Abschnitte und Kapitel diese \
Beispiele selbst evaluieren (keine Angst, wie das geht steht weiter unten!). \
Sie k\[ODoubleDot]nnen nat\[UDoubleDot]rlich jederzeit die Beispiele ab\
\[ADoubleDot]ndern und neu evaluieren, neue Varianten ausprobieren oder \
eigene Beispiele erfinden. Je mehr Sie ausprobieren, desto eher werden Sie \
ein \"Gef\[UDoubleDot]hl\" f\[UDoubleDot]r die einzelnen Befehle und die \
Funktionsweise von ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " entwickeln.\nIn den blauen Definitionsboxen werden die im Text und an \
Hand von Beispielen durchbesprochenen Befehle und ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-typischen Schreibweisen noch einmal in \[UDoubleDot]bersichtlicher Form \
pr\[ADoubleDot]sentiert bzw. zusammengefasst."
}], "Text"],

Cell[TextData[{
  "Eine ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Datei (eine solche wird als \"Notebook\" bezeichnet) ist durch die \
Einteilung in sogenannte Zellen gegliedert. Die eckigen blauen Klammern \
rechts bezeichnen die einzelnen Zellen. Mehrere Zellen k\[ODoubleDot]nnen \
durch eine alle umfassende weitere Zellenklammer zu gr\[ODoubleDot]\[SZ]eren \
Einheiten zusammengefasst werden (siehe z.B. die Zellenklammer ganz rechts; \
sie umfasst das gesamte Kapitel \"Grundlegende Funktionsweise und Bedienung \
von ",
  StyleBox["Mathematica\"",
    FontSlant->"Italic"],
  ").\nDas kleine blaue Dreieck am unteren Ende von manchen Zellenklammern \
bedeutet, dass diese Zelle mehr als nur die eine sichtbare Zelle enth\
\[ADoubleDot]lt. Mit einem Doppelklick auf die Klammer mit dem Dreieck \
\[ODoubleDot]ffnen Sie diese Zelle und machen so die restlichen Zellen \
sichtbar.\nJEDE Zellenklammer, die mehrere Zellen umfasst, l\[ADoubleDot]sst \
sich mit einem Doppelklick schlie\[SZ]en. Es ist dann nur noch die erste \
Zelle sichtbar und die umfassende Zellenklammer wird mit einem kleinen blauen \
Dreieck am unteren Rand versehen."
}], "Text"],

Cell["\<\
\[CapitalODoubleDot]ffnen Sie nun das erste Unterkapitel \
\"Durchf\[UDoubleDot]hren von Berechnungen; Grundrechnungsarten\" durch einen \
Doppelklick auf die entsprechende Zellenklammer. \
\>", "Text"],

Cell[CellGroupData[{

Cell["Durchf\[UDoubleDot]hren von Berechnungen; Grundrechnungsarten", \
"Section",
  CellTags->"kap1"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " verf\[UDoubleDot]gt \[UDoubleDot]ber ein eigenes Dateiformat. Eine Datei \
in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " wird als \"Notebook\" bezeichnet, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Dateien werden automatisch mit der Extension \".nb\" abgespeichert. Um \
Dateien zu \[ODoubleDot]ffnen, abzuspeichern oder zu schlie\[SZ]en verwendet \
man die entsprechenden Punkte im Men\[UDoubleDot] \"File\"."
}], "Text",
  CellTags->"kap1"],

Cell[TextData[{
  "Wenn ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " gestartet wird erscheint normalerweise ein leeres Notebook. Um \
Berechnungen durchzuf\[UDoubleDot]hren tippen Sie zun\[ADoubleDot]chst die \
entsprechenden ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Befehle ein. Ihre Eingabe kann auch mehrere Zeilen umfassen, solange sich \
nur alles in einer einzigen Zelle befindet. Um die Berechnung zu starten gibt \
es zwei M\[ODoubleDot]glichkeiten: Entweder dr\[UDoubleDot]ckt man \"Shift\" \
+\"Return\" (halten Sie dazu die \"Shift\"-Taste gedr\[UDoubleDot]ckt und dr\
\[UDoubleDot]cken Sie dann \"Return\") oder man bet\[ADoubleDot]tigt die \
\"Enter\"-Taste auf der Tastatur rechts neben dem Zahlenblock (Durch \
alleiniges Dr\[UDoubleDot]cken der \"Return\"-Taste springt der Curser nur in \
die n\[ADoubleDot]chste Zeile.). Der Inhalt Ihrer Input-Zelle wird nun vom \
Notebook an den ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Kernel geschickt (Das ist der Teil von ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", der tats\[ADoubleDot]chlich rechnet. Der Kernel wird i.A. bei der ersten \
Berechnung gestartet. Er ist \"unsichtbar\", bis auf eventuell einen Eintrag \
in der Statuszeile), der die Berechnung durchf\[UDoubleDot]hrt. Das Ergebnis \
dieser Berechnung wird im Notebook unter dem Input in einer eigenen Zelle \
ausgegeben.\nSobald eine Berechnung gestartet wird versieht ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " die Eingabe mit ",
  StyleBox["In[",
    FontFamily->"Courier New",
    FontWeight->"Bold"],
  StyleBox["n",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier New",
    FontWeight->"Bold"],
  " (",
  StyleBox["n",
    FontSlant->"Italic"],
  " steht hier f\[UDoubleDot]r eine nat\[UDoubleDot]rliche Zahl). Die zugeh\
\[ODoubleDot]rige Ausgabe wird mit ",
  StyleBox["Out[",
    FontFamily->"Courier New",
    FontWeight->"Bold"],
  StyleBox["n",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier New",
    FontWeight->"Bold"],
  " versehen. ",
  StyleBox["In",
    FontFamily->"Courier New",
    FontWeight->"Bold"],
  " bzw. ",
  StyleBox["Out",
    FontFamily->"Courier New",
    FontWeight->"Bold"],
  " steht f\[UDoubleDot]r Input bzw. Output, die Zahl ",
  StyleBox["n",
    FontSlant->"Italic"],
  " in den eckigen Klammern danach gibt an, um den wievielten In- bzw. Output \
es sich handelt seit der ",
  StyleBox["Mathematica-",
    FontSlant->"Italic"],
  "Kernel gestartet wurde.\nUm eine Zelle zu l\[ODoubleDot]schen, klicken Sie \
auf die Zelle (sie sollte dann schwarz unterlegt sein) und \
dr\[UDoubleDot]cken Sie die \"Delete\"-Taste."
}], "Text",
  CellTags->"kap1"],

Cell[TextData[{
  "Wie schon erw\[ADoubleDot]hnt kann man mit ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " wie mit einem Taschenrechner rechnen. Untersuchen wir in diesem Abschnitt \
also einmal die Taschenrechner-Funktionalit\[ADoubleDot]t von ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Wir geben ",
  StyleBox["2+2",
    FontFamily->"Courier New"],
  " ein und dr\[UDoubleDot]cken \"Shift\"+\"Return\" (Letzteres sollen Sie \
jetzt selbst tun. Bitte beachten Sie dabei, dass sich der Curser irgendwo in \
der Input-Zelle \"",
  StyleBox["2+2",
    FontFamily->"Courier New"],
  "\" befinden muss. Es wird n\[ADoubleDot]mlich immer der Inhalt DER \
Input-Zelle an den Kernel geschickt, in der sich der Curser befindet.):"
}], "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(2 + 2\)], "Input",
  CellTags->"kap1"],

Cell[TextData[{
  "Die Befehle f\[UDoubleDot]r die Grundrechnungsarten lauten wie folgt: \
Addiert wird mit dem Befehl \"",
  StyleBox["+",
    FontFamily->"Courier New"],
  "\", subtrahiert mit \"",
  StyleBox["-",
    FontFamily->"Courier New"],
  "\" (Bindestrich), multipliziert mit \"",
  StyleBox["*",
    FontFamily->"Courier New"],
  "\" und dividiert mit \"",
  StyleBox["/",
    FontFamily->"Courier New"],
  "\". Das Komma wird als Punkt \"",
  StyleBox[".",
    FontFamily->"Courier New"],
  "\" eingegeben. Ausdr\[UDoubleDot]cke, die in runden Klammern stehen, \
werden zuerst evaluiert. Das folgende Beispiel zeigt uns, dass ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " die \[UDoubleDot]blichen Rechenregeln (Klammerung, \"Punkt- vor \
Strichrechnung\") beachtet:"
}], "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(\((2 + 4.5*5)\)/7\)], "Input",
  CellTags->"kap1"],

Cell[TextData[{
  "Statt des Multiplikationszeichens \"",
  StyleBox["*",
    FontFamily->"Courier New"],
  "\" kann man auch einfach einen Abstand zwischen den zwei Zahlen lassen, \
die man miteinander multiplizieren m\[ODoubleDot]chte. (Ich bitte allerdings \
diese Methode der Multiplikation nicht zu exzessiv zu vewenden: Erfahrungsgem\
\[ADoubleDot]\[SZ] kommt es bei der Verwendung von \" \" viel \
\[ODoubleDot]fter zu Eingabefehlern als bei dem Befehl \"",
  StyleBox["*",
    FontFamily->"Courier New"],
  "\". Ein Abstand ist nun einmal nicht so einfach zu sehen wie ein \
Stern...)"
}], "Text",
  CellTags->"kap1"],

Cell["Das berechnet 4 mal 2.", "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(4\ 2\)], "Input",
  CellTags->"kap1"],

Cell[TextData[{
  " Potenzen berechnet man mittels \"",
  StyleBox["^",
    FontFamily->"Courier New"],
  "\"."
}], "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(2^10\)], "Input",
  CellTags->"kap1"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            StyleBox["a",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "+", 
            StyleBox["b",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["a",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["plus",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["b",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]},
        {
          RowBox[{
            StyleBox["a",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "-", 
            StyleBox["b",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["a",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["minus",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["b",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]},
        {
          RowBox[{
            RowBox[{
              StyleBox["a",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "*", 
              StyleBox["b",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "  ", 
              StyleBox["oder",
                FontSlant->"Italic"]}], "\[IndentingNewLine]", 
            RowBox[{
              StyleBox["a",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], " ", 
              StyleBox["b",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["a",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["mal",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["b",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]},
        {
          RowBox[{
            StyleBox["a",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "/", 
            StyleBox["b",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["a",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["dividiert",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["durch",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["b",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]},
        {
          RowBox[{
            StyleBox["a",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "^", 
            StyleBox["b",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["a",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["hoch",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["b",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"kap1"],

Cell["\<\
Es k\[ODoubleDot]nnen auch mehrere Berechnungen innerhalb einer Input-Zelle \
durchgef\[UDoubleDot]hrt werden. Dazu schreibt man die einzelnen Eingaben \
untereinander (um mit dem Curser in die n\[ADoubleDot]chste Zeile zu h\
\[UDoubleDot]pfen, \"Return\" dr\[UDoubleDot]cken!). Die \
zugeh\[ODoubleDot]rigen Outputs werden separat durchnumeriert.\
\>", "Text"],

Cell[BoxData[{
    \(5^2 - 1\), "\[IndentingNewLine]", 
    \(30*30\), "\[IndentingNewLine]", 
    \(4 - 7\)}], "Input"],

Cell[TextData[{
  "Ein Semikolon am Ende einer Eingabe unterdr\[UDoubleDot]ckt die Ausgabe, \
auf die Numerierung hat das aber keinen Einfluss. Das Ergebnis von ",
  StyleBox["30*30",
    FontFamily->"Courier New"],
  " scheint zwar nicht auf, wird aber mitgez\[ADoubleDot]hlt."
}], "Text"],

Cell[BoxData[{
    \(5^2 - 1\), "\n", 
    \(\(30*30;\)\), "\n", 
    \(4 - 7\)}], "Input"],

Cell["\<\
Manchmal m\[ODoubleDot]chte man Berechnungen abbrechen - sei es, weil sie \
einfach zu lange dauern, oder weil sie wegen einer Endlosschleife gar nicht \
zu Ende gebracht werden k\[ODoubleDot]nnen. Dazu w\[ADoubleDot]hlt man \
entweder aus dem Men\[UDoubleDot] \"Kernel\" den Punkt \"Interrupt Evaluation\
\" oder man dr\[UDoubleDot]ckt \"Alt\"+\".\". \
\>", "Text",
  CellTags->"kap1"],

Cell["\<\
Hier ist ein Beispiel f\[UDoubleDot]r eine Berechnung, die sehr lange dauert \
(500000 Fakult\[ADoubleDot]t).\
\>", "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(\(500000!\)\)], "Input",
  CellTags->"kap1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Befehle und der Help Browser"
}], "Section",
  CellTags->"kap1"],

Cell[TextData[{
  "Neben der Taschenrechner-Funktionalit\[ADoubleDot]t stellt ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " wie jedes Computer Algebra System eine Vielzahl von eingebauten Befehlen \
zur Vef\[UDoubleDot]gung. Alle ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Befehle beginnen mit einem Gro\[SZ]buchstaben, die Argumente stehen in \
eckigen Klammern. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ist case-sensitive, das hei\[SZ]t es macht einen Unterschied, ob Sie Gro\
\[SZ]- oder Kleinbuchstaben verwenden!"
}], "Text",
  CellTags->"kap1"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["Round",
    FontFamily->"Courier New"],
  " rundet die Zahl, die in den eckigen Klammern steht. ",
  StyleBox["Round",
    FontFamily->"Courier New"],
  " ist der Name des Befehls, die Zahl in den eckigen Klammern das Argument."
}], "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(Round[7.81]\)], "Input",
  CellTags->"kap1"],

Cell[TextData[{
  StyleBox["Sqrt",
    FontFamily->"Courier New"],
  " berechnet die Quadratwurzel einer Zahl."
}], "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(Sqrt\ [4]\)], "Input",
  CellTags->"kap1"],

Cell[TextData[{
  "Befehle k\[ODoubleDot]nnen auch mehrere Argumente haben. ",
  StyleBox["Max",
    FontFamily->"Courier New"],
  " liefert die gr\[ODoubleDot]\[SZ]te Zahl, die als Argument eingegeben \
wurde. Die einzelnen Argumente werden mit Beistrichen voneinander getrennt."
}], "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(Max[2, \(-7\), 6, 0]\)], "Input",
  CellTags->"kap1"],

Cell[TextData[{
  "Befehle haben eine sogenannte Syntax, d.h. sie m\[UDoubleDot]ssen einer \
bestimmten \[ADoubleDot]u\[SZ]eren Form entsprechen. Ist man sich nicht \
sicher, wie die Syntax eines Befehls aussieht, so kann man diese im Help \
Browser abrufen. Um den Help Browser zu \[ODoubleDot]ffnen w\[ADoubleDot]hlt \
man im Men\[UDoubleDot] \"Help\" den Punkt \"Help Browser\". Geben Sie nun \
nur noch den Befehl, zu dem sie n\[ADoubleDot]here Informationen w\
\[UDoubleDot]nschen, oben in das Eingabefeld ein und klicken Sie auf \"Go \
to\" (der Button \"Built-in Functions\" ist beim \[CapitalODoubleDot]ffnen \
des Help Browsers automatisch aktiviert). Sie erhalten eine Beschreibung der \
Syntax und der Funktionsweise des eingegebenen Befehls, sowie auch einige \
Beispiele (klicken Sie dazu auf das kleine Dreieck links neben \"Further \
Examples\").\nDer Help Browser kann aber noch mehr. In den grau unterlegten K\
\[ADoubleDot]stchen k\[ODoubleDot]nnen durch Anklicken die zu einem \
bestimmten \"Thema\" zur Vef\[UDoubleDot]gung stehenden Befehle gesucht \
werden.\nDurch Anklicken des Buttons \"The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Book\" kommen Sie in den Bereich des Help Browsers, der das komplette ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Handbuch enth\[ADoubleDot]lt. Die grau unterlegten K\[ADoubleDot]stchen \
enthalten nun das Inhaltsverzeichnis des Handbuchs.\nMeine Empfehlung: \
Spielen Sie sich ein bisschen mit dem Help Browser. Suchen Sie Befehle, \
klicken Sie herum und probieren Sie Dinge aus. Je besser Sie sich im Help \
Browser auskennen und mit ihm umgehen k\[ODoubleDot]nnen, desto seltener \
werden Sie Hilfe von Dritten ben\[ODoubleDot]tigen."
}], "Text",
  CellTags->"kap1"],

Cell[TextData[{
  StyleBox["BEMERKUNG",
    FontWeight->"Bold"],
  " zur Verwendung der verschiedenen Schriftarten im Help Browser und in \
diesem ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Kurs: In den Definitionsboxen und in der Hilfe zu den einzelnen Befehlen \
sind die Teile des Befehls, die wortw\[ODoubleDot]rtlich abgetippt werden m\
\[UDoubleDot]ssen in der Schriftart ",
  StyleBox["Courier New",
    FontFamily->"Courier New"],
  " gehalten. Die Teile, die vom Benutzer selbst bestimmt werden (also z.B. \
die konkreten Zahlen, mit denen gerechnet werden soll), werden durch \
Buchstaben oder Worte in der Schriftart ",
  StyleBox["Times New Roman kursiv",
    FontSlant->"Italic"],
  " symbolisiert."
}], "Text",
  CellTags->"kap1"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " stellt nat\[UDoubleDot]rlich auch wichtige Konstanten zur Verf\
\[UDoubleDot]gung. Die Zahl \[Pi] wird zum Beispiel mit ",
  StyleBox["Pi",
    FontFamily->"Courier New"],
  " aufgerufen, die Eulersche Zahl \[ExponentialE] mit ",
  StyleBox["E",
    FontFamily->"Courier New"],
  " (beachten Sie wieder die Schreibweise mit dem Gro\[SZ]buchstaben am \
Beginn!)."
}], "Text",
  CellTags->"kap1"],

Cell[TextData[{
  "Das hier berechnet den Sinus von ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\/3\)]],
  ". (Auch hier beginnt der Befehl wieder mit einem Gro\[SZ]buchstaben und \
das Argument steht in eckigen Klammern.)"
}], "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(Sin[Pi/3]\)], "Input",
  CellTags->"kap1"],

Cell[TextData[{
  StyleBox["BEMERKUNG",
    FontWeight->"Bold"],
  ": Befehle, die nur ein Argument verlangen, k\[ODoubleDot]nnen mit \"",
  StyleBox["//",
    FontFamily->"Courier New"],
  "\" auch nachgestellt werden. Dies ist der einzige Fall, in dem das \
Argument NICHT in eckigen Klammern steht. Hier zwei Beispiele:"
}], "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(7.81\ \ \  // Round\)], "Input",
  CellTags->"kap1"],

Cell[BoxData[
    \(Pi/3\ \ \  // Sin\)], "Input",
  CellTags->"kap1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Verwenden von fr\[UDoubleDot]heren Ergebnissen", "Section",
  CellTags->"kap1"],

Cell[TextData[{
  "Oft ben\[ODoubleDot]tigt man im Zuge seiner Berechnungen \
fr\[UDoubleDot]here Ergebnisse. In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " steht \"",
  StyleBox["%",
    FontFamily->"Courier New"],
  "\" immer f\[UDoubleDot]r den letzten Output."
}], "Text",
  CellTags->"kap1"],

Cell[TextData[{
  "Hier ist eine Berechnung mit dem Ergebnis ",
  StyleBox["7",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(2 + 5\)], "Input",
  CellTags->"kap1"],

Cell[TextData[{
  StyleBox["Hier addieren wir ",
    FontFamily->"Times New Roman"],
  StyleBox["1",
    FontFamily->"Courier New"],
  StyleBox[" zum letzten Ergebnis. ",
    FontFamily->"Times New Roman"],
  StyleBox["%",
    FontFamily->"Courier New"],
  " ruft dabei den letzten Output auf (hier also ",
  StyleBox["7",
    FontFamily->"Courier New"],
  " - vorausgesetzt Sie haben die obige Zeile gerade evaluiert)."
}], "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(% + 1\)], "Input",
  CellTags->"kap1"],

Cell[TextData[{
  StyleBox["%%",
    FontFamily->"Courier New"],
  " steht f\[UDoubleDot]r den vorletzten Output, ",
  StyleBox["%%%",
    FontFamily->"Courier New"],
  " f\[UDoubleDot]r den vorvorletzten usw."
}], "Text",
  CellTags->"kap1"],

Cell["\<\
In dieser Berechnung verwenden wir das letzte und das vorletzte Ergebnis.\
\>", "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(5*%% + %^2 - %%\)], "Input",
  CellTags->"kap1"],

Cell[TextData[{
  "Wir haben fr\[UDoubleDot]her schon festgestellt, dass ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " alle In- und Outputs durchnumeriert. Wir k\[ODoubleDot]nnen diese Nummern \
dazu verwenden, um die entsprechenden Outputs aufzurufen."
}], "Text",
  CellTags->"kap1"],

Cell["\<\
Hier werden der Output mit der Nummer 2 und der Output mir der Nummer 3 \
addiert (was auch immer diese waren...).\
\>", "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(%2 + %3\)], "Input",
  CellTags->"kap1"],

Cell[TextData[{
  "Statt ",
  StyleBox["%",
    FontFamily->"Courier New"],
  StyleBox["n",
    FontSlant->"Italic"],
  " kann man auch",
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["Out[",
    FontFamily->"Courier New"],
  StyleBox["n",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier New"],
  " schreiben. Den letzten Befehl k\[ODoubleDot]nnen wir also auch so \
schreiben:"
}], "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(Out[2] + Out[3]\)], "Input",
  CellTags->"kap1"],

Cell[BoxData[GridBox[{
        {"%", 
          RowBox[{"   ", 
            StyleBox[\(letzter\ Output\),
              FontFamily->"Times New Roman"]}]},
        {
          RowBox[{\(%% ... \), "%", " ", 
            RowBox[{"(", 
              RowBox[{
                StyleBox["k",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], " ", "Mal"}], ")"}]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["k",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["t",
                    FontFamily->"Times New Roman"]}]], 
              StyleBox["-",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["letzter",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Output",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        StyleBox["k",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"], 
                        StyleBox["ist",
                          FontFamily->"Times New Roman"], 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"], 
                        StyleBox["die",
                          FontFamily->"Times New Roman"], 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"], 
                        StyleBox["Anzahl",
                          FontFamily->"Times New Roman"], 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"], 
                        StyleBox["der",
                          FontFamily->"Times New Roman"], 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"], 
                        StyleBox["%",
                          FontFamily->"Courier New"], 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"], 
                        StyleBox["in",
                          FontFamily->"Times New Roman"], 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"], 
                        StyleBox["%%",
                          FontFamily->"Courier New"]}], 
                      StyleBox["...",
                        FontFamily->"Courier New"]}], 
                    StyleBox["%",
                      FontFamily->"Courier New"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}]}]}]},
        {
          RowBox[{
            RowBox[{"%", 
              StyleBox["n",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "  ", 
              StyleBox["oder",
                FontSlant->"Italic"]}], "\[IndentingNewLine]", 
            RowBox[{"Out", "[", 
              StyleBox["n",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "]"}]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["Output",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["mit",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["der",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Nummer",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["n",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"kap1"],

Cell[TextData[{
  StyleBox["ACHTUNG",
    FontWeight->"Bold"],
  ":\n1. Solange der Kernel aktiv ist, merkt er sich alle In- und Outputs, \
auch wenn der zugeh\[ODoubleDot]rige Text im Notebook \
\[UDoubleDot]berschrieben oder gel\[ODoubleDot]scht wurde.\n2. Die Numerieung \
der In- und Outputs beginnt bei jedem Neustart des Kernels wieder bei 1.\n3. \
Der Kernel kann \[UDoubleDot]ber den Men\[UDoubleDot]punkt \"Quit Kernel\" \
(Local) im Men\[UDoubleDot] \"Kernel\" deaktiviert werden. Alle bis dahin \
durchgef\[UDoubleDot]hrten Berechnungen, Definitionen etc. sind nun \
\"vergessen\" (d.h. unter anderem, dass bis dahin produzierte Outputs nicht \
mehr mit ",
  StyleBox["%",
    FontFamily->"Courier New"],
  StyleBox["n",
    FontSlant->"Italic"],
  " aufgerufen werden k\[ODoubleDot]nnen), auf den geschriebenen Text im \
Notebook hat das Deaktivieren des Kernels aber keinen Einfluss. Um den Kernel \
wieder zu starten, w\[ADoubleDot]hlt man entweder den Men\[UDoubleDot]punkt \
\"Start Kernel\" (Local) im Men\[UDoubleDot] \"Kernel\", oder man evaluiert \
einfach eine Input-Zelle. Die Numerierung der In- und Outputs startet wieder \
bei 1."
}], "Text",
  CellTags->"kap1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Exakte und approximative Rechenergebnisse; der Befehl ",
  StyleBox["N",
    FontFamily->"Courier New"]
}], "Section",
  CellTags->{"exakt", "kap1"}],

Cell[TextData[{
  "Mit herk\[ODoubleDot]mmlichen Taschenrechnern werden Berechnungen nur bis \
zu einer bestimmten (voher fest vorgegebenen) Genauigkeit durchgef\
\[UDoubleDot]hrt. Mit ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ist es m\[ODoubleDot]glich, exakt ( d.h. rundungsfehlerfrei) zu rechnen. \
Einzige Voraussetzung daf\[UDoubleDot]r ist, dass die Eingabe exakt ist (nach \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Ma\[SZ]stab). ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " h\[ADoubleDot]lt eine Eingabe dann f\[UDoubleDot]r exakt, wenn keine der \
eingegebenen Zahlen einen Dezimalpunkt enth\[ADoubleDot]lt."
}], "Text",
  CellTags->{"exakt", "kap1"}],

Cell[TextData[{
  "Hier ist eine exakte Eingabe. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " gibt daher auch ein exaktes Ergebnis aus, obwohl es 31 Stellen hat."
}], "Text",
  CellTags->{"exakt", "kap1"}],

Cell[BoxData[
    \(2^100\)], "Input",
  CellTags->{"exakt", "kap1"}],

Cell[TextData[{
  "Hier dieselbe Berechnung nocheinmal, doch diesmal versehen wie die Zahl ",
  StyleBox["2",
    FontFamily->"Courier New"],
  " mit einem Dezimalpunkt. Die Eingabe ist f\[UDoubleDot]r ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nicht mehr exakt, wir erhalten als Ergebnis daher nur einen \
N\[ADoubleDot]herungswert (in Gleitkommadarstellung)."
}], "Text",
  CellTags->{"exakt", "kap1"}],

Cell[BoxData[
    \(2. ^100\)], "Input",
  CellTags->{"exakt", "kap1"}],

Cell[TextData[{
  "Wir wollen nun einen N\[ADoubleDot]herungswert f\[UDoubleDot]r \[Pi]. \
Geben wir nur ",
  StyleBox["Pi",
    FontFamily->"Courier New"],
  " ein, so ist das f\[UDoubleDot]r ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " eine exakte Eingabe, und wir erhalten daher ein exaktes Ergebnis - n\
\[ADoubleDot]mlich \[Pi]."
}], "Text",
  CellTags->{"exakt", "kap1"}],

Cell[BoxData[
    \(Pi\)], "Input",
  CellTags->{"exakt", "kap1"}],

Cell[TextData[{
  "Mit Hilfe des Befehls ",
  StyleBox["N",
    FontFamily->"Courier New"],
  " k\[ODoubleDot]nnen wir ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " zwingen, eine numerische Approximation anstatt des exakten Ergebnisses \
auszugeben. Per default ist das Ergebnis auf sechs signifikante Stellen \
genau."
}], "Text",
  CellTags->{"exakt", "kap1"}],

Cell[BoxData[
    \(N[Pi]\)], "Input",
  CellTags->{"exakt", "kap1"}],

Cell[TextData[{
  "Eine Variante des Befehls ",
  StyleBox["N",
    FontFamily->"Courier New"],
  " erlaubt es, die Genauigkeit der Ausgabe zu ver\[ADoubleDot]ndern. Dazu \
geben wir die Anzahl der gew\[UDoubleDot]nschten signifikanten Stellen als \
zweites Argument an. "
}], "Text",
  CellTags->{"exakt", "kap1"}],

Cell["\<\
Hier ist die Zahl \[Pi] auf 20 signifikante Stellen genau.\
\>", "Text",
  CellTags->{"exakt", "kap1"}],

Cell[BoxData[
    \(N[Pi, 20]\)], "Input",
  CellTags->{"exakt", "kap1"}],

Cell[TextData[{
  StyleBox["BEMERKUNG",
    FontWeight->"Bold"],
  ": Versuchen Sie die obige Berechnung mit einer Anzahl von signifikanten \
Stellen zwischen 0 und 16 durchzuf\[UDoubleDot]hren. Es handelt sich hier \
offenbar um einen Fehler im Programm, der trotz hoher Versionszahl noch immer \
nicht ausgemerzt wurde. Ab 17 signifikanten Stellen gibt es keine Probleme \
mehr."
}], "Text",
  CellTags->{"exakt", "kap1"}],

Cell[BoxData[GridBox[{
        {
          RowBox[{"N", "[", 
            StyleBox["ausdruck",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["numerische",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Approximation",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["ausdruck",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox[\(auf\ 6\ signifikante\ Stellen\ genau\),
                FontFamily->"Times New Roman"]}]}]},
        {
          RowBox[{"N", "[", 
            RowBox[{
              StyleBox["ausdruck",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              StyleBox["n",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["numerische",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Approximation",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["ausdruck",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["auf",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["n",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["signifikante",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Stellen",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["genau",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->{"exakt", "kap1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Eingabe \[UDoubleDot]ber Paletten", "Section",
  CellTags->"kap1"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " gibt Ausdr\[UDoubleDot]cke in einer gut lesbaren Form aus, also z. B. ",
  Cell[BoxData[
      \(\[Pi]\/5\)]],
  " statt ",
  StyleBox["Pi",
    FontFamily->"Courier New"],
  StyleBox["/5",
    FontFamily->"Courier New"],
  ". Wir k\[ODoubleDot]nnen \[Pi], \[ExponentialE], Br\[UDoubleDot]che, \
Potenzen etc. entweder mit den \[UDoubleDot]blichen Symbolen \"",
  StyleBox["Pi",
    FontFamily->"Courier New"],
  "\", \"",
  StyleBox["E",
    FontFamily->"Courier New"],
  "\", \"",
  StyleBox["/",
    FontFamily->"Courier New"],
  "\", \"",
  StyleBox["^",
    FontFamily->"Courier New"],
  "\" etc. eingeben oder mit der Maus die entsprechenden Symbole aus einer \
sogenannten Palette ausw\[ADoubleDot]hlen. Die verschiedenen Paletten \
befinden sich im Punkt \"Palettes\" im Men\[UDoubleDot] \"File\"."
}], "Text",
  CellTags->"kap1"],

Cell["Eingabe mit den \"\[UDoubleDot]blichen\" Symbolen:", "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(Pi/5\)], "Input",
  CellTags->"kap1"],

Cell[TextData[{
  "Eingabe mit Hilfe der Palette BasicInput: Wir klicken zuerst auf den \
Button \"",
  Cell[BoxData[
      \(TraditionalForm\`\[Placeholder]\/\[Placeholder]\)]],
  "\" der Palette BasicInput. Im Notebook erscheint nun diese leere Struktur \
f\[UDoubleDot]r die Eingabe eines Bruchs. Im Z\[ADoubleDot]hler ist das K\
\[ADoubleDot]stchen schwarz, das bedeutet, dass alles, was jetzt auf der \
Tastatur getippt wird, im Z\[ADoubleDot]hler des Bruchs erscheinen wird. Wir \
klicken hier einfach auf den Button \"\[Pi]\", im Z\[ADoubleDot]hler \
erscheint das pi. Dann klicken wir auf das K\[ADoubleDot]stchen im Nenner, \
dieses wird nun schwarz. Jetzt k\[ODoubleDot]nnen wir die Zahl ",
  StyleBox["5",
    FontFamily->"Courier New"],
  " eintippen. Hier ist das Ergebnis:"
}], "Text",
  CellTags->"kap1"],

Cell[BoxData[
    \(\[Pi]\/5\)], "Input",
  CellTags->"kap1"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "kap1"->{
    Cell[4683, 122, 102, 2, 73, "Section",
      CellTags->"kap1"],
    Cell[4788, 126, 546, 14, 52, "Text",
      CellTags->"kap1"],
    Cell[5337, 142, 2803, 73, 186, "Text",
      CellTags->"kap1"],
    Cell[8477, 228, 485, 12, 52, "Text",
      CellTags->"kap1"],
    Cell[8965, 242, 58, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[9026, 246, 824, 24, 71, "Text",
      CellTags->"kap1"],
    Cell[9853, 272, 70, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[9926, 276, 625, 14, 71, "Text",
      CellTags->"kap1"],
    Cell[10554, 292, 58, 1, 33, "Text",
      CellTags->"kap1"],
    Cell[10615, 295, 57, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[10675, 299, 143, 6, 33, "Text",
      CellTags->"kap1"],
    Cell[10821, 307, 57, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[10881, 311, 4552, 129, 135, "Text",
      CellTags->"kap1"],
    Cell[16320, 468, 396, 7, 52, "Text",
      CellTags->"kap1"],
    Cell[16719, 477, 153, 4, 33, "Text",
      CellTags->"kap1"],
    Cell[16875, 483, 64, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[16976, 490, 136, 5, 43, "Section",
      CellTags->"kap1"],
    Cell[17115, 497, 597, 15, 52, "Text",
      CellTags->"kap1"],
    Cell[17715, 514, 305, 9, 33, "Text",
      CellTags->"kap1"],
    Cell[18023, 525, 64, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[18090, 529, 143, 5, 33, "Text",
      CellTags->"kap1"],
    Cell[18236, 536, 62, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[18301, 540, 312, 7, 33, "Text",
      CellTags->"kap1"],
    Cell[18616, 549, 73, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[18692, 553, 1759, 28, 185, "Text",
      CellTags->"kap1"],
    Cell[20454, 583, 760, 19, 71, "Text",
      CellTags->"kap1"],
    Cell[21217, 604, 466, 13, 52, "Text",
      CellTags->"kap1"],
    Cell[21686, 619, 260, 7, 36, "Text",
      CellTags->"kap1"],
    Cell[21949, 628, 62, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[22014, 632, 355, 9, 52, "Text",
      CellTags->"kap1"],
    Cell[22372, 643, 72, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[22447, 647, 70, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[22554, 654, 85, 1, 43, "Section",
      CellTags->"kap1"],
    Cell[22642, 657, 311, 10, 33, "Text",
      CellTags->"kap1"],
    Cell[22956, 669, 149, 6, 33, "Text",
      CellTags->"kap1"],
    Cell[23108, 677, 58, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[23169, 681, 452, 14, 33, "Text",
      CellTags->"kap1"],
    Cell[23624, 697, 58, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[23685, 701, 242, 8, 33, "Text",
      CellTags->"kap1"],
    Cell[23930, 711, 117, 3, 33, "Text",
      CellTags->"kap1"],
    Cell[24050, 716, 68, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[24121, 720, 298, 7, 33, "Text",
      CellTags->"kap1"],
    Cell[24422, 729, 158, 4, 33, "Text",
      CellTags->"kap1"],
    Cell[24583, 735, 60, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[24646, 739, 481, 19, 33, "Text",
      CellTags->"kap1"],
    Cell[25130, 760, 68, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[25201, 764, 4495, 112, 103, "Text",
      CellTags->"kap1"],
    Cell[29699, 878, 1187, 23, 147, "Text",
      CellTags->"kap1"],
    Cell[30923, 906, 168, 5, 44, "Section",
      CellTags->{"exakt", "kap1"}],
    Cell[31094, 913, 709, 17, 71, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[31806, 932, 219, 6, 33, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[32028, 940, 69, 2, 30, "Input",
      CellTags->{"exakt", "kap1"}],
    Cell[32100, 944, 420, 10, 52, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[32523, 956, 71, 2, 30, "Input",
      CellTags->{"exakt", "kap1"}],
    Cell[32597, 960, 391, 11, 33, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[32991, 973, 66, 2, 30, "Input",
      CellTags->{"exakt", "kap1"}],
    Cell[33060, 977, 375, 11, 52, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[33438, 990, 69, 2, 30, "Input",
      CellTags->{"exakt", "kap1"}],
    Cell[33510, 994, 315, 8, 33, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[33828, 1004, 113, 3, 33, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[33944, 1009, 73, 2, 30, "Input",
      CellTags->{"exakt", "kap1"}],
    Cell[34020, 1013, 424, 9, 52, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[34447, 1024, 3163, 81, 63, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[37647, 1110, 72, 1, 43, "Section",
      CellTags->"kap1"],
    Cell[37722, 1113, 910, 28, 55, "Text",
      CellTags->"kap1"],
    Cell[38635, 1143, 86, 1, 33, "Text",
      CellTags->"kap1"],
    Cell[38724, 1146, 57, 2, 30, "Input",
      CellTags->"kap1"],
    Cell[38784, 1150, 819, 16, 74, "Text",
      CellTags->"kap1"],
    Cell[39606, 1168, 61, 2, 40, "Input",
      CellTags->"kap1"]},
  "exakt"->{
    Cell[30923, 906, 168, 5, 44, "Section",
      CellTags->{"exakt", "kap1"}],
    Cell[31094, 913, 709, 17, 71, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[31806, 932, 219, 6, 33, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[32028, 940, 69, 2, 30, "Input",
      CellTags->{"exakt", "kap1"}],
    Cell[32100, 944, 420, 10, 52, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[32523, 956, 71, 2, 30, "Input",
      CellTags->{"exakt", "kap1"}],
    Cell[32597, 960, 391, 11, 33, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[32991, 973, 66, 2, 30, "Input",
      CellTags->{"exakt", "kap1"}],
    Cell[33060, 977, 375, 11, 52, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[33438, 990, 69, 2, 30, "Input",
      CellTags->{"exakt", "kap1"}],
    Cell[33510, 994, 315, 8, 33, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[33828, 1004, 113, 3, 33, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[33944, 1009, 73, 2, 30, "Input",
      CellTags->{"exakt", "kap1"}],
    Cell[34020, 1013, 424, 9, 52, "Text",
      CellTags->{"exakt", "kap1"}],
    Cell[34447, 1024, 3163, 81, 63, "Text",
      CellTags->{"exakt", "kap1"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"kap1", 40304, 1190},
  {"exakt", 45085, 1329}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 134, 4, 52, "Subtitle"],
Cell[1913, 59, 246, 7, 52, "Text"],
Cell[2162, 68, 16, 0, 33, "Text"],
Cell[2181, 70, 1087, 19, 128, "Text"],
Cell[3271, 91, 1172, 21, 147, "Text"],
Cell[4446, 114, 212, 4, 33, "Text"],

Cell[CellGroupData[{
Cell[4683, 122, 102, 2, 73, "Section",
  CellTags->"kap1"],
Cell[4788, 126, 546, 14, 52, "Text",
  CellTags->"kap1"],
Cell[5337, 142, 2803, 73, 186, "Text",
  CellTags->"kap1"],
Cell[8143, 217, 331, 9, 33, "Text"],
Cell[8477, 228, 485, 12, 52, "Text",
  CellTags->"kap1"],
Cell[8965, 242, 58, 2, 30, "Input",
  CellTags->"kap1"],
Cell[9026, 246, 824, 24, 71, "Text",
  CellTags->"kap1"],
Cell[9853, 272, 70, 2, 30, "Input",
  CellTags->"kap1"],
Cell[9926, 276, 625, 14, 71, "Text",
  CellTags->"kap1"],
Cell[10554, 292, 58, 1, 33, "Text",
  CellTags->"kap1"],
Cell[10615, 295, 57, 2, 30, "Input",
  CellTags->"kap1"],
Cell[10675, 299, 143, 6, 33, "Text",
  CellTags->"kap1"],
Cell[10821, 307, 57, 2, 30, "Input",
  CellTags->"kap1"],
Cell[10881, 311, 4552, 129, 135, "Text",
  CellTags->"kap1"],
Cell[15436, 442, 371, 6, 52, "Text"],
Cell[15810, 450, 120, 3, 70, "Input"],
Cell[15933, 455, 290, 6, 33, "Text"],
Cell[16226, 463, 91, 3, 70, "Input"],
Cell[16320, 468, 396, 7, 52, "Text",
  CellTags->"kap1"],
Cell[16719, 477, 153, 4, 33, "Text",
  CellTags->"kap1"],
Cell[16875, 483, 64, 2, 30, "Input",
  CellTags->"kap1"]
}, Closed]],

Cell[CellGroupData[{
Cell[16976, 490, 136, 5, 43, "Section",
  CellTags->"kap1"],
Cell[17115, 497, 597, 15, 52, "Text",
  CellTags->"kap1"],
Cell[17715, 514, 305, 9, 33, "Text",
  CellTags->"kap1"],
Cell[18023, 525, 64, 2, 30, "Input",
  CellTags->"kap1"],
Cell[18090, 529, 143, 5, 33, "Text",
  CellTags->"kap1"],
Cell[18236, 536, 62, 2, 30, "Input",
  CellTags->"kap1"],
Cell[18301, 540, 312, 7, 33, "Text",
  CellTags->"kap1"],
Cell[18616, 549, 73, 2, 30, "Input",
  CellTags->"kap1"],
Cell[18692, 553, 1759, 28, 185, "Text",
  CellTags->"kap1"],
Cell[20454, 583, 760, 19, 71, "Text",
  CellTags->"kap1"],
Cell[21217, 604, 466, 13, 52, "Text",
  CellTags->"kap1"],
Cell[21686, 619, 260, 7, 36, "Text",
  CellTags->"kap1"],
Cell[21949, 628, 62, 2, 30, "Input",
  CellTags->"kap1"],
Cell[22014, 632, 355, 9, 52, "Text",
  CellTags->"kap1"],
Cell[22372, 643, 72, 2, 30, "Input",
  CellTags->"kap1"],
Cell[22447, 647, 70, 2, 30, "Input",
  CellTags->"kap1"]
}, Closed]],

Cell[CellGroupData[{
Cell[22554, 654, 85, 1, 43, "Section",
  CellTags->"kap1"],
Cell[22642, 657, 311, 10, 33, "Text",
  CellTags->"kap1"],
Cell[22956, 669, 149, 6, 33, "Text",
  CellTags->"kap1"],
Cell[23108, 677, 58, 2, 30, "Input",
  CellTags->"kap1"],
Cell[23169, 681, 452, 14, 33, "Text",
  CellTags->"kap1"],
Cell[23624, 697, 58, 2, 30, "Input",
  CellTags->"kap1"],
Cell[23685, 701, 242, 8, 33, "Text",
  CellTags->"kap1"],
Cell[23930, 711, 117, 3, 33, "Text",
  CellTags->"kap1"],
Cell[24050, 716, 68, 2, 30, "Input",
  CellTags->"kap1"],
Cell[24121, 720, 298, 7, 33, "Text",
  CellTags->"kap1"],
Cell[24422, 729, 158, 4, 33, "Text",
  CellTags->"kap1"],
Cell[24583, 735, 60, 2, 30, "Input",
  CellTags->"kap1"],
Cell[24646, 739, 481, 19, 33, "Text",
  CellTags->"kap1"],
Cell[25130, 760, 68, 2, 30, "Input",
  CellTags->"kap1"],
Cell[25201, 764, 4495, 112, 103, "Text",
  CellTags->"kap1"],
Cell[29699, 878, 1187, 23, 147, "Text",
  CellTags->"kap1"]
}, Closed]],

Cell[CellGroupData[{
Cell[30923, 906, 168, 5, 44, "Section",
  CellTags->{"exakt", "kap1"}],
Cell[31094, 913, 709, 17, 71, "Text",
  CellTags->{"exakt", "kap1"}],
Cell[31806, 932, 219, 6, 33, "Text",
  CellTags->{"exakt", "kap1"}],
Cell[32028, 940, 69, 2, 30, "Input",
  CellTags->{"exakt", "kap1"}],
Cell[32100, 944, 420, 10, 52, "Text",
  CellTags->{"exakt", "kap1"}],
Cell[32523, 956, 71, 2, 30, "Input",
  CellTags->{"exakt", "kap1"}],
Cell[32597, 960, 391, 11, 33, "Text",
  CellTags->{"exakt", "kap1"}],
Cell[32991, 973, 66, 2, 30, "Input",
  CellTags->{"exakt", "kap1"}],
Cell[33060, 977, 375, 11, 52, "Text",
  CellTags->{"exakt", "kap1"}],
Cell[33438, 990, 69, 2, 30, "Input",
  CellTags->{"exakt", "kap1"}],
Cell[33510, 994, 315, 8, 33, "Text",
  CellTags->{"exakt", "kap1"}],
Cell[33828, 1004, 113, 3, 33, "Text",
  CellTags->{"exakt", "kap1"}],
Cell[33944, 1009, 73, 2, 30, "Input",
  CellTags->{"exakt", "kap1"}],
Cell[34020, 1013, 424, 9, 52, "Text",
  CellTags->{"exakt", "kap1"}],
Cell[34447, 1024, 3163, 81, 63, "Text",
  CellTags->{"exakt", "kap1"}]
}, Closed]],

Cell[CellGroupData[{
Cell[37647, 1110, 72, 1, 43, "Section",
  CellTags->"kap1"],
Cell[37722, 1113, 910, 28, 55, "Text",
  CellTags->"kap1"],
Cell[38635, 1143, 86, 1, 33, "Text",
  CellTags->"kap1"],
Cell[38724, 1146, 57, 2, 30, "Input",
  CellTags->"kap1"],
Cell[38784, 1150, 819, 16, 74, "Text",
  CellTags->"kap1"],
Cell[39606, 1168, 61, 2, 40, "Input",
  CellTags->"kap1"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

