(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     42218,       1248]*)
(*NotebookOutlinePosition[     42944,       1273]*)
(*  CellTagsIndexPosition[     42900,       1269]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["L\[ODoubleDot]sen von Gleichungen", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Der Vergleichsoperator ",
  StyleBox["==",
    FontFamily->"Courier New"]
}], "Section"],

Cell[TextData[{
  "Gleichungen werden in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " mit Hilfe des Vergleichsoperators ",
  StyleBox["==",
    FontFamily->"Courier New"],
  " eingegeben."
}], "Text"],

Cell[TextData[{
  "Die linke Seite wird hier automatisch ausgerechnet, der Vergleichsoperator \
",
  StyleBox["==",
    FontFamily->"Courier New"],
  " liefert ",
  StyleBox["True",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(1 + 1 \[Equal] 2\)], "Input"],

Cell[TextData[{
  "Diese Gleichung stimmt offensichtlich nicht, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " gibt ",
  StyleBox["False",
    FontFamily->"Courier New"],
  " aus."
}], "Text"],

Cell[BoxData[
    \(2 + 2 \[Equal] 5 + 3\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            StyleBox["ls",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "\[Equal]", 
            StyleBox["rs",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["gibt",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["True",
                  FontFamily->"Courier New"]}], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox[\(wenn\ ls\ und\ rs\ gleich\ sind\),
                FontFamily->"Times New Roman"], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["sonst",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["False",
                  FontFamily->"Courier New"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  "Eine h\[ADoubleDot]ufige Fehlerursache ist die Verwechslung des \
Vergleichsoperators ",
  StyleBox["==",
    FontFamily->"Courier New"],
  StyleBox[" mit dem Zuweisun",
    FontFamily->"Times New Roman"],
  "gsoperator ",
  StyleBox["=",
    FontFamily->"Courier New"],
  StyleBox[". Der Operator ",
    FontFamily->"Times New Roman"],
  StyleBox["==",
    FontFamily->"Courier New"],
  StyleBox[" vergleicht zwei Ausdr\[UDoubleDot]cke miteinander. Der Operator \
",
    FontFamily->"Times New Roman"],
  StyleBox["=",
    FontFamily->"Courier New"],
  StyleBox[" weist einer Variablen einen Wert zu (vgl. den Abschnitt ",
    FontFamily->"Times New Roman"],
  ButtonBox["Zuweisen und L\[ODoubleDot]schen",
    ButtonData:>{"variablen.nb", "zuweisen"},
    ButtonStyle->"Hyperlink"],
  StyleBox[" im Kapitel ",
    FontFamily->"Times New Roman"],
  ButtonBox["Variablen",
    ButtonData:>{"variablen.nb", None},
    ButtonStyle->"Hyperlink"],
  StyleBox[").",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[TextData[{
  "Hier ist eine Gleichung, von der ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nicht so ohne weiteres sagen kann, ob sie stimmt oder nicht."
}], "Text"],

Cell[BoxData[
    \(Sin[x]\^2 + Cos[x]\^2 \[Equal] 1\)], "Input"],

Cell[TextData[{
  "Wenden wir allerdings den Umformungsbefehl ",
  StyleBox["Simplify",
    FontFamily->"Courier New"],
  " auf die Gleichung an, so gibt ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["True",
    FontFamily->"Courier New"],
  " aus, denn die Gleichung stimmt, egal welche Werte ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " annimmt."
}], "Text"],

Cell[BoxData[
    \(Simplify[Sin[x]\^2 + Cos[x]\^2 \[Equal] 1]\)], "Input"],

Cell[TextData[{
  "Hier ist schlie\[SZ]lich eine Gleichung, deren Richtigkeit vom Wert ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " abh\[ADoubleDot]ngt. Um zu bestimmen, f\[UDoubleDot]r welche ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " die Gleichung erf\[UDoubleDot]llt ist, muss die Gleichung nach ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " aufgel\[ODoubleDot]st werden. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " l\[ADoubleDot]sst die Gleichung daher unver\[ADoubleDot]ndert stehen."
}], "Text"],

Cell[BoxData[
    \(x^2 \[Equal] 1\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            StyleBox["ls",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "\[Equal]", 
            StyleBox["rs",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{"   ", 
            StyleBox[\(repr\[ADoubleDot]sentiert\ eine\ Gleichung\),
              FontFamily->"Times New Roman"]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Der Befehl ",
  StyleBox["Solve",
    FontFamily->"Courier New"]
}], "Section"],

Cell["Gleichungen k\[ODoubleDot]nnen auch Variablen zugewiesen werden.", \
"Text"],

Cell[BoxData[
    \(gleichung = \((x^2 + 2  x - 15 \[Equal] 0)\)\)], "Input"],

Cell[TextData[{
  "Zur L\[ODoubleDot]sung von Gleichungen steht der Befehl ",
  StyleBox["Solve",
    FontFamily->"Courier New"],
  " zur Verf\[UDoubleDot]gung. Wir m\[UDoubleDot]ssen die Gleichung und die \
Unbekannte, nach der die Gleichung aufgel\[ODoubleDot]st werden soll, \
angeben."
}], "Text"],

Cell[BoxData[
    \(loesung = Solve[gleichung, x]\)], "Input"],

Cell[TextData[{
  "Die Ausgabe von ",
  StyleBox["Solve",
    FontFamily->"Courier New"],
  " ist eine Liste von Ersetzungsregeln. Die Anwendung von \"",
  StyleBox["/.",
    FontFamily->"Courier New"],
  "\" gibt eine Liste der L\[ODoubleDot]sungen (vgl. den Abschnitt ",
  ButtonBox["Substitution",
    ButtonData:>{"variablen.nb", "Substitution"},
    ButtonStyle->"Hyperlink"],
  " im Kapitel ",
  ButtonBox["Variablen",
    ButtonData:>{"variablen.nb", None},
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text"],

Cell[BoxData[
    \(x /. loesung\)], "Input"],

Cell["\<\
Durch Einsetzen in die Gleichung k\[ODoubleDot]nnen die L\[ODoubleDot]sungen \
\[UDoubleDot]berpr\[UDoubleDot]ft werden.\
\>", "Text"],

Cell[BoxData[
    \(Simplify[\ gleichung /. loesung]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Solve", "[", 
            RowBox[{
              StyleBox["gleichung",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["versucht",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["die",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Gleichung",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["gleichung",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox["nach",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["der",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Unbekannten",
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[
                RowBox[{
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], " "}]], 
              StyleBox["zu",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["l\[ODoubleDot]sen",
                FontFamily->"Times New Roman"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[BoxData[
    \(Clear[gleichung, loesung]\)], "Input"],

Cell["\<\
Die zu l\[ODoubleDot]sende Gleichung kann auch Formvariablem enthalten. Hier \
erhalten wir die \"gro\[SZ]e L\[ODoubleDot]sungsformel\" f\[UDoubleDot]r \
quadratische Gleichungen.\
\>", "Text"],

Cell[BoxData[
    \(Solve[a*x^2 + b*x + c \[Equal] 0, x]\)], "Input"],

Cell[TextData[{
  StyleBox["Solve",
    FontFamily->"Courier New"],
  " kann auch Gleichungssysteme l\[ODoubleDot]sen. Dazu werden die \
Gleichungen und die Unbekannten, nach denen das Gleichungssystem aufgel\
\[ODoubleDot]st werden soll, in zwei separaten Listen eingegeben."
}], "Text"],

Cell[BoxData[
    \(Solve[{x^2 - y^2 \[Equal] 2, x \[Equal] y + 1}, {x, y}]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Solve", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["gl",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["x",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[\(x\_m\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["versucht",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["das",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Gleichungssystem",
                    FontFamily->"Times New Roman"], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], " "}]], 
                  StyleBox[
                    SubscriptBox["gl", 
                      StyleBox["1",
                        FontSlant->"Plain"]],
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[" ",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], " "}]], 
                  StyleBox["nach",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["den",
                    FontFamily->"Times New Roman"]}]}], "\[IndentingNewLine]",
               " ", 
              RowBox[{
                RowBox[{
                  StyleBox["Unbekannten",
                    FontFamily->"Times New Roman"], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], " "}]], 
                  StyleBox[
                    SubscriptBox[
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  RowBox[{
                    SubscriptBox[
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox["m",
                        FontSlant->"Italic"]], "  ", "zu", " ", 
                    "l\[ODoubleDot]sen"}],
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  StyleBox["Solve",
    FontFamily->"Courier New"],
  " kann nicht immer explizite L\[ODoubleDot]sungen von Polynomen angeben. In \
einem solchen Fall liefert ",
  StyleBox["Solve",
    FontFamily->"Courier New"],
  " eine symbolische Repr\[ADoubleDot]sentation der L\[ODoubleDot]sung in \
Form eines ",
  StyleBox["Root",
    FontFamily->"Courier New"],
  "-Objektes."
}], "Text"],

Cell[BoxData[
    \(Solve[x^5 + x^4 - 7  x^3 + 6 \[Equal] 0, x]\)], "Input"],

Cell[TextData[{
  "Um solche L\[ODoubleDot]sungen zu \"sehen\" m\[UDoubleDot]ssen sie mit ",
  StyleBox["N",
    FontFamily->"Courier New"],
  " numerisch ausgewertet werden."
}], "Text"],

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["NSolve",
    FontFamily->"Courier New"],
  " (selbe Syntax wie ",
  StyleBox["Solve",
    FontFamily->"Courier New"],
  ") gibt gleich eine numerische Approximation der L\[ODoubleDot]sungen an."
}], "Text"],

Cell[BoxData[
    \(NSolve[x^5 + x^4 - 7  x^3 + 6 \[Equal] 0, x]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"NSolve", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["gl",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["x",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", 
                  RowBox[{"...", 
                    StyleBox[\(x\_m\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox[\(liefert\ dasselbe\ Ergebnis\ wie\),
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
              RowBox[{
                RowBox[{
                  StyleBox["N",
                    FontFamily->"Courier New"], 
                  StyleBox["[",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox["Solve",
                      FontFamily->"Courier New"], 
                    StyleBox["[",
                      FontFamily->"Courier New"], 
                    RowBox[{
                      StyleBox[
                        RowBox[{"{", 
                          RowBox[{
                            StyleBox[
                              SubscriptBox[
                                StyleBox["gl",
                                  FontSlant->"Italic"], "1"],
                              FontFamily->"Times New Roman"], ",", "...", ",",
                             
                            StyleBox[\(gl\_n\),
                              FontFamily->"Times New Roman",
                              FontSlant->"Italic"]}], "}"}],
                        FontFamily->"Courier New"], 
                      StyleBox[",",
                        FontFamily->"Courier New"], 
                      RowBox[{
                        StyleBox["{",
                          FontFamily->"Courier New"], 
                        RowBox[{
                          StyleBox[
                            SubscriptBox[
                              StyleBox["x",
                                FontSlant->"Italic"], "1"],
                            FontFamily->"Times New Roman"], 
                          StyleBox[",",
                            FontFamily->"Courier New"], 
                          StyleBox["...",
                            FontFamily->"Courier New"], 
                          StyleBox[",",
                            FontFamily->"Courier New"], 
                          StyleBox[\(x\_m\),
                            FontFamily->"Times New Roman",
                            FontSlant->"Italic"]}], 
                        StyleBox["}",
                          FontFamily->"Courier New"]}]}], 
                    StyleBox["]",
                      FontFamily->"Courier New"]}], 
                  StyleBox["]",
                    FontFamily->"Courier New"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
                
                StyleBox[\(bis\ auf\ die\ numerische\ Genauigkeit\),
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["Solve",
    FontFamily->"Courier New"],
  " ist haupts\[ADoubleDot]chlich f\[UDoubleDot]r lineare und polynomiale \
Gleichungen bzw. Gleichungssysteme geeignet. Gleichungen anderer Art sind von \
",
  StyleBox["Solve",
    FontFamily->"Courier New"],
  " nur l\[ODoubleDot]sbar, wenn sie sehr einfach sind. Es werden dann auch \
nicht immer alle L\[ODoubleDot]sungen ermittelt. ",
  StyleBox["Solve",
    FontFamily->"Courier New"],
  " gibt hier eine Warnung aus."
}], "Text"],

Cell[BoxData[
    \(Solve[Sin[x] == 1\/2, x]\)], "Input"],

Cell[TextData[{
  "Der ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  " von ",
  StyleBox["Sin[x]",
    FontFamily->"Courier New"],
  " und ",
  Cell[BoxData[
      \(TraditionalForm\`1\/2\)], "Input",
    FontFamily->"Courier New"],
  " zeigt, dass ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\/6\)]],
  " nicht die einzige L\[ODoubleDot]sung der Gleichung sin(",
  StyleBox["x",
    FontSlant->"Italic"],
  ")=",
  Cell[BoxData[
      \(TraditionalForm\`1\/2\)]],
  " ist."
}], "Text"],

Cell[BoxData[
    \(Plot[{Sin[x], 1/2}, {x, \(-10\), 10}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Der Befehl ",
  StyleBox["FindRoot",
    FontFamily->"Courier New"]
}], "Section"],

Cell[TextData[{
  "Die folgende Gleichung kann ",
  StyleBox["Solve",
    FontFamily->"Courier New"],
  " nicht mehr L\[ODoubleDot]sen."
}], "Text"],

Cell[BoxData[
    \(Solve[Sin[2  x] \[Equal] x, x]\)], "Input"],

Cell[TextData[{
  "Auch ",
  StyleBox["NSolve",
    FontFamily->"Courier New"],
  " hat keinen Erfolg."
}], "Text"],

Cell[BoxData[
    \(NSolve[Sin[2  x] \[Equal] x, x]\)], "Input"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["FindRoot",
    FontFamily->"Courier New"],
  " verwendet (unter anderen) das Newton'sche N\[ADoubleDot]herungsverfahren, \
um EINE L\[ODoubleDot]sung der Gleichung numerisch zu approximieren. Es muss \
die Gleichung, der Name der Unbekannten und ein Startwert angegeben werden."
}], "Text"],

Cell[TextData[{
  StyleBox["FindRoot",
    FontFamily->"Courier New"],
  " findet zu unserer Gleichung eine L\[ODoubleDot]sung."
}], "Text"],

Cell[BoxData[
    \(FindRoot[Sin[2  x] \[Equal] x, {x, 1}]\)], "Input"],

Cell["Andere Startwerte k\[ODoubleDot]nnen andere L\[ODoubleDot]sungen \
liefern.", "Text"],

Cell[BoxData[
    \(FindRoot[Sin[2  x] \[Equal] x, {x, \(-1\)}]\)], "Input"],

Cell[TextData[{
  "F\[UDoubleDot]r den Startwert 0.1 liefert ",
  StyleBox["FindRoot",
    FontFamily->"Courier New"],
  " eine numerische Approximation von 0."
}], "Text"],

Cell[BoxData[
    \(FindRoot[Sin[2  x] \[Equal] x, {x, 0.1}]\)], "Input"],

Cell[TextData[{
  "Ein ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  " von ",
  StyleBox["Sin[2x]",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " zeigt, dass das alle L\[ODoubleDot]sungen sind."
}], "Text"],

Cell[BoxData[
    \(Plot[{Sin[2  x], x}, {x, \(-2\), 2}]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"FindRoot", "[", 
            RowBox[{
              RowBox[{
                StyleBox["ls",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "\[Equal]", 
                StyleBox["rs",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox[
                    SubscriptBox[
                      StyleBox["x",
                        FontSlant->"Italic"], "0"],
                    FontFamily->"Times New Roman"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              
              StyleBox[\(sucht\ nach\ einer\ numerischen\ Approximation\ \
einer\ L\[ODoubleDot]sung\ der\ Gleichung\),
                FontFamily->"Times New Roman"], " ", "\[IndentingNewLine]", 
              " ", 
              RowBox[{
                RowBox[{
                  StyleBox["ls",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["\[Equal]",
                    FontFamily->"Courier New"], 
                  RowBox[{
                    StyleBox["rs",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[
                      RowBox[{" ", 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"]}]], 
                    StyleBox["in",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["der",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["Unbekannten",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  RowBox[{
                  "Startwert", " ", "des", " ", 
                    "N\[ADoubleDot]herungsverfahrens", " ", "ist", " ", 
                    SubscriptBox[
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "0"]}],
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  StyleBox["FindRoot",
    FontFamily->"Courier New"],
  " kann auch L\[ODoubleDot]sungen zu Gleichungssystemen ermitteln. F\
\[UDoubleDot]r jede Unbekannte muss ein Startwert angegeben werden."
}], "Text"],

Cell[BoxData[
    \(FindRoot[{Sin[x] \[Equal] y, x \[Equal] y - 5}, {x, 1}, {y, 
        1}]\)], "Input"],

Cell["\<\
Nicht jeder Startwert bzw. jede Kombination von Startwerten muss zu einer L\
\[ODoubleDot]sung f\[UDoubleDot]hren.\
\>", "Text"],

Cell[BoxData[
    \(FindRoot[{Sin[x] \[Equal] y, x \[Equal] y - 5}, {x, 0}, {y, 
        1}]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"FindRoot", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["gl",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}], ",", "\[IndentingNewLine]",
               
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["x",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", 
                  StyleBox[
                    SubscriptBox[
                      StyleBox["start",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"]}], "}"}], ",", "...", ",", 
              
              RowBox[{"{", 
                RowBox[{
                  StyleBox[\(x\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox[\(start\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              
              StyleBox[\(sucht\ nach\ einer\ numerischen\ Approximation\ \
einer\ L\[ODoubleDot]sung\ des\),
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["\[IndentingNewLine]",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox[
                  RowBox[{"Gleichungssystems", " ", 
                    SubscriptBox[
                      StyleBox["gl",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"]}],
                  FontFamily->"Times New Roman"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["in",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["den",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Unbekannten",
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox["\[IndentingNewLine]",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox[
                  SubscriptBox[
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "1"],
                  FontFamily->"Times New Roman"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  SubscriptBox[
                    StyleBox["x",
                      FontSlant->"Italic"], 
                    StyleBox["n",
                      FontSlant->"Italic"]],
                  FontFamily->"Times New Roman"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["Startwert",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["von",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[\(x\_i\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["ist",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[\(start\_i\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Der Befehl ",
  StyleBox["Reduce",
    FontFamily->"Courier New"]
}], "Section"],

Cell[TextData[{
  StyleBox["Solve",
    FontFamily->"Courier New"],
  " vernachl\[ADoubleDot]ssigt L\[ODoubleDot]sungen, die nur existieren, wenn \
die Parameter der Gleichung bestimmte Bedingungen erf\[UDoubleDot]llen. So \
wird der Fall ",
  StyleBox["a",
    FontSlant->"Italic"],
  "=",
  StyleBox["b",
    FontSlant->"Italic"],
  "=0 im folgenden Fall nicht ber\[UDoubleDot]cksichtigt."
}], "Text"],

Cell[BoxData[
    \(Solve[a*x \[Equal] b, x]\)], "Input"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["Reduce",
    FontFamily->"Courier New"],
  " (selbe Syntax wie ",
  StyleBox["Solve",
    FontFamily->"Courier New"],
  ") beachtet alle M\[ODoubleDot]glichkeiten. Der Output von ",
  StyleBox["Reduce",
    FontFamily->"Courier New"],
  " ist ein vereinfachter logischer Ausdruck. ",
  StyleBox["&&",
    FontFamily->"Courier New"],
  " ist das logische UND, ",
  StyleBox["||",
    FontFamily->"Courier New"],
  " das logische ODER. Der Output des folgenden Beispiels bedeutet also \
Folgendes: Die Gleichung ist erf\[UDoubleDot]llt, wenn ",
  StyleBox["a",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["b",
    FontFamily->"Courier New"],
  " Null sind, oder wenn ",
  StyleBox["x",
    FontFamily->"Courier New"],
  "=",
  Cell[BoxData[
      FormBox[
        FractionBox[
          StyleBox["b",
            FontSlant->"Plain"], 
          StyleBox["a",
            FontSlant->"Plain"]], TraditionalForm]],
    FontFamily->"Courier New"],
  " und gleichzeitig ",
  StyleBox["a",
    FontFamily->"Courier New"],
  " ungleich Null ist."
}], "Text"],

Cell[BoxData[
    \(Reduce[a*x \[Equal] b, x]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Reduce", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["gl",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["x",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[\(x\_m\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["versucht",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["das",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Gleichungssystem",
                    FontFamily->"Times New Roman"], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], " "}]], 
                  StyleBox[
                    SubscriptBox["gl", 
                      StyleBox["1",
                        FontSlant->"Plain"]],
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[" ",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], " "}]], 
                  StyleBox["nach",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["den",
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                RowBox[{
                  StyleBox["Unbekannten",
                    FontFamily->"Times New Roman"], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], " "}]], 
                  StyleBox[
                    SubscriptBox[
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  RowBox[{
                    SubscriptBox[
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox["m",
                        FontSlant->"Italic"]], "  ", 
                    "aufzul\[ODoubleDot]sen"}],
                  FontFamily->"Times New Roman"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(indem\ die\),
                  FontFamily->"Times New Roman"]}], 
              StyleBox["\[IndentingNewLine]",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox[\(Gleichungen\ vereinfacht\ werden\),
                  FontFamily->"Times New Roman"], 
                StyleBox[";",
                  FontFamily->"Times New Roman"], " ", 
                RowBox[{
                  StyleBox[
                    RowBox[{"d", 
                      StyleBox["ie",
                        FontFamily->"Times New Roman"]}]], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["von",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Reduce",
                    FontFamily->"Courier New"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["erzeugten",
                    FontFamily->"Times New Roman"]}]}], "\[IndentingNewLine]",
               
              
              StyleBox[\(Gleichungen\ sind\ \[ADoubleDot]quivalent\ zu\ den\ \
Gleichungen\),
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox[
                  SubscriptBox["gl", 
                    StyleBox["1",
                      FontSlant->"Plain"]],
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[" ",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["und",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["beinhalten",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["alle",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["L\[ODoubleDot]sungen",
                    FontFamily->"Times New Roman"]}]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell["Noch ein Beispiel:", "Text"],

Cell[TextData[{
  StyleBox["Solve",
    FontFamily->"Courier New"],
  " liefert hier keine L\[ODoubleDot]sung."
}], "Text"],

Cell[BoxData[
    \(Solve[{x \[Equal] 1, x \[Equal] a}, x]\)], "Input"],

Cell[TextData[{
  StyleBox["Reduce",
    FontFamily->"Courier New"],
  " ber\[UDoubleDot]cksichtigt auch den Fall ",
  StyleBox["a",
    FontSlant->"Italic"],
  "=1."
}], "Text"],

Cell[BoxData[
    \(Reduce[{x \[Equal] 1, x \[Equal] a}, x]\)], "Input"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 53, 0, 51, "Subtitle"],
Cell[1832, 55, 246, 7, 52, "Text"],

Cell[CellGroupData[{
Cell[2103, 66, 107, 4, 74, "Section"],
Cell[2213, 72, 214, 8, 33, "Text"],
Cell[2430, 82, 231, 9, 33, "Text"],
Cell[2664, 93, 49, 1, 30, "Input"],
Cell[2716, 96, 204, 8, 33, "Text"],
Cell[2923, 106, 53, 1, 30, "Input"],
Cell[2979, 109, 1425, 38, 48, "Text"],
Cell[4407, 149, 1026, 31, 52, "Text"],
Cell[5436, 182, 184, 5, 33, "Text"],
Cell[5623, 189, 65, 1, 30, "Input"],
Cell[5691, 192, 397, 14, 33, "Text"],
Cell[6091, 208, 75, 1, 31, "Input"],
Cell[6169, 211, 547, 14, 52, "Text"],
Cell[6719, 227, 47, 1, 30, "Input"],
Cell[6769, 230, 559, 15, 48, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[7365, 250, 98, 4, 44, "Section"],
Cell[7466, 256, 82, 1, 33, "Text"],
Cell[7551, 259, 77, 1, 30, "Input"],
Cell[7631, 262, 301, 7, 33, "Text"],
Cell[7935, 271, 62, 1, 30, "Input"],
Cell[8000, 274, 514, 16, 33, "Text"],
Cell[8517, 292, 45, 1, 30, "Input"],
Cell[8565, 295, 144, 3, 33, "Text"],
Cell[8712, 300, 65, 1, 30, "Input"],
Cell[8780, 303, 2216, 58, 48, "Text"],
Cell[10999, 363, 58, 1, 30, "Input"],
Cell[11060, 366, 203, 4, 33, "Text"],
Cell[11266, 372, 69, 1, 30, "Input"],
Cell[11338, 375, 288, 6, 33, "Text"],
Cell[11629, 383, 88, 1, 30, "Input"],
Cell[11720, 386, 4257, 106, 67, "Text"],
Cell[15980, 494, 397, 12, 33, "Text"],
Cell[16380, 508, 76, 1, 30, "Input"],
Cell[16459, 511, 187, 5, 33, "Text"],
Cell[16649, 518, 37, 1, 30, "Input"],
Cell[16689, 521, 251, 8, 33, "Text"],
Cell[16943, 531, 77, 1, 30, "Input"],
Cell[17023, 534, 3802, 88, 85, "Text"],
Cell[20828, 624, 522, 14, 52, "Text"],
Cell[21353, 640, 57, 1, 42, "Input"],
Cell[21413, 643, 501, 21, 36, "Text"],
Cell[21917, 666, 70, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[22024, 672, 101, 4, 44, "Section"],
Cell[22128, 678, 148, 5, 33, "Text"],
Cell[22279, 685, 63, 1, 30, "Input"],
Cell[22345, 688, 115, 5, 33, "Text"],
Cell[22463, 695, 64, 1, 30, "Input"],
Cell[22530, 698, 335, 7, 52, "Text"],
Cell[22868, 707, 140, 4, 33, "Text"],
Cell[23011, 713, 71, 1, 30, "Input"],
Cell[23085, 716, 91, 1, 33, "Text"],
Cell[23179, 719, 76, 1, 30, "Input"],
Cell[23258, 722, 172, 5, 33, "Text"],
Cell[23433, 729, 73, 1, 30, "Input"],
Cell[23509, 732, 265, 11, 33, "Text"],
Cell[23777, 745, 69, 1, 30, "Input"],
Cell[23849, 748, 3034, 74, 67, "Text"],
Cell[26886, 824, 222, 5, 33, "Text"],
Cell[27111, 831, 105, 2, 30, "Input"],
Cell[27219, 835, 138, 3, 33, "Text"],
Cell[27360, 840, 105, 2, 30, "Input"],
Cell[27468, 844, 5120, 126, 85, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[32625, 975, 99, 4, 44, "Section"],
Cell[32727, 981, 403, 12, 33, "Text"],
Cell[33133, 995, 57, 1, 30, "Input"],
Cell[33193, 998, 1104, 39, 55, "Text"],
Cell[34300, 1039, 58, 1, 30, "Input"],
Cell[34361, 1042, 7336, 179, 125, "Text"],
Cell[41700, 1223, 34, 0, 33, "Text"],
Cell[41737, 1225, 123, 4, 33, "Text"],
Cell[41863, 1231, 71, 1, 30, "Input"],
Cell[41937, 1234, 178, 7, 33, "Text"],
Cell[42118, 1243, 72, 1, 30, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

