(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14497,        434]*)
(*NotebookOutlinePosition[     15161,        457]*)
(*  CellTagsIndexPosition[     15117,        453]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Grenzwertberechnungen bei Funktionen", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell["", "Text"],

Cell[TextData[{
  "Betrachten wir die Folge ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          RowBox[{"(", " ", 
            RowBox[{"sin", "(", " ", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{"n", "+", 
                    FormBox[\(1\/n\),
                      "TraditionalForm"]}], ")"}], " ", "\[Pi]"}], " ", ")"}],
             " ", ")"}], \(n \[Element] \[DoubleStruckCapitalN]\)], 
        TraditionalForm]]],
  ". Der Grenzwert dieser Folge ist 0. Das Ergebnis, das uns ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " liefert, ist aber ein anderes:"
}], "Text"],

Cell[BoxData[
    \(Limit[Sin[\((n + 1\/n)\)*\[Pi]], n \[Rule] Infinity]\)], "Input"],

Cell[TextData[{
  "Der Grund hierf\[UDoubleDot]r ist, dass ",
  StyleBox["Limit",
    FontFamily->"Courier New"],
  " nicht annimmt, dass die ",
  StyleBox["n",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  " nat\[UDoubleDot]rliche Zahlen sind. ",
  StyleBox["Limit",
    FontFamily->"Courier New"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "versucht also nicht, den Grenzwert der FOLGE ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          RowBox[{"(", " ", 
            RowBox[{"sin", "(", " ", 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{"n", "+", 
                    FormBox[\(1\/n\),
                      "TraditionalForm"]}], ")"}], " ", "\[Pi]"}], " ", ")"}],
             " ", ")"}], \(n \[Element] \[DoubleStruckCapitalN]\)], 
        TraditionalForm]]],
  " zu berechnen, sondern vielmehr den Grenzwert der FUNKTION  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " : \[DoubleStruckCapitalR] \[Rule] \[DoubleStruckCapitalR], ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(n)\), ":=", 
          RowBox[{"sin", "(", " ", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{"n", "+", 
                  FormBox[\(1\/n\),
                    "TraditionalForm"]}], ")"}], " ", "\[Pi]"}], " ", ")"}]}],
         TraditionalForm]]],
  " f\[UDoubleDot]r ",
  StyleBox["n",
    FontSlant->"Italic"],
  " gegen \[Infinity].\nF\[UDoubleDot]r diese Funktion existiert nat\
\[UDoubleDot]rlich kein Grenzwert f\[UDoubleDot]r ",
  StyleBox["n",
    FontSlant->"Italic"],
  " gegen \[Infinity], das Schwanken der Funktionswerte ist aber auf das \
Intervall [-1, 1] begrenzt. In einem solchen Fall liefert ",
  StyleBox["Limit",
    FontFamily->"Courier New"],
  " ein sogenanntes ",
  StyleBox["Interval",
    FontFamily->"Courier New"],
  "-Objekt (wie wir oben gesehen haben)."
}], "Text"],

Cell[TextData[{
  "Hier ist der ",
  "Graph",
  " der Funktion ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(n)\), ":=", 
          RowBox[{"sin", "(", " ", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{"n", "+", 
                  FormBox[\(1\/n\),
                    "TraditionalForm"]}], ")"}], " ", "\[Pi]"}], " ", ")"}]}],
         TraditionalForm]]],
  " im Intervall [0, 20]."
}], "Text"],

Cell[BoxData[
    \(Plot[Sin[\((n + 1\/n)\)*\[Pi]], {n, 0, 20}]\)], "Input"],

Cell[TextData[{
  StyleBox["Limit",
    FontFamily->"Courier New"],
  " berechnet nicht nur Grenzwerte von Funktionen  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  in ",
  StyleBox["x",
    FontSlant->"Italic"],
  " f\[UDoubleDot]r ",
  StyleBox["x",
    FontSlant->"Italic"],
  " \[Rule] \[Infinity]."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Limit", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{
                StyleBox["x",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "\[Rule]", 
                StyleBox[
                  SubscriptBox[
                    StyleBox["x",
                      FontSlant->"Italic"], "0"],
                  FontFamily->"Times New Roman"]}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["findet",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["den",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Grenzwert",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["wenn",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["x",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{
                    StyleBox[" ",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"]}]], 
                StyleBox["gegen",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  SubscriptBox[
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "0"],
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["geht",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell["In diesem Fall ist der Grenzwert 1.", "Text"],

Cell[BoxData[
    \(Limit[Sin[x]\/x, x \[Rule] 0]\)], "Input"],

Cell[BoxData[
    \(Plot[Sin[x]/x, {x, \(-10\), 10}]\)], "Input"],

Cell[TextData[{
  "Manche Funktionen haben verschiedene Grenzwerte in bestimmten Punkten, abh\
\[ADoubleDot]ngig aus welcher Richtung man sich diesen Punkten \
n\[ADoubleDot]hert. Mit der Option ",
  StyleBox["Direction",
    FontFamily->"Courier New"],
  " l\[ADoubleDot]sst sich die Richtung spezifizieren."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Limit", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{
                StyleBox["x",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "\[Rule]", 
                StyleBox[
                  SubscriptBox[
                    StyleBox["x",
                      FontSlant->"Italic"], "0"],
                  FontFamily->"Times New Roman"]}], 
              ",", \(Direction \[Rule] 1\)}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[
                RowBox[{
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], " "}]], 
              StyleBox["n\[ADoubleDot]hert",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["sich",
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox[
                SubscriptBox[
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], "0"],
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["von",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["links",
                FontFamily->"Times New Roman"]}]}]},
        {
          RowBox[{"Limit", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{
                StyleBox["x",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "\[Rule]", 
                StyleBox[
                  SubscriptBox[
                    StyleBox["x",
                      FontSlant->"Italic"], "0"],
                  FontFamily->"Times New Roman"]}], 
              ",", \(Direction \[Rule] \(-1\)\)}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["n\[ADoubleDot]hert",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["sich",
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox[
                SubscriptBox[
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], "0"],
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["von",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["rechts",
                FontFamily->"Times New Roman"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  StyleBox["x",
    FontSlant->"Italic"],
  " n\[ADoubleDot]hert sich von links."
}], "Text"],

Cell[BoxData[
    \(Limit[Sign[x], x \[Rule] 0, Direction \[Rule] 1]\)], "Input"],

Cell[TextData[{
  StyleBox["x",
    FontSlant->"Italic"],
  " n\[ADoubleDot]hert sich von rechts."
}], "Text"],

Cell[BoxData[
    \(Limit[Sign[x], x \[Rule] 0, Direction \[Rule] \(-1\)]\)], "Input"],

Cell[TextData[{
  "Per Default n\[ADoubleDot]hert sich ",
  StyleBox["x",
    FontSlant->"Italic"],
  " von rechts."
}], "Text"],

Cell[BoxData[
    \(Limit[Sign[x], x \[Rule] 0]\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 56, 0, 51, "Subtitle"],
Cell[1835, 55, 246, 7, 52, "Text"],
Cell[2084, 64, 16, 0, 33, "Text"],
Cell[2103, 66, 634, 18, 37, "Text"],
Cell[2740, 86, 85, 1, 42, "Input"],
Cell[2828, 89, 1885, 55, 97, "Text"],
Cell[4716, 146, 432, 15, 36, "Text"],
Cell[5151, 163, 76, 1, 42, "Input"],
Cell[5230, 166, 319, 13, 33, "Text"],
Cell[5552, 181, 3477, 89, 48, "Text"],
Cell[9032, 272, 51, 0, 33, "Text"],
Cell[9086, 274, 62, 1, 42, "Input"],
Cell[9151, 277, 65, 1, 30, "Input"],
Cell[9219, 280, 321, 7, 52, "Text"],
Cell[9543, 289, 4346, 114, 63, "Text"],
Cell[13892, 405, 109, 4, 33, "Text"],
Cell[14004, 411, 81, 1, 30, "Input"],
Cell[14088, 414, 110, 4, 33, "Text"],
Cell[14201, 420, 86, 1, 30, "Input"],
Cell[14290, 423, 128, 5, 33, "Text"],
Cell[14421, 430, 60, 1, 30, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

