(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     82270,       2512]*)
(*NotebookOutlinePosition[     91815,       2781]*)
(*  CellTagsIndexPosition[     91577,       2770]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Funktionen", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell[CellGroupData[{

Cell["Eingebaute mathematische Funktionen", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " stellt eine Vielzahl von mathematischen Funktionen zur \
Verf\[UDoubleDot]gung. So wie bei allen anderen ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Befehlen beginnen auch die Namen der eingebauten mathematischen \
Funktionen alle mit einem Gro\[SZ]buchstaben, die Argumente stehen in eckigen \
Klammern."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Sqrt", "[", 
            StyleBox["x",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["Quadratwurzel",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["aus",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox["   ",
                FontFamily->"Times New Roman"], 
              StyleBox[
                RowBox[{"(", 
                  SqrtBox[
                    StyleBox["x",
                      FontSlant->"Italic"]], ")"}],
                FontFamily->"Times New Roman"]}]}]},
        {
          RowBox[{
            RowBox[{"Sin", "[", 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "]"}], ",", 
            RowBox[{"Cos", "[", 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "]"}], ",", 
            RowBox[{"Tan", "[", 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "]"}]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["Sinus",
                FontFamily->"Times New Roman"], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["Cosinus",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["und",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Tangens",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["x",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["   ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["im",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["Bogenma\[SZ]",
                      FontFamily->"Times New Roman"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}]}]}]},
        {
          RowBox[{
            RowBox[{"ArcSin", "[", 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "]"}], ",", 
            RowBox[{"ArcCos", "[", 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "]"}], ",", 
            RowBox[{"ArcTan", "[", 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "]"}]}], 
          RowBox[{"   ", 
            StyleBox[\(inverse\ trigonometrische\ Funktionen\),
              FontFamily->"Times New Roman"]}]},
        {
          RowBox[{"Exp", "[", 
            StyleBox["x",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["Exponentialfunktion",
                FontFamily->"Times New Roman"], 
              StyleBox["   ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  SuperscriptBox["e", 
                    StyleBox["x",
                      FontSlant->"Italic"]],
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}]}]}]},
        {
          RowBox[{"Log", "[", 
            StyleBox["x",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["nat\[UDoubleDot]rlicher",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Logarithmus",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["von",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox["   ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox[
                    SubscriptBox["log", 
                      StyleBox["e",
                        FontSlant->"Italic"]],
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}]}]}]},
        {
          RowBox[{"Log", "[", 
            RowBox[{
              StyleBox["b",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["Logarithmus",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["von",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["zur",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Basis",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["b",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox["   ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox[
                    SubscriptBox["log", 
                      StyleBox["b",
                        FontSlant->"Italic"]],
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}]}]}]},
        {
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["n",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "!"}], "  ", 
              StyleBox["oder",
                FontSlant->"Italic"]}], "\[IndentingNewLine]", 
            RowBox[{"Factorial", "[", 
              StyleBox["n",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "]"}]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["n",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Fakult\[ADoubleDot]t",
                FontFamily->"Times New Roman"], 
              StyleBox["   ",
                FontFamily->"Times New Roman"], 
              StyleBox[\((\(1*2* ... \)*\((n - 1)\)*n)\),
                FontFamily->"Times New Roman"]}]}]},
        {
          RowBox[{"Abs", "[", 
            StyleBox["x",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["Absolutbetrag",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["von",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox["   ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["|",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["|",
                    FontFamily->"Times New Roman"]}], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}]}]}]},
        {
          RowBox[{"Round", "[", 
            StyleBox["x",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["n\[ADoubleDot]chste",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["ganze",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Zahl",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["zu",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  TextAlignment->Left,
  TextJustification->0,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell["\<\
Das gibt den Logarithmus von 5.23 zur Basis \[ExponentialE].\
\>", "Text"],

Cell[BoxData[
    \(Log[5.23]\)], "Input"],

Cell["\<\
Hier wird der Sinus von \[Pi] berechnet.\
\>", "Text"],

Cell[BoxData[
    \(Sin[Pi]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " bel\[ADoubleDot]sst die folgende Zahl (die Wurzel aus 2) in exakter \
symbolischer Form, da die Eingabe exakt ist (vgl. den Abschnitt ",
  ButtonBox["Exakte und approximative Rechenergebnisse; der Befehl N",
    ButtonData:>{"grundlagen.nb", "exakt"},
    ButtonStyle->"Hyperlink"],
  " im Kapitel ",
  ButtonBox["Grundlegende Funktionsweise und Bedienung von Mathematica",
    ButtonData:>{"grundlagen.nb", None},
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text"],

Cell[BoxData[
    \(Sqrt[2]\)], "Input"],

Cell[TextData[{
  "Will man einen N\[ADoubleDot]herungswert f\[UDoubleDot]r ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)]],
  ", so versieht man entweder die Zahl 2 mit einem Dezimalpunkt..."
}], "Text"],

Cell[BoxData[
    \(Sqrt[2. ]\)], "Input"],

Cell[TextData[{
  "...oder man f\[UDoubleDot]gt den Befehl ",
  StyleBox["N",
    FontFamily->"Courier New"],
  " hinzu."
}], "Text"],

Cell[BoxData[
    \(Sqrt[2]\ \ \  // N\)], "Input"],

Cell["\<\
Die einzelnen Befehle lassen sich nat\[UDoubleDot]rlich auch schachteln oder \
in umfangreichere Berechnungen einbauen.\
\>", "Text"],

Cell[BoxData[
    \(Round[Exp[3]] - 1\)], "Input"],

Cell[TextData[{
  "Hier wird die Zahl 1",
  StyleBox["*",
    FontFamily->"Courier New"],
  "2",
  StyleBox["*",
    FontFamily->"Courier New"],
  "3",
  StyleBox["*...*",
    FontFamily->"Courier New"],
  "29",
  StyleBox["*",
    FontFamily->"Courier New"],
  "30 exakt berechnet."
}], "Text"],

Cell[BoxData[
    \(Factorial[30]\)], "Input"],

Cell[TextData[{
  "Die Kurzform des Befehls ",
  StyleBox["Factorial",
    FontFamily->"Courier New"],
  " entspricht der mathematischen Standardnotation:"
}], "Text"],

Cell[BoxData[
    \(\(30!\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Definition von Funktionen", "Section",
  CellTags->"def"],

Cell["Auch wir k\[ODoubleDot]nnen Funktionen definieren. Aber wie?", "Text",
  CellTags->"def"],

Cell["Erster Versuch:", "Text",
  CellTags->"def"],

Cell[BoxData[
    \(f = x^2\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Wir versuchen (ganz nach dem Vorbild der in ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "eingebauten Funktionen) den Funktionswert f\[UDoubleDot]r ",
  StyleBox["x",
    FontSlant->"Italic"],
  "=3 auszurechnen."
}], "Text",
  CellTags->"def"],

Cell[BoxData[
    \(f[3]\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "So geht es also offensichtlich nicht. Ist auch kein Wunder: ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " ist nur eine Variable, der der Wert ",
  StyleBox["x^2",
    FontFamily->"Courier New"],
  " zugewiesen wurde. Wo immer jetzt ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " auftaucht wird es von ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " automatisch durch ",
  StyleBox["x^2",
    FontFamily->"Courier New"],
  " ersetzt.\nUm in einen Ausdruck dieser Art Werte f\[UDoubleDot]r ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " einzusetzen (ohne dass der symbolischen Variablen ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " dieser Wert auch zugewiesen wird) verwenden wir am Besten den Operator \
\"",
  StyleBox["/.",
    FontFamily->"Courier New"],
  "\" (vgl. den Abschnitt ",
  ButtonBox["Substitution",
    ButtonData:>{"variablen.nb", "Substitution"},
    ButtonStyle->"Hyperlink"],
  " im Kapitel ",
  ButtonBox["Variablen",
    ButtonData:>{"variablen.nb", None},
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text",
  CellTags->"def"],

Cell["\<\
Zweiter Versuch (angelehnt an die mathematische Schreibweise):\
\>", "Text",
  CellTags->"def"],

Cell[BoxData[{
    \(Clear[f]\), "\[IndentingNewLine]", 
    \(f[x] = x^2\)}], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Wieder versuchen wir f\[UDoubleDot]r ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " den Wert ",
  StyleBox["3",
    FontFamily->"Courier New"],
  " einzusetzen."
}], "Text",
  CellTags->"def"],

Cell[BoxData[
    \(f[3]\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Noch einmal ein Fehlschlag. Was hat hier nicht funktioniert? Wir haben \
durch ",
  StyleBox["f[x]=x^2",
    FontFamily->"Courier New"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nur den Funktionswert an der Stelle ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " mitgeteilt (n\[ADoubleDot]mlich ",
  StyleBox["x^2",
    FontFamily->"Courier New"],
  "), jedoch an keiner anderen. Und tats\[ADoubleDot]chlich erhalten wir beim \
Aufruf von ",
  StyleBox["f[x]",
    FontFamily->"Courier New"],
  " als Ausgabe ",
  StyleBox["x^2",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"def"],

Cell[BoxData[
    \(f[x]\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Das Problem im 2. Versuch besteht darin, dass f\[UDoubleDot]r ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " das ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " in ",
  StyleBox["f[x]",
    FontFamily->"Courier New"],
  " nicht als Platzhalter sondern als fixer Wert aufgefasst wird. Um ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " mitzuteilen, dass das ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " eine unabh\[ADoubleDot]ngige Variable ist, m\[UDoubleDot]ssen wir einen \
Unterstrich hinzuf\[UDoubleDot]gen (aber NUR auf der LINKEN Seite!)."
}], "Text",
  CellTags->"def"],

Cell["Dritter und letzter Versuch:", "Text",
  CellTags->"def"],

Cell[BoxData[{
    \(Clear[f]\), "\[IndentingNewLine]", 
    \(f[x_] := x^2\)}], "Input",
  CellTags->"def"],

Cell["\<\
Der Doppelpunkt vor dem Gleichheitszeichen bedeutet wieder eine verz\
\[ODoubleDot]gerte Zuweisung. Das heisst, die rechte Seite wird erst \
evaluiert, wenn die Funktion aufgerufen wird, und zwar bei jedem Aufruf \
neu.\
\>", "Text",
  CellTags->"def"],

Cell["Endlich funktioniert das Berechnen des Funktionswertes:", "Text",
  CellTags->"def"],

Cell[BoxData[
    \(f[3]\)], "Input",
  CellTags->"def"],

Cell["\<\
In Funktionen k\[ODoubleDot]nnen nicht nur Zahlen, sondern beliebige Ausdr\
\[UDoubleDot]cke eingesetzt werden.\
\>", "Text",
  CellTags->"def"],

Cell[BoxData[
    \(f[a + Sin[1]]\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Selbst definierte Funktionen k\[ODoubleDot]nnen auch zusammen mit anderen \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Befehlen aufgerufen werden."
}], "Text",
  CellTags->"def"],

Cell[BoxData[
    \(Expand[n^2 - f[7  n - 3  m]]\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Mit dem Befehl \"",
  StyleBox["?",
    FontFamily->"Courier New"],
  "\" kann  (k\[ODoubleDot]nnen) (wie schon bei Variablen) die Definition(en) \
einer Funktion abgefragt werden."
}], "Text",
  CellTags->"def"],

Cell[BoxData[
    \(\(?f\)\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Wird der symbolischen Variablen ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " ein Wert zugewiesen, so \[ADoubleDot]ndert das an der Funktion ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " nichts."
}], "Text",
  CellTags->"def"],

Cell[BoxData[
    \(x = 3; f[0]\)], "Input",
  CellTags->"def"],

Cell[BoxData[
    \(Clear[f, x]\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Funktionen k\[ODoubleDot]nnen selbst ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-Befehle aufrufen."
}], "Text",
  CellTags->"def"],

Cell[BoxData[
    \(f[x_] := Cos[x]*Sin[x]\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  StyleBox["f",
    FontFamily->"Courier New"],
  " berechnet den Sinus und den Cosinus von ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " und multipliziert die beiden Werte miteinander."
}], "Text",
  CellTags->"def"],

Cell[BoxData[
    \(f[Pi/4]\)], "Input",
  CellTags->"def"],

Cell[BoxData[
    \(Clear[f]\)], "Input",
  CellTags->"def"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{
              StyleBox["name",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "[", 
              StyleBox[
                RowBox[{
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], "_"}]], "]"}], ":=", 
            StyleBox["ausdruck",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{
            StyleBox[
              RowBox[{" ", 
                StyleBox["  ",
                  FontFamily->"Times New Roman"]}]], 
            RowBox[{
              StyleBox["Definition",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["einer",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Funktion",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["mit",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["dem",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Namen",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["name",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["und",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["dem",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Argument",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"def"],

Cell["\<\
Wie bei der Benennung von Variablen gilt auch hier: Um Verwechslungen zu \
vermeiden sollten die Namen selbst definierter Funktionen immer mit einem \
Kleinbuchstaben beginnen.\
\>", "Text",
  CellTags->"def"],

Cell["Funktionen k\[ODoubleDot]nnen auch mehrere Argumente haben.", "Text",
  CellTags->"def"],

Cell[BoxData[
    \(mittel[a_, b_] := \(a + b\)\/2\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Mit der Funktion ",
  StyleBox["mittel",
    FontFamily->"Courier New"],
  " kann der arithmetische Mittelwert zweier Zahlen ausgerechnet werden."
}], "Text",
  CellTags->"def"],

Cell[BoxData[
    \(mittel[7, 3]\)], "Input",
  CellTags->"def"],

Cell[BoxData[
    \(Clear[mittel]\)], "Input",
  CellTags->"def"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{
              StyleBox["name",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "[", 
              RowBox[{
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["x",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], "_"}], ",", "...", ",", 
                RowBox[{
                  StyleBox[\(x\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], "_"}]}], "]"}], ":=", 
            StyleBox["ausdruck",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["Definition",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["einer",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Funktion",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["mit",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["dem",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Namen",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["name",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["und",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["den",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
              RowBox[{
                StyleBox[
                  RowBox[{"Argumenten", " ", 
                    SubscriptBox[
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"]}],
                  FontFamily->"Times New Roman"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  SubscriptBox[
                    StyleBox["x",
                      FontSlant->"Italic"], 
                    StyleBox["n",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]],
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"def"],

Cell[TextData[{
  "Funktionen von \[DoubleStruckCapitalR] (bzw. ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^m\)]],
  ") nach ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " k\[ODoubleDot]nnen mit Hilfe sogenannter Listen definiert werden. Eine \
Liste in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ist eine Reihe von Ausdr\[UDoubleDot]cken, die, mit Beistrichen von \
einander, getrennt in geschwungenen Klammern stehen."
}], "Text",
  CellTags->"def"],

Cell["Eine Liste mit drei Elementen:", "Text",
  CellTags->"def"],

Cell[BoxData[
    \({3, x^2, 7  y + 1}\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Eine Funktion vom ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " in den ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  ":"
}], "Text",
  CellTags->"def"],

Cell[BoxData[
    \(f[a_, b_] := {\(a + b\)\/2, \@\(a*b\)}\)], "Input",
  CellTags->"def"],

Cell["\<\
Die erste Koordinate des Bildpunktes ist das arithmetische Mittel der beiden \
Argumente, die zweite ist das geometrische Mittel.\
\>", "Text",
  CellTags->"def"],

Cell[BoxData[
    \(f[3, 12]\)], "Input",
  CellTags->"def"],

Cell[BoxData[
    \(Clear[f]\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Funktionen k\[ODoubleDot]nnen auch nur mit einem \"",
  StyleBox["=",
    FontFamily->"Courier New"],
  "\" anstatt eines \"",
  StyleBox[":=",
    FontFamily->"Courier New"],
  "\" definiert werden. Dann wird die rechte Seite zuerst ausgewertet, und \
zwar mit allen aktuellen Belegungen."
}], "Text",
  CellTags->"def"],

Cell[BoxData[
    \(x = 3\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Dort, wo auf der rechten Seite ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " steht, wird von ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["3",
    FontFamily->"Courier New"],
  " eingesetzt. ",
  StyleBox["g",
    FontFamily->"Courier New"],
  " ist damit unabh\[ADoubleDot]ngig von ",
  StyleBox["x",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"def"],

Cell[BoxData[
    \(g[x_, y_] = x^2 + y^2 + a\)], "Input",
  CellTags->"def"],

Cell[BoxData[
    \(g[0, 1]\)], "Input",
  CellTags->"def"],

Cell[TextData[{
  "Das passiert bei einer Definition mit \"",
  StyleBox[":=",
    FontFamily->"Courier New"],
  "\" nicht."
}], "Text",
  CellTags->"def"],

Cell[BoxData[{
    \(Clear[g]\), "\[IndentingNewLine]", 
    \(g[x_, y_] := x^2 + y^2 + a\)}], "Input",
  CellTags->"def"],

Cell[BoxData[
    \(g[0, 1]\)], "Input",
  CellTags->"def"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"?", 
            StyleBox["f",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["zeigt",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["alle",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Definitionen",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["von",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]},
        {
          RowBox[{"Clear", "[", 
            StyleBox["f",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["l\[ODoubleDot]scht",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["alle",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Definitionen",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["von",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->{"?", "def"}],

Cell[BoxData[
    \(Clear[g, x]\)], "Input",
  CellTags->"def"]
}, Closed]],

Cell[CellGroupData[{

Cell["Grafische Darstellung von Funktionen", "Section",
  CellTags->"Grafische Darstellung von Funktionen"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kann Funktionen von \[DoubleStruckCapitalR] nach \[DoubleStruckCapitalR] \
in dem angegebenen Intervall grafisch darstellen. Hierzu dient der Befehl ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  ". Das Intervall, in dem die Funktion gezeichnet werden soll, wird als \
Liste angegeben."
}], "Text",
  CellTags->"Grafische Darstellung von Funktionen"],

Cell[BoxData[
    \(Plot[Sin[x], {x, \(-Pi\), 3  Pi}]\)], "Input",
  CellTags->"Grafische Darstellung von Funktionen"],

Cell["\<\
Will man mehrere Funktionen gleichzeitig zeichnen, so gibt man die einzelnen \
Funktionsterme in Form einer Liste an.\
\>", "Text",
  CellTags->"Grafische Darstellung von Funktionen"],

Cell[BoxData[
    \(Plot[{x^2, 25*Sin[x]}, {x, \(-5\), 5}]\)], "Input",
  CellTags->"Grafische Darstellung von Funktionen"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Plot", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["xmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["xmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["zeichnet",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["die",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Funktion",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["im",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["Intervall",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["[",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["xmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Times New Roman"], 
                  StyleBox["xmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  FontFamily->"Times New Roman"]}]}]}]},
        {
          RowBox[{"Plot", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["f",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], "1"],
                      FontFamily->"Times New Roman"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], ",", "...", ",", 
                  RowBox[{
                    StyleBox[\(f\_n\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}]}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["xmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["xmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["zeichnet",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Funktionen",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  SubscriptBox[
                    StyleBox["f",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "1"],
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["bis",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(f\_n\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["im",
                  FontFamily->"Times New Roman"]}], "\[IndentingNewLine]", 
              " ", 
              RowBox[{
                StyleBox["Intervall",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["[",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["xmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Times New Roman"], 
                  StyleBox["xmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"Grafische Darstellung von Funktionen"],

Cell[TextData[{
  StyleBox["BEMERKUNG",
    FontWeight->"Bold"],
  " zu einer Schreibweise in den blauen Boxen:  ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "(",
  StyleBox["x",
    FontSlant->"Italic"],
  ") steht f\[UDoubleDot]r den FunktionsTERM in der Variablen ",
  StyleBox["x",
    FontSlant->"Italic"],
  ",  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  (ohne die runden Klammern und der Variablen) steht f\[UDoubleDot]r den \
NAMEN der Funktion. Beispiele: ",
  StyleBox["Sin[x]",
    FontFamily->"Courier New"],
  " ist der Funktionsterm, ",
  StyleBox["Sin",
    FontFamily->"Courier New"],
  " ist der Name der Funktion. Wenn wir eine Funktion selbst definieren, z.B. \
durch ",
  StyleBox["quadrat[x_]:=x^2",
    FontFamily->"Courier New"],
  ", dann ist ",
  StyleBox["x^2",
    FontFamily->"Courier New"],
  " bzw. ",
  StyleBox["quadrat[x]",
    FontFamily->"Courier New"],
  " (was ja ",
  StyleBox["x^2",
    FontFamily->"Courier New"],
  " aufruft) der Funktionsterm, ",
  StyleBox["quadrat",
    FontFamily->"Courier New"],
  " ist der Name der Funktion.\n",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  " verlangt den Funktionsterm einer Funktion als erstes Argument. Wir haben \
aber auch schon einen Befehl kennengelernt, der nur den Namen der Funktion \
verlangt: ",
  StyleBox["?",
    FontFamily->"Courier New"],
  StyleBox["f",
    FontSlant->"Italic"],
  "  liefert alle zur Zeit g\[UDoubleDot]ltigen Definitionen von  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  (siehe den vorigen Abschnitt ",
  ButtonBox["Definition von Funktionen",
    ButtonData:>"def",
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text",
  CellTags->{"bem1", "Grafische Darstellung von Funktionen"}],

Cell[TextData[{
  "Definieren wir nun noch einmal die Funktion ",
  StyleBox["mittel",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"Grafische Darstellung von Funktionen"],

Cell[BoxData[
    \(mittel[a_, b_] := \(a + b\)\/2\)], "Input",
  CellTags->"Grafische Darstellung von Funktionen"],

Cell[TextData[{
  "Funktionen wie ",
  StyleBox["mittel",
    FontFamily->"Courier New"],
  " (also Funktionen von ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " nach \[DoubleStruckCapitalR]) k\[ODoubleDot]nnen mit dem Befehl ",
  StyleBox["Plot3D",
    FontFamily->"Courier New"],
  " grafisch dargestellt werden. ",
  StyleBox["mittel",
    FontFamily->"Courier New"],
  " ist von zwei Eingabewerten abh\[ADoubleDot]ngig, daher muss auch f\
\[UDoubleDot]r jeden Eingabewert separat ein Intervall angegeben werden, in \
dem geplottet werden soll."
}], "Text",
  CellTags->"Grafische Darstellung von Funktionen"],

Cell[BoxData[
    \(Plot3D[mittel[a, b], {a, 0, 4}, {b, \(-2\), 3}]\)], "Input",
  CellTags->"Grafische Darstellung von Funktionen"],

Cell[BoxData[
    \(Clear[mittel]\)], "Input"],

Cell["\<\
Hier ist noch ein Beispiel. (Mich erinnert dieser Plot immer an einen \
Eierkarton.)\
\>", "Text",
  CellTags->"Grafische Darstellung von Funktionen"],

Cell[BoxData[
    \(Plot3D[Sin[x]*Sin[y], {x, \(-2\) Pi, Pi}, {y, 0, 3  Pi}]\)], "Input",
  CellTags->"Grafische Darstellung von Funktionen"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Plot3D", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Times New Roman"], 
                    StyleBox["y",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["xmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["xmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["y",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["ymin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["ymax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["zeichnet",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["die",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Funktion",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["f",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["mit",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["-",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(Werten\ aus\ dem\),
                  FontFamily->"Times New Roman"]}], "\[IndentingNewLine]", 
              " ", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["Intervall",
                      FontFamily->"Times New Roman"], 
                    StyleBox["  ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["[",
                      FontFamily->"Times New Roman"], 
                    RowBox[{
                      StyleBox["xmin",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[",",
                        FontFamily->"Times New Roman"], 
                      StyleBox["xmax",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox["]",
                      FontFamily->"Times New Roman"]}], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["und",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["y",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["-",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(Werten\ aus\ dem\),
                  FontFamily->"Times New Roman"]}], "\[IndentingNewLine]", 
              " ", 
              RowBox[{
                StyleBox["Intervall",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["[",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["ymin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Times New Roman"], 
                  StyleBox["ymax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"Grafische Darstellung von Funktionen"],

Cell[TextData[{
  "Wer mehr \[UDoubleDot]ber die M\[ODoubleDot]glichkeiten der Plot-Befehle \
wissen m\[ODoubleDot]chte, der sei auf das Kapitel ",
  ButtonBox["Plots",
    ButtonData:>{"plots.nb", None},
    ButtonStyle->"Hyperlink"],
  " verwiesen."
}], "Text",
  CellTags->"Grafische Darstellung von Funktionen"]
}, Closed]],

Cell[CellGroupData[{

Cell["Wertetabellen", "Section",
  CellTags->"wertetabellen"],

Cell[TextData[{
  "Mit Hilfe des Befehls ",
  StyleBox["Table",
    FontFamily->"Courier New"],
  " kann eine ganze Reihe von Werten in eine Funktion eingesetzt werden und \
so eine Wertetabelle erstellt werden. Die Funktionswerte werden in Form einer \
Liste ausgegeben.\nDas erste Argument von ",
  StyleBox["Table",
    FontFamily->"Courier New"],
  " ist ein Ausdruck, der an verschiedenen Stellen ausgewertet werden soll, \
in der folgenden Input-Zelle also ",
  StyleBox["a+x",
    FontFamily->"Courier New"],
  ". Das zweite Argument von ",
  StyleBox["Table",
    FontFamily->"Courier New"],
  " ist eine Liste. Sie enth\[ADoubleDot]lt die Variable, f\[UDoubleDot]r die \
die verschiedenen Werte eingesetzt werden sollen, den Startwert, den \
Stoppwert und die Schrittweite. Hier werden f\[UDoubleDot]r ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " also die Werte ",
  StyleBox["0",
    FontFamily->"Courier New"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`1\/2\)], "Input",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["1",
    FontFamily->"Courier New"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`3\/2\)], "Input",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["2",
    FontFamily->"Courier New"],
  " eingesetzt."
}], "Text",
  CellTags->"wertetabellen"],

Cell[BoxData[
    \(Table[a + x, {x, 0, 2, 1\/2}]\)], "Input",
  CellTags->"wertetabellen"],

Cell["\<\
Wird die Schrittweite weggelassen, so ist sie automatisch 1. Wenn auch kein \
Startwert eingegeben wird, dann startet die Berechnung mit dem Wert 1.\
\>", "Text",
  CellTags->"wertetabellen"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Table", "[", 
            RowBox[{
              StyleBox["ausdruck",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              RowBox[{"{", 
                StyleBox["imax",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["erzeugt",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["eine",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Liste",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["mit",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["imax",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Mal",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["ausdruck",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["als",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Elemente",
                FontFamily->"Times New Roman"]}]}]},
        {
          RowBox[{"Table", "[", 
            RowBox[{
              StyleBox["ausdruck",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["i",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["imax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{
            StyleBox["    ",
              FontFamily->"Times New Roman"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["erzeugt",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["eine",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Liste",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["von",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["den",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Werten",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["von",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["ausdruck",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["wenn",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["i",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["von",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["1",
                    FontFamily->"Times New Roman"]}]}], "\[IndentingNewLine]",
               
              RowBox[{
                StyleBox["bis",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["imax",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["l\[ADoubleDot]uft",
                  FontFamily->"Times New Roman"]}]}]}]},
        {
          RowBox[{"Table", "[", 
            RowBox[{
              StyleBox["ausdruck",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["i",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["imin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["imax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{
            StyleBox["    ",
              FontFamily->"Times New Roman"], 
            RowBox[{
              RowBox[{
                StyleBox["startet",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["bei",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["i",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["=",
                FontFamily->"Times New Roman"], 
              StyleBox["imin",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]},
        {
          RowBox[{"Table", "[", 
            RowBox[{
              StyleBox["ausdruck",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["i",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["imin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["imax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["incr",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["i",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["wird",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["immer",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["um",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["incr",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["erh\[ODoubleDot]ht",
                FontFamily->"Times New Roman"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"wertetabellen"],

Cell["\<\
Es k\[ODoubleDot]nnen auch mehrere Ausdr\[UDoubleDot]cke gleichzeitig \
ausgewertet werden. Dazu gibt man die einzelnen Ausdr\[UDoubleDot]cke in Form \
einer Liste ein. Die Ausgabe ist dann eine Liste mit Listen als Elemente.\
\>", "Text",
  CellTags->"wertetabellen"],

Cell[BoxData[
    \(wertetabelle = Table[{x, x^2}, {x, 5}]\)], "Input",
  CellTags->"wertetabellen"],

Cell[TextData[{
  "Um diese Wertetabelle f\[UDoubleDot]r uns besser lesbar zu machen, wenden \
wir auf die Ausgabe von ",
  StyleBox["Table",
    FontFamily->"Courier New"],
  " den Befehl ",
  StyleBox["TableForm",
    FontFamily->"Courier New"],
  " an. (",
  StyleBox["TableForm",
    FontFamily->"Courier New"],
  " ben\[ODoubleDot]tigt also eine Liste als Argument.)"
}], "Text",
  CellTags->"wertetabellen"],

Cell[BoxData[
    \(TableForm[wertetabelle]\)], "Input",
  CellTags->"wertetabellen"],

Cell[TextData[{
  StyleBox["ACHTUNG",
    FontWeight->"Bold"],
  ": Mit dieser Ausgabe kann ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nicht mehr weiterrechnen. ",
  StyleBox["TableForm",
    FontFamily->"Courier New"],
  " liefert nur eine grafische Darstellung der Liste, keinen f\[UDoubleDot]r \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " weiter verwendbaren Output."
}], "Text",
  CellTags->"wertetabellen"],

Cell[TextData[{
  "Um ein bestimmtes Element aus einer Liste herauszugreifen (im n\
\[ADoubleDot]chsten Beispiel ist das das zweite Element), verwendet man den \
Befehl ",
  StyleBox["Part",
    FontFamily->"Courier New"],
  ". In diesem Fall ist das Element selbst eine Liste."
}], "Text",
  CellTags->"wertetabellen"],

Cell[BoxData[
    \(Part[wertetabelle, 2]\)], "Input",
  CellTags->"wertetabellen"],

Cell[TextData[{
  "Eine Kurzform von ",
  StyleBox["Part",
    FontFamily->"Courier New"],
  " ist"
}], "Text",
  CellTags->"wertetabellen"],

Cell[BoxData[
    \(wertetabelle[\([2]\)]\)], "Input",
  CellTags->"wertetabellen"],

Cell["Wir k\[ODoubleDot]nnen in der Verschachtelung auch tiefer gehen. So", \
"Text",
  CellTags->"wertetabellen"],

Cell[BoxData[
    \(Part[wertetabelle, 2, 1]\)], "Input",
  CellTags->"wertetabellen"],

Cell["oder so", "Text",
  CellTags->"wertetabellen"],

Cell[BoxData[
    \(\(wertetabelle[\([2]\)]\)[\([1]\)]\)], "Input",
  CellTags->"wertetabellen"],

Cell["oder so", "Text",
  CellTags->"wertetabellen"],

Cell[BoxData[
    \(wertetabelle[\([2, 1]\)]\)], "Input",
  CellTags->"wertetabellen"],

Cell[TextData[{
  "und erhalten das erste Element des zweiten Elements von ",
  StyleBox["wertetabelle",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"wertetabellen"],

Cell[BoxData[
    \(Clear[wertetabelle]\)], "Input",
  CellTags->"wertetabellen"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{
              RowBox[{"Part", "[", 
                RowBox[{
                  StyleBox["liste",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["n",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "]"}], "  ", 
              StyleBox["oder",
                FontSlant->"Italic"]}], "\[IndentingNewLine]", 
            RowBox[{
              StyleBox["liste",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "[", 
              RowBox[{"[", 
                StyleBox["n",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "]"}], "]"}]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["n",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox["-",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["tes",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Element",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["der",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Liste",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["liste",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}]}]}]},
        {
          RowBox[{
            RowBox[{
              RowBox[{"Part", "[", 
                RowBox[{
                  StyleBox["liste",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox[
                    SubscriptBox[
                      StyleBox["n",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[\(n\_m\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "]"}], "  ", 
              StyleBox["oder",
                FontSlant->"Italic"]}], "\[IndentingNewLine]", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["liste",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "[", 
                    RowBox[{"[", 
                      StyleBox[
                        SubscriptBox[
                          StyleBox["n",
                            FontSlant->"Italic"], "1"],
                        FontFamily->"Times New Roman"], "]"}], "]"}], "..."}],
                 "[", 
                RowBox[{"[", 
                  StyleBox[\(n\_m\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], "]"}], "]"}], "  ", 
              StyleBox["oder",
                FontSlant->"Italic"]}], "\[IndentingNewLine]", 
            RowBox[{
              StyleBox["liste",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "[", 
              RowBox[{"[", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["n",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[\(n\_m\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "]"}], "]"}]}], 
          RowBox[{
            StyleBox["    ",
              FontFamily->"Times New Roman"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox[\(n\_m\),
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox["-",
                        FontFamily->"Times New Roman"], 
                      RowBox[{
                        StyleBox["tes",
                          FontFamily->"Times New Roman"], 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"], 
                        StyleBox["Element",
                          FontFamily->"Times New Roman"], 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"], 
                        StyleBox["des",
                          FontFamily->"Times New Roman"], 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"], 
                        StyleBox[
                          SubscriptBox["n", 
                            RowBox[{"m", 
                              StyleBox["-",
                                FontSlant->"Plain"], 
                              StyleBox["1",
                                FontSlant->"Plain"]}]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}], 
                      StyleBox["-",
                        FontFamily->"Times New Roman"], 
                      StyleBox[\(ten\ Elements\ des\),
                        FontFamily->"Times New Roman"]}], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["...",
                      FontFamily->"Courier New"]}], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["des",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[
                    SubscriptBox[
                      StyleBox["n",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"]}], 
                StyleBox["-",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(tes\ Elements\),
                  FontFamily->"Times New Roman"]}], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["der",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Liste",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["liste",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"wertetabellen"],

Cell[TextData[{
  StyleBox["Table",
    FontFamily->"Courier New"],
  " kann auch Funktionen mit mehr als einem Argument auswerten, der Output \
wird aber sehr schnell zu un\[UDoubleDot]bersichtlich.\nHier wurde die \
Funktion ",
  StyleBox["mittel",
    FontFamily->"Courier New"],
  " an den Stellen (1, 1), (1, 2), (3, 1), (3, 2), (5, 1) und (5, 2) \
ausgewertet, also f\[UDoubleDot]r jede Kombination der angegebenen ",
  StyleBox["x",
    FontFamily->"Courier New"],
  "- und ",
  StyleBox["y",
    FontFamily->"Courier New"],
  "-Werte."
}], "Text",
  CellTags->"wertetabellen"],

Cell[BoxData[{
    \(mittel[a_, b_] := \(a + b\)\/2\), "\[IndentingNewLine]", 
    \(Table[mittel[x, y], {x, 1, 5, 2}, {y, 2}]\)}], "Input",
  CellTags->"wertetabellen"],

Cell[BoxData[
    \(TableForm[%]\)], "Input",
  CellTags->"wertetabellen"],

Cell[BoxData[
    \(Clear[mittel]\)], "Input",
  CellTags->"wertetabellen"]
}, Closed]],

Cell[CellGroupData[{

Cell["St\[UDoubleDot]ckweise Definition von Funktionen", "Section",
  CellTags->"Bedingung"],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ist es auch m\[ODoubleDot]glich, Funktionen der Art ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            FormBox[\(\(f(x)\)\(=\)\),
              "TraditionalForm"],
            "InlineFormula"], 
          RowBox[{
            StyleBox["{",
              FontColor->GrayLevel[0]], 
            StyleBox[GridBox[{
                  {\(\@\(x - 1\)\), \(f\[UDoubleDot]r\ x \[GreaterEqual] 
                      1\)},
                  {\(\(-\(1\/2\)\) x - 2\), \(f\[UDoubleDot]r\ x < 1\)}
                  }],
              "InlineFormula"], 
            StyleBox["     ",
              "InlineFormula"]}]}], TraditionalForm]]],
  "zu definieren. Dazu ben\[ODoubleDot]tigen wir den Befehl \"",
  StyleBox["/;",
    FontFamily->"Courier New"],
  "\" (dieser hei\[SZ]t in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["Condition",
    FontFamily->"Courier New"],
  ", also Bedingung)."
}], "Text",
  CellTags->"Bedingung"],

Cell[BoxData[{
    \(f[x_] := 
      Sqrt[x - 1]\ \ \  /; \ \ \ x \[GreaterEqual] 
          1\), "\[IndentingNewLine]", 
    \(f[x_] := \(-\(1\/2\)\) x - 2\ \ \  /; \ \ \ x < 1\)}], "Input",
  CellTags->"Bedingung"],

Cell[TextData[{
  "Wird jetzt eine Zahl f\[UDoubleDot]r ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " eingesetzt, so \[UDoubleDot]berpr\[UDoubleDot]ft Mathematica zuerst, ob \
die Bedingung nach dem \"",
  StyleBox["/;",
    FontFamily->"Courier New"],
  "\" erf\[UDoubleDot]llt ist. Wenn ja, dann wird der Funktionswert nach der \
Definition links vom \"",
  StyleBox["/;",
    FontFamily->"Courier New"],
  "\" berechnet."
}], "Text",
  CellTags->"Bedingung"],

Cell[BoxData[
    \(f[3]\)], "Input",
  CellTags->"Bedingung"],

Cell[BoxData[
    \(f[\(-1\)]\)], "Input",
  CellTags->"Bedingung"],

Cell["\<\
Wird keine der Bedingungen erf\[UDoubleDot]llt, so wird kein Funktionswert \
berechnet.\
\>", "Text",
  CellTags->"Bedingung"],

Cell[BoxData[
    \(f[a]\)], "Input",
  CellTags->"Bedingung"],

Cell[TextData[{
  "Auch st\[UDoubleDot]ckweise definierte Funktionen k\[ODoubleDot]nnen wir \
mit ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  " zeichnen (Voraussetzung hier ist nat\[UDoubleDot]rlich, dass die Funktion \
in dem Intervall, in dem wir sie zeichnen wollen, auch definiert ist!).\nAm \
Plot unserer Funktion ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " f\[ADoubleDot]llt auf, dass die Sprungstelle bei 1 nicht als solche \
dargestellt wird - ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " stellt den Graphen der Funktion als durchgehende Linie dar. (Der Grund \
daf\[UDoubleDot]r liegt in der Funktionsweise des Plot-Befehls. \
F\[UDoubleDot]r eine genauere Beschreibung siehe den Abschnitt ",
  ButtonBox["Plots im ",
    ButtonData:>{"plots.nb", "plotR2"},
    ButtonStyle->"Hyperlink"],
  ButtonBox["R",
    ButtonData:>{"plots.nb", "plotR2"},
    ButtonStyle->"Hyperlink"],
  ButtonBox["2",
    ButtonData:>{"plots.nb", "plotR2"},
    ButtonStyle->"Hyperlink"],
  " im Kapitel ",
  ButtonBox["Plots",
    ButtonData:>{"plots.nb", None},
    ButtonStyle->"Hyperlink"],
  ".)"
}], "Text",
  CellTags->"Bedingung"],

Cell[BoxData[
    \(Plot[f[x], {x, \(-2\), 4}]\)], "Input",
  CellTags->"Bedingung"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            StyleBox["ls",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], ":=", 
            RowBox[{
              StyleBox["rs",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], " ", "/;", " ", 
              StyleBox["bedingung",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox[\(eine\ Definition\),
                  FontFamily->"Times New Roman"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(die\ nur\ dann\ angewendet\ wird\),
                  FontFamily->"Times New Roman"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["wenn",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["die",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Bedingung",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["bedingung",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
              StyleBox[\(erf\[UDoubleDot]llt\ ist\),
                FontFamily->"Times New Roman"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"Bedingung"],

Cell[BoxData[
    \(Clear[f]\)], "Input",
  CellTags->"Bedingung"]
}, Closed]],

Cell[CellGroupData[{

Cell["Rekursive Definition von Funktionen", "Section"],

Cell[TextData[{
  "Einige mathematische Funktionen sind rekursiv definiert, z. B. die Fakult\
\[ADoubleDot]tsfunktion n!:=n",
  StyleBox["*",
    FontFamily->"Times New Roman"],
  "(n-1)!, 0!:=1. Rekursiv bedeutet also: Die Funktion ruft sich selbst auf. \
Das ist auch in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " m\[ODoubleDot]glich."
}], "Text"],

Cell[BoxData[{
    \(fakultaet[0] := 1\), "\[IndentingNewLine]", 
    \(fakultaet[n_] := n*fakultaet[n - 1]\)}], "Input"],

Cell[TextData[{
  StyleBox["WICHTIG",
    FontWeight->"Bold"],
  ":\n1.Bei rekursiven Definitionen ist der Doppelpunkt vor dem \
Gleichheitszeichen unerl\[ADoubleDot]sslich. Ohne Doppelpunkt \
w\[UDoubleDot]rde ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " versuchen, die rechte Seite zu evaluieren, was eine Endlosschleife zur \
Folge hat.\n2. Bei jeder rekursiven Definition muss (mindestens) ein \
Funktionswert extra definiert werden, damit die Rekursion auch abbricht. Hier \
ist das ",
  StyleBox["fakultaet[0]:=1",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell["\<\
F\[UDoubleDot]r nat\[UDoubleDot]rliche Zahlen k\[ODoubleDot]nnen wir jetzt \
Funktionswerte berechnen.\
\>", "Text"],

Cell[BoxData[
    \(fakultaet[4]\)], "Input"],

Cell[BoxData[
    \(fakultaet[20]\)], "Input"],

Cell[TextData[{
  "Wir vergleichen die Ergebnisse unserer selbst definierten Funktion ",
  StyleBox["fakultaet",
    FontFamily->"Courier New"],
  " mit den Ergebnissen der eingebauten Funktion ",
  StyleBox["Factorial",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(Factorial[4]\)], "Input"],

Cell[BoxData[
    \(Factorial[20]\)], "Input"],

Cell[TextData[{
  "Hier kommt es bei ",
  StyleBox["fakultaet",
    FontFamily->"Courier New"],
  " zu Problemen:"
}], "Text"],

Cell[BoxData[
    \(fakultaet[\(-1\)]\)], "Input"],

Cell[BoxData[
    \(fakultaet[3.5]\)], "Input"],

Cell[BoxData[
    \(fakultaet[n]\)], "Input"],

Cell[TextData[{
  "Das Problem besteht darin, dass die Rekursion (aus verschiedenen Gr\
\[UDoubleDot]nden) nie auf den Rekursionsanfang kommt und daher nicht \
abbricht. Um zu vermeiden, dass bei solchen Eingaben die Rekursion \
\[UDoubleDot]berhaupt gestartet wird, versehen wir die Definition von ",
  StyleBox["fakultaet",
    FontFamily->"Courier New"],
  " mit zwei Bedingungen (mit Hilfe des Befehls \"",
  StyleBox["/;",
    FontFamily->"Courier New"],
  "\", vgl. ",
  ButtonBox["St\[UDoubleDot]ckweise Definition von Funktionen",
    ButtonData:>"Bedingung",
    ButtonStyle->"Hyperlink"],
  " in diesem Kapitel). Zuerst m\[UDoubleDot]ssen wir jedoch die alte \
Definition l\[ODoubleDot]schen. Wir l\[ODoubleDot]schen hier mittels \"",
  StyleBox["=.",
    FontFamily->"Courier New"],
  "\", da dadurch wirklich nur der Teil gel\[ODoubleDot]scht wird, den wir \
neu definieren wollen, nicht aber die Definition ",
  StyleBox["fakultaet[0]:=1",
    FontFamily->"Courier New"],
  ". (Wir h\[ADoubleDot]tten nat\[UDoubleDot]rlich auch den ",
  StyleBox["Clear",
    FontFamily->"Courier New"],
  "-Befehl verwenden k\[ODoubleDot]nnen, doch dann w\[ADoubleDot]ren ALLE \
Definitionen von ",
  StyleBox["fakultaet",
    FontFamily->"Courier New"],
  " gel\[ODoubleDot]scht worden und wir h\[ADoubleDot]tten auch ",
  StyleBox["fakultaet[0]",
    FontFamily->"Courier New"],
  " nochmals definieren m\[UDoubleDot]ssen.)"
}], "Text"],

Cell[BoxData[
    \(fakultaet[n_] =. \)], "Input"],

Cell[TextData[{
  "Jetzt zur neuen Definition: Das Argument von ",
  StyleBox["fakultaet",
    FontFamily->"Courier New"],
  " muss ganzzahlig und nicht-negativ sein. Mehrere Bedingungen verkn\
\[UDoubleDot]pfen wir mit einem logischen UND, in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ist das das Symbol \"",
  StyleBox["&&",
    FontFamily->"Courier New"],
  "\"."
}], "Text"],

Cell[BoxData[
    \(fakultaet[n_] := 
      n*fakultaet[n - 1]\ \ \  /; \ 
        IntegerQ[n]\  && \ n \[GreaterEqual] 0\)], "Input"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["IntegerQ",
    FontFamily->"Courier New"],
  " liefert ",
  StyleBox["True",
    FontFamily->"Courier New"],
  ", falls das Argument ganzzahlig ist, andernfalls ",
  StyleBox["False",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(IntegerQ[\(-3\)]\)], "Input"],

Cell[BoxData[
    \(IntegerQ[2.5]\)], "Input"],

Cell[TextData[{
  "Nur wenn der gesamte Ausdruck rechts vom \"",
  StyleBox["/;",
    FontFamily->"Courier New"],
  "\"  in der neuen Definition von ",
  StyleBox["fakultaet",
    FontFamily->"Courier New"],
  " ",
  StyleBox["True",
    FontFamily->"Courier New"],
  " liefert, wird die Rekursion gestartet."
}], "Text"],

Cell[BoxData[
    \(fakultaet[\(-1\)]\)], "Input"],

Cell[BoxData[
    \(fakultaet[3.5]\)], "Input"],

Cell[BoxData[
    \(fakultaet[n]\)], "Input"],

Cell[BoxData[
    \(fakultaet[5]\)], "Input"],

Cell[BoxData[
    \(Clear[fakultaet]\)], "Input"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "def"->{
    Cell[16153, 480, 63, 1, 43, "Section",
      CellTags->"def"],
    Cell[16219, 483, 95, 1, 33, "Text",
      CellTags->"def"],
    Cell[16317, 486, 50, 1, 33, "Text",
      CellTags->"def"],
    Cell[16370, 489, 59, 2, 30, "Input",
      CellTags->"def"],
    Cell[16432, 493, 276, 9, 33, "Text",
      CellTags->"def"],
    Cell[16711, 504, 56, 2, 30, "Input",
      CellTags->"def"],
    Cell[16770, 508, 1111, 36, 90, "Text",
      CellTags->"def"],
    Cell[17884, 546, 105, 3, 33, "Text",
      CellTags->"def"],
    Cell[17992, 551, 106, 3, 50, "Input",
      CellTags->"def"],
    Cell[18101, 556, 219, 9, 33, "Text",
      CellTags->"def"],
    Cell[18323, 567, 56, 2, 30, "Input",
      CellTags->"def"],
    Cell[18382, 571, 645, 23, 52, "Text",
      CellTags->"def"],
    Cell[19030, 596, 56, 2, 30, "Input",
      CellTags->"def"],
    Cell[19089, 600, 635, 19, 52, "Text",
      CellTags->"def"],
    Cell[19727, 621, 63, 1, 33, "Text",
      CellTags->"def"],
    Cell[19793, 624, 108, 3, 50, "Input",
      CellTags->"def"],
    Cell[19904, 629, 262, 6, 52, "Text",
      CellTags->"def"],
    Cell[20169, 637, 90, 1, 33, "Text",
      CellTags->"def"],
    Cell[20262, 640, 56, 2, 30, "Input",
      CellTags->"def"],
    Cell[20321, 644, 154, 4, 33, "Text",
      CellTags->"def"],
    Cell[20478, 650, 65, 2, 30, "Input",
      CellTags->"def"],
    Cell[20546, 654, 213, 7, 33, "Text",
      CellTags->"def"],
    Cell[20762, 663, 80, 2, 30, "Input",
      CellTags->"def"],
    Cell[20845, 667, 231, 7, 33, "Text",
      CellTags->"def"],
    Cell[21079, 676, 58, 2, 30, "Input",
      CellTags->"def"],
    Cell[21140, 680, 263, 9, 33, "Text",
      CellTags->"def"],
    Cell[21406, 691, 63, 2, 30, "Input",
      CellTags->"def"],
    Cell[21472, 695, 63, 2, 30, "Input",
      CellTags->"def"],
    Cell[21538, 699, 164, 6, 33, "Text",
      CellTags->"def"],
    Cell[21705, 707, 74, 2, 30, "Input",
      CellTags->"def"],
    Cell[21782, 711, 242, 8, 33, "Text",
      CellTags->"def"],
    Cell[22027, 721, 59, 2, 30, "Input",
      CellTags->"def"],
    Cell[22089, 725, 60, 2, 30, "Input",
      CellTags->"def"],
    Cell[22152, 729, 2570, 69, 48, "Text",
      CellTags->"def"],
    Cell[24725, 800, 219, 5, 33, "Text",
      CellTags->"def"],
    Cell[24947, 807, 94, 1, 33, "Text",
      CellTags->"def"],
    Cell[25044, 810, 82, 2, 42, "Input",
      CellTags->"def"],
    Cell[25129, 814, 196, 6, 33, "Text",
      CellTags->"def"],
    Cell[25328, 822, 64, 2, 30, "Input",
      CellTags->"def"],
    Cell[25395, 826, 65, 2, 30, "Input",
      CellTags->"def"],
    Cell[25463, 830, 3435, 87, 67, "Text",
      CellTags->"def"],
    Cell[28901, 919, 525, 14, 52, "Text",
      CellTags->"def"],
    Cell[29429, 935, 65, 1, 33, "Text",
      CellTags->"def"],
    Cell[29497, 938, 70, 2, 30, "Input",
      CellTags->"def"],
    Cell[29570, 942, 236, 9, 33, "Text",
      CellTags->"def"],
    Cell[29809, 953, 90, 2, 42, "Input",
      CellTags->"def"],
    Cell[29902, 957, 172, 4, 33, "Text",
      CellTags->"def"],
    Cell[30077, 963, 60, 2, 30, "Input",
      CellTags->"def"],
    Cell[30140, 967, 60, 2, 30, "Input",
      CellTags->"def"],
    Cell[30203, 971, 340, 10, 33, "Text",
      CellTags->"def"],
    Cell[30546, 983, 57, 2, 30, "Input",
      CellTags->"def"],
    Cell[30606, 987, 426, 18, 33, "Text",
      CellTags->"def"],
    Cell[31035, 1007, 77, 2, 30, "Input",
      CellTags->"def"],
    Cell[31115, 1011, 59, 2, 30, "Input",
      CellTags->"def"],
    Cell[31177, 1015, 155, 6, 33, "Text",
      CellTags->"def"],
    Cell[31335, 1023, 122, 3, 50, "Input",
      CellTags->"def"],
    Cell[31460, 1028, 59, 2, 30, "Input",
      CellTags->"def"],
    Cell[31522, 1032, 2097, 57, 63, "Text",
      CellTags->{"?", "def"}],
    Cell[33622, 1091, 63, 2, 30, "Input",
      CellTags->"def"]},
  "?"->{
    Cell[31522, 1032, 2097, 57, 63, "Text",
      CellTags->{"?", "def"}]},
  "Grafische Darstellung von Funktionen"->{
    Cell[33722, 1098, 107, 1, 43, "Section",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[33832, 1101, 431, 10, 52, "Text",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[34266, 1113, 118, 2, 30, "Input",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[34387, 1117, 193, 4, 33, "Text",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[34583, 1123, 123, 2, 30, "Input",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[34709, 1127, 6727, 168, 85, "Text",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[41439, 1297, 1721, 57, 109, "Text",
      CellTags->{"bem1", "Grafische Darstellung von Funktionen"}],
    Cell[43163, 1356, 188, 6, 33, "Text",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[43354, 1364, 115, 2, 42, "Input",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[43472, 1368, 645, 17, 52, "Text",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[44120, 1387, 132, 2, 30, "Input",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[44304, 1394, 160, 4, 33, "Text",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[44467, 1400, 141, 2, 30, "Input",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[44611, 1404, 5472, 133, 85, "Text",
      CellTags->"Grafische Darstellung von Funktionen"],
    Cell[50086, 1539, 315, 8, 33, "Text",
      CellTags->"Grafische Darstellung von Funktionen"]},
  "bem1"->{
    Cell[41439, 1297, 1721, 57, 109, "Text",
      CellTags->{"bem1", "Grafische Darstellung von Funktionen"}]},
  "wertetabellen"->{
    Cell[50438, 1552, 61, 1, 43, "Section",
      CellTags->"wertetabellen"],
    Cell[50502, 1555, 1302, 40, 93, "Text",
      CellTags->"wertetabellen"],
    Cell[51807, 1597, 91, 2, 42, "Input",
      CellTags->"wertetabellen"],
    Cell[51901, 1601, 201, 4, 33, "Text",
      CellTags->"wertetabellen"],
    Cell[52105, 1607, 8647, 221, 119, "Text",
      CellTags->"wertetabellen"],
    Cell[60755, 1830, 278, 5, 33, "Text",
      CellTags->"wertetabellen"],
    Cell[61036, 1837, 100, 2, 30, "Input",
      CellTags->"wertetabellen"],
    Cell[61139, 1841, 413, 13, 33, "Text",
      CellTags->"wertetabellen"],
    Cell[61555, 1856, 85, 2, 30, "Input",
      CellTags->"wertetabellen"],
    Cell[61643, 1860, 443, 15, 33, "Text",
      CellTags->"wertetabellen"],
    Cell[62089, 1877, 319, 8, 33, "Text",
      CellTags->"wertetabellen"],
    Cell[62411, 1887, 83, 2, 30, "Input",
      CellTags->"wertetabellen"],
    Cell[62497, 1891, 140, 6, 33, "Text",
      CellTags->"wertetabellen"],
    Cell[62640, 1899, 83, 2, 30, "Input",
      CellTags->"wertetabellen"],
    Cell[62726, 1903, 114, 2, 33, "Text",
      CellTags->"wertetabellen"],
    Cell[62843, 1907, 86, 2, 30, "Input",
      CellTags->"wertetabellen"],
    Cell[62932, 1911, 52, 1, 33, "Text",
      CellTags->"wertetabellen"],
    Cell[62987, 1914, 96, 2, 30, "Input",
      CellTags->"wertetabellen"],
    Cell[63086, 1918, 52, 1, 33, "Text",
      CellTags->"wertetabellen"],
    Cell[63141, 1921, 86, 2, 30, "Input",
      CellTags->"wertetabellen"],
    Cell[63230, 1925, 183, 6, 33, "Text",
      CellTags->"wertetabellen"],
    Cell[63416, 1933, 81, 2, 30, "Input",
      CellTags->"wertetabellen"],
    Cell[63500, 1937, 7151, 175, 125, "Text",
      CellTags->"wertetabellen"],
    Cell[70654, 2114, 584, 17, 52, "Text",
      CellTags->"wertetabellen"],
    Cell[71241, 2133, 169, 3, 63, "Input",
      CellTags->"wertetabellen"],
    Cell[71413, 2138, 74, 2, 30, "Input",
      CellTags->"wertetabellen"],
    Cell[71490, 2142, 75, 2, 30, "Input",
      CellTags->"wertetabellen"]},
  "Bedingung"->{
    Cell[71602, 2149, 92, 1, 43, "Section",
      CellTags->"Bedingung"],
    Cell[71697, 2152, 1058, 34, 78, "Text",
      CellTags->"Bedingung"],
    Cell[72758, 2188, 216, 5, 63, "Input",
      CellTags->"Bedingung"],
    Cell[72977, 2195, 470, 14, 52, "Text",
      CellTags->"Bedingung"],
    Cell[73450, 2211, 62, 2, 30, "Input",
      CellTags->"Bedingung"],
    Cell[73515, 2215, 67, 2, 30, "Input",
      CellTags->"Bedingung"],
    Cell[73585, 2219, 136, 4, 33, "Text",
      CellTags->"Bedingung"],
    Cell[73724, 2225, 62, 2, 30, "Input",
      CellTags->"Bedingung"],
    Cell[73789, 2229, 1161, 32, 71, "Text",
      CellTags->"Bedingung"],
    Cell[74953, 2263, 84, 2, 30, "Input",
      CellTags->"Bedingung"],
    Cell[75040, 2267, 2104, 52, 67, "Text",
      CellTags->"Bedingung"],
    Cell[77147, 2321, 66, 2, 30, "Input",
      CellTags->"Bedingung"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"def", 82940, 2530},
  {"?", 86811, 2649},
  {"Grafische Darstellung von Funktionen", 86931, 2652},
  {"bem1", 88458, 2683},
  {"wertetabellen", 88592, 2686},
  {"Bedingung", 90677, 2741}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 30, 0, 51, "Subtitle"],
Cell[1809, 55, 246, 7, 52, "Text"],

Cell[CellGroupData[{
Cell[2080, 66, 54, 0, 73, "Section"],
Cell[2137, 68, 404, 10, 52, "Text"],
Cell[2544, 80, 11543, 306, 219, "Text"],
Cell[14090, 388, 84, 2, 33, "Text"],
Cell[14177, 392, 42, 1, 30, "Input"],
Cell[14222, 395, 64, 2, 33, "Text"],
Cell[14289, 399, 40, 1, 30, "Input"],
Cell[14332, 402, 536, 13, 52, "Text"],
Cell[14871, 417, 40, 1, 30, "Input"],
Cell[14914, 420, 208, 5, 33, "Text"],
Cell[15125, 427, 42, 1, 30, "Input"],
Cell[15170, 430, 133, 5, 33, "Text"],
Cell[15306, 437, 51, 1, 30, "Input"],
Cell[15360, 440, 143, 3, 33, "Text"],
Cell[15506, 445, 50, 1, 30, "Input"],
Cell[15559, 448, 295, 14, 33, "Text"],
Cell[15857, 464, 46, 1, 30, "Input"],
Cell[15906, 467, 167, 5, 33, "Text"],
Cell[16076, 474, 40, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[16153, 480, 63, 1, 43, "Section",
  CellTags->"def"],
Cell[16219, 483, 95, 1, 33, "Text",
  CellTags->"def"],
Cell[16317, 486, 50, 1, 33, "Text",
  CellTags->"def"],
Cell[16370, 489, 59, 2, 30, "Input",
  CellTags->"def"],
Cell[16432, 493, 276, 9, 33, "Text",
  CellTags->"def"],
Cell[16711, 504, 56, 2, 30, "Input",
  CellTags->"def"],
Cell[16770, 508, 1111, 36, 90, "Text",
  CellTags->"def"],
Cell[17884, 546, 105, 3, 33, "Text",
  CellTags->"def"],
Cell[17992, 551, 106, 3, 50, "Input",
  CellTags->"def"],
Cell[18101, 556, 219, 9, 33, "Text",
  CellTags->"def"],
Cell[18323, 567, 56, 2, 30, "Input",
  CellTags->"def"],
Cell[18382, 571, 645, 23, 52, "Text",
  CellTags->"def"],
Cell[19030, 596, 56, 2, 30, "Input",
  CellTags->"def"],
Cell[19089, 600, 635, 19, 52, "Text",
  CellTags->"def"],
Cell[19727, 621, 63, 1, 33, "Text",
  CellTags->"def"],
Cell[19793, 624, 108, 3, 50, "Input",
  CellTags->"def"],
Cell[19904, 629, 262, 6, 52, "Text",
  CellTags->"def"],
Cell[20169, 637, 90, 1, 33, "Text",
  CellTags->"def"],
Cell[20262, 640, 56, 2, 30, "Input",
  CellTags->"def"],
Cell[20321, 644, 154, 4, 33, "Text",
  CellTags->"def"],
Cell[20478, 650, 65, 2, 30, "Input",
  CellTags->"def"],
Cell[20546, 654, 213, 7, 33, "Text",
  CellTags->"def"],
Cell[20762, 663, 80, 2, 30, "Input",
  CellTags->"def"],
Cell[20845, 667, 231, 7, 33, "Text",
  CellTags->"def"],
Cell[21079, 676, 58, 2, 30, "Input",
  CellTags->"def"],
Cell[21140, 680, 263, 9, 33, "Text",
  CellTags->"def"],
Cell[21406, 691, 63, 2, 30, "Input",
  CellTags->"def"],
Cell[21472, 695, 63, 2, 30, "Input",
  CellTags->"def"],
Cell[21538, 699, 164, 6, 33, "Text",
  CellTags->"def"],
Cell[21705, 707, 74, 2, 30, "Input",
  CellTags->"def"],
Cell[21782, 711, 242, 8, 33, "Text",
  CellTags->"def"],
Cell[22027, 721, 59, 2, 30, "Input",
  CellTags->"def"],
Cell[22089, 725, 60, 2, 30, "Input",
  CellTags->"def"],
Cell[22152, 729, 2570, 69, 48, "Text",
  CellTags->"def"],
Cell[24725, 800, 219, 5, 33, "Text",
  CellTags->"def"],
Cell[24947, 807, 94, 1, 33, "Text",
  CellTags->"def"],
Cell[25044, 810, 82, 2, 42, "Input",
  CellTags->"def"],
Cell[25129, 814, 196, 6, 33, "Text",
  CellTags->"def"],
Cell[25328, 822, 64, 2, 30, "Input",
  CellTags->"def"],
Cell[25395, 826, 65, 2, 30, "Input",
  CellTags->"def"],
Cell[25463, 830, 3435, 87, 67, "Text",
  CellTags->"def"],
Cell[28901, 919, 525, 14, 52, "Text",
  CellTags->"def"],
Cell[29429, 935, 65, 1, 33, "Text",
  CellTags->"def"],
Cell[29497, 938, 70, 2, 30, "Input",
  CellTags->"def"],
Cell[29570, 942, 236, 9, 33, "Text",
  CellTags->"def"],
Cell[29809, 953, 90, 2, 42, "Input",
  CellTags->"def"],
Cell[29902, 957, 172, 4, 33, "Text",
  CellTags->"def"],
Cell[30077, 963, 60, 2, 30, "Input",
  CellTags->"def"],
Cell[30140, 967, 60, 2, 30, "Input",
  CellTags->"def"],
Cell[30203, 971, 340, 10, 33, "Text",
  CellTags->"def"],
Cell[30546, 983, 57, 2, 30, "Input",
  CellTags->"def"],
Cell[30606, 987, 426, 18, 33, "Text",
  CellTags->"def"],
Cell[31035, 1007, 77, 2, 30, "Input",
  CellTags->"def"],
Cell[31115, 1011, 59, 2, 30, "Input",
  CellTags->"def"],
Cell[31177, 1015, 155, 6, 33, "Text",
  CellTags->"def"],
Cell[31335, 1023, 122, 3, 50, "Input",
  CellTags->"def"],
Cell[31460, 1028, 59, 2, 30, "Input",
  CellTags->"def"],
Cell[31522, 1032, 2097, 57, 63, "Text",
  CellTags->{"?", "def"}],
Cell[33622, 1091, 63, 2, 30, "Input",
  CellTags->"def"]
}, Closed]],

Cell[CellGroupData[{
Cell[33722, 1098, 107, 1, 43, "Section",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[33832, 1101, 431, 10, 52, "Text",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[34266, 1113, 118, 2, 30, "Input",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[34387, 1117, 193, 4, 33, "Text",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[34583, 1123, 123, 2, 30, "Input",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[34709, 1127, 6727, 168, 85, "Text",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[41439, 1297, 1721, 57, 109, "Text",
  CellTags->{"bem1", "Grafische Darstellung von Funktionen"}],
Cell[43163, 1356, 188, 6, 33, "Text",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[43354, 1364, 115, 2, 42, "Input",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[43472, 1368, 645, 17, 52, "Text",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[44120, 1387, 132, 2, 30, "Input",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[44255, 1391, 46, 1, 30, "Input"],
Cell[44304, 1394, 160, 4, 33, "Text",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[44467, 1400, 141, 2, 30, "Input",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[44611, 1404, 5472, 133, 85, "Text",
  CellTags->"Grafische Darstellung von Funktionen"],
Cell[50086, 1539, 315, 8, 33, "Text",
  CellTags->"Grafische Darstellung von Funktionen"]
}, Closed]],

Cell[CellGroupData[{
Cell[50438, 1552, 61, 1, 43, "Section",
  CellTags->"wertetabellen"],
Cell[50502, 1555, 1302, 40, 93, "Text",
  CellTags->"wertetabellen"],
Cell[51807, 1597, 91, 2, 42, "Input",
  CellTags->"wertetabellen"],
Cell[51901, 1601, 201, 4, 33, "Text",
  CellTags->"wertetabellen"],
Cell[52105, 1607, 8647, 221, 119, "Text",
  CellTags->"wertetabellen"],
Cell[60755, 1830, 278, 5, 33, "Text",
  CellTags->"wertetabellen"],
Cell[61036, 1837, 100, 2, 30, "Input",
  CellTags->"wertetabellen"],
Cell[61139, 1841, 413, 13, 33, "Text",
  CellTags->"wertetabellen"],
Cell[61555, 1856, 85, 2, 30, "Input",
  CellTags->"wertetabellen"],
Cell[61643, 1860, 443, 15, 33, "Text",
  CellTags->"wertetabellen"],
Cell[62089, 1877, 319, 8, 33, "Text",
  CellTags->"wertetabellen"],
Cell[62411, 1887, 83, 2, 30, "Input",
  CellTags->"wertetabellen"],
Cell[62497, 1891, 140, 6, 33, "Text",
  CellTags->"wertetabellen"],
Cell[62640, 1899, 83, 2, 30, "Input",
  CellTags->"wertetabellen"],
Cell[62726, 1903, 114, 2, 33, "Text",
  CellTags->"wertetabellen"],
Cell[62843, 1907, 86, 2, 30, "Input",
  CellTags->"wertetabellen"],
Cell[62932, 1911, 52, 1, 33, "Text",
  CellTags->"wertetabellen"],
Cell[62987, 1914, 96, 2, 30, "Input",
  CellTags->"wertetabellen"],
Cell[63086, 1918, 52, 1, 33, "Text",
  CellTags->"wertetabellen"],
Cell[63141, 1921, 86, 2, 30, "Input",
  CellTags->"wertetabellen"],
Cell[63230, 1925, 183, 6, 33, "Text",
  CellTags->"wertetabellen"],
Cell[63416, 1933, 81, 2, 30, "Input",
  CellTags->"wertetabellen"],
Cell[63500, 1937, 7151, 175, 125, "Text",
  CellTags->"wertetabellen"],
Cell[70654, 2114, 584, 17, 52, "Text",
  CellTags->"wertetabellen"],
Cell[71241, 2133, 169, 3, 63, "Input",
  CellTags->"wertetabellen"],
Cell[71413, 2138, 74, 2, 30, "Input",
  CellTags->"wertetabellen"],
Cell[71490, 2142, 75, 2, 30, "Input",
  CellTags->"wertetabellen"]
}, Closed]],

Cell[CellGroupData[{
Cell[71602, 2149, 92, 1, 43, "Section",
  CellTags->"Bedingung"],
Cell[71697, 2152, 1058, 34, 78, "Text",
  CellTags->"Bedingung"],
Cell[72758, 2188, 216, 5, 63, "Input",
  CellTags->"Bedingung"],
Cell[72977, 2195, 470, 14, 52, "Text",
  CellTags->"Bedingung"],
Cell[73450, 2211, 62, 2, 30, "Input",
  CellTags->"Bedingung"],
Cell[73515, 2215, 67, 2, 30, "Input",
  CellTags->"Bedingung"],
Cell[73585, 2219, 136, 4, 33, "Text",
  CellTags->"Bedingung"],
Cell[73724, 2225, 62, 2, 30, "Input",
  CellTags->"Bedingung"],
Cell[73789, 2229, 1161, 32, 71, "Text",
  CellTags->"Bedingung"],
Cell[74953, 2263, 84, 2, 30, "Input",
  CellTags->"Bedingung"],
Cell[75040, 2267, 2104, 52, 67, "Text",
  CellTags->"Bedingung"],
Cell[77147, 2321, 66, 2, 30, "Input",
  CellTags->"Bedingung"]
}, Closed]],

Cell[CellGroupData[{
Cell[77250, 2328, 54, 0, 43, "Section"],
Cell[77307, 2330, 365, 10, 52, "Text"],
Cell[77675, 2342, 121, 2, 50, "Input"],
Cell[77799, 2346, 584, 15, 90, "Text"],
Cell[78386, 2363, 126, 3, 33, "Text"],
Cell[78515, 2368, 45, 1, 30, "Input"],
Cell[78563, 2371, 46, 1, 30, "Input"],
Cell[78612, 2374, 270, 8, 33, "Text"],
Cell[78885, 2384, 45, 1, 30, "Input"],
Cell[78933, 2387, 46, 1, 30, "Input"],
Cell[78982, 2390, 126, 5, 33, "Text"],
Cell[79111, 2397, 50, 1, 30, "Input"],
Cell[79164, 2400, 47, 1, 30, "Input"],
Cell[79214, 2403, 45, 1, 30, "Input"],
Cell[79262, 2406, 1435, 33, 109, "Text"],
Cell[80700, 2441, 50, 1, 30, "Input"],
Cell[80753, 2444, 395, 12, 52, "Text"],
Cell[81151, 2458, 134, 3, 30, "Input"],
Cell[81288, 2463, 278, 11, 33, "Text"],
Cell[81569, 2476, 49, 1, 30, "Input"],
Cell[81621, 2479, 46, 1, 30, "Input"],
Cell[81670, 2482, 321, 11, 33, "Text"],
Cell[81994, 2495, 50, 1, 30, "Input"],
Cell[82047, 2498, 47, 1, 30, "Input"],
Cell[82097, 2501, 45, 1, 30, "Input"],
Cell[82145, 2504, 45, 1, 30, "Input"],
Cell[82193, 2507, 49, 1, 30, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

