(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     32719,       1050]*)
(*NotebookOutlinePosition[     34892,       1121]*)
(*  CellTagsIndexPosition[     34821,       1115]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Grenzwertberechnungen bei Folgen und Reihen", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell[CellGroupData[{

Cell["Folgen", "Section"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Limit", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["n",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{
                StyleBox["n",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "\[Rule]", "Infinity"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["findet",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["den",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Grenzwert",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["n",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["wenn",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["n",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{
                    StyleBox[" ",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"]}]], 
                StyleBox["gegen",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["\[Infinity]",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["geht",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  "Wenn eine Folge durch einen erzeugenden Term gegeben ist, kann ",
  StyleBox["Limit",
    FontFamily->"Courier New"],
  " den Grenzwert (sofern existent) zumeist ermitteln."
}], "Text",
  TextAlignment->Left,
  TextJustification->0],

Cell["Die Folge konvergiert.", "Text"],

Cell[BoxData[
    \(Limit[a/n, n \[Rule] Infinity]\)], "Input"],

Cell["Die Glieder dieser Folge werden beliebig gro\[SZ].", "Text"],

Cell[BoxData[
    \(Limit[n, n \[Rule] Infinity]\)], "Input"],

Cell[TextData[{
  "Diese Folge besitzt zwei H\[ADoubleDot]ufungspunkte. ",
  StyleBox["Limit",
    FontFamily->"Courier New"],
  " kann daher keinen Grenzwert ermitteln."
}], "Text"],

Cell[BoxData[
    \(Limit[\((\(-1\))\)^n, n \[Rule] Infinity]\)], "Input"],

Cell[TextData[{
  "Der erzeugende Term dieser Folge ist zu allgemein. ",
  "Der Grenzwert der Folge ",
  Cell[BoxData[
      \(TraditionalForm\`1\/n\^k\)]],
  " h\[ADoubleDot]ngt von ",
  StyleBox["k",
    FontSlant->"Italic"],
  " ab."
}], "Text"],

Cell[BoxData[
    \(Limit[1/n^k, n \[Rule] Infinity]\)], "Input"],

Cell[TextData[{
  "F\[UDoubleDot]r positive ",
  StyleBox["k",
    FontSlant->"Italic"],
  " ist der Limes 0."
}], "Text"],

Cell[BoxData[
    \(Limit[1/n^\((1/3)\), n \[Rule] Infinity]\)], "Input"],

Cell[TextData[{
  "F\[UDoubleDot]r ",
  StyleBox["k",
    FontSlant->"Italic"],
  "=0 ist der Limes 1."
}], "Text"],

Cell[BoxData[
    \(Limit[1/n^0, n \[Rule] Infinity]\)], "Input"],

Cell[TextData[{
  "F\[UDoubleDot]r negative ",
  StyleBox["k",
    FontSlant->"Italic"],
  " divergiert die Folge."
}], "Text"],

Cell[BoxData[
    \(Limit[1/n^\((\(-2\))\), n \[Rule] Infinity]\)], "Input"],

Cell["", "Text"],

Cell[TextData[{
  "Oft sind Folgen rekursiv definiert. Der Befehl ",
  StyleBox["FixedPoint",
    FontFamily->"Courier New"],
  " kann dazu verwendet werden, um Grenzwerte solcher Folgen zu ermitteln."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"FixedPoint", "[", 
            RowBox[{
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              StyleBox[
                SubscriptBox[
                  StyleBox["x",
                    FontSlant->"Italic"], "0"],
                FontFamily->"Times New Roman"]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["berechnet",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{"(", 
                    SubscriptBox[
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "0"], ")"}],
                  FontFamily->"Times New Roman"]}], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["f",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[
                      RowBox[{"(", 
                        SubscriptBox[
                          StyleBox["x",
                            FontFamily->"Times New Roman",
                            FontSlant->"Italic"], "0"], ")"}],
                      FontFamily->"Times New Roman"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["f",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      RowBox[{
                        StyleBox["f",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[
                          RowBox[{"(", 
                            SubscriptBox[
                              StyleBox["x",
                                FontFamily->"Times New Roman",
                                FontSlant->"Italic"], "0"], ")"}],
                          FontFamily->"Times New Roman"]}], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}], 
                StyleBox[
                  RowBox[{" ", 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"]}]], 
                StyleBox[\(\(etc\)\(.\)\),
                  FontFamily->"Times New Roman"]}], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              
              StyleBox[\(bis\ sich\ das\ Ergebnis\ nicht\ mehr\ \
\[ADoubleDot]ndert\),
                FontFamily->"Times New Roman"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  StyleBox["ACHTUNG",
    FontWeight->"Bold"],
  ": Der Befehl ",
  StyleBox["FixedPoint",
    FontFamily->"Courier New"],
  " verlangt als erstes Argument den NAMEN der Funktion, NICHT ihren \
FunktionsTERM! (Vgl. die ",
  ButtonBox["Bemerkung",
    ButtonData:>{"funktionen.nb", "bem1"},
    ButtonStyle->"Hyperlink"],
  " nach der ersten Definitionsbox im Abschnitt ",
  ButtonBox["Grafische Darstellung von Funktionen",
    ButtonData:>{"funktionen.nb", "Grafische Darstellung von Funktionen"},
    ButtonStyle->"Hyperlink"],
  " im Kapitel ",
  ButtonBox["Funktionen",
    ButtonData:>{"funktionen.nb", None},
    ButtonStyle->"Hyperlink"],
  ".)"
}], "Text"],

Cell[TextData[{
  StyleBox["myNewton",
    FontFamily->"Courier New"],
  " f\[UDoubleDot]hrt einen Schritt des \
Newton-N\[ADoubleDot]herungsverfahrens zur Berechnung von ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\%3\)]],
  " durch. Das Ergebnis wird auf 20 Stellen genau ausgerechnet."
}], "Text"],

Cell[BoxData[
    \(myNewton[x_] := N[x + \(2 - x\^3\)\/\(3  x\^2\), 20]\)], "Input"],

Cell[TextData[{
  StyleBox["FixedPoint",
    FontFamily->"Courier New"],
  " wendet ",
  StyleBox["myNewton",
    FontFamily->"Courier New"],
  " wiederholt an, bis sich das Ergebnis nicht mehr \[ADoubleDot]ndert. Der \
Startwert ist 1."
}], "Text"],

Cell[BoxData[
    \(FixedPoint[myNewton, 1]\)], "Input"],

Cell["Kontrolle:", "Text"],

Cell[BoxData[
    \(N[\@2\%3, 19]\)], "Input"],

Cell[TextData[{
  "Bei der Definition von ",
  StyleBox["myNewton",
    FontFamily->"Courier New"],
  " ist der Befehl ",
  StyleBox["N",
    FontFamily->"Courier New"],
  " entscheidend. Ohne ihn rechnet ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " exakt (da auch der Startwert exakt ist) und findet daher nie zwei gleiche \
aufeinanderfolgende Ergebnisse."
}], "Text"],

Cell[BoxData[
    \(myNewton2[x_] := x + \(2 - x\^3\)\/\(3  x\^2\)\)], "Input"],

Cell[BoxData[
    \(\(\(FixedPoint[myNewton2, 
      1]\)\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \)\( (*\ 
      Abbruch\ mit\ "\<Alt\>" + "\<.\>"\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Das Problem kann umgangen werden, indem der Startwert nicht exakt (gemeint \
ist hier eine Zahl mit einem Dezimalpunkt oder in Verbindung mit dem Befehl \
",
  StyleBox["N",
    FontFamily->"Courier New"],
  ") eingegeben wird."
}], "Text"],

Cell[BoxData[
    \(FixedPoint[myNewton2, N[1, 20]]\)], "Input"],

Cell[BoxData[
    \(Clear[myNewton, myNewton2]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Reihen", "Section"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Sum", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["n",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["n",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["nmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["nmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["berechnet",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["die",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Summe",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox[
                  UnderoverscriptBox["\[Sum]", 
                    RowBox[{
                      StyleBox["n",
                        FontSlant->"Italic"], "=", 
                      StyleBox["nmin",
                        FontSlant->"Italic"]}], 
                    StyleBox["nmax",
                      FontSlant->"Italic"]],
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["f",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox["(",
                      FontFamily->"Times New Roman"], 
                    StyleBox["n",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[")",
                      FontFamily->"Times New Roman"]}]}]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  "Das berechnet ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(n = 0\)\%50 1\/\(n!\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\(\ \)\(Sum[1/\(n!\), {n, 0, 50}]\)\)\)], "Input"],

Cell[TextData[{
  "Den Grenzwert (falls existent) erh\[ADoubleDot]lt man, indem man f\
\[UDoubleDot]r ",
  StyleBox["nmax",
    FontSlant->"Italic"],
  " ",
  StyleBox["Infinity",
    FontFamily->"Courier New"],
  " angibt. Die Eingabe ist exakt, daher ist die Ausgabe ebenfalls exakt und \
keine Approximation."
}], "Text"],

Cell[BoxData[
    \(\(\(\ \)\(Sum[1/\(n!\), {n, 0, Infinity}]\)\)\)], "Input"],

Cell[TextData[{
  StyleBox["nmin",
    FontSlant->"Italic"],
  " und ",
  StyleBox["nmax",
    FontSlant->"Italic"],
  " m\[UDoubleDot]ssen keine Zahlen sein."
}], "Text"],

Cell[BoxData[
    \(Sum[n, {n, a, b}]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"NSum", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["n",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["n",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["nmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["nmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["berechnet",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["eine",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["numerische",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Approximation",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["der",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Summe",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox[
                  UnderoverscriptBox["\[Sum]", 
                    RowBox[{
                      StyleBox["n",
                        FontSlant->"Italic"], "=", 
                      StyleBox["nmin",
                        FontSlant->"Italic"]}], 
                    StyleBox["nmax",
                      FontSlant->"Italic"]],
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["f",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  RowBox[{
                    StyleBox["(",
                      FontFamily->"Times New Roman"], 
                    StyleBox["n",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[")",
                      FontFamily->"Times New Roman"]}]}]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  StyleBox["NSum",
    FontFamily->"Courier New"],
  " verwendet numerische Algorithmen zur Berechnung der Summe. ",
  StyleBox["nmin",
    FontSlant->"Italic"],
  " und ",
  StyleBox["nmax",
    FontSlant->"Italic"],
  " m\[UDoubleDot]ssen daher Zahlen oder ",
  StyleBox["Infinity",
    FontFamily->"Courier New"],
  " sein."
}], "Text"],

Cell[BoxData[
    \(\(\(\ \)\(NSum[1/\(n!\), {n, 0, Infinity}]\)\)\)], "Input"],

Cell["", "Text"],

Cell[TextData[{
  "Ob der Befehl ",
  StyleBox["Sum",
    FontFamily->"Courier New"],
  " oder ",
  StyleBox["NSum",
    FontFamily->"Courier New"],
  " das bessere Ergebnis liefert, h\[ADoubleDot]ngt von der Reihe ab:"
}], "Text"],

Cell[TextData[{
  StyleBox["Sum",
    FontFamily->"Courier New"],
  " liefert hier das richtige Ergebnis."
}], "Text"],

Cell[BoxData[
    \(Sum[1/n, {n, 1, Infinity}]\)], "Input"],

Cell["\<\
Die Folge der Partialsummen der harmonischen Reihe w\[ADoubleDot]chst zu \
langsam f\[UDoubleDot]r einen numerischen Algorithmus, die Divergenz wird \
nicht erkannt.\
\>", "Text"],

Cell[BoxData[
    \(NSum[1/n, {n, 1, Infinity}]\)], "Input"],

Cell[TextData[{
  "Die folgende Reihe ist zu kompliziert f\[UDoubleDot]r den Befehl ",
  StyleBox["Sum",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(Sum[1\/\(n*Log[n]\^2\), {n, 2, Infinity}]\)], "Input"],

Cell[TextData[{
  StyleBox["NSum",
    FontFamily->"Courier New"],
  " liefert hier ein Ergebnis."
}], "Text"],

Cell[BoxData[
    \(NSum[1\/\(n*Log[n]\^2\), {n, 2, Infinity}]\)], "Input"],

Cell[TextData[{
  "Faustregel: Wenn ",
  StyleBox["Sum",
    FontFamily->"Courier New"],
  " ein Ergebnis liefert, dann ist dieses im Allgemeinen auch richtig \
(Vorsicht ist geboten, wenn die Summe von einem Parameter abh\[ADoubleDot]ngt \
\[Rule] siehe unten). F\[UDoubleDot]r ",
  StyleBox["NSum",
    FontFamily->"Courier New"],
  " gilt das nicht (siehe harmonische Reihe)."
}], "Text"],

Cell["", "Text"],

Cell[TextData[{
  StyleBox["ACHTUNG",
    FontWeight->"Bold"],
  ": ",
  StyleBox["Sum",
    FontFamily->"Courier New"],
  " setzt hier stillschweigend voraus, dass |",
  StyleBox["q",
    FontSlant->"Italic"],
  "|<1."
}], "Text"],

Cell[BoxData[
    \(Sum[q^n, {n, 0, Infinity}]\)], "Input"],

Cell[TextData[{
  "In das Ergebnis k\[ODoubleDot]nnen aber auch andere Werte f\[UDoubleDot]r \
",
  StyleBox["q",
    FontSlant->"Italic"],
  " eingesetzt werden."
}], "Text"],

Cell[BoxData[
    \(% /. q \[Rule] 2\)], "Input"],

Cell[TextData[{
  "F\[UDoubleDot]r ",
  StyleBox["q",
    FontSlant->"Italic"],
  "=2 konvergiert die Reihe ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(n = 0\)\%\[Infinity] q\^n\)]],
  " aber nicht."
}], "Text"],

Cell[BoxData[
    \(Sum[2^n, {n, 0, Infinity}]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Grafische Darstellung von Folgen und Reihen", "Section",
  CellTags->"graf"],

Cell[TextData[{
  "Zur grafischen Darstellung von Folgen und Reihen bietet sich der Befehl ",
  StyleBox["ListPlot",
    FontFamily->"Courier New"],
  " an."
}], "Text",
  CellTags->"graf"],

Cell[TextData[{
  "Hier ist eine Liste der ersten sieben Folgenglieder der Folge ",
  Cell[BoxData[
      \(TraditionalForm\`n\^2\)]],
  "."
}], "Text",
  CellTags->"graf"],

Cell[BoxData[
    \(folgenglieder = Table[n^2, {n, 7}]\)], "Input",
  CellTags->"graf"],

Cell[TextData[{
  StyleBox["ListPlot",
    FontFamily->"Courier New"],
  " zeichnet eine Liste von Werten als Punkte im ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  ". Die ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-Koordinaten der einzelnen Punkte sind der Reihe nach die Werte 1, 2, 3, \
... , die ",
  StyleBox["y",
    FontSlant->"Italic"],
  "-Koordinaten sind die Werte in der Liste."
}], "Text",
  CellTags->"graf"],

Cell[TextData[{
  "Der ",
  StyleBox["ListPlot",
    FontFamily->"Courier New"],
  " unserer Liste ",
  StyleBox["folgenglieder",
    FontFamily->"Courier New"],
  " sieht also so aus:"
}], "Text",
  CellTags->"graf"],

Cell[BoxData[
    \(ListPlot[folgenglieder]\)], "Input",
  CellTags->"graf"],

Cell[BoxData[
    \(Clear[folgenglieder]\)], "Input",
  CellTags->"graf"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"ListPlot", "[", 
            RowBox[{"{", 
              RowBox[{
                StyleBox[
                  SubscriptBox[
                    StyleBox["y",
                      FontSlant->"Italic"], "1"],
                  FontFamily->"Times New Roman"], ",", 
                StyleBox[
                  SubscriptBox[
                    StyleBox["y",
                      FontSlant->"Italic"], "2"],
                  FontFamily->"Times New Roman"], ",", "...", ",", 
                StyleBox[\(y\_n\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], "}"}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox[
                RowBox[{"zeichnet", " ", "die", " ", "Punkte", " ", 
                  RowBox[{"(", 
                    RowBox[{"1", ",", " ", 
                      SubscriptBox[
                        StyleBox["y",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], "1"]}], ")"}]}],
                FontFamily->"Times New Roman"], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox[
                RowBox[{"(", 
                  RowBox[{"2", ",", " ", 
                    SubscriptBox[
                      StyleBox["y",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "2"]}], ")"}],
                FontFamily->"Times New Roman"], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox["...",
                FontFamily->"Courier New"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["n",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[\(y\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"graf"],

Cell["\<\
Hier noch ein Beispiel: Das ist eine Liste der ersten 20 Partialsummen der \
harmonischen Reihe.\
\>", "Text",
  CellTags->"graf"],

Cell[BoxData[
    \(partialsummen = Table[\[Sum]\+\(i = 1\)\%n 1\/i, {n, 1, 20}]\)], "Input",\

  CellTags->"graf"],

Cell[TextData[{
  "Und das ist der ",
  StyleBox["ListPlot",
    FontFamily->"Courier New"],
  " der ersten 20 Partialsummen."
}], "Text",
  CellTags->"graf"],

Cell[BoxData[
    \(ListPlot[partialsummen]\)], "Input",
  CellTags->"graf"],

Cell[BoxData[
    \(Clear[partialsummen]\)], "Input",
  CellTags->"graf"],

Cell["", "Text",
  CellTags->"graf"],

Cell[TextData[{
  "Wir k\[ODoubleDot]nnen die ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-Koordinaten der Punkte, die ",
  StyleBox["ListPlot",
    FontFamily->"Courier New"],
  " zeichnen soll, auch explizit angeben. Dazu \[UDoubleDot]bergeben wir an \
",
  StyleBox["ListPlot",
    FontFamily->"Courier New"],
  " eine Liste von Zahlenpaaren ",
  StyleBox["{",
    FontFamily->"Courier New"],
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\_i\)]],
  StyleBox["}",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"graf"],

Cell[TextData[{
  "Das liefert eine grafische Darstellung der Punkte ",
  "(",
  Cell[BoxData[
      \(TraditionalForm\`1\/2\)]],
  ", 7), (2, -1) und (-2.3, 2)."
}], "Text",
  CellTags->"graf"],

Cell[BoxData[
    \(ListPlot[{{1\/2, 5}, {2, \(-1\)}, {\(-2.3\), 2}}]\)], "Input",
  CellTags->"graf"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"ListPlot", "[", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["x",
                          FontSlant->"Italic"], "1"],
                      FontFamily->"Times New Roman"], ",", 
                    StyleBox[
                      SubscriptBox[
                        StyleBox["y",
                          FontSlant->"Italic"], "1"],
                      FontFamily->"Times New Roman"]}], 
                  StyleBox["}",
                    FontFamily->"Times New Roman"]}], ",", "...", ",", 
                RowBox[{"{", 
                  RowBox[{
                    StyleBox[\(x\_n\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], ",", 
                    StyleBox[\(y\_n\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], "}"}]}], "}"}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox[
                RowBox[{"zeichnet", " ", "die", " ", "Punkte", " ", 
                  RowBox[{"(", 
                    RowBox[{
                      SubscriptBox[
                        StyleBox["x",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], "1"], ",", " ", 
                      SubscriptBox[
                        StyleBox["y",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], "1"]}], ")"}]}],
                FontFamily->"Times New Roman"], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox["...",
                FontFamily->"Courier New"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox[\(x\_n\),
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[\(y\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"graf"],

Cell[TextData[{
  "Es ist daher auch m\[ODoubleDot]glich, Folgen ",
  "im ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " mit Hilfe des Befehls ",
  StyleBox["ListPlot",
    FontFamily->"Courier New"],
  " grafisch darzustellen. Hier ist eine grafische Darstellung der ersten 20 \
Folgenglieder der Folge ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(1\/n\) \(sin(n/3)\), \ \(1\/n\) \(cos(n/3)\))\)\
\_\(n \[Element] N\)\)]],
  ":"
}], "Text",
  CellTags->"graf"],

Cell[BoxData[
    \(ListPlot[Table[{1\/n*Sin[n/3], 1\/n*Cos[n/3]}, {n, 1, 20}]]\)], "Input",\

  CellTags->"graf"],

Cell[TextData[{
  "Wie Sie zum Beispiel die Gr\[ODoubleDot]\[SZ]e gezeichneten Punkt ver\
\[ADoubleDot]ndern kann, das erfahren Sie im Abschnitt ",
  ButtonBox["Plots im R2",
    ButtonData:>{"plots.nb", "plotR2"},
    ButtonStyle->"Hyperlink"],
  " des Kapitels ",
  ButtonBox["Plots",
    ButtonData:>{"plots.nb", None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->"graf"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "graf"->{
    Cell[23140, 739, 82, 1, 43, "Section",
      CellTags->"graf"],
    Cell[23225, 742, 189, 6, 33, "Text",
      CellTags->"graf"],
    Cell[23417, 750, 172, 6, 33, "Text",
      CellTags->"graf"],
    Cell[23592, 758, 87, 2, 30, "Input",
      CellTags->"graf"],
    Cell[23682, 762, 460, 15, 33, "Text",
      CellTags->"graf"],
    Cell[24145, 779, 217, 9, 33, "Text",
      CellTags->"graf"],
    Cell[24365, 790, 76, 2, 30, "Input",
      CellTags->"graf"],
    Cell[24444, 794, 73, 2, 30, "Input",
      CellTags->"graf"],
    Cell[24520, 798, 2792, 71, 48, "Text",
      CellTags->"graf"],
    Cell[27315, 871, 140, 4, 33, "Text",
      CellTags->"graf"],
    Cell[27458, 877, 115, 3, 49, "Input",
      CellTags->"graf"],
    Cell[27576, 882, 158, 6, 33, "Text",
      CellTags->"graf"],
    Cell[27737, 890, 76, 2, 30, "Input",
      CellTags->"graf"],
    Cell[27816, 894, 73, 2, 30, "Input",
      CellTags->"graf"],
    Cell[27892, 898, 36, 1, 33, "Text",
      CellTags->"graf"],
    Cell[27931, 901, 595, 23, 33, "Text",
      CellTags->"graf"],
    Cell[28529, 926, 194, 7, 36, "Text",
      CellTags->"graf"],
    Cell[28726, 935, 102, 2, 42, "Input",
      CellTags->"graf"],
    Cell[28831, 939, 2848, 71, 48, "Text",
      CellTags->"graf"],
    Cell[31682, 1012, 498, 15, 60, "Text",
      CellTags->"graf"],
    Cell[32183, 1029, 114, 3, 42, "Input",
      CellTags->"graf"],
    Cell[32300, 1034, 391, 12, 33, "Text",
      CellTags->"graf"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"graf", 33328, 1066}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 63, 0, 51, "Subtitle"],
Cell[1842, 55, 246, 7, 52, "Text"],

Cell[CellGroupData[{
Cell[2113, 66, 25, 0, 73, "Section"],
Cell[2141, 68, 3141, 80, 48, "Text"],
Cell[5285, 150, 251, 7, 33, "Text"],
Cell[5539, 159, 38, 0, 33, "Text"],
Cell[5580, 161, 63, 1, 30, "Input"],
Cell[5646, 164, 66, 0, 33, "Text"],
Cell[5715, 166, 61, 1, 30, "Input"],
Cell[5779, 169, 182, 5, 33, "Text"],
Cell[5964, 176, 74, 1, 30, "Input"],
Cell[6041, 179, 248, 9, 36, "Text"],
Cell[6292, 190, 65, 1, 30, "Input"],
Cell[6360, 193, 122, 5, 33, "Text"],
Cell[6485, 200, 73, 1, 30, "Input"],
Cell[6561, 203, 115, 5, 33, "Text"],
Cell[6679, 210, 65, 1, 30, "Input"],
Cell[6747, 213, 127, 5, 33, "Text"],
Cell[6877, 220, 76, 1, 30, "Input"],
Cell[6956, 223, 16, 0, 33, "Text"],
Cell[6975, 225, 213, 5, 33, "Text"],
Cell[7191, 232, 3967, 99, 48, "Text"],
Cell[11161, 333, 680, 20, 52, "Text"],
Cell[11844, 355, 303, 8, 36, "Text"],
Cell[12150, 365, 85, 1, 45, "Input"],
Cell[12238, 368, 249, 8, 33, "Text"],
Cell[12490, 378, 56, 1, 30, "Input"],
Cell[12549, 381, 26, 0, 33, "Text"],
Cell[12578, 383, 46, 1, 35, "Input"],
Cell[12627, 386, 384, 12, 52, "Text"],
Cell[13014, 400, 79, 1, 45, "Input"],
Cell[13096, 403, 216, 4, 30, "Input"],
Cell[13315, 409, 259, 7, 33, "Text"],
Cell[13577, 418, 64, 1, 30, "Input"],
Cell[13644, 421, 59, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[13740, 427, 25, 0, 43, "Section"],
Cell[13768, 429, 2610, 67, 49, "Text"],
Cell[16381, 498, 131, 5, 36, "Text"],
Cell[16515, 505, 72, 1, 30, "Input"],
Cell[16590, 508, 324, 10, 33, "Text"],
Cell[16917, 520, 78, 1, 30, "Input"],
Cell[16998, 523, 171, 7, 33, "Text"],
Cell[17172, 532, 50, 1, 30, "Input"],
Cell[17225, 535, 3097, 79, 49, "Text"],
Cell[20325, 616, 355, 13, 33, "Text"],
Cell[20683, 631, 79, 1, 30, "Input"],
Cell[20765, 634, 16, 0, 33, "Text"],
Cell[20784, 636, 231, 8, 33, "Text"],
Cell[21018, 646, 118, 4, 33, "Text"],
Cell[21139, 652, 59, 1, 30, "Input"],
Cell[21201, 655, 189, 4, 33, "Text"],
Cell[21393, 661, 60, 1, 30, "Input"],
Cell[21456, 664, 154, 5, 33, "Text"],
Cell[21613, 671, 74, 1, 44, "Input"],
Cell[21690, 674, 110, 4, 33, "Text"],
Cell[21803, 680, 75, 1, 44, "Input"],
Cell[21881, 683, 391, 10, 52, "Text"],
Cell[22275, 695, 16, 0, 33, "Text"],
Cell[22294, 697, 231, 10, 33, "Text"],
Cell[22528, 709, 59, 1, 30, "Input"],
Cell[22590, 712, 175, 6, 33, "Text"],
Cell[22768, 720, 49, 1, 30, "Input"],
Cell[22820, 723, 221, 8, 33, "Text"],
Cell[23044, 733, 59, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[23140, 739, 82, 1, 43, "Section",
  CellTags->"graf"],
Cell[23225, 742, 189, 6, 33, "Text",
  CellTags->"graf"],
Cell[23417, 750, 172, 6, 33, "Text",
  CellTags->"graf"],
Cell[23592, 758, 87, 2, 30, "Input",
  CellTags->"graf"],
Cell[23682, 762, 460, 15, 33, "Text",
  CellTags->"graf"],
Cell[24145, 779, 217, 9, 33, "Text",
  CellTags->"graf"],
Cell[24365, 790, 76, 2, 30, "Input",
  CellTags->"graf"],
Cell[24444, 794, 73, 2, 30, "Input",
  CellTags->"graf"],
Cell[24520, 798, 2792, 71, 48, "Text",
  CellTags->"graf"],
Cell[27315, 871, 140, 4, 33, "Text",
  CellTags->"graf"],
Cell[27458, 877, 115, 3, 49, "Input",
  CellTags->"graf"],
Cell[27576, 882, 158, 6, 33, "Text",
  CellTags->"graf"],
Cell[27737, 890, 76, 2, 30, "Input",
  CellTags->"graf"],
Cell[27816, 894, 73, 2, 30, "Input",
  CellTags->"graf"],
Cell[27892, 898, 36, 1, 33, "Text",
  CellTags->"graf"],
Cell[27931, 901, 595, 23, 33, "Text",
  CellTags->"graf"],
Cell[28529, 926, 194, 7, 36, "Text",
  CellTags->"graf"],
Cell[28726, 935, 102, 2, 42, "Input",
  CellTags->"graf"],
Cell[28831, 939, 2848, 71, 48, "Text",
  CellTags->"graf"],
Cell[31682, 1012, 498, 15, 60, "Text",
  CellTags->"graf"],
Cell[32183, 1029, 114, 3, 42, "Input",
  CellTags->"graf"],
Cell[32300, 1034, 391, 12, 33, "Text",
  CellTags->"graf"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

