(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     67436,       1937]*)
(*NotebookOutlinePosition[     70038,       2020]*)
(*  CellTagsIndexPosition[     69965,       2014]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Gew\[ODoubleDot]hnliche Differentialgleichungen", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Der Befehl ",
  StyleBox["DSolve",
    FontFamily->"Courier New"]
}], "Section",
  CellTags->"dsolve"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ist in der Lage, eine Reihe verschiedener Klassen von \
gew\[ODoubleDot]hnlichen Differentialgleichungen zu l\[ODoubleDot]sen. Der \
zugeh\[ODoubleDot]rige Befehl hei\[SZ]t ",
  StyleBox["DSolve",
    FontFamily->"Courier New"],
  " und funktioniert \[ADoubleDot]hnlich wie der ",
  StyleBox["Solve",
    FontFamily->"Courier New"],
  "-Befehl."
}], "Text",
  CellTags->"dsolve"],

Cell[TextData[{
  StyleBox["DSolve",
    FontFamily->"Courier New"],
  " verlangt drei Argumente: die Gleichung, die Funktion, nach der die \
Gleichung aufgel\[ODoubleDot]st werden soll, und die Variable, von der die \
Funktion abh\[ADoubleDot]ngt."
}], "Text",
  CellTags->"dsolve"],

Cell[BoxData[
    \(DSolve[\(y'\)[t] \[Equal] t*y[t], y[t], t]\)], "Input",
  CellTags->"dsolve"],

Cell[TextData[{
  "Um die unbekannte Konstante ",
  StyleBox["C[1]",
    FontFamily->"Courier New"],
  " aus der L\[ODoubleDot]sung zu eliminieren, muss eine Anfangs- oder \
Randbedingung angegeben werden. Mehrere Gleichungen werden als Liste \
eingegeben."
}], "Text",
  CellTags->"dsolve"],

Cell[BoxData[
    \(DSolve[{\(y'\)[t] \[Equal] t*y[t], y[0] \[Equal] 2}, y[t], 
      t]\)], "Input",
  CellTags->"dsolve"],

Cell[TextData[{
  StyleBox["DSolve",
    FontFamily->"Courier New"],
  " l\[ODoubleDot]st auch Systeme von Differentialgleichungen. Die \
Gleichungen und Funktionen werden dabei als Listen eingegeben."
}], "Text",
  CellTags->"dsolve"],

Cell[BoxData[
    \(DSolve[{\(y'\)[t] \[Equal] x[t]*y[t], \(x'\)[t] \[Equal] y[t]}, {x[t], 
        y[t]}, t]\)], "Input",
  CellTags->"dsolve"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"DSolve", "[", 
            RowBox[{
              StyleBox["gleichung",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              RowBox[{
                StyleBox["y",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "[", 
                StyleBox["t",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "]"}], ",", 
              StyleBox["t",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["versucht",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Differentialgleichung",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["gleichung",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["nach",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["y",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["[",
                    FontFamily->"Courier New"], 
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["]",
                    FontFamily->"Courier New"]}], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["zu",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["l\[ODoubleDot]sen",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[",",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", "   ", 
              
              RowBox[{
                StyleBox["wobei",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["t",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["als",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["unabh\[ADoubleDot]ngige",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Variable",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["ist",
                  FontFamily->"Times New Roman"]}]}]}]},
        {
          RowBox[{"DSolve", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["gl",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}], ",", "\[IndentingNewLine]",
               
              RowBox[{"{", 
                RowBox[{
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["y",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], "1"],
                      FontFamily->"Times New Roman"], "[", 
                    StyleBox["t",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "]"}], ",", "...", ",", 
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["y",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox["m",
                          FontSlant->"Italic"]],
                      FontFamily->"Times New Roman"], "[", 
                    StyleBox["t",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "]"}]}], "}"}], ",", "t"}], "]"}],
           
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox[
                  RowBox[{
                  "versucht", " ", "das", " ", "Differentialgleichungssystem",
                     "  ", 
                    SubscriptBox[
                      StyleBox["gl",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"]}],
                  FontFamily->"Times New Roman"], ",", "...", ",", 
                RowBox[{
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["nach",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["den",
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
              RowBox[{
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["y",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], "[", 
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], "]"}], ",", "...", ",", 
                RowBox[{
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["y",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox["m",
                          FontSlant->"Italic"]],
                      FontFamily->"Times New Roman"], "[", 
                    StyleBox["t",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "]"}], 
                  StyleBox[
                    RowBox[{" ", 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"]}]], 
                  StyleBox["zu",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["l\[ODoubleDot]sen",
                    FontFamily->"Times New Roman"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["wobei",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["die",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["unabh\[ADoubleDot]ngige",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Variable",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["ist",
                    FontFamily->"Times New Roman"]}]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"dsolve"],

Cell[TextData[{
  "Hier ist eine einfache Differentialgleichung erster Ordnung mit \
Anfangsbedingung. Die L\[ODoubleDot]sung ist eine Ersetzungsregel (vgl. den \
Abschnitt ",
  ButtonBox["Substitution",
    ButtonData:>{"variablen.nb", "Substitution"},
    ButtonStyle->"Hyperlink"],
  " im Kapitel ",
  ButtonBox["Variablen",
    ButtonData:>{"variablen.nb", None},
    ButtonStyle->"Hyperlink"],
  "), die angibt, was in einem beliebigen Ausdruck f\[UDoubleDot]r ",
  StyleBox["y[t]",
    FontFamily->"Courier New"],
  " eingesetzt werden soll."
}], "Text",
  CellTags->"dsolve"],

Cell[BoxData[
    \(loesung1 = 
      DSolve[{\(y'\)[t] \[Equal] t*y[t], y[0] \[Equal] 1}, y[t], 
        t]\)], "Input",
  CellTags->"dsolve"],

Cell[TextData[{
  StyleBox["y[t]",
    FontFamily->"Courier New"],
  " wird hier also durch ",
  Cell[BoxData[
      \(2\ \[ExponentialE]\^t\)]],
  " ersetzt."
}], "Text",
  CellTags->"dsolve"],

Cell[BoxData[
    \(y[t] /. loesung1[\([1]\)]\)], "Input",
  CellTags->"dsolve"],

Cell[TextData[{
  "Will man aber zum Beispiel ",
  StyleBox["y[1]",
    FontFamily->"Courier New"],
  " berechnen, so funktioniert die Ersetzungsregel nicht. Sie besagt ja nur, \
was f\[UDoubleDot]r ",
  StyleBox["y[t]",
    FontFamily->"Courier New"],
  " eingesetzt werden soll, und links von ",
  StyleBox["/.",
    FontFamily->"Courier New"],
  " steht kein ",
  StyleBox["y[t]",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"dsolve"],

Cell[BoxData[
    \(y[1] /. loesung1[\([1]\)]\)], "Input",
  CellTags->"dsolve"],

Cell[TextData[{
  "Ein \[ADoubleDot]hnliches Problem gibt es mit ",
  StyleBox["y'[t]",
    FontFamily->"Courier New"],
  "."
}], "Text",
  CellTags->"dsolve"],

Cell[BoxData[
    \(\(y'\)[t] /. loesung1[\([1]\)]\)], "Input",
  CellTags->"dsolve"],

Cell[TextData[{
  "Die eine M\[ODoubleDot]glichkeit dieses Problem zu beheben besteht darin, \
die Funktion ",
  StyleBox["y",
    FontFamily->"Courier New"],
  " zu definieren."
}], "Text",
  CellTags->"dsolve"],

Cell[BoxData[
    \(y[t_] = y[t] /. loesung1[\([1]\)]\)], "Input",
  CellTags->"dsolve"],

Cell["\<\
Jetzt lassen sich Funktionswerte und Ableitungen wie gewohnt \
berechnen.\
\>", "Text",
  CellTags->"dsolve"],

Cell[BoxData[{
    \(y[1]\), "\[IndentingNewLine]", 
    \(\(y'\)[t]\)}], "Input",
  CellTags->"dsolve"],

Cell[TextData[{
  "Der Nachteil dieser Methode liegt darin, dass wir die Variable ",
  StyleBox["y",
    FontFamily->"Courier New"],
  " nun mit einem Ausdruck belegt haben. Will man das verhindern, so l\
\[ADoubleDot]sst man ",
  StyleBox["DSolve",
    FontFamily->"Courier New"],
  " das Gleichungssystem nicht nach ",
  StyleBox["y[t]",
    FontFamily->"Courier New"],
  ", sondern nach der Funktion ",
  StyleBox["y",
    FontFamily->"Courier New"],
  " aufl\[ODoubleDot]sen (die unabh\[ADoubleDot]ngige Variable \[LongDash] \
hier ",
  StyleBox["t",
    FontFamily->"Courier New"],
  " \[LongDash] muss aber trotzdem als drittes Argument eingegeben werden). \
Die L\[ODoubleDot]sung wird als sogenannte \"pure function\" ausgegeben. \
Statt nur des Funktionsterms steht dort der Befehl ",
  StyleBox["Function",
    FontFamily->"Courier New"],
  ", das erste Argument ist der Variablenname (in geschwungenen Klammern), \
das zweite Argument ist der Funktionsterm."
}], "Text",
  CellTags->"dsolve"],

Cell[BoxData[{
    \(Clear[y]\), "\[IndentingNewLine]", 
    \(loesung2 = 
      DSolve[{\(y'\)[t] \[Equal] t*y[t], y[0] \[Equal] 1}, y, t]\)}], "Input",\

  CellTags->"dsolve"],

Cell[TextData[{
  "Ausdr\[UDoubleDot]cke wie ",
  StyleBox["y[1]",
    FontFamily->"Courier New"],
  " oder ",
  StyleBox["y'[t]",
    FontFamily->"Courier New"],
  " lassen sich jetzt einfach durch Substitution berechnen, denn die \
Ersetzungsregel gibt nun an, was f\[UDoubleDot]r ",
  StyleBox["y",
    FontFamily->"Courier New"],
  " eingesetzt werden soll \[LongDash] und das kommt links von ",
  StyleBox["/.",
    FontFamily->"Courier New"],
  " sehr wohl vor."
}], "Text",
  CellTags->"dsolve"],

Cell[BoxData[{
    \(y[1] /. loesung2[\([1]\)]\), "\[IndentingNewLine]", 
    \(\(y'\)[t] /. loesung2[\([1]\)]\)}], "Input",
  CellTags->"dsolve"],

Cell[BoxData[
    \(Clear[loesung1, loesung2]\)], "Input",
  CellTags->"dsolve"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"DSolve", "[", 
            RowBox[{
              StyleBox["gleichung",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              StyleBox["y",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              StyleBox["t",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], 
            StyleBox["]",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["versucht",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Differentialgleichung",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["gleichung",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["nach",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["der",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Funktion",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["y",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["(",
                      FontFamily->"Times New Roman"], 
                    RowBox[{
                      StyleBox["mit",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["unabh\[ADoubleDot]ngiger",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["Variablen",
                        FontFamily->"Times New Roman"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["t",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox[")",
                      FontFamily->"Times New Roman"]}], " ", 
                  StyleBox["zu",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["l\[ODoubleDot]sen",
                    FontFamily->"Times New Roman"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(wobei\ \ die\ L\[ODoubleDot]sung\ als\),
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["\[IndentingNewLine]",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox[\(pure\ function\ angegeben\ wird\),
                FontFamily->"Times New Roman"]}]}]},
        {
          RowBox[{"DSolve", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["gl",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}], ",", "\[IndentingNewLine]",
               
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["y",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[
                    SubscriptBox[
                      StyleBox["y",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox["m",
                        FontSlant->"Italic"]],
                    FontFamily->"Times New Roman"]}], "}"}], ",", 
              StyleBox["t",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox[
                  RowBox[{
                  "versucht", " ", "das", " ", "Differentialgleichungssystem",
                     "  ", 
                    SubscriptBox[
                      StyleBox["gl",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"]}],
                  FontFamily->"Times New Roman"], ",", "...", ",", 
                RowBox[{
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[
                    RowBox[{
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], " "}]], 
                  StyleBox["nach",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["den",
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
              RowBox[{
                StyleBox[
                  RowBox[{"Funktionen", " ", 
                    SubscriptBox[
                      StyleBox["y",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"]}],
                  FontFamily->"Times New Roman"], ",", "...", ",", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["y",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox["m",
                        FontSlant->"Italic"]],
                    FontFamily->"Times New Roman"], 
                  StyleBox[
                    RowBox[{" ", 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"]}]], 
                  RowBox[{
                    StyleBox["(",
                      FontFamily->"Times New Roman"], 
                    RowBox[{
                      StyleBox["mit",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["unabh\[ADoubleDot]ngiger",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["Variablen",
                        FontFamily->"Times New Roman"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["t",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox[")",
                      FontFamily->"Times New Roman"]}], " ", 
                  StyleBox["zu",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["l\[ODoubleDot]sen",
                    FontFamily->"Times New Roman"]}], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
                
                
                StyleBox[\(wobei\ \ die\ L\[ODoubleDot]sungen\ als\ pure\ \
functions\ angegeben\ werden\),
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109],
  CellTags->"dsolve"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Der Befehl ",
  StyleBox["NDSolve",
    FontFamily->"Courier New"]
}], "Section"],

Cell[TextData[{
  StyleBox["DSolve",
    FontFamily->"Courier New"],
  " versucht die L\[ODoubleDot]sungsfunktion(en) in geschlossener Form \
anzugeben. Oft ist das aber nicht m\[ODoubleDot]glich und der ",
  StyleBox["DSolve",
    FontFamily->"Courier New"],
  "-Befehl versagt daher."
}], "Text"],

Cell[BoxData[
    \(DSolve[\(y'\)[t] + t^2*\(y''\)[t] \[Equal] y[t]^2, y[t], t]\)], "Input"],

Cell[TextData[{
  "Man kann aber versuchen eine numerische Approximation der \
L\[ODoubleDot]sungsfunktion zu finden. Hierzu dient der Befehl ",
  StyleBox["NDSolve",
    FontFamily->"Courier New"],
  ". Der Unterschied zum ",
  StyleBox["DSolve",
    FontFamily->"Courier New"],
  "-Befehl besteht darin, dass ein Intervall f\[UDoubleDot]r die unabh\
\[ADoubleDot]ngige Variable angegeben werden muss. Weiters hat das \
Gleichungssystem gen\[UDoubleDot]gend Anfangs- oder Randbedingungen zu \
enthalten \[LongDash] denn offensichtlich haben unbekannte Konstanten ",
  StyleBox["C[1]",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["C[2]",
    FontFamily->"Courier New"],
  " etc. nichts in einer numerischen L\[ODoubleDot]sung verloren. Die L\
\[ODoubleDot]sung ist nicht ein geschlossener Ausdruck, sondern eine die L\
\[ODoubleDot]sungsfunktion numerisch approximierende sogenannte ",
  StyleBox["InterpolatingFunction",
    FontFamily->"Courier New"],
  StyleBox[",  die auf dem im Befehl angegebenen Intervall definiert ist.",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"NDSolve", "[", 
            RowBox[{
              StyleBox["gleichung",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              StyleBox["y",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              RowBox[{
                StyleBox["{",
                  FontWeight->"Plain",
                  FontSlant->"Plain",
                  FontTracking->"Plain",
                  FontVariations->{"Underline"->False,
                  "Outline"->False,
                  "Shadow"->False,
                  "StrikeThrough"->False,
                  "Masked"->False,
                  "CompatibilityType"->0,
                  "RotationAngle"->0}], 
                RowBox[{
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New"], 
                  StyleBox["tmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Plain"], 
                  StyleBox["tmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  FontFamily->"Courier New",
                  FontVariations->{"CompatibilityType"->0}]}]}], 
            StyleBox["]",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"]}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["versucht",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Differentialgleichung",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["gleichung",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["nach",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["der",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Funktion",
                  FontFamily->"Times New Roman"]}], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
              RowBox[{
                StyleBox["y",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["mit",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["unabh\[ADoubleDot]ngiger",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["Variablen",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["t",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["aus",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["dem",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    RowBox[{
                      StyleBox["Intervall",
                        FontFamily->"Times New Roman"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["[",
                        FontFamily->"Times New Roman"], 
                      RowBox[{
                        StyleBox["tmin",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Times New Roman"], 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"], 
                        StyleBox["tmax",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}], 
                      StyleBox["]",
                        FontFamily->"Times New Roman"]}]}], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], " ", 
              "\[IndentingNewLine]", " ", 
              RowBox[{
                StyleBox[\(zu\ l\[ODoubleDot]sen\),
                  FontFamily->"Times New Roman"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["wobei",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["die",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["L\[ODoubleDot]sung",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["als",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["InterpolatingFunction",
                    FontFamily->"Courier New"]}]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
              StyleBox[\(angegeben\ wird\),
                FontFamily->"Times New Roman"]}]}]},
        {
          RowBox[{"NDSolve", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["gl",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}], ",", "\[IndentingNewLine]",
               
              RowBox[{"{", 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["y",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], ",", "...", ",", 
                  StyleBox[
                    SubscriptBox[
                      StyleBox["y",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox["m",
                        FontSlant->"Italic"]],
                    FontFamily->"Times New Roman"]}], "}"}], ",", 
              RowBox[{
                StyleBox["{",
                  FontWeight->"Plain",
                  FontSlant->"Plain",
                  FontTracking->"Plain",
                  FontVariations->{"Underline"->False,
                  "Outline"->False,
                  "Shadow"->False,
                  "StrikeThrough"->False,
                  "Masked"->False,
                  "CompatibilityType"->0,
                  "RotationAngle"->0}], 
                RowBox[{
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New"], 
                  StyleBox["tmin",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Plain"], 
                  StyleBox["tmax",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  FontFamily->"Courier New",
                  FontVariations->{"CompatibilityType"->0}]}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["versucht",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["das",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Differentialgleichungssystem",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[\(gl\_1\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                RowBox[{
                  StyleBox[\(gl\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["nach",
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
              RowBox[{
                RowBox[{
                  StyleBox["den",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Funktionen",
                    FontFamily->"Times New Roman"], 
                  StyleBox[
                    RowBox[{
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], " "}]], 
                  StyleBox[\(y\_1\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Courier New"], 
                StyleBox[
                  SubscriptBox["y", 
                    StyleBox["m",
                      FontSlant->"Italic"]],
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["mit",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["unabh\[ADoubleDot]ngiger",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Variablen",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["t",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["aus",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["dem",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["Intervall",
                      FontFamily->"Times New Roman"], 
                    StyleBox["  ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["[",
                      FontFamily->"Times New Roman"], 
                    RowBox[{
                      StyleBox["tmin",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[",",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["tmax",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox["]",
                      FontFamily->"Times New Roman"]}]}], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}], " ", 
              "\[IndentingNewLine]", " ", 
              RowBox[{
                StyleBox[\(zu\ l\[ODoubleDot]sen\),
                  FontFamily->"Times New Roman"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["wobei",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["die",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[
                    RowBox[{
                      StyleBox["L\[ODoubleDot]sung",
                        FontFamily->"Times New Roman"], "en"}]], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["als",
                    FontFamily->"Times New Roman"]}]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", " ", 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["InterpolatingFunction",
                      FontFamily->"Courier New"], 
                    StyleBox["s",
                      FontFamily->"Times New Roman"]}]], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["angegeben",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["werden",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell["\<\
Hier ist eine Differentialgleichung zweiter Ordnung \[LongDash] wir \
geben daher zwei Anfangsbedingungen an. Die L\[ODoubleDot]sungskurve soll auf \
dem Intervall [1,5] definiert sein.\
\>", "Text"],

Cell[BoxData[
    \(loesung = 
      NDSolve[{\(y'\)[t] + t^2*\(y''\)[t] \[Equal] y[t]^2, 
          y[1] \[Equal] 1, \(y'\)[1] \[Equal] 1}, y, {t, 1, 5}]\)], "Input"],

Cell[TextData[{
  StyleBox["BEMERKUNG",
    FontWeight->"Bold"],
  ": Nat\[UDoubleDot]rlich kann man ",
  StyleBox["NDSolve",
    FontFamily->"Courier New"],
  " das Gleichungssystem auch nach ",
  StyleBox["y[t]",
    FontFamily->"Courier New"],
  " statt nach ",
  StyleBox["y",
    FontFamily->"Courier New"],
  " l\[ODoubleDot]sen lassen. Der Unterschied ist derselbe wie schon bei ",
  StyleBox["DSolve",
    FontFamily->"Courier New"],
  " (siehe den Abschnitt ",
  ButtonBox["Der Befehl DSolve",
    ButtonData:>"dsolve",
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text"],

Cell[TextData[{
  "Auch wenn die L\[ODoubleDot]sungskurve als approximierende ",
  StyleBox["InterpolatingFunction",
    FontFamily->"Courier New"],
  " gegeben ist, k\[ODoubleDot]nnen wir so wie im letzten Abschnitt \
Funktionswerte berechnen lassen."
}], "Text"],

Cell[BoxData[
    \(y[3] /. loesung[\([1]\)]\)], "Input"],

Cell["\<\
Man kann auch Funktionswerte von Stellen ermitteln, die \
au\[SZ]erhalb des Definitionsbereichs der InterpolatingFunction liegen. Es \
wird eine Warnung ausgegeben \[LongDash] und zu Recht, denn die Ergebnisse k\
\[ODoubleDot]nnen sehr schnell sehr falsch werden.\
\>", "Text"],

Cell[BoxData[
    \(y[0] /. loesung[\([1]\)]\)], "Input"],

Cell["Auch Funktionswerte von Ableitungen k\[ODoubleDot]nnen ermittelt \
werden.", "Text"],

Cell[BoxData[
    \(\(y'''\)[3] /. loesung[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(Clear[loesung]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Plotten von L\[ODoubleDot]sungskurven und Vektorfeldern", "Section"],

Cell[CellGroupData[{

Cell["Beispiel 1", "Subsection"],

Cell[TextData[{
  "Wenn man bestimmte L\[ODoubleDot]sungskurven von Differentialgleichungen \
mit ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " zeichnen will, d\[UDoubleDot]rfen nat\[UDoubleDot]rlich keine \
unbestimmten Konstanten ",
  StyleBox["C[1]",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["C[2]",
    FontFamily->"Courier New"],
  " etc. in der L\[ODoubleDot]sung vorkommen. Im folgenden Beispiel ist daher \
eine Anfangsbedingung angegeben."
}], "Text"],

Cell[BoxData[
    \(gl = {\(y'\)[t] \[Equal] y[t], y[0] \[Equal] 2}\)], "Input"],

Cell[BoxData[
    \(DSolve[gl, y[t], t]\)], "Input"],

Cell[TextData[{
  StyleBox["Die L\[ODoubleDot]sungskurve ist eine Funktion von \
\[DoubleStruckCapitalR] nach \[DoubleStruckCapitalR] und kann also mit dem ",
    FontFamily->"Times New Roman"],
  StyleBox["Plot",
    FontFamily->"Courier New"],
  StyleBox["-Befehl gezeichnet werden. Der Befehl ",
    FontFamily->"Times New Roman"],
  StyleBox["Evaluate",
    FontFamily->"Courier New"],
  " bewirkt, dass ZUERST substituiert und erst DANN geplottet wird."
}], "Text"],

Cell[BoxData[
    \(Plot[Evaluate[y[t] /. %], {t, \(-1\), 2}]\)], "Input"],

Cell[TextData[{
  "Auch wenn die L\[ODoubleDot]sungskurve als ",
  StyleBox["InterpolatingFunction",
    FontFamily->"Courier New"],
  " gegeben ist kann sie geplottet werden \[LongDash] und innerhalb des im ",
  StyleBox["NDSolve",
    FontFamily->"Courier New"],
  "-Befehls angegebenen Intervalls sieht sie auch so aus wie die L\
\[ODoubleDot]sungskurve, die ",
  StyleBox["DSolve",
    FontFamily->"Courier New"],
  " ermittelt hat."
}], "Text"],

Cell[BoxData[
    \(NDSolve[gl, y, {t, \(-1\), 2}]\)], "Input"],

Cell[BoxData[
    \(Plot[Evaluate[y[t] /. %], {t, \(-1\), 2}]\)], "Input"],

Cell[TextData[{
  "Der hier gezeichnete Graph obiger ",
  StyleBox["InterpolatingFunction",
    FontFamily->"Courier New"],
  " sieht links von \[Dash]1 ganz anders aus als die L\[ODoubleDot]sungskurve \
",
  Cell[BoxData[
      \(2\ \[ExponentialE]\^t\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Plot[Evaluate[y[t] /. %%], {t, \(-7\), 2}]\)], "Input"],

Cell[BoxData[
    \(Clear[gl]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Beispiel 2", "Subsection"],

Cell["Hier sind zwei Funktionen in zwei Variablen.", "Text"],

Cell[BoxData[{
    \(f[x_, y_] := \((4 - y^2)\) x - 3\ y\), "\n", 
    \(g[x_, y_] := \((4 - x^2)\) y + 3\ x\)}], "Input"],

Cell[TextData[{
  "Durch ",
  StyleBox["x'[t]\[Equal]f[x[t],y[t]]",
    FontFamily->"Courier New"],
  StyleBox[" und ",
    FontFamily->"Times New Roman"],
  StyleBox["y'[t]\[Equal]g[x[t],y[t]]",
    FontFamily->"Courier New"],
  " erh\[ADoubleDot]lt man eine zweidimensionale nicht-lineare \
Differentialgleichung. Wir verwenden den Befehl ",
  StyleBox["NDSolve",
    FontFamily->"Courier New"],
  ", daher m\[UDoubleDot]ssen wir zwei Anfangs- oder Randbedingungen angeben. \
Die L\[ODoubleDot]sung ist eine Funktion von \[DoubleStruckCapitalR] in den \
",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " mit den Komponenten ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["y",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(loesungskurve = 
      NDSolve[{\(x'\)[t] \[Equal] f[x[t], y[t]], \(y'\)[t] \[Equal] 
            g[x[t], y[t]], x[0] \[Equal] 1, y[0] \[Equal] 0}, {x, y}, {t, 0, 
          1.5}]\)], "Input"],

Cell[TextData[{
  "Man kann so wie vorher die einzelnen Komponenten graphisch darstellen, \
also ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " bzw. ",
  StyleBox["y",
    FontFamily->"Courier New"],
  " als Funktion von ",
  StyleBox["t",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(Plot[
      Evaluate[x[t] /. loesungskurve[\([1, 1]\)]], {t, 0, 1.5}]\)], "Input"],

Cell[BoxData[
    \(Plot[
      Evaluate[y[t] /. loesungskurve[\([1, 2]\)]], {t, 0, 1.5}]\)], "Input"],

Cell[TextData[{
  "Die L\[ODoubleDot]sungskurve ist jedoch eine Funktion von \
\[DoubleStruckCapitalR] in den ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " mit den Komponenten ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["y",
    FontFamily->"Courier New"],
  ". Mit ",
  StyleBox["ParametricPlot",
    FontFamily->"Courier New"],
  " lassen sich die Punkte (",
  StyleBox["x[t]",
    FontFamily->"Courier New"],
  StyleBox[", ",
    FontFamily->"Times New Roman"],
  StyleBox["y[t]",
    FontFamily->"Courier New"],
  ") \[Element] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " zeichnen, wobei der Parameter ",
  StyleBox["t",
    FontFamily->"Courier New"],
  " \[LongDash] also die unabh\[ADoubleDot]ngige Variable aus dem ",
  StyleBox["NDSolv",
    FontFamily->"Courier New"],
  "e-Befehl \[LongDash] das Intervall [0, 1.5] durchl\[ADoubleDot]uft."
}], "Text"],

Cell[BoxData[
    \(ParametricPlot[
      Evaluate[{x[t], y[t]} /. loesungskurve], {t, 0,  .5}]\)], "Input"],

Cell[TextData[{
  "F\[UDoubleDot]r verschiedene Anfangsbedingungen erhalten wir \
unterschiedliche L\[ODoubleDot]sungskurven. Der n\[ADoubleDot]chste Befehl \
erzeugt eine Liste von ",
  StyleBox["NDSolve",
    FontFamily->"Courier New"],
  "-L\[ODoubleDot]sungen ein und derselben Differentialgleichung, wobei mit \
Hilfe des ",
  StyleBox["Table",
    FontFamily->"Courier New"],
  "-Befehls die Anfangsbedingungen variiert wurden. Wir erhalten \
Ersetzungsregeln f\[UDoubleDot]r insgesamt 13",
  StyleBox["\[Star]",
    FontFamily->"Courier New"],
  "13",
  StyleBox["=",
    FontFamily->"Courier New"],
  "169 verschiedene L\[ODoubleDot]sungskurven. Der Befehl ",
  StyleBox["Flatten",
    FontFamily->"Courier New"],
  " bewirkt, dass alle bis auf die \[ADoubleDot]u\[SZ]ersten geschwungenen \
Klammern in der Ausgabe von ",
  StyleBox["Table",
    FontFamily->"Courier New"],
  " weggelassen werden. Der Strichpunkt am Ende unterdr\[UDoubleDot]ckt die \
Ausgabe. Das Ergebnis der Berechnung wird in die Variable ",
  StyleBox["loesungskurven1",
    FontFamily->"Courier New"],
  " geschrieben."
}], "Text"],

Cell[BoxData[
    \(\(loesungskurven1 = 
        Table[NDSolve[{\(x'\)[t] \[Equal] f[x[t], y[t]], \(y'\)[t] \[Equal] 
                  g[x[t], y[t]], x[0] \[Equal] m, y[0] \[Equal] n}, {x, 
                y}, {t, 0, 1.5}], {m, \(-6\), 6}, {n, \(-6\), 6}] // 
          Flatten;\)\)], "Input"],

Cell[TextData[{
  "Je zwei aufeinanderfolgende Ersetzungsregeln (eine f\[UDoubleDot]r x, eine \
f\[UDoubleDot]r y) sind die Komponenten einer bestimmten \
L\[ODoubleDot]sungskurve. Das Ergebnis des n\[ADoubleDot]chsten Befehls ist \
eine Liste der Funktionsterme der L\[ODoubleDot]sungskurven \[LongDash] d. h. \
die Ersetzungsregeln werden durch Substitution zu Funktionstermen (von ",
  StyleBox["InterpolatingFunction",
    FontFamily->"Courier New"],
  "s) und die zusammengeh\[ODoubleDot]renden Komponenten werden in \
geschwungenen Klammern zusammengefasst. Der Strichpunkt am Ende unterdr\
\[UDoubleDot]ckt wieder die Ausgabe. Das Ergebnis der Berechnung wird in die \
Variable ",
  StyleBox["kurven1",
    FontFamily->"Courier New"],
  " geschrieben."
}], "Text"],

Cell[BoxData[
    \(\(kurven1 = 
        Table[{x[t] /. loesungskurven1[\([i]\)], 
            y[t] /. loesungskurven1[\([i + 1]\)]}, {i, 1, 337, 
            2}];\)\)], "Input"],

Cell[TextData[{
  "Nun k\[ODoubleDot]nnen wir alle 169 L\[ODoubleDot]sungskurven in einem \
Plot zeichnen. (Die Ausgabe von ",
  StyleBox["ParametricPlot",
    FontFamily->"Courier New"],
  " \[LongDash] ein ",
  StyleBox["Graphics",
    FontFamily->"Courier New"],
  "-Objekt \[LongDash] wird in die Variable ",
  StyleBox["bild1",
    FontFamily->"Courier New"],
  " geschrieben.)"
}], "Text"],

Cell[BoxData[
    \(bild1 = 
      ParametricPlot[Evaluate[kurven1], {t, 0, 1}, 
        AspectRatio \[Rule] Automatic, 
        PlotRange \[Rule] {{\(-6\), 6}, {\(-6\), 6}}]\)], "Input"],

Cell[TextData[{
  "Betrachtet man einen fixen Punkt (",
  StyleBox["x[t]",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["y[t]",
    FontFamily->"Courier New"],
  ") \[Element] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " einer bestimmten L\[ODoubleDot]sungskurve,  so liefert (",
  StyleBox["x'[t]",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["y'[t]",
    FontFamily->"Courier New"],
  ") ",
  StyleBox["=",
    FontFamily->"Courier New"],
  " (",
  StyleBox["f[x[t],y[t]]",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["g[x[t],y[t]]",
    FontFamily->"Courier New"],
  ") einen Tangentialvektor in (",
  StyleBox["x[t]",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["y[t]",
    FontFamily->"Courier New"],
  ") an die L\[ODoubleDot]sungskurve und gibt damit die ungef\[ADoubleDot]hre \
Richtung an, in die die Kurve weiter verl\[ADoubleDot]uft. Die \
L\[ADoubleDot]nge des Vektors korrespondiert dabei zur \"Geschwindigkeit\", \
mit der die Kurve an dieser Stelle durchlaufen wird.\nLegt man \
\[UDoubleDot]ber einen bestimmten Ausschnitt des ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " ein Gitter, berechnet in jedem Gitterpunkt den zugeh\[ODoubleDot]rigen \
Tangentialvektor und zeichnet anschlie\[SZ]end alle Vektoren als Pfeile (mit \
dem Schaft im zugeh\[ODoubleDot]rigen Gitterpunkt) ein, so erh\[ADoubleDot]lt \
man ein \"Vektorfeld\". Die L\[ODoubleDot]sungskurven verlaufen mit den durch \
die Pfeile dargestellten \"Str\[ODoubleDot]mungen\".\nAuf diese Art und Weise \
erh\[ADoubleDot]lt man oft einen Eindruck \[UDoubleDot]ber den Verlauf der L\
\[ODoubleDot]sungskurven, ohne eine einzige L\[ODoubleDot]sungskurve explizit \
ausrechnen zu m\[UDoubleDot]ssen."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " stellt einen Befehl zur Verf\[UDoubleDot]gung, der solche \
(zweidimensionalen) Vektorfelder zeichnen kann, den Befehl ",
  StyleBox["PlotVectorField",
    FontFamily->"Courier New"],
  ". Der Befehl befindet sich allerdings nicht im Standard-Repertoire von ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", sondern im Package ",
  StyleBox["Graphics`PlotField`",
    FontFamily->"Courier New"],
  ". Damit ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " den Befehl erkennt, muss dieses Package (es ist ein Standard-Package, das \
im Programmpaket enthalten ist) erst \"geladen\" werden. Das macht der \
folgende Befehl."
}], "Text"],

Cell[BoxData[
    \(<< Graphics`PlotField`\)], "Input"],

Cell[TextData[{
  "Das Vektorfeld unserer Differentialgleichung ist durch (",
  StyleBox["x",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["y",
    FontFamily->"Courier New"],
  ") \[RightTeeArrow] (",
  StyleBox["f[x,y]",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["g[x,y]",
    FontFamily->"Courier New"],
  ") gegeben. Es m\[UDoubleDot]ssen neben dem Funktionsterm (eine Liste mit \
zwei Elementen) auch die Namen der beiden Variablen zusammen mit den \
jeweiligen Intervallgrenzen angegeben werden.\n(Die Ausgabe von P",
  StyleBox["lotVectorField",
    FontFamily->"Courier New"],
  " \[LongDash] auch ein ",
  StyleBox["Graphics",
    FontFamily->"Courier New"],
  "-Objekt \[LongDash] wird in die Variable ",
  StyleBox["bild2",
    FontFamily->"Courier New"],
  " geschrieben.)"
}], "Text"],

Cell[BoxData[
    \(bild2 = 
      PlotVectorField[{f[x, y], g[x, y]}, {x, \(-6\), 6}, {y, \(-6\), 
          6}]\)], "Input"],

Cell[TextData[{
  "Der Befehl ",
  StyleBox["Show",
    FontFamily->"Courier New"],
  " erm\[ODoubleDot]glicht es, verschiedene Plots in einer einzigen Zeichnung \
vereinigt zu zeigen. ",
  StyleBox["Show",
    FontFamily->"Courier New"],
  " akzeptiert als Argument ein ",
  StyleBox["Graphics",
    FontFamily->"Courier New"],
  "-Object oder eine Liste von ",
  StyleBox["Graphics",
    FontFamily->"Courier New"],
  "-Objekten. Viele der f\[UDoubleDot]r ",
  StyleBox["Plot",
    FontFamily->"Courier New"],
  " m\[ODoubleDot]glichen Optionen sind auch in ",
  StyleBox["Show",
    FontFamily->"Courier New"],
  " m\[ODoubleDot]glich."
}], "Text"],

Cell[TextData[{
  "Die Ausgabe des obigen ",
  StyleBox["ParametricPlot",
    FontFamily->"Courier New"],
  "- bzw. ",
  StyleBox["PlotVectorField",
    FontFamily->"Courier New"],
  "-Befehls \[LongDash] beides ",
  StyleBox["Graphics",
    FontFamily->"Courier New"],
  "-Objekte \[LongDash] wurde in ",
  StyleBox["bild1",
    FontFamily->"Courier New"],
  " bzw. ",
  StyleBox["bild2",
    FontFamily->"Courier New"],
  " abgespeichert. ",
  StyleBox["Show",
    FontFamily->"Courier New"],
  " zeigt nun beide Zeichnungen in einem Bild."
}], "Text"],

Cell[BoxData[
    \(Show[{bild1, bild2}, Ticks \[Rule] None, 
      PlotRange \[Rule] {{\(-6\), 6}, {\(-6\), 6}}]\)], "Input"],

Cell["", "Text"],

Cell["\<\
Um das Verhalten der L\[ODoubleDot]sungskurven um eine station\
\[ADoubleDot]re L\[ODoubleDot]sungen \[LongDash] einem sogenannten Fixpunkt \
\[LongDash] zu untersuchen, betrachtet man die zu diesem Punkt geh\
\[ODoubleDot]rige lineare Differentialgleichung.\
\>", "Text"],

Cell[TextData[{
  "Die Fixpunkte unserer Differentialgleichung sind genau jene Punkte (",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  "), die ",
  StyleBox["x ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["' ",
    FontFamily->"Times New Roman"],
  "= ",
  StyleBox["f",
    FontFamily->"Courier New"],
  StyleBox[" (",
    FontFamily->"Times New Roman"],
  StyleBox["x",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier New"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["y",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[") ",
    FontFamily->"Times New Roman"],
  "= 0 und ",
  StyleBox["y ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["' ",
    FontFamily->"Times New Roman"],
  "= ",
  StyleBox["g",
    FontFamily->"Courier New"],
  StyleBox[" (",
    FontFamily->"Times New Roman"],
  StyleBox["x",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier New"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["y",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[") = ",
    FontFamily->"Times New Roman"],
  "0 erf\[UDoubleDot]llen. Wir ermitteln diese Punkte mittels ",
  StyleBox["Solve",
    FontFamily->"Courier New"],
  " und schreiben die Ausgabe in die Variable ",
  StyleBox["FP",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(FP = Solve[{f[x, y] \[Equal] 0, g[x, y] \[Equal] 0}, {x, y}]\)], "Input"],

Cell[TextData[{
  "Die Koeffizientenmatrix  ",
  StyleBox["A",
    FontSlant->"Italic"],
  "  der zum Fixpunkt (",
  StyleBox["x",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  ") geh\[ODoubleDot]rigen linearen Differentialgleichung  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {\(x' \((t)\)\)},
              {\(y' \((t)\)\)}
              }], ")"}], TraditionalForm]]],
  " = A",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\^ . \)\)\)]],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {\(x(t)\)},
              {\(y(t)\)}
              }], ")"}], TraditionalForm]]],
  "  ist die Jacobi-Matrix der Funktion (",
  StyleBox["x",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  ") \[RightTeeArrow] (",
  StyleBox["f",
    FontFamily->"Courier New"],
  StyleBox[" (",
    FontFamily->"Times New Roman"],
  StyleBox["x",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier New"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["y",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[")",
    FontFamily->"Times New Roman"],
  ", ",
  StyleBox["g",
    FontFamily->"Courier New"],
  StyleBox[" (",
    FontFamily->"Times New Roman"],
  StyleBox["x",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier New"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["y",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[")) ",
    FontFamily->"Times New Roman"],
  "im Punkt (",
  StyleBox["x",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell[BoxData[
    \(A[x_, 
        y_] = {{D[f[x, y], x], D[f[x, y], y]}, {D[g[x, y], x], 
          D[g[x, y], y]}}\)], "Input"],

Cell[TextData[{
  "Die Koeffizientenmatrix der zum Fixpunkt (\[Dash]",
  Cell[BoxData[
      \(TraditionalForm\`1\/2\)]],
  Cell[BoxData[
      \(TraditionalForm\`\@10\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\@10\)]],
  ") geh\[ODoubleDot]rigen linearen Differentialgleichung ist also"
}], "Text"],

Cell[BoxData[
    \(matrix = \({{a, b}, {c, d}} = A[x, y] /. FP[\([2]\)]\)\)], "Input"],

Cell["Die Eigenwerte dieser Matrix sind", "Text"],

Cell[BoxData[
    \(Eigenvalues[matrix]\)], "Input"],

Cell[TextData[{
  "Der Fixpunkt (\[Dash]",
  Cell[BoxData[
      \(TraditionalForm\`1\/2\)]],
  Cell[BoxData[
      \(TraditionalForm\`\@10\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\@10\)]],
  ") ist also ein Sattelpunkt, da die Matrix sowohl positive als auch \
negative Eigenwerte besitzt."
}], "Text"],

Cell[TextData[{
  "Eine Reihe von L\[ODoubleDot]sungskurven der zum Fixpunkt (\[Dash]",
  Cell[BoxData[
      \(TraditionalForm\`1\/2\)]],
  Cell[BoxData[
      \(TraditionalForm\`\@10\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\@10\)]],
  ") geh\[ODoubleDot]rigen linearen Differentialgleichung lassen sich nat\
\[UDoubleDot]rlich genauso wie die L\[ODoubleDot]sungen unserer urspr\
\[UDoubleDot]nglichen Differentialgleichung mittels ",
  StyleBox["NDSolve",
    FontFamily->"Courier New"],
  " berechnen und mit Hilfe von ",
  StyleBox["ParametricPlot",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["PlotVectorField",
    FontFamily->"Courier New"],
  " grafisch darstellen. Die Darstellung dieser L\[ODoubleDot]sungskurven um \
(0, 0) zeigt das ungef\[ADoubleDot]hre Verhalten der \
L\[ODoubleDot]sungskurven der urspr\[UDoubleDot]nglichen \
Differentialgleichung in der N\[ADoubleDot]he des Fixpunktes (\[Dash]",
  Cell[BoxData[
      \(TraditionalForm\`1\/2\)]],
  Cell[BoxData[
      \(TraditionalForm\`\@10\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\@10\)]],
  ").\nDie Abfolge der Befehle im n\[ADoubleDot]chsten Input ist dieselbe wie \
f\[UDoubleDot]r unsere urspr\[UDoubleDot]ngliche Differentialgleichung.\n(Das \
Setzen der Option ",
  StyleBox["DisplayFunction",
    FontFamily->"Courier New"],
  " auf ",
  StyleBox["Identity",
    FontFamily->"Courier New"],
  " in ",
  StyleBox["ParametricPlot",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["PlotVectorField",
    FontFamily->"Courier New"],
  " verhindert, dass die beiden Plots zu diesem Zeitpunkt am Bildschirm \
ausgegeben werden. In ",
  StyleBox["Show",
    FontFamily->"Courier New"],
  " wird ",
  StyleBox["DisplayFunction",
    FontFamily->"Courier New"],
  " auf ihren Default-Wert gesetzt.)"
}], "Text"],

Cell[BoxData[{
    \(\(loesungskurven2 = 
        Table[DSolve[{\(x'\)[t] \[Equal] a*x[t] + b*y[t], \(y'\)[t] \[Equal] 
                  c*x[t] + d*y[t], x[0] \[Equal] m, y[0] \[Equal] n}, {x, y}, 
              t], {m, \(-1\), 1}, {n, \(-1\), 1}] // Flatten;\)\), "\n", 
    \(\(kurven2 = 
        Table[{x[t] /. loesungskurven2[\([i]\)], 
            y[t] /. loesungskurven2[\([i + 1]\)]}, {i, 1, 17, 
            2}];\)\), "\n", 
    \(\(bild3 = 
        ParametricPlot[Evaluate[kurven2], {t, \(-1\), 1}, 
          AspectRatio \[Rule] Automatic, 
          PlotRange \[Rule] {{\(-3\), 3}, {\(-3\), 3}}, 
          DisplayFunction \[Rule] Identity];\)\), "\n", 
    \(\(bild4 = 
        PlotVectorField[matrix . {x, y}, {x, \(-2\), 2}, {y, \(-2\), 2}, 
          DisplayFunction \[Rule] Identity];\)\), "\n", 
    \(Show[{bild3, bild4}, Ticks \[Rule] None, 
      DisplayFunction \[Rule] $DisplayFunction]\)}], "Input"],

Cell[BoxData[
    \(Clear[f, g, loesungskurve, loesungskurven1, loesungskurven2, kurve, 
      kurven1, kurven2, bild1, bild2, bild3, bild4, FP, matrix, A, a, b, c, 
      d]\)], "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1012, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, 1}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "dsolve"->{
    Cell[2117, 66, 121, 5, 74, "Section",
      CellTags->"dsolve"],
    Cell[2241, 73, 451, 13, 52, "Text",
      CellTags->"dsolve"],
    Cell[2695, 88, 283, 7, 33, "Text",
      CellTags->"dsolve"],
    Cell[2981, 97, 97, 2, 30, "Input",
      CellTags->"dsolve"],
    Cell[3081, 101, 291, 8, 33, "Text",
      CellTags->"dsolve"],
    Cell[3375, 111, 123, 3, 30, "Input",
      CellTags->"dsolve"],
    Cell[3501, 116, 235, 6, 33, "Text",
      CellTags->"dsolve"],
    Cell[3739, 124, 144, 3, 30, "Input",
      CellTags->"dsolve"],
    Cell[3886, 129, 9270, 225, 107, "Text",
      CellTags->"dsolve"],
    Cell[13159, 356, 582, 16, 52, "Text",
      CellTags->"dsolve"],
    Cell[13744, 374, 143, 4, 30, "Input",
      CellTags->"dsolve"],
    Cell[13890, 380, 193, 8, 33, "Text",
      CellTags->"dsolve"],
    Cell[14086, 390, 80, 2, 30, "Input",
      CellTags->"dsolve"],
    Cell[14169, 394, 455, 16, 33, "Text",
      CellTags->"dsolve"],
    Cell[14627, 412, 80, 2, 30, "Input",
      CellTags->"dsolve"],
    Cell[14710, 416, 159, 6, 33, "Text",
      CellTags->"dsolve"],
    Cell[14872, 424, 85, 2, 30, "Input",
      CellTags->"dsolve"],
    Cell[14960, 428, 212, 7, 33, "Text",
      CellTags->"dsolve"],
    Cell[15175, 437, 88, 2, 30, "Input",
      CellTags->"dsolve"],
    Cell[15266, 441, 119, 4, 33, "Text",
      CellTags->"dsolve"],
    Cell[15388, 447, 104, 3, 50, "Input",
      CellTags->"dsolve"],
    Cell[15495, 452, 1003, 26, 90, "Text",
      CellTags->"dsolve"],
    Cell[16501, 480, 177, 5, 50, "Input",
      CellTags->"dsolve"],
    Cell[16681, 487, 502, 16, 52, "Text",
      CellTags->"dsolve"],
    Cell[17186, 505, 146, 3, 50, "Input",
      CellTags->"dsolve"],
    Cell[17335, 510, 80, 2, 30, "Input",
      CellTags->"dsolve"],
    Cell[17418, 514, 9392, 223, 145, "Text",
      CellTags->"dsolve"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"dsolve", 68093, 1955}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 67, 0, 51, "Subtitle"],
Cell[1846, 55, 246, 7, 52, "Text"],

Cell[CellGroupData[{
Cell[2117, 66, 121, 5, 74, "Section",
  CellTags->"dsolve"],
Cell[2241, 73, 451, 13, 52, "Text",
  CellTags->"dsolve"],
Cell[2695, 88, 283, 7, 33, "Text",
  CellTags->"dsolve"],
Cell[2981, 97, 97, 2, 30, "Input",
  CellTags->"dsolve"],
Cell[3081, 101, 291, 8, 33, "Text",
  CellTags->"dsolve"],
Cell[3375, 111, 123, 3, 30, "Input",
  CellTags->"dsolve"],
Cell[3501, 116, 235, 6, 33, "Text",
  CellTags->"dsolve"],
Cell[3739, 124, 144, 3, 30, "Input",
  CellTags->"dsolve"],
Cell[3886, 129, 9270, 225, 107, "Text",
  CellTags->"dsolve"],
Cell[13159, 356, 582, 16, 52, "Text",
  CellTags->"dsolve"],
Cell[13744, 374, 143, 4, 30, "Input",
  CellTags->"dsolve"],
Cell[13890, 380, 193, 8, 33, "Text",
  CellTags->"dsolve"],
Cell[14086, 390, 80, 2, 30, "Input",
  CellTags->"dsolve"],
Cell[14169, 394, 455, 16, 33, "Text",
  CellTags->"dsolve"],
Cell[14627, 412, 80, 2, 30, "Input",
  CellTags->"dsolve"],
Cell[14710, 416, 159, 6, 33, "Text",
  CellTags->"dsolve"],
Cell[14872, 424, 85, 2, 30, "Input",
  CellTags->"dsolve"],
Cell[14960, 428, 212, 7, 33, "Text",
  CellTags->"dsolve"],
Cell[15175, 437, 88, 2, 30, "Input",
  CellTags->"dsolve"],
Cell[15266, 441, 119, 4, 33, "Text",
  CellTags->"dsolve"],
Cell[15388, 447, 104, 3, 50, "Input",
  CellTags->"dsolve"],
Cell[15495, 452, 1003, 26, 90, "Text",
  CellTags->"dsolve"],
Cell[16501, 480, 177, 5, 50, "Input",
  CellTags->"dsolve"],
Cell[16681, 487, 502, 16, 52, "Text",
  CellTags->"dsolve"],
Cell[17186, 505, 146, 3, 50, "Input",
  CellTags->"dsolve"],
Cell[17335, 510, 80, 2, 30, "Input",
  CellTags->"dsolve"],
Cell[17418, 514, 9392, 223, 145, "Text",
  CellTags->"dsolve"]
}, Closed]],

Cell[CellGroupData[{
Cell[26847, 742, 100, 4, 44, "Section"],
Cell[26950, 748, 298, 8, 33, "Text"],
Cell[27251, 758, 92, 1, 30, "Input"],
Cell[27346, 761, 1083, 24, 90, "Text"],
Cell[28432, 787, 16271, 388, 201, "Text"],
Cell[44706, 1177, 209, 4, 33, "Text"],
Cell[44918, 1183, 167, 3, 30, "Input"],
Cell[45088, 1188, 578, 20, 52, "Text"],
Cell[45669, 1210, 264, 6, 33, "Text"],
Cell[45936, 1218, 57, 1, 30, "Input"],
Cell[45996, 1221, 287, 5, 52, "Text"],
Cell[46286, 1228, 57, 1, 30, "Input"],
Cell[46346, 1231, 90, 1, 33, "Text"],
Cell[46439, 1234, 64, 1, 30, "Input"],
Cell[46506, 1237, 47, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[46590, 1243, 74, 0, 43, "Section"],

Cell[CellGroupData[{
Cell[46689, 1247, 32, 0, 38, "Subsection"],
Cell[46724, 1249, 483, 14, 52, "Text"],
Cell[47210, 1265, 80, 1, 30, "Input"],
Cell[47293, 1268, 52, 1, 30, "Input"],
Cell[47348, 1271, 470, 11, 52, "Text"],
Cell[47821, 1284, 74, 1, 30, "Input"],
Cell[47898, 1287, 449, 12, 52, "Text"],
Cell[48350, 1301, 63, 1, 30, "Input"],
Cell[48416, 1304, 74, 1, 30, "Input"],
Cell[48493, 1307, 275, 9, 33, "Text"],
Cell[48771, 1318, 75, 1, 30, "Input"],
Cell[48849, 1321, 42, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[48928, 1327, 32, 0, 30, "Subsection"],
Cell[48963, 1329, 60, 0, 33, "Text"],
Cell[49026, 1331, 122, 2, 50, "Input"],
Cell[49151, 1335, 783, 24, 52, "Text"],
Cell[49937, 1361, 212, 4, 30, "Input"],
Cell[50152, 1367, 297, 12, 33, "Text"],
Cell[50452, 1381, 102, 2, 30, "Input"],
Cell[50557, 1385, 102, 2, 30, "Input"],
Cell[50662, 1389, 961, 31, 52, "Text"],
Cell[51626, 1422, 108, 2, 30, "Input"],
Cell[51737, 1426, 1112, 29, 90, "Text"],
Cell[52852, 1457, 294, 5, 70, "Input"],
Cell[53149, 1464, 771, 15, 90, "Text"],
Cell[53923, 1481, 178, 4, 30, "Input"],
Cell[54104, 1487, 395, 12, 33, "Text"],
Cell[54502, 1501, 187, 4, 30, "Input"],
Cell[54692, 1507, 1781, 46, 128, "Text"],
Cell[56476, 1555, 726, 19, 71, "Text"],
Cell[57205, 1576, 55, 1, 30, "Input"],
Cell[57263, 1579, 812, 25, 71, "Text"],
Cell[58078, 1606, 126, 3, 30, "Input"],
Cell[58207, 1611, 651, 21, 52, "Text"],
Cell[58861, 1634, 554, 20, 52, "Text"],
Cell[59418, 1656, 126, 2, 30, "Input"],
Cell[59547, 1660, 16, 0, 33, "Text"],
Cell[59566, 1662, 282, 5, 52, "Text"],
Cell[59851, 1669, 1537, 60, 52, "Text"],
Cell[61391, 1731, 93, 1, 30, "Input"],
Cell[61487, 1734, 2002, 80, 64, "Text"],
Cell[63492, 1816, 129, 3, 30, "Input"],
Cell[63624, 1821, 311, 10, 36, "Text"],
Cell[63938, 1833, 87, 1, 30, "Input"],
Cell[64028, 1836, 49, 0, 33, "Text"],
Cell[64080, 1838, 52, 1, 30, "Input"],
Cell[64135, 1841, 317, 11, 36, "Text"],
Cell[64455, 1854, 1825, 53, 134, "Text"],
Cell[66283, 1909, 923, 18, 170, "Input"],
Cell[67209, 1929, 187, 3, 50, "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

