(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     57983,       1753]*)
(*NotebookOutlinePosition[     58667,       1777]*)
(*  CellTagsIndexPosition[     58623,       1773]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Mehrdimensionale Funktionen und ihre Differentiation", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell[CellGroupData[{

Cell["Mehrdimensionale Funktionen", "Section"],

Cell[TextData[{
  "Wie man Funktionen vom ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^m\)]],
  " in den ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " definiert, haben wir bereits im Abschnitt ",
  ButtonBox["Definition von Funktionen",
    ButtonData:>{"funktionen.nb", "def"},
    ButtonStyle->"Hyperlink"],
  " im Kapitel ",
  ButtonBox["Funktionen",
    ButtonData:>{"funktionen.nb", None},
    ButtonStyle->"Hyperlink"],
  " gesehen."
}], "Text"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{
              StyleBox["name",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "[", 
              RowBox[{
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["x",
                        FontSlant->"Italic"], "1"],
                    FontFamily->"Times New Roman"], "_"}], ",", "...", ",", 
                RowBox[{
                  StyleBox[\(x\_m\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], "_"}]}], "]"}], ":=", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  SubscriptBox[
                    StyleBox["name",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "1"], "[", 
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["x",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], "1"],
                      FontFamily->"Times New Roman"], ",", "...", ",", 
                    StyleBox[\(x\_m\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], "]"}], ",", "...", ",", 
                RowBox[{
                  StyleBox[\(name\_n\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], "[", 
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["x",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], "1"],
                      FontFamily->"Times New Roman"], ",", "...", ",", 
                    StyleBox[\(x\_m\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], "]"}]}], "}"}]}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["Definition",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["einer",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Funktion",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], "vom", 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  SuperscriptBox[
                    StyleBox["\[DoubleStruckCapitalR]",
                      FontSlant->"Plain"], "m"],
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["in",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["den",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  SuperscriptBox[
                    StyleBox["\[DoubleStruckCapitalR]",
                      FontSlant->"Plain"], "n"],
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], " ", 
                StyleBox["mit",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["dem",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Namen",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["name",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["und",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["den",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Argumenten",
                  FontFamily->"Times New Roman"]}], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox[
                  SubscriptBox[
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], "1"],
                  FontFamily->"Times New Roman"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox["...",
                  FontFamily->"Courier New"], 
                StyleBox[",",
                  FontFamily->"Times New Roman"], 
                StyleBox[
                  SubscriptBox[
                    StyleBox["x",
                      FontSlant->"Italic"], 
                    StyleBox["m",
                      FontSlant->"Italic"]],
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  StyleBox["BEMERKUNG",
    FontWeight->"Bold"],
  ": Um die Komposition ",
  StyleBox["g ",
    FontSlant->"Italic"],
  "\[SmallCircle]",
  StyleBox[" f",
    FontSlant->"Italic"],
  " zweier Funktionen ",
  StyleBox["f",
    FontSlant->"Italic"],
  " und ",
  StyleBox["g",
    FontSlant->"Italic"],
  " bilden gibt es zwei M\[ODoubleDot]glichkeiten:\n1. Will man das Ergebnis \
der ersten Funktion ",
  StyleBox["f",
    FontSlant->"Italic"],
  " als Argument in die zweite Funktion ",
  StyleBox["g",
    FontSlant->"Italic"],
  " einsetzen, so ist es notwendig, dass der Output von ",
  StyleBox["f",
    FontSlant->"Italic"],
  " dieselbe Form hat wie der Input von ",
  StyleBox["g",
    FontSlant->"Italic"],
  ". Ist der Bildraum der Funktion ",
  StyleBox["f",
    FontSlant->"Italic"],
  " mehrdimensional, so ist der Output eine Liste. Das Argument der Funktion \
",
  StyleBox["g",
    FontSlant->"Italic"],
  " muss daher auch eine Liste sein. Konkret sieht das so aus:"
}], "Text"],

Cell[BoxData[{
    \(f[x_] := {x, x^2}\), "\[IndentingNewLine]", 
    \(g[{x_, y_}] := {x, y, x*y}\)}], "Input"],

Cell[TextData[{
  "Die Komposition von ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["g",
    FontFamily->"Courier New"],
  " l\[ADoubleDot]sst sich nun einfach durch einsetzen von ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " in ",
  StyleBox["g",
    FontFamily->"Courier New"],
  " berechnen. ",
  StyleBox["h:=g\[SmallCircle]f",
    FontFamily->"Courier New"],
  StyleBox[" ist eine Funktion von \[DoubleStruckCapitalR] in den ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ":"
}], "Text"],

Cell[BoxData[{
    \(h[x_] := g[f[x]]\), "\[IndentingNewLine]", 
    \(h[x]\)}], "Input"],

Cell[TextData[{
  "2. Die zweite M\[ODoubleDot]glichkeit besteht in der Verwendung des \
Befehls ",
  StyleBox["Composition",
    FontFamily->"Courier New"],
  ". Die Argumente von ",
  StyleBox["Composition",
    FontFamily->"Courier New"],
  " sind die Funktionen (genauer: die Funktionsnamen, NICHT die \
Funktionsterme), die zusammengesetzt werden sollen."
}], "Text"],

Cell[BoxData[{
    \(Clear[h]\), "\[IndentingNewLine]", 
    \(h := Composition[g, f]\), "\[IndentingNewLine]", 
    \(h[x]\)}], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"Composition", "[", 
            RowBox[{
              StyleBox["g",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], "]"}], 
          RowBox[{
            StyleBox["die",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["zusammengesetze",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["Funktion",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            RowBox[{
              StyleBox["g",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox["\[SmallCircle]",
                FontFamily->"Times New Roman"], 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[BoxData[
    \(Clear[f, g, h]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Partielle Ableitungen", "Section"],

Cell[TextData[{
  "Hier ist eine Funktion vom ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " nach \[DoubleStruckCapitalR]."
}], "Text"],

Cell[BoxData[
    \(f[x_, y_, z_] := x^2 + y*Sin[x*z] - Exp[y]*z\)], "Input"],

Cell[TextData[{
  "Die partiellen Ableitungen einer Funktion",
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  "erh\[ADoubleDot]lt man mit den aus dem Kapitel ",
  ButtonBox["Differentiation",
    ButtonData:>{"differentiation.nb", None},
    ButtonStyle->"Hyperlink"],
  " bereits bekannten Befehlen ",
  StyleBox["D",
    FontFamily->"Courier New"],
  " oder (\[UDoubleDot]ber die Palette) ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_\[Placeholder]\ \[Placeholder]\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Hier ist die partielle Ableitung von ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " nach ",
  StyleBox["x",
    FontFamily->"Courier New"],
  ". Dabei wurden ",
  StyleBox["y",
    FontFamily->"Courier New"],
  " und ",
  StyleBox["z",
    FontFamily->"Courier New"],
  " als Konstante behandelt."
}], "Text"],

Cell[BoxData[
    \(D[f[x, y, z], x]\)], "Input"],

Cell["\<\
Dieselbe partielle Ableitung, mit Hilfe der Palette eingegeben.\
\>", "Text"],

Cell[BoxData[
    \(\[PartialD]\_x\ f[x, y, z]\)], "Input"],

Cell[TextData[{
  "Die dritte im Kapitel Differentiation vorgestellte Methode der \
Differentiation - mit dem Hochkomma - ist in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " f\[UDoubleDot]r eine Funktion mit mehreren Argumenten nicht \
m\[ODoubleDot]glich."
}], "Text"],

Cell[BoxData[
    \(\(f'\)[x, y, z]\)], "Input"],

Cell[TextData[{
  "Das ist die partielle Ableitung von ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " nach ",
  StyleBox["y",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(D[f[x, y, z], y]\)], "Input"],

Cell[TextData[{
  "Und jetzt die partielle Ableitung von ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " nach ",
  StyleBox["z",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(D[f[x, y, z], z]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{
              RowBox[{"D", "[", 
                RowBox[{
                  RowBox[{
                    StyleBox["f",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      RowBox[{
                        StyleBox[
                          SubscriptBox["x", 
                            StyleBox["1",
                              FontSlant->"Plain"]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New",
                          FontSlant->"Italic"], 
                        StyleBox["...",
                          FontFamily->"Courier New",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New",
                          FontSlant->"Italic"], 
                        StyleBox[\(x\_m\),
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], ",", 
                  StyleBox[\(x\_l\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], "  ", 
              StyleBox["oder",
                FontFamily->"Courier New",
                FontSlant->"Italic"]}], "\[IndentingNewLine]", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  StyleBox[\(x\_l\),
                    FontSlant->"Italic"]], " ", 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox[
                    SubscriptBox["x", 
                      StyleBox["1",
                        FontSlant->"Plain"]],
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox["...",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox[\(x\_m\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}]}]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["liefert",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["die",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["partielle",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Ableitung",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["von",
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox[
                    SubscriptBox["x", 
                      StyleBox["1",
                        FontSlant->"Plain"]],
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox["...",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox[\(x\_m\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[")",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["nach",
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox[\(x\_l\),
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[BoxData[
    \(Clear[f]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Die erste Ableitung", "Section"],

Cell[TextData[{
  "Hier ist eine Funktion vom ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " in den ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". Die Funktionen ",
  Cell[BoxData[
      \(TraditionalForm\`g\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`g\_2\)]],
  " und ",
  Cell[BoxData[
      \(TraditionalForm\`g\_3\)]],
  " sind dabei durch ",
  Cell[BoxData[
      \(TraditionalForm\`g\_1\)]],
  "(x, y)=",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  "+y, ",
  Cell[BoxData[
      \(TraditionalForm\`g\_2\)]],
  "(x, y)=x sin(y) und ",
  Cell[BoxData[
      \(TraditionalForm\`g\_3\)]],
  "(x, y)=x",
  Cell[BoxData[
      \(TraditionalForm\`y\^2\)]],
  " gegeben."
}], "Text"],

Cell[BoxData[
    \(g[x_, y_] := {x^2 + y, x*Sin[y], x*y^2}\)], "Input"],

Cell[TextData[{
  "Der Funktionswert von ",
  StyleBox["g",
    FontFamily->"Courier New"],
  " ist ein Element des ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\(\ \)\(g[2, 3]\)\)\)], "Input"],

Cell[TextData[{
  "Die partielle Ableitung von ",
  StyleBox["g",
    FontFamily->"Courier New"],
  " nach ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " im Punkt (",
  StyleBox["x",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["y",
    FontFamily->"Courier New"],
  ") ist ein Element des ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". Das Ergebnis ist daher eine Liste mit drei Elementen."
}], "Text"],

Cell[BoxData[
    \(dxg = D[g[x, y], x]\)], "Input"],

Cell[TextData[{
  "Dasselbe gilt f\[UDoubleDot]r die partielle Ableitung von ",
  StyleBox["g",
    FontFamily->"Courier New"],
  " nach ",
  StyleBox["y",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(dyg = \[PartialD]\_y\ g[x, y]\)], "Input"],

Cell["\<\
Die Matrix der partiellen Ableitungen (Jacobimatrix) erhalten wir nun \
folgenderma\[SZ]en:\
\>", "Text"],

Cell[BoxData[
    \(\((dg[x_, y_] = Transpose[{dxg, dyg}])\)\ \ \  // MatrixForm\)], "Input"],

Cell[TextData[{
  "Die Funktion ",
  StyleBox["dg",
    FontFamily->"Courier New"],
  " ordnet jedem (",
  StyleBox["x",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["y",
    FontFamily->"Courier New"],
  ") \[Element] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " die (durch eine Matrix beschriebene) lineare Abbildung ",
  StyleBox["dg[x,y]",
    FontFamily->"Courier New"],
  " : ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  "\[Rule] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " zu.\n",
  StyleBox["dg",
    FontFamily->"Courier New"],
  " ist die Ableitung von ",
  StyleBox["g",
    FontFamily->"Courier New"],
  ".\n",
  StyleBox["dg[x,y]",
    FontFamily->"Courier New"],
  " ist die Ableitung von ",
  StyleBox["g",
    FontFamily->"Courier New"],
  " an der Stelle (",
  StyleBox["x",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["y",
    FontFamily->"Courier New"],
  ")."
}], "Text"],

Cell[TextData[{
  "Die Ableitung von ",
  StyleBox["g",
    FontFamily->"Courier New"],
  " an der Stelle (2, 3) \[Element] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " ist die durch folgende Matrix beschriebene lineare Abbildung:"
}], "Text"],

Cell[BoxData[
    \(dg[2, 3]\ \ \  // MatrixForm\)], "Input"],

Cell[TextData[{
  "Die Richtungsableitung an der Stelle (2, 3) in Richtung (",
  StyleBox["v",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["w",
    FontFamily->"Courier New"],
  ") ist"
}], "Text"],

Cell[BoxData[
    \(Limit[\(g[2 + t*v, 3 + t*w] - g[2, 3]\)\/t, t \[Rule] 0]\)], "Input"],

Cell[TextData[{
  "...und das ist nichts anderes als das Bild von (",
  StyleBox["v",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["w",
    FontFamily->"Courier New"],
  ") unter ",
  StyleBox["dg[2,3]",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(dg[2, 3] . {v, w}\)], "Input"],

Cell[BoxData[
    \(Clear[g, dxg, dyg, dg]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["H\[ODoubleDot]here partielle Ableitungen", "Section"],

Cell[TextData[{
  "Auch f\[UDoubleDot]r h\[ODoubleDot]here Ableitungen haben wir die Syntax \
schon im Kapitel ",
  ButtonBox["Differentiation",
    ButtonData:>{"differentiation.nb", None},
    ButtonStyle->"Hyperlink"],
  " kennengelernt."
}], "Text"],

Cell[TextData[{
  "Hier ist nocheinmal die Funktion ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " von oben."
}], "Text"],

Cell[BoxData[
    \(f[x_, y_, z_] := x^2 + y*Sin[x*z] - Exp[y]*z\)], "Input"],

Cell[TextData[{
  "Das ist ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " dreimal nach ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " partiell abgeleitet."
}], "Text"],

Cell[BoxData[
    \(D[f[x, y, z], x, x, x]\)], "Input"],

Cell["\[CapitalADoubleDot]quivalente Schreibweisen sind", "Text"],

Cell[BoxData[
    \(D[f[x, y, z], {x, 3}]\)], "Input"],

Cell["oder auch", "Text"],

Cell[BoxData[
    \(\[PartialD]\_\(x, x, x\)f[x, y, z]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"D", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["x", 
                        StyleBox["1",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[\(x\_m\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox[\(x\_i\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["k",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["liefert",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["die",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["partielle",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Ableitung",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["k",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["-",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(ter\ Ordnung\ von\),
                  FontFamily->"Times New Roman"]}], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["x", 
                        StyleBox["1",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[\(x\_m\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["nach",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(x\_i\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}]}]}]},
        {
          RowBox[{"D", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["x", 
                        StyleBox["1",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[\(x\_m\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              StyleBox[\(x\_i\),
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", "...", ",", 
              StyleBox[\(x\_i\),
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["liefert",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["die",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["partielle",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Ableitung",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["k",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["-",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(ter\ Ordnung\ von\),
                  FontFamily->"Times New Roman"]}], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["x", 
                        StyleBox["1",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[\(x\_m\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["nach",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(x\_i\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"]}]], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["k",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["ist",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["die",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["Anzahl",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["der",
                        FontFamily->"Times New Roman"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox[\(x\_i\),
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[
                        RowBox[{
                          StyleBox[" ",
                            FontFamily->"Times New Roman",
                            FontSlant->"Italic"], 
                          StyleBox[" ",
                            FontFamily->"Times New Roman"]}]], 
                      StyleBox["in",
                        FontFamily->"Times New Roman"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox[\(x\_i\),
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox[",",
                      FontFamily->"Times New Roman"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox[",",
                      FontFamily->"Times New Roman"], 
                    StyleBox[\(x\_i\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}]}]}]},
        {
          RowBox[{
            RowBox[{
              SubscriptBox["\[PartialD]", 
                RowBox[{
                  StyleBox[\(x\_i\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", "...", ",", 
                  StyleBox[\(x\_i\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}]], " ", 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], 
            RowBox[{
              StyleBox["(",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox[
                  SubscriptBox["x", 
                    StyleBox["1",
                      FontSlant->"Plain"]],
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                StyleBox["...",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontFamily->"Courier New",
                  FontSlant->"Italic"], 
                StyleBox[\(x\_m\),
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox[")",
                FontFamily->"Times New Roman"]}]}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["liefert",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["die",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["partielle",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["Ableitung",
                    FontFamily->"Times New Roman"], 
                  StyleBox["  ",
                    FontFamily->"Times New Roman"], 
                  StyleBox["k",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["-",
                  FontFamily->"Times New Roman"], 
                StyleBox[\(ter\ Ordnung\ von\),
                  FontFamily->"Times New Roman"]}], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], "\[IndentingNewLine]", 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox[
                    SubscriptBox["x", 
                      StyleBox["1",
                        FontSlant->"Plain"]],
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox["...",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox[\(x\_m\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["nach",
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox[\(x\_i\),
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[
                RowBox[{
                  StyleBox[" ",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"]}]], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  RowBox[{
                    StyleBox["k",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox["  ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["ist",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["die",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["Anzahl",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["der",
                      FontFamily->"Times New Roman"], 
                    StyleBox["  ",
                      FontFamily->"Times New Roman"], 
                    StyleBox[\(x\_i\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[
                      RowBox[{
                        StyleBox[" ",
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[" ",
                          FontFamily->"Times New Roman"]}]], 
                    StyleBox["in",
                      FontFamily->"Times New Roman"], 
                    StyleBox["  ",
                      FontFamily->"Times New Roman"], 
                    StyleBox[\(x\_i\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[",",
                    FontFamily->"Times New Roman"], 
                  StyleBox["...",
                    FontFamily->"Courier New"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  StyleBox[",",
                    FontFamily->"Times New Roman"], 
                  StyleBox[\(x\_i\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  "Gemischte Ableitungen ermittelt man \[ADoubleDot]hnlich. Hier wird ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " zuerst nach ",
  StyleBox["z",
    FontFamily->"Courier New"],
  " und dann zweimal nach ",
  StyleBox["y",
    FontFamily->"Courier New"],
  " partiell differenziert."
}], "Text"],

Cell[BoxData[
    \(D[f[x, y, z], z, y, y]\)], "Input"],

Cell["Dasselbe noch einmal mit Hilfe der Palette.", "Text"],

Cell[BoxData[
    \(\[PartialD]\_\(z, y, y\)\ f[x, y, z]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{
              RowBox[{"D", "[", 
                RowBox[{
                  RowBox[{
                    StyleBox["f",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      RowBox[{
                        StyleBox[
                          SubscriptBox["x", 
                            StyleBox["1",
                              FontSlant->"Plain"]],
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New",
                          FontSlant->"Italic"], 
                        StyleBox["...",
                          FontFamily->"Courier New",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontFamily->"Courier New",
                          FontSlant->"Italic"], 
                        StyleBox[\(x\_m\),
                          FontFamily->"Times New Roman",
                          FontSlant->"Italic"]}], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], ",", 
                  StyleBox[
                    SubscriptBox["x", 
                      SubscriptBox["i", 
                        StyleBox["1",
                          FontSlant->"Plain"]]],
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox[
                    RowBox[{
                      StyleBox["..",
                        FontFamily->"Courier New",
                        FontSlant->"Italic"], "."}]], ",", 
                  StyleBox[
                    SubscriptBox["x", 
                      SubscriptBox["i", 
                        StyleBox["k",
                          FontFamily->"Times New Roman"]]],
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "]"}], "  ", 
              StyleBox["oder",
                FontSlant->"Italic"]}], "\[IndentingNewLine]", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["x", 
                        SubscriptBox["i", 
                          StyleBox["1",
                            FontSlant->"Plain"]]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[
                      RowBox[{
                        StyleBox["..",
                          FontFamily->"Courier New",
                          FontSlant->"Italic"], "."}]], ",", 
                    StyleBox[
                      SubscriptBox["x", 
                        SubscriptBox["i", 
                          StyleBox["k",
                            FontFamily->"Times New Roman"]]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}]], " ", 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox[
                    SubscriptBox["x", 
                      StyleBox["1",
                        FontSlant->"Plain"]],
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox["...",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    FontFamily->"Courier New",
                    FontSlant->"Italic"], 
                  StyleBox[\(x\_m\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}]}]}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["liefert",
                    FontFamily->"Times New Roman"], 
                  StyleBox[" ",
                    FontFamily->"Times New Roman"], 
                  FractionBox[\(\(\[PartialD]\)\(\ \)\), 
                    RowBox[{"\[PartialD]", " ", 
                      StyleBox[
                        SubscriptBox["x", 
                          SubscriptBox["i", 
                            StyleBox["1",
                              FontSlant->"Plain"]]],
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}]]}], "..."}], 
              FractionBox[\(\(\[PartialD]\)\(\ \)\), 
                RowBox[{"\[PartialD]", " ", 
                  StyleBox[\(x\_\(i\_k\)\),
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}]], 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[
                RowBox[{"(", 
                  RowBox[{
                    StyleBox[
                      SubscriptBox["x", 
                        StyleBox["1",
                          FontSlant->"Plain"]],
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox["...",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[",",
                      FontFamily->"Courier New",
                      FontSlant->"Italic"], 
                    StyleBox[\(x\_m\),
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], ")"}],
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[BoxData[
    \(Clear[f]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Die zweite Ableitung", "Section"],

Cell[TextData[{
  "Die zweite Ableitung einer Funktion  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " : ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^m\)]],
  "\[SupersetEqual]",
  StyleBox["U",
    FontSlant->"Italic"],
  " \[Rule] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " ist die Funktion  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " ",
  "'': ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^m\)]],
  "\[SupersetEqual]",
  StyleBox["U",
    FontSlant->"Italic"],
  " \[Rule] ",
  StyleBox["L",
    FontSlant->"Italic"],
  " (",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^m\)]],
  ", ",
  StyleBox["L",
    FontSlant->"Italic"],
  " (",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^m\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  ")) \[TildeFullEqual] ",
  StyleBox["L",
    FontSlant->"Italic"],
  " (",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^m\)]],
  "\[Times] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^m\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  "), die jedem ",
  StyleBox["x",
    FontSlant->"Italic"],
  " \[Element] ",
  StyleBox["U",
    FontSlant->"Italic"],
  "  die bilineare Abbildung  ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "''(",
  StyleBox["x",
    FontSlant->"Italic"],
  ") zuordnet.\nF\[UDoubleDot]r eine skalarwertige Funktion  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " : ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^m\)]],
  "\[SupersetEqual]",
  StyleBox["U",
    FontSlant->"Italic"],
  " \[Rule] \[DoubleStruckCapitalR] bedeutet dies, dass die zweite Ableitung \
von  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " an der Stelle ",
  StyleBox["z",
    FontSlant->"Italic"],
  " \[Element] ",
  StyleBox["U",
    FontSlant->"Italic"],
  "  \[LongDash] also die bilineare Abbildung  ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "''(",
  StyleBox["z",
    FontSlant->"Italic"],
  ") \[LongDash]  durch  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " ''(",
  StyleBox["z",
    FontSlant->"Italic"],
  ")(",
  StyleBox["u",
    FontSlant->"Italic"],
  ", ",
  StyleBox["v",
    FontSlant->"Italic"],
  ") = ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["u", 
          StyleBox["t",
            FontSlant->"Plain"]], TraditionalForm]]],
  " ",
  StyleBox["A",
    FontSlant->"Italic"],
  " ",
  StyleBox["v",
    FontSlant->"Italic"],
  " gegeben ist, wobei  ",
  StyleBox["A",
    FontSlant->"Italic"],
  " die (",
  StyleBox["m",
    FontSlant->"Italic"],
  "\[Times]",
  StyleBox["m",
    FontSlant->"Italic"],
  ")-Matrix ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {\(\[PartialD]\_1\(\[PartialD]\_1\ \(f(
                      z)\)\)\), \(\[PartialD]\_1\(\[PartialD]\_2\ \(f(
                      z)\)\)\), 
                "...", \(\[PartialD]\_1\(\[PartialD]\_m\ \(f(z)\)\)\)},
              {\(\[PartialD]\_2\(\[PartialD]\_1\ \(f(
                      z)\)\)\), \(\[PartialD]\_2\(\[PartialD]\_2\ \(f(
                      z)\)\)\), 
                "...", \(\[PartialD]\_2\(\[PartialD]\_m\ \(f(z)\)\)\)},
              {"...", "...", "...", "..."},
              {\(\[PartialD]\_m\(\[PartialD]\_1\ \(f(
                      z)\)\)\), \(\[PartialD]\_m\(\[PartialD]\_2\ \(f(
                      z)\)\)\), 
                "...", \(\[PartialD]\_m\(\[PartialD]\_m\ \(f(z)\)\)\)}
              }], ")"}], TraditionalForm]]],
  " ist."
}], "Text"],

Cell[TextData[{
  "Hier ist eine Funktion  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  : ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  "\[Rule] \[DoubleStruckCapitalR]."
}], "Text"],

Cell[BoxData[
    \(f[x_, y_] := x^2*\((y - 5)\) - y^2\)], "Input"],

Cell[TextData[{
  "Die zweite Ableitung von  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  im Punkt (",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  ") \[Element] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " ist die bilineare Abbildung  ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "''(",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  "), die durch die folgende Matrix ",
  StyleBox["ddf[x,y]",
    FontFamily->"Courier New"],
  " vermittelt wird:"
}], "Text"],

Cell[BoxData[
    RowBox[{\((ddf[x_, 
            y_] = {{\[PartialD]\_\(x, x\)f[x, y], \[PartialD]\_\(x, y\)f[x, 
                  y]}, {\[PartialD]\_\(y, x\)f[x, y], \[PartialD]\_\(y, y\)f[
                  x, y]}})\), "   ", "//", 
      RowBox[{"MatrixForm", Cell[""]}]}]], "Input"],

Cell[TextData[{
  "Die zweite Ableitung von  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " an der Stelle (2, 3) in Richtung ",
  StyleBox["u",
    FontSlant->"Italic"],
  "=(",
  Cell[BoxData[
      \(TraditionalForm\`u\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\_2\)]],
  ") und ",
  StyleBox["v",
    FontSlant->"Italic"],
  "=(",
  Cell[BoxData[
      \(TraditionalForm\`v\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`v\_2\)]],
  ") \[Element] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " ist das Bild von (",
  StyleBox["u",
    FontSlant->"Italic"],
  ", ",
  StyleBox["v",
    FontSlant->"Italic"],
  ") \[Element] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  "\[Times] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " unter  ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "''(2, 3), also ein Element aus \[DoubleStruckCapitalR]:"
}], "Text"],

Cell[BoxData[
    \({u1, u2} . ddf[2, 3] . {v1, v2}\)], "Input"],

Cell[TextData[{
  "In obigem Input war es nicht n\[ODoubleDot]tig den ",
  StyleBox["Transpose",
    FontFamily->"Courier New"],
  "-Befehl zu verwenden, da ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " automatisch ",
  StyleBox["{v1,v2}",
    FontFamily->"Courier New"],
  " als Spaltenvektor und ",
  StyleBox["{u1,u2}",
    FontFamily->"Courier New"],
  " als Zeilenvektor auffasst (vgl. den Abschnitt ",
  ButtonBox["Matrizen",
    ButtonData:>{"matrizen.nb", "matrizen"},
    ButtonStyle->"Hyperlink"],
  " im Kapitel ",
  ButtonBox["Vektoren und Matrizen",
    ButtonData:>{"matrizen.nb", None},
    ButtonStyle->"Hyperlink"],
  ").\nAuf Grund eben dieser Eigenschaft von ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " erh\[ADoubleDot]lt man obiges Ergebnis auch mit der folgenden Eingabe \
(die der mathematischen Schreibweise  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " ''(",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  ")(",
  Cell[BoxData[
      \(TraditionalForm\`u\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`u\_2\)]],
  ")(",
  Cell[BoxData[
      \(TraditionalForm\`v\_1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`v\_2\)]],
  ") sehr \[ADoubleDot]hnlich ist):"
}], "Text"],

Cell[BoxData[
    \(ddf[2, 3] . {u1, u2} . {v1, v2}\)], "Input"],

Cell[BoxData[
    \(Clear[f, ddf]\)], "Input"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowCellTags->True
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 72, 0, 51, "Subtitle"],
Cell[1851, 55, 246, 7, 52, "Text"],

Cell[CellGroupData[{
Cell[2122, 66, 46, 0, 73, "Section"],
Cell[2171, 68, 509, 16, 33, "Text"],
Cell[2683, 86, 5811, 142, 85, "Text"],
Cell[8497, 230, 1012, 36, 71, "Text"],
Cell[9512, 268, 112, 2, 50, "Input"],
Cell[9627, 272, 596, 21, 33, "Text"],
Cell[10226, 295, 89, 2, 50, "Input"],
Cell[10318, 299, 372, 10, 52, "Text"],
Cell[10693, 311, 137, 3, 70, "Input"],
Cell[10833, 316, 1289, 35, 48, "Text"],
Cell[12125, 353, 47, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[12209, 359, 40, 0, 43, "Section"],
Cell[12252, 361, 168, 5, 33, "Text"],
Cell[12423, 368, 77, 1, 30, "Input"],
Cell[12503, 371, 508, 15, 33, "Text"],
Cell[13014, 388, 336, 14, 33, "Text"],
Cell[13353, 404, 49, 1, 30, "Input"],
Cell[13405, 407, 87, 2, 33, "Text"],
Cell[13495, 411, 59, 1, 30, "Input"],
Cell[13557, 414, 283, 7, 33, "Text"],
Cell[13843, 423, 48, 1, 30, "Input"],
Cell[13894, 426, 183, 8, 33, "Text"],
Cell[14080, 436, 49, 1, 30, "Input"],
Cell[14132, 439, 185, 8, 33, "Text"],
Cell[14320, 449, 49, 1, 30, "Input"],
Cell[14372, 452, 5535, 138, 69, "Text"],
Cell[19910, 592, 41, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[19988, 598, 38, 0, 43, "Section"],
Cell[20029, 600, 771, 32, 33, "Text"],
Cell[20803, 634, 72, 1, 30, "Input"],
Cell[20878, 637, 209, 8, 33, "Text"],
Cell[21090, 647, 54, 1, 30, "Input"],
Cell[21147, 650, 451, 17, 33, "Text"],
Cell[21601, 669, 52, 1, 30, "Input"],
Cell[21656, 672, 205, 8, 33, "Text"],
Cell[21864, 682, 62, 1, 30, "Input"],
Cell[21929, 685, 115, 3, 33, "Text"],
Cell[22047, 690, 93, 1, 30, "Input"],
Cell[22143, 693, 1008, 41, 71, "Text"],
Cell[23154, 736, 278, 8, 33, "Text"],
Cell[23435, 746, 61, 1, 30, "Input"],
Cell[23499, 749, 204, 8, 33, "Text"],
Cell[23706, 759, 89, 1, 42, "Input"],
Cell[23798, 762, 259, 11, 33, "Text"],
Cell[24060, 775, 50, 1, 30, "Input"],
Cell[24113, 778, 55, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[24205, 784, 59, 0, 43, "Section"],
Cell[24267, 786, 253, 7, 33, "Text"],
Cell[24523, 795, 129, 5, 33, "Text"],
Cell[24655, 802, 77, 1, 30, "Input"],
Cell[24735, 805, 183, 8, 33, "Text"],
Cell[24921, 815, 55, 1, 30, "Input"],
Cell[24979, 818, 65, 0, 33, "Text"],
Cell[25047, 820, 54, 1, 30, "Input"],
Cell[25104, 823, 25, 0, 33, "Text"],
Cell[25132, 825, 67, 1, 30, "Input"],
Cell[25202, 828, 18083, 438, 147, "Text"],
Cell[43288, 1268, 321, 11, 33, "Text"],
Cell[43612, 1281, 55, 1, 30, "Input"],
Cell[43670, 1284, 59, 0, 33, "Text"],
Cell[43732, 1286, 69, 1, 30, "Input"],
Cell[43804, 1289, 6740, 162, 75, "Text"],
Cell[50547, 1453, 41, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[50625, 1459, 39, 0, 43, "Section"],
Cell[50667, 1461, 3644, 139, 119, "Text"],
Cell[54314, 1602, 219, 8, 33, "Text"],
Cell[54536, 1612, 67, 1, 30, "Input"],
Cell[54606, 1615, 599, 26, 33, "Text"],
Cell[55208, 1643, 288, 5, 34, "Input"],
Cell[55499, 1650, 979, 41, 33, "Text"],
Cell[56481, 1693, 64, 1, 30, "Input"],
Cell[56548, 1696, 1291, 47, 71, "Text"],
Cell[57842, 1745, 64, 1, 30, "Input"],
Cell[57909, 1748, 46, 1, 30, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

