(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     28015,        791]*)
(*NotebookOutlinePosition[     28679,        814]*)
(*  CellTagsIndexPosition[     28635,        810]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Differentiation", "Subtitle"],

Cell[TextData[{
  "Version 0.95\n\[Copyright]  2004 by Evelina Erlacher <",
  ButtonBox["evelina.erlacher@univie.ac.at",
    ButtonData:>{
      URL[ "mailto:evelina.erlacher@univie.ac.at"], None},
    ButtonStyle->"Hyperlink"],
  ">"
}], "Text"],

Cell["", "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kann Funktionen symbolisch differenzieren. Hier ist eine Funktion:"
}], "Text"],

Cell[BoxData[
    \(f[x_] := x^2*Sin[3  x]\)], "Input"],

Cell[TextData[{
  StyleBox["D",
    FontFamily->"Courier New"],
  " liefert die Ableitung von ",
  StyleBox["f[x]",
    FontFamily->"Courier New"],
  " nach ",
  StyleBox["x",
    FontFamily->"Courier New"],
  ". Dazu m\[UDoubleDot]ssen wir den Funktionsterm und die Variable, nach der \
abgeleitet werden soll, eingeben."
}], "Text"],

Cell[BoxData[
    \(D[f[x], x]\)], "Input"],

Cell[TextData[{
  "Wir k\[ODoubleDot]nnen zum Differenzieren von ",
  StyleBox["f",
    FontFamily->"Courier New"],
  " auch den entsprechenden Button \"",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_\[Placeholder]\ \[Placeholder]\)]],
  "\" in der Palette BasicInput verwenden. Wieder m\[UDoubleDot]ssen wir den \
Funktionsterm und die Variable, nach der abgeleitet werden soll, eingeben."
}], "Text"],

Cell[BoxData[
    \(\[PartialD]\_x\ f[x]\)], "Input"],

Cell[TextData[{
  "Wenn die Funktion nur ein Argument hat, gibt es noch eine dritte M\
\[ODoubleDot]glichkeit die Ableitung zu bilden. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " differenziert einfach nach dem Argument der Funktion."
}], "Text"],

Cell[BoxData[
    \(\(f'\)[x]\)], "Input"],

Cell[BoxData[
    \(Clear[f]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{
            RowBox[{
              RowBox[{"D", "[", 
                RowBox[{
                  RowBox[{
                    StyleBox["f",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[")",
                        FontFamily->"Times New Roman"]}]}], ",", 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], 
                StyleBox["]",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], "  ", 
              StyleBox["oder",
                FontFamily->"Courier New",
                FontSlant->"Italic"]}], "\[IndentingNewLine]", 
            RowBox[{
              RowBox[{
                SubscriptBox["\[PartialD]", 
                  StyleBox["x",
                    FontSlant->"Italic"]], " ", 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              RowBox[{
                StyleBox["(",
                  FontFamily->"Times New Roman"], 
                StyleBox["x",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[")",
                  FontFamily->"Times New Roman"]}], "  ", 
              StyleBox["oder",
                FontFamily->"Courier New",
                FontSlant->"Italic"]}], "\[IndentingNewLine]", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], "'"}], "[", 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], "]"}]}], 
          RowBox[{"   ", 
            RowBox[{
              StyleBox["liefert",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["die",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Ableitung",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["von",
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[\((x)\),
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["nach",
                FontFamily->"Times New Roman"], 
              StyleBox["  ",
                FontFamily->"Times New Roman"], 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  "F\[UDoubleDot]r die Differentiation mit ",
  StyleBox["D",
    FontFamily->"Courier New"],
  " oder ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_\[Placeholder]\ \[Placeholder]\)]],
  " m\[UDoubleDot]ssen wir die Funktion gar nicht definieren. Es gen\
\[UDoubleDot]gt, den Ausdruck, der differenziert werden soll, direkt in den \
Befehl hinein zu schreiben."
}], "Text"],

Cell[BoxData[
    \(D[Sin[x]\/x, x]\)], "Input"],

Cell[BoxData[
    \(\[PartialD]\_x\ \(Sin[x]\/x\)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nimmt an, dass alle von ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " verschiedenen Variablen von ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " unabh\[ADoubleDot]ngig sind, also Ableitung 0 haben."
}], "Text"],

Cell[BoxData[
    \(D[x^2 + y^2, x]\)], "Input"],

Cell[TextData[{
  "Ist ",
  StyleBox["y",
    FontFamily->"Courier New"],
  " aber von ",
  StyleBox["x",
    FontFamily->"Courier New"],
  " abh\[ADoubleDot]ngig, so muss ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dies explizit mitgeteilt werden. Dies geschieht sehr einfach durch die \
Schreibweise ",
  StyleBox["y[x]",
    FontFamily->"Courier New"],
  StyleBox[".",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[BoxData[
    \(D[x^2 + y[x]^2, x]\)], "Input"],

Cell[TextData[{
  "Wir k\[ODoubleDot]nnen h\[ODoubleDot]here Ableitungen direkt berechnen. \
Das leitet ",
  StyleBox["z^n",
    FontFamily->"Courier New"],
  " dreimal nach ",
  StyleBox["z",
    FontFamily->"Courier New"],
  " ab."
}], "Text"],

Cell[BoxData[
    \(D[z^n, z, z, z]\)], "Input"],

Cell["Das auch.", "Text"],

Cell[BoxData[
    \(D[z^n, {z, 3}]\)], "Input"],

Cell["So geht es mit dem Symbol aus der Palette.", "Text"],

Cell[BoxData[
    \(\[PartialD]\_\(z, z, z\)z^n\)], "Input"],

Cell[TextData[{
  "Wenn wir die Funktion ",
  StyleBox["z^n",
    FontFamily->"Courier New"],
  " definieren, gibt es noch eine M\[ODoubleDot]glichkeit."
}], "Text"],

Cell[BoxData[{
    \(\(g[z_] := z^n;\)\), "\[IndentingNewLine]", 
    \(\(g'''\)[z]\)}], "Input"],

Cell[BoxData[
    \(Clear[g]\)], "Input"],

Cell[BoxData[GridBox[{
        {
          RowBox[{"D", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", 
                  StyleBox["n",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}], "}"}]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["liefert",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["n",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["-",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["te",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Ableitung",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["nach",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["x",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}]}]}]},
        {
          RowBox[{"D", "[", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}], ",", 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], ",", "...", ",", 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], "]"}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["liefert",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["n",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["-",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["te",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Ableitung",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["nach",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["x",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"]}]], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["n",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["ist",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["die",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["Anzahl",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["der",
                        FontFamily->"Times New Roman"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[
                        RowBox[{
                          StyleBox[" ",
                            FontFamily->"Times New Roman",
                            FontSlant->"Italic"], 
                          StyleBox[" ",
                            FontFamily->"Times New Roman"]}]], 
                      StyleBox["in",
                        FontFamily->"Times New Roman"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox[",",
                      FontFamily->"Times New Roman"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox[",",
                      FontFamily->"Times New Roman"], 
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}]}]}]},
        {
          RowBox[{
            RowBox[{
              SubscriptBox["\[PartialD]", 
                RowBox[{
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], ",", "...", ",", 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"]}]], " ", 
              StyleBox["f",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"]}], 
            RowBox[{
              StyleBox["(",
                FontFamily->"Times New Roman"], 
              StyleBox["x",
                FontFamily->"Times New Roman",
                FontSlant->"Italic"], 
              StyleBox[")",
                FontFamily->"Times New Roman"]}]}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["liefert",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["n",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["-",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["te",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Ableitung",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["nach",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["x",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{
                    StyleBox[" ",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"]}]], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["n",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["ist",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["die",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["Anzahl",
                        FontFamily->"Times New Roman"], 
                      StyleBox[" ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["der",
                        FontFamily->"Times New Roman"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"], 
                      StyleBox[
                        StyleBox[
                          RowBox[{
                            StyleBox[" ",
                              FontFamily->"Times New Roman",
                              FontSlant->"Italic"], 
                            StyleBox[" ",
                              FontFamily->"Times New Roman"]}]],
                        FontFamily->"Times New Roman"], 
                      StyleBox["in",
                        FontFamily->"Times New Roman"], 
                      StyleBox["  ",
                        FontFamily->"Times New Roman"], 
                      StyleBox["x",
                        FontFamily->"Times New Roman",
                        FontSlant->"Italic"]}], 
                    StyleBox[",",
                      FontFamily->"Times New Roman"], 
                    StyleBox["...",
                      FontFamily->"Courier New"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox[",",
                      FontFamily->"Times New Roman"], 
                    StyleBox["x",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}]}]}]},
        {
          RowBox[{
            RowBox[{
              SuperscriptBox[
                RowBox[{
                  StyleBox["f",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], "'"}], "..."], "'"}], "[", 
            StyleBox["x",
              FontFamily->"Times New Roman",
              FontSlant->"Italic"], 
            StyleBox["]",
              FontFamily->"Courier New"]}], 
          RowBox[{"   ", 
            RowBox[{
              RowBox[{
                StyleBox["liefert",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["die",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["n",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"]}], 
              StyleBox["-",
                FontFamily->"Times New Roman"], 
              RowBox[{
                StyleBox["te",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["Ableitung",
                  FontFamily->"Times New Roman"], 
                StyleBox[" ",
                  FontFamily->"Times New Roman"], 
                StyleBox["von",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["f",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  StyleBox["x",
                    FontFamily->"Times New Roman",
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["nach",
                  FontFamily->"Times New Roman"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                StyleBox["x",
                  FontFamily->"Times New Roman",
                  FontSlant->"Italic"], 
                StyleBox["  ",
                  FontFamily->"Times New Roman"], 
                RowBox[{
                  StyleBox["(",
                    FontFamily->"Times New Roman"], 
                  RowBox[{
                    StyleBox["n",
                      FontFamily->"Times New Roman",
                      FontSlant->"Italic"], 
                    StyleBox["  ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["ist",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["die",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["Anzahl",
                      FontFamily->"Times New Roman"], 
                    StyleBox[" ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["der",
                      FontFamily->"Times New Roman"], 
                    StyleBox["  ",
                      FontFamily->"Times New Roman"], 
                    StyleBox["Hochkommas",
                      FontFamily->"Times New Roman"]}], 
                  StyleBox[")",
                    FontFamily->"Times New Roman"]}]}]}]}]}
        },
      ColumnAlignments->{Right, Left}]], "Text",
  CellFrame->True,
  Background->RGBColor[0.679698, 0.890639, 0.996109]],

Cell[TextData[{
  "F\[UDoubleDot]r die Ableitung(en) nicht n\[ADoubleDot]her definierter \
Funktionen verwendet ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " die \[UDoubleDot]bliche mathematische Schreibweise."
}], "Text"],

Cell[BoxData[
    \(D[h[a], {a, 3}]\)], "Input"],

Cell[TextData[{
  "Wir k\[ODoubleDot]nnen die h\[ODoubleDot]here Ableitung aber nicht so \
eingeben. Das hochgestellte ",
  StyleBox["(3)",
    FontFamily->"Courier New"],
  " wird von ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " als dritte Potenz aufgefasst."
}], "Text"],

Cell[BoxData[{
    \(\(h[x_] := x^5;\)\), "\[IndentingNewLine]", 
    \(\(h\^\((3)\)\)[x]\)}], "Input"],

Cell[BoxData[
    \(Clear[h]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kennt die diversen Differentiationsregeln."
}], "Text"],

Cell["Produktregel:", "Text"],

Cell[BoxData[
    \(D[u[x]*v[x], x]\)], "Input"],

Cell["Quotientenregel:", "Text"],

Cell[BoxData[
    \(D[u[x]\/v[x], x]\ \ \  // Together\)], "Input"],

Cell["Kettenregel:", "Text"],

Cell[BoxData[
    \(D[u[v[x]], x]\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowToolbars->{},
WindowSize->{1016, 648},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 35, 0, 51, "Subtitle"],
Cell[1814, 55, 246, 7, 52, "Text"],
Cell[2063, 64, 16, 0, 33, "Text"],
Cell[2082, 66, 151, 4, 33, "Text"],
Cell[2236, 72, 55, 1, 30, "Input"],
Cell[2294, 75, 334, 11, 33, "Text"],
Cell[2631, 88, 43, 1, 30, "Input"],
Cell[2677, 91, 412, 9, 52, "Text"],
Cell[3092, 102, 53, 1, 30, "Input"],
Cell[3148, 105, 260, 6, 33, "Text"],
Cell[3411, 113, 42, 1, 30, "Input"],
Cell[3456, 116, 41, 1, 30, "Input"],
Cell[3500, 119, 3487, 90, 85, "Text"],
Cell[6990, 211, 400, 10, 33, "Text"],
Cell[7393, 223, 48, 1, 42, "Input"],
Cell[7444, 226, 62, 1, 42, "Input"],
Cell[7509, 229, 299, 10, 33, "Text"],
Cell[7811, 241, 48, 1, 30, "Input"],
Cell[7862, 244, 433, 16, 33, "Text"],
Cell[8298, 262, 51, 1, 30, "Input"],
Cell[8352, 265, 245, 9, 33, "Text"],
Cell[8600, 276, 48, 1, 30, "Input"],
Cell[8651, 279, 25, 0, 33, "Text"],
Cell[8679, 281, 47, 1, 30, "Input"],
Cell[8729, 284, 58, 0, 33, "Text"],
Cell[8790, 286, 60, 1, 30, "Input"],
Cell[8853, 289, 165, 5, 33, "Text"],
Cell[9021, 296, 97, 2, 50, "Input"],
Cell[9121, 300, 41, 1, 30, "Input"],
Cell[9165, 303, 17708, 435, 99, "Text"],
Cell[26876, 740, 235, 6, 33, "Text"],
Cell[27114, 748, 48, 1, 30, "Input"],
Cell[27165, 751, 286, 9, 33, "Text"],
Cell[27454, 762, 103, 2, 50, "Input"],
Cell[27560, 766, 41, 1, 30, "Input"],
Cell[27604, 769, 127, 4, 33, "Text"],
Cell[27734, 775, 29, 0, 33, "Text"],
Cell[27766, 777, 48, 1, 30, "Input"],
Cell[27817, 780, 32, 0, 33, "Text"],
Cell[27852, 782, 67, 1, 44, "Input"],
Cell[27922, 785, 28, 0, 33, "Text"],
Cell[27953, 787, 46, 1, 30, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

